/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.ia.ui.CollectorOptionsEditor;
import com.ibm.cics.ia.ui.composites.GenericPropertyItem;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeItem;

public class ComboPropertyItem
extends GenericPropertyItem
implements SelectionListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected CCombo combo;
    protected TreeEditor editor;

    public ComboPropertyItem(TreeItem parent, CollectorOptionsEditor atomEditor, String key, String description) {
        super(parent, atomEditor, key, description);
    }

    @Override
    public void setValue(String value, boolean dirty) {
        this.value = value;
        this.combo.setText(value);
        int i = 0;
        while (i < this.combo.getItemCount()) {
            if (this.combo.getItem(i).equals(value)) {
                this.combo.select(i);
                break;
            }
            ++i;
        }
        if (!dirty) {
            this.oldValue = value;
            this.treeItem.setFont(NORMAL_FONT);
            this.combo.setFont(NORMAL_FONT);
        } else {
            this.treeItem.setFont(BOLD_FONT);
            this.combo.setFont(BOLD_FONT);
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void widgetSelected(SelectionEvent e) {
        this.value = this.combo.getItem(this.combo.getSelectionIndex());
        if (!this.value.equals(this.oldValue)) {
            this.treeItem.setFont(BOLD_FONT);
            this.combo.setFont(BOLD_FONT);
            this.atomEditor.fireDirty();
        } else {
            this.treeItem.setFont(NORMAL_FONT);
            this.combo.setFont(NORMAL_FONT);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void populateCombo() {
    }
}

