/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.compareresources;

import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.ia.commands.FindCollectionsByRegionCommand;
import com.ibm.cics.ia.commands.FindRegionsResourceCommand;
import com.ibm.cics.ia.commands.FindTransByCollectionCommand;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ComparisonEditor;
import com.ibm.cics.ia.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class CompareCollectionResDialog
extends Dialog {
    private Composite parentComposite;
    private FindRegionsResourceCommand findRegionsCommand;
    private FindCollectionsByRegionCommand findCollectionsByRegionCommand;
    private FindTransByCollectionCommand findLTransByCollectionCommand;
    private FindTransByCollectionCommand findRTransByCollectionCommand;
    private Button continueBtn;
    private EngineShell.EngineListener regionCommandListener;
    private EngineShell.EngineListener leftCollectionCommandListener;
    private EngineShell.EngineListener rightCollectionCommandListener;
    private EngineShell.EngineListener leftTransactionCommandListener;
    private EngineShell.EngineListener rightTransactionCommandListener;
    private String[] regionsArray = new String[0];
    private String[] leftCollectionsArray = new String[0];
    private String[] rightCollectionsArray = new String[0];
    private String[] leftTransactionsArray = new String[0];
    private String[] rightTransactionsArray = new String[0];
    private Combo leftRegionCombo;
    private Combo rightRegionCombo;
    private Combo rightTransactionCombo;
    private Combo leftTransactionCombo;
    private Combo rightCollectionCombo;
    private Combo leftCollectionCombo;
    HashMap<String, Map<String, String>> selectedResources = new HashMap();

    public HashMap<String, Map<String, String>> getSelectedResources() {
        HashMap<String, String> leftMap = new HashMap<String, String>();
        ResourceFactory.getSingleton().clear();
        leftMap.put("REGION", this.leftRegionCombo.getText());
        leftMap.put("TRANSACTION", this.leftTransactionCombo.getText());
        HashMap<String, String> rightMap = new HashMap<String, String>();
        rightMap.put("REGION", this.rightRegionCombo.getText());
        rightMap.put("TRANSACTION", this.rightTransactionCombo.getText());
        this.selectedResources.put("LeftResource", leftMap);
        this.selectedResources.put("RighResource", rightMap);
        return this.selectedResources;
    }

    public CompareCollectionResDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.parentComposite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        this.parentComposite.setLayout((Layout)layout);
        this.findRegion();
        this.createContent();
        return this.parentComposite;
    }

    private void createErrorMessage() {
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ComparisonResource.errorMessage.dialog.title"), (String)Messages.getString("ComparisonResource.errorMessage"));
    }

    private void createContent() {
        this.createLeftContents();
        this.createMiddleContents();
        this.createRightContents();
    }

    protected Point getInitialSize() {
        return new Point(600, 300);
    }

    private void createRightContents() {
        Composite rightComposite = new Composite(this.parentComposite, 0);
        rightComposite.setLayout((Layout)new GridLayout(3, false));
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group rightGroup = new Group(rightComposite, 0);
        rightGroup.setText(Messages.getString("ComparisonResource.dialogResourceTitle"));
        rightGroup.setLayout((Layout)new GridLayout(1, false));
        rightGroup.setLayoutData((Object)new GridData(4, 0, true, true));
        GridData gridDatab = new GridData();
        gridDatab.verticalSpan = 10;
        gridDatab.grabExcessHorizontalSpace = true;
        gridDatab.horizontalAlignment = 4;
        this.rightRegionCombo = new Combo((Composite)rightGroup, 12);
        this.rightRegionCombo.setItems(this.regionsArray);
        this.rightRegionCombo.setLayoutData((Object)gridDatab);
        this.rightCollectionCombo = new Combo((Composite)rightGroup, 12);
        this.rightCollectionCombo.setItems(this.rightCollectionsArray);
        this.rightCollectionCombo.setLayoutData((Object)gridDatab);
        this.rightTransactionCombo = new Combo((Composite)rightGroup, 12);
        this.rightTransactionCombo.setItems(this.rightTransactionsArray);
        this.rightTransactionCombo.setLayoutData((Object)gridDatab);
        this.rightRegionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object source = event.getSource();
                if (source != null && ((Combo)source).getText() instanceof String) {
                    String regionSelected = ((Combo)source).getText();
                    IASQLCommand.setRegion((String)regionSelected);
                    CompareCollectionResDialog.this.findRightCollectionsByRegion();
                    CompareCollectionResDialog.this.rightCollectionCombo.setItems(CompareCollectionResDialog.this.rightCollectionsArray);
                    CompareCollectionResDialog.this.rightTransactionCombo.removeAll();
                    CompareCollectionResDialog.this.continueBtn.setEnabled(false);
                }
            }
        });
        this.rightCollectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object source = event.getSource();
                if (source != null && ((Combo)source).getText() instanceof String) {
                    String collectionIdSelected = ((Combo)source).getText();
                    IASQLCommand.setCollectionIdByResource((String)collectionIdSelected);
                    CompareCollectionResDialog.this.findRightTransactions();
                    CompareCollectionResDialog.this.rightTransactionCombo.setItems(CompareCollectionResDialog.this.rightTransactionsArray);
                    CompareCollectionResDialog.this.continueBtn.setEnabled(false);
                }
            }
        });
        this.rightTransactionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object source = event.getSource();
                if (source != null && ((Combo)source).getText().trim() instanceof String && CompareCollectionResDialog.this.leftTransactionCombo.getText() != null && !CompareCollectionResDialog.this.leftTransactionCombo.getText().isEmpty()) {
                    if (CompareCollectionResDialog.this.leftTransactionCombo.getText().equals(CompareCollectionResDialog.this.rightTransactionCombo.getText()) && CompareCollectionResDialog.this.leftCollectionCombo.getText().equals(CompareCollectionResDialog.this.rightCollectionCombo.getText())) {
                        CompareCollectionResDialog.this.createErrorMessage();
                        CompareCollectionResDialog.this.continueBtn.setEnabled(false);
                    } else {
                        CompareCollectionResDialog.this.continueBtn.setEnabled(true);
                    }
                }
            }
        });
    }

    private void createMiddleContents() {
        Composite middleComposite = new Composite(this.parentComposite, 0);
        middleComposite.setLayout((Layout)new GridLayout(3, false));
        middleComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group middleGroup = new Group(middleComposite, 0);
        middleGroup.setText(Messages.getString("ComparisonResource.dialogResourceTitle"));
        middleGroup.setLayout((Layout)new GridLayout(1, false));
        middleGroup.setLayoutData((Object)new GridData(4, 0, true, true));
        GridData gridDatab = new GridData();
        gridDatab.verticalSpan = 10;
        gridDatab.grabExcessHorizontalSpace = true;
        gridDatab.horizontalAlignment = 4;
        this.leftRegionCombo = new Combo((Composite)middleGroup, 12);
        this.leftRegionCombo.setItems(this.regionsArray);
        this.leftRegionCombo.setLayoutData((Object)gridDatab);
        this.leftCollectionCombo = new Combo((Composite)middleGroup, 12);
        this.leftCollectionCombo.setItems(this.leftCollectionsArray);
        this.leftCollectionCombo.setLayoutData((Object)gridDatab);
        this.leftTransactionCombo = new Combo((Composite)middleGroup, 12);
        this.leftTransactionCombo.setItems(this.leftTransactionsArray);
        this.leftTransactionCombo.setLayoutData((Object)gridDatab);
        this.leftRegionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object source = event.getSource();
                if (source != null && ((Combo)source).getText() instanceof String) {
                    String regionSelected = ((Combo)source).getText();
                    IASQLCommand.setRegion((String)regionSelected);
                    CompareCollectionResDialog.this.findLeftCollectionsByRegion();
                    CompareCollectionResDialog.this.leftCollectionCombo.setItems(CompareCollectionResDialog.this.leftCollectionsArray);
                    CompareCollectionResDialog.this.leftTransactionCombo.removeAll();
                    CompareCollectionResDialog.this.continueBtn.setEnabled(false);
                }
            }
        });
        this.leftCollectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object source = event.getSource();
                if (source != null && ((Combo)source).getText() instanceof String) {
                    String collectionIdSelected = ((Combo)source).getText();
                    IASQLCommand.setCollectionIdByResource((String)collectionIdSelected);
                    CompareCollectionResDialog.this.findLeftTransactions();
                    CompareCollectionResDialog.this.leftTransactionCombo.setItems(CompareCollectionResDialog.this.leftTransactionsArray);
                    CompareCollectionResDialog.this.continueBtn.setEnabled(false);
                }
            }
        });
        this.leftTransactionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object source = event.getSource();
                if (source != null && ((Combo)source).getText().trim() instanceof String && CompareCollectionResDialog.this.rightTransactionCombo.getText() != null && !CompareCollectionResDialog.this.rightTransactionCombo.getText().isEmpty()) {
                    if (CompareCollectionResDialog.this.leftTransactionCombo.getText().equals(CompareCollectionResDialog.this.rightTransactionCombo.getText()) && CompareCollectionResDialog.this.leftCollectionCombo.getText().equals(CompareCollectionResDialog.this.rightCollectionCombo.getText())) {
                        CompareCollectionResDialog.this.createErrorMessage();
                        CompareCollectionResDialog.this.continueBtn.setEnabled(false);
                    } else {
                        CompareCollectionResDialog.this.continueBtn.setEnabled(true);
                    }
                }
            }
        });
    }

    private void createLeftContents() {
        Composite leftComposite = new Composite(this.parentComposite, 0);
        leftComposite.setLayout((Layout)new GridLayout(1, false));
        leftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gridDatab = new GridData();
        gridDatab.verticalSpan = 16;
        Label selectRegionlbl = new Label(leftComposite, 0);
        selectRegionlbl.setText(Messages.getString("ComparisonResource.selectRegionLabel"));
        selectRegionlbl.setLayoutData((Object)gridDatab);
        GridData gridData = new GridData();
        gridData.verticalSpan = 4;
        Label selectCollectionlbl = new Label(leftComposite, 0);
        selectCollectionlbl.setText(Messages.getString("ComparisonResource.selectCollectionIDLabel"));
        selectCollectionlbl.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.verticalSpan = 16;
        Label selectTranslbl = new Label(leftComposite, 0);
        selectTranslbl.setText(Messages.getString("ComparisonResource.selectTransactionLabel"));
        selectTranslbl.setLayoutData((Object)gridData2);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("ComparisonResource.dialogTitle"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.continueBtn = this.getButton(0);
        this.continueBtn.setText("Continue");
        this.setButtonLayoutData(this.continueBtn);
        this.continueBtn.setEnabled(false);
        Button cancel = this.getButton(1);
        cancel.setText("Exit");
        this.setButtonLayoutData(cancel);
    }

    protected void okPressed() {
        Activator.openEditor(ComparisonEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.comparisonresourceseditor", true);
        IEditorPart editor = Activator.openEditor(ComparisonEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.comparisonresourceseditor", true);
        if (editor != null) {
            ((ComparisonEditor)editor).setInput(this.getSelectedResources(), this.getCollectionIDMap());
        }
        super.okPressed();
    }

    private String[] getAllCollectionID() {
        ArrayList<String> collectionIds = Activator.getCollectionIdsView().getCollectionIds();
        return collectionIds.toArray(new String[0]);
    }

    public void findRightTransactions() {
        this.findRTransByCollectionCommand = new FindTransByCollectionCommand();
        this.findRTransByCollectionCommand.addListener(this.getRightTransactionCommandListener());
        if (this.findRTransByCollectionCommand != null) {
            this.findRTransByCollectionCommand.setAsync(false);
            this.findRTransByCollectionCommand.start();
        }
    }

    private EngineShell.EngineListener getRightTransactionCommandListener() {
        final Display display = Display.getDefault();
        if (this.rightTransactionCommandListener == null) {
            this.rightTransactionCommandListener = new EngineShell.EngineListener(){

                public void dataAvailable(final Collection<Object> items) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<String> transactionsNameList = new ArrayList<String>();
                            for (String transaction : items) {
                                transactionsNameList.add(transaction);
                            }
                            CompareCollectionResDialog.this.rightTransactionsArray = transactionsNameList.toArray(new String[0]);
                        }
                    });
                }

                public void notifyResultCount(int count) {
                }

                public void statusUpdate(EngineShell.EngineStatus es) {
                }
            };
        }
        return this.rightTransactionCommandListener;
    }

    public void findLeftTransactions() {
        this.findLTransByCollectionCommand = new FindTransByCollectionCommand();
        this.findLTransByCollectionCommand.addListener(this.getLeftTransactionCommandListener());
        if (this.findLTransByCollectionCommand != null) {
            this.findLTransByCollectionCommand.setAsync(false);
            this.findLTransByCollectionCommand.start();
        }
    }

    private EngineShell.EngineListener getLeftTransactionCommandListener() {
        final Display display = Display.getDefault();
        if (this.leftTransactionCommandListener == null) {
            this.leftTransactionCommandListener = new EngineShell.EngineListener(){

                public void dataAvailable(final Collection<Object> items) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<String> transactionsNameList = new ArrayList<String>();
                            for (String transaction : items) {
                                transactionsNameList.add(transaction);
                            }
                            CompareCollectionResDialog.this.leftTransactionsArray = transactionsNameList.toArray(new String[0]);
                        }
                    });
                }

                public void notifyResultCount(int count) {
                }

                public void statusUpdate(EngineShell.EngineStatus es) {
                }
            };
        }
        return this.leftTransactionCommandListener;
    }

    public void findRegion() {
        this.findRegionsCommand = new FindRegionsResourceCommand();
        this.findRegionsCommand.addListener(this.getCommandListener());
        if (this.findRegionsCommand != null) {
            this.findRegionsCommand.setAsync(false);
            this.findRegionsCommand.start();
        }
    }

    public void findLeftCollectionsByRegion() {
        this.findCollectionsByRegionCommand = new FindCollectionsByRegionCommand();
        this.findCollectionsByRegionCommand.addListener(this.getLeftCollectionCommandListener());
        if (this.findCollectionsByRegionCommand != null) {
            this.findCollectionsByRegionCommand.setAsync(false);
            this.findCollectionsByRegionCommand.start();
        }
    }

    private EngineShell.EngineListener getLeftCollectionCommandListener() {
        final Display display = Display.getDefault();
        if (this.leftCollectionCommandListener == null) {
            this.leftCollectionCommandListener = new EngineShell.EngineListener(){

                public void dataAvailable(final Collection<Object> items) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<String> collectionsNameList = new ArrayList<String>();
                            for (String collection : items) {
                                collectionsNameList.add(collection);
                            }
                            CompareCollectionResDialog.this.leftCollectionsArray = collectionsNameList.toArray(new String[0]);
                        }
                    });
                }

                public void notifyResultCount(int count) {
                }

                public void statusUpdate(EngineShell.EngineStatus es) {
                }
            };
        }
        return this.leftCollectionCommandListener;
    }

    public void findRightCollectionsByRegion() {
        this.findCollectionsByRegionCommand = new FindCollectionsByRegionCommand();
        this.findCollectionsByRegionCommand.addListener(this.getRightCollectionCommandListener());
        if (this.findCollectionsByRegionCommand != null) {
            this.findCollectionsByRegionCommand.setAsync(false);
            this.findCollectionsByRegionCommand.start();
        }
    }

    private EngineShell.EngineListener getRightCollectionCommandListener() {
        final Display display = Display.getDefault();
        if (this.rightCollectionCommandListener == null) {
            this.rightCollectionCommandListener = new EngineShell.EngineListener(){

                public void dataAvailable(final Collection<Object> items) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<String> collectionsNameList = new ArrayList<String>();
                            for (String collection : items) {
                                collectionsNameList.add(collection);
                            }
                            CompareCollectionResDialog.this.rightCollectionsArray = collectionsNameList.toArray(new String[0]);
                        }
                    });
                }

                public void notifyResultCount(int count) {
                }

                public void statusUpdate(EngineShell.EngineStatus es) {
                }
            };
        }
        return this.rightCollectionCommandListener;
    }

    private EngineShell.EngineListener getCommandListener() {
        final Display display = Display.getDefault();
        if (this.regionCommandListener == null) {
            this.regionCommandListener = new EngineShell.EngineListener(){

                public void dataAvailable(final Collection<Object> items) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<String> regionName = new ArrayList<String>();
                            for (String region : items) {
                                regionName.add(region);
                            }
                            CompareCollectionResDialog.this.regionsArray = regionName.toArray(new String[0]);
                        }
                    });
                }

                public void notifyResultCount(int count) {
                }

                public void statusUpdate(EngineShell.EngineStatus es) {
                }
            };
        }
        return this.regionCommandListener;
    }

    private Map<String, String> getCollectionIDMap() {
        HashMap<String, String> collectionIDMap = new HashMap<String, String>();
        collectionIDMap.put("LeftCollectionID", this.leftCollectionCombo.getText());
        collectionIDMap.put("RightCollectionID", this.rightCollectionCombo.getText());
        return collectionIDMap;
    }

    protected boolean isResizable() {
        return true;
    }
}

