/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.adapters;

import com.ibm.cics.eclipse.common.historical.IHistoricalTransaction;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.actions.MoreRegionsAction;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.swt.widgets.Display;

public class HistoricalTransactionFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Class[] ADAPTER_TYPES = new Class[]{IHistoricalTransaction.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof Transaction) {
            String name = ((Resource)adaptableObject).getName();
            List regionList = ((Resource)adaptableObject).getRegions();
            return this.processTran((Resource)adaptableObject, name, regionList);
        }
        if (adaptableObject instanceof Task) {
            String name = ((Task)adaptableObject).getTransaction().getName();
            List regionList = ((Resource)adaptableObject).getRegions();
            return this.processTran((Resource)adaptableObject, name, regionList);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTER_TYPES;
    }

    private IHistoricalTransaction processTran(final Resource adaptable, final String name, final List regionList) {
        if (name != null && regionList != null) {
            return new IHistoricalTransaction(){

                public String getApplid() {
                    Region region;
                    if (regionList.size() > 0 && (region = HistoricalTransactionFactory.this.findRegion(adaptable, name, regionList)) != null) {
                        return region.getName();
                    }
                    return null;
                }

                public String getTransactionName() {
                    return name;
                }

                public boolean isTransactionInstance() {
                    return regionList.size() > 0;
                }
            };
        }
        return null;
    }

    private Region findRegion(final Resource adaptableObject, final String name, List regionList) {
        final Region[] regions = new Region[1];
        if (regionList.size() != 1) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MoreRegionsAction dialog = new MoreRegionsAction(String.valueOf(Messages.getString((String)"TimelineHandlerIA.TransactionUsing")) + name);
                    dialog.setResource(adaptableObject);
                    regions[0] = dialog.getRegion();
                }
            });
        } else {
            regions[0] = (Region)regionList.get(0);
        }
        return regions[0];
    }
}

