/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.UsageTree;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class UsedByAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(UsedByAction.class.getPackage().getName());
    protected Resource resource;
    protected Region region;
    protected boolean collectPrograms = true;
    protected boolean collectTransactions = true;
    private ISelectionChangedListener selectionChangedListener;
    private IWorkbenchPart currentPart;

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region aRegion) {
        this.region = aRegion;
    }

    public void setResource(Resource aResource) {
        this.resource = aResource;
    }

    public void run() {
        IEditorPart editor;
        Debug.enter((Logger)logger, (String)UsedByAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.resource != null && (editor = Activator.openEditor(UsageTree.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.usagetree", true)) != null) {
            ((UsageTree)editor).setInput(this.resource, this.region, this.collectPrograms, this.collectTransactions);
        }
        Debug.exit((Logger)logger, (String)UsedByAction.class.getName(), (String)"run");
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection;
        Object firstElement;
        Debug.enter((Logger)logger, (String)UsedByAction.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Resource) {
            this.resource = (Resource)firstElement;
        }
        Debug.exit((Logger)logger, (String)UsedByAction.class.getName(), (String)"selectionChanged");
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        Debug.enter((Logger)logger, (String)UsedByAction.class.getName(), (String)"setActivePart", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (targetPart != this.currentPart) {
            this.currentPart.getSite().getSelectionProvider().removeSelectionChangedListener(this.getSelectionChangedListener());
            targetPart.getSite().getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
            this.currentPart = targetPart;
        }
        Debug.exit((Logger)logger, (String)UsedByAction.class.getName(), (String)"setActivePart");
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    UsedByAction.this.selectionChanged(null, event.getSelection());
                }
            };
        }
        return this.selectionChangedListener;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

