/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class TransactionRunsAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TransactionRunsAction.class.getPackage().getName());
    private Transaction transaction;
    private Region region;

    public TransactionRunsAction() {
    }

    public TransactionRunsAction(Transaction transaction) {
        this.transaction = transaction;
    }

    public TransactionRunsAction(Transaction iaResource, Region iaRegion) {
        this.transaction = iaResource;
        this.region = iaRegion;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run() {
        Debug.enter((Logger)logger, (String)TransactionRunsAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.transaction != null) {
            QueryCommand tasksCommand = this.transaction.createGetCommandFlowRunsCommand(this.region);
            tasksCommand.setSaveable(false);
            DisplayableData displayableData = (DisplayableData)tasksCommand.getAdapter(DisplayableData.class);
            String description = MessageFormat.format(Messages.getString("TransactionRunsAction.description"), this.transaction.toString());
            displayableData.setDescription(description);
            displayableData.setImage(ImageFactory.getSearchImage());
            tasksCommand.setDescription(description);
            Activator.executeSearch((Command)tasksCommand);
        }
        Debug.exit((Logger)logger, (String)TransactionRunsAction.class.getName(), (String)"run");
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection;
        Object firstElement;
        Debug.enter((Logger)logger, (String)TransactionRunsAction.class.getName(), (String)"selectionChanged", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Transaction) {
            this.transaction = (Transaction)firstElement;
        }
        Debug.exit((Logger)logger, (String)TransactionRunsAction.class.getName(), (String)"selectionChanged");
    }
}

