/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.threadsafe.CreateThreadsafeReportModel;
import com.ibm.cics.ia.model.threadsafe.CreateThreadsafeReportModelImpl;
import com.ibm.cics.ia.ui.CreateThreadsafeReportPresenterImpl;
import com.ibm.cics.ia.ui.CreateThreadsafeReportViewImpl;
import com.ibm.cics.ia.ui.actions.Messages;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ThreadsafeReportAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ThreadsafeReportAction.class.getPackage().getName());
    protected Resource resource;
    public static final String ID = "com.ibm.cics.ia.action.report.threadsafe";

    public ThreadsafeReportAction(Resource resource) {
        this.resource = resource;
    }

    public ThreadsafeReportAction() {
    }

    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.resource instanceof Region) {
            this.runWizard(null, (Region)this.resource);
        } else {
            this.runWizard(this.resource, null);
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run");
    }

    protected void runWizard(Resource resource, Region region) {
        CreateThreadsafeReportViewImpl view = new CreateThreadsafeReportViewImpl(Messages.getString("ThreadsafeReportWizard.title"));
        CreateThreadsafeReportPresenterImpl presenter = new CreateThreadsafeReportPresenterImpl();
        presenter.setView(view);
        CreateThreadsafeReportModelImpl model = new CreateThreadsafeReportModelImpl(resource, region);
        presenter.setModel((CreateThreadsafeReportModel)model);
        view.setPresenter(presenter);
        view.show();
        String helpContextId = "com.ibm.cics.ia.help.threadsafe_report_wizard";
        view.getParametersPage().setHelpContextId(helpContextId);
        view.getLocationPage().setHelpContextId(helpContextId);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                action.setEnabled(false);
            } else if (action instanceof Action) {
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof Resource) {
                    this.resource = (Resource)firstElement;
                } else {
                    action.setEnabled(false);
                }
            } else {
                action.setEnabled(false);
                this.resource = null;
            }
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectionChanged");
    }

    public void dispose() {
        this.resource = null;
    }

    public void init(IWorkbenchWindow window) {
    }
}

