/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.ia.commands.FindDefiningResourcesCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.IAApplication;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPAPP;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ShowDefiningResourcesAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ShowDefiningResourcesAction.class.getPackage().getName());
    private IAApplication iaApplication;
    protected String resourceType = "";

    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)ShowDefiningResourcesAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        FindDefiningResourcesCommand showResourcesCommand = new FindDefiningResourcesCommand();
        String descriptionPrefix = IAUtilities.hasContent((String)this.resourceType) ? Messages.getString("ShowDefiningResourcesAction." + this.resourceType) : Messages.getString("ShowDefiningResourcesAction.ALL");
        String description = MessageFormat.format(Messages.getString("ShowDefiningResourcesAction.description"), descriptionPrefix, String.valueOf(ResourceTypeRenderer.asText(this.iaApplication.getTypeName())) + " (" + ResourceRenderer.asText((Resource)this.iaApplication) + ")");
        showResourcesCommand.setApplication(this.iaApplication.getName());
        showResourcesCommand.setResourceType(this.resourceType);
        DisplayableData displayableData = (DisplayableData)showResourcesCommand.getAdapter(DisplayableData.class);
        displayableData.setImage(ImageFactory.getApplicationImage());
        displayableData.setDescription(description);
        Activator.executeSearch((Command)showResourcesCommand);
        Debug.exit((Logger)logger, (String)ShowDefiningResourcesAction.class.getName(), (String)"run");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Debug.enter((Logger)logger, (String)ShowDefiningResourcesAction.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IAApplication) {
                this.iaApplication = (IAApplication)firstElement;
                IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
                if (resourceManager.isConnected()) {
                    boolean spAvailable = DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").isProcedureAvailable((StoredProcedureDefinition)new ProcedureCIUSPAPP());
                    action.setEnabled(spAvailable);
                } else {
                    action.setEnabled(false);
                }
            } else {
                action.setEnabled(false);
            }
        }
        Debug.exit((Logger)logger, (String)ShowDefiningResourcesAction.class.getName(), (String)"selectionChanged");
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

