/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.ia.commands.FindResourcesForApplicationCommand;
import com.ibm.cics.ia.commands.FindResourcesForIAApplicationCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.IAApplication;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPAPP;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ShowApplicationResourcesAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ShowApplicationResourcesAction.class.getPackage().getName());
    private Object selection;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)ShowApplicationResourcesAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        FindResourcesForApplicationCommand.SourceTable type = null;
        String actionID = action.getId();
        actionID = actionID.substring(actionID.lastIndexOf(46) + 1, actionID.length());
        if (actionID.equals("allresources")) {
            type = FindResourcesForApplicationCommand.SourceTable.ALL;
        } else if (actionID.equals("cicsresources")) {
            type = FindResourcesForApplicationCommand.SourceTable.CICS;
        } else if (actionID.equals("imsresources")) {
            type = FindResourcesForApplicationCommand.SourceTable.IMS;
        } else if (actionID.equals("mqresources")) {
            type = FindResourcesForApplicationCommand.SourceTable.MQ;
        } else if (actionID.equals("db2resources")) {
            type = FindResourcesForApplicationCommand.SourceTable.DB2;
        } else if (actionID.equals("naturalresources")) {
            type = FindResourcesForApplicationCommand.SourceTable.NAT;
        }
        FindResourcesForIAApplicationCommand showResourcesCommand = null;
        String selectionName = "";
        if (this.selection instanceof IAApplication) {
            IAApplication application = (IAApplication)this.selection;
            showResourcesCommand = new FindResourcesForIAApplicationCommand();
            showResourcesCommand.setApplication(application.getName());
            selectionName = String.valueOf(ResourceTypeRenderer.asText("IA_APPLICATION")) + " (" + application.getName() + ")";
        }
        if (showResourcesCommand != null) {
            String descriptionPrefix = Messages.getString("ShowApplicationResourcesAction." + type.toString());
            String description = MessageFormat.format(Messages.getString("ShowApplicationResourcesAction.description"), descriptionPrefix, selectionName);
            showResourcesCommand.setType(type);
            DisplayableData displayableData = (DisplayableData)showResourcesCommand.getAdapter(DisplayableData.class);
            displayableData.setImage(ImageFactory.getApplicationImage());
            displayableData.setDescription(description);
            Activator.executeSearch((Command)showResourcesCommand);
        }
        Debug.exit((Logger)logger, (String)ShowApplicationResourcesAction.class.getName(), (String)"run");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Debug.enter((Logger)logger, (String)ShowApplicationResourcesAction.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IAApplication) {
                this.selection = firstElement;
                IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
                if (resourceManager.isConnected()) {
                    boolean spAvailable = DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").isProcedureAvailable((StoredProcedureDefinition)new ProcedureCIUSPAPP());
                    action.setEnabled(spAvailable);
                } else {
                    action.setEnabled(false);
                }
            } else {
                action.setEnabled(false);
            }
        }
        Debug.exit((Logger)logger, (String)ShowApplicationResourcesAction.class.getName(), (String)"selectionChanged");
    }
}

