/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.WebServiceRequest;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.ScenarioBasedCollectionModel;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ScenarioBasedCollectionPresenter;
import com.ibm.cics.ia.ui.ScenarioBasedCollectionView;
import com.ibm.cics.ia.ui.actions.CollectorAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.PlatformUI;

class ScenarioBasedCollectionPresenterImpl
implements ScenarioBasedCollectionPresenter {
    protected static Logger logger = Logger.getLogger(ScenarioBasedCollectionPresenterImpl.class.getPackage().getName());
    private ScenarioBasedCollectionModel model;
    private ScenarioBasedCollectionView view;

    public ScenarioBasedCollectionPresenterImpl(ScenarioBasedCollectionModel model, ScenarioBasedCollectionView view) {
        this.model = model;
        this.view = view;
        view.show();
        view.setSelectedRadioButtonIndex(0);
        view.setCheckButtonsStates(new boolean[]{model.isDb2Enabled(), model.isMqEnabled(), model.isImsEnabled(), model.isCpsmEnabled(), model.isNatEnabled(), model.isOptEnabled()});
    }

    @Override
    public void onOkPressed() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onOkPressed", (Object)("Thread ID: " + Thread.currentThread().getId()));
        final String taskName = MessageFormat.format(Messages.getString("IAOperationsView.startScenarioBasedCollectionCintRequestTask"), this.model.getApplId());
        Job job = new Job(taskName){

            public IStatus run(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"ScenarioBasedCollectionPresenterImpl.Job().run()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(taskName, -1);
                try {
                    ScenarioBasedCollectionPresenterImpl.this.model.startScenarioBasedCollection();
                }
                finally {
                    monitor.done();
                }
                Debug.exit((Logger)logger, (String)"ScenarioBasedCollectionPresenterImpl.Job().run()", (String)"run", (Object)("status: " + Status.OK_STATUS));
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"ScenarioBasedCollectionPresenterImpl.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            if (ScenarioBasedCollectionPresenterImpl.this.model.getAtomContent() != null) {
                                ArrayList<AtomContent> collectors = new ArrayList<AtomContent>();
                                collectors.add(ScenarioBasedCollectionPresenterImpl.this.model.getAtomContent());
                                CollectorAction.updateViews(collectors);
                            }
                            Debug.exit((Logger)logger, (String)"ScenarioBasedCollectionPresenterImpl.JobChangeAdapter().done().syncExec", (String)"run");
                        }
                    });
                }
            }
        });
        job.setRule((ISchedulingRule)WebServiceRequest.MUTEX_RULE);
        job.schedule();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onOkPressed");
    }

    @Override
    public void onViewClosing() {
    }

    @Override
    public void onCancelPressed() {
    }

    @Override
    public void onSelectionChanged() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onSelectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.model.setCollectionType(ScenarioBasedCollectionModel.CollectionType.values()[this.view.getSelectedRadioButtonIndex()]);
        if (this.model.getCollectionType().equals((Object)ScenarioBasedCollectionModel.CollectionType.F)) {
            this.view.setCheckButtonsEnablement(false, false, false, false, false, false);
            this.model.setDb2Enabled(null);
            this.model.setMqEnabled(null);
            this.model.setImsEnabled(null);
            this.model.setCpsmEnabled(null);
            this.model.setNatEnabled(null);
            this.model.setOptEnabled(null);
        } else {
            this.view.setCheckButtonsEnablement(true, true, true, true, true, true);
            this.model.setDb2Enabled(Boolean.valueOf(this.view.getCheckButtonsStates()[0]));
            this.model.setMqEnabled(Boolean.valueOf(this.view.getCheckButtonsStates()[1]));
            this.model.setImsEnabled(Boolean.valueOf(this.view.getCheckButtonsStates()[2]));
            this.model.setCpsmEnabled(Boolean.valueOf(this.view.getCheckButtonsStates()[3]));
            this.model.setNatEnabled(Boolean.valueOf(this.view.getCheckButtonsStates()[4]));
            this.model.setOptEnabled(Boolean.valueOf(this.view.getCheckButtonsStates()[5]));
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onSelectionChanged");
    }
}

