/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.PurgeWizard;
import com.ibm.cics.ia.ui.actions.Messages;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PurgeWizardAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PurgeWizardAction.class.getPackage().getName());
    private String title;
    private Program program;
    protected int returnCode;

    public PurgeWizardAction() {
    }

    public PurgeWizardAction(String title) {
        this.title = title;
    }

    public PurgeWizardAction(String title, Program program) {
        this(title);
        this.program = program;
    }

    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)PurgeWizardAction.class.getName(), (String)"run", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "program " + this.program.getName()});
        String collectionId = IASQLCommand.getCollectionId();
        if (collectionId.isEmpty()) {
            MessageDialog.open((int)1, null, (String)"Error", (String)Messages.getString("PurgeWizard.setCurrentScopeError.message"), (int)1);
            return;
        }
        PurgeWizard wizard = new PurgeWizard(this.program, null);
        WizardDialog wizardDialog = new WizardDialog(null, (IWizard)wizard);
        wizardDialog.open();
        Debug.exit((Logger)logger, (String)PurgeWizardAction.class.getName(), (String)"run");
    }

    public void run() {
        this.run((IAction)this);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                action.setEnabled(false);
            } else if (action instanceof Action) {
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof Resource) {
                    this.program = (Program)firstElement;
                } else {
                    action.setEnabled(false);
                }
            } else {
                action.setEnabled(false);
            }
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

