/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ProgramType;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.core.ui.editors.actions.EditCICSObjectHelper;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.MoreCICSPlexesDialog;
import com.ibm.cics.ia.ui.MoreRegionsDialog;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.actions.Messages;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IProgram;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenSMEditorAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(OpenSMEditorAction.class.getPackage().getName());
    private Resource resource;

    public void run(IAction action) {
        ICICSplex targetPlex;
        Region targetRegion;
        Debug.enter((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.resource == null) {
            Debug.exit((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"run");
            return;
        }
        ICPSM cpsm = (ICPSM)ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.sm.connection");
        if (!cpsm.isConnected()) {
            MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
            box.setText(Messages.getString("OpenSMEditorAction.CouldntConnectToCICSSM.title"));
            box.setMessage(Messages.getString("OpenSMEditorAction.CouldntConnectToCICSSM.message"));
            box.open();
            Debug.exit((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"run");
            return;
        }
        if (this.resource.getRegions().size() > 1) {
            MoreRegionsDialog dialog = new MoreRegionsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.resource, Messages.getString("MoreRegionsDialog.MoreRegionsDialog.title.text"), false);
            int result = dialog.open();
            if (result != 0) {
                Debug.exit((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"run");
                return;
            }
            targetRegion = dialog.getRegion();
        } else if (this.resource.getRegions().size() == 1) {
            targetRegion = (Region)this.resource.getRegions().get(0);
        } else {
            IAPlugin.getDefault().logInformation("Couldn't find any region for " + ResourceTypeRenderer.asText(this.resource.getTypeName()) + " (" + this.resource.getTypeName() + ")" + "in CIU_RESOURCE table. Check if IA database is consistent");
            Debug.exit((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"run");
            return;
        }
        ICICSplex[] cicsplexes = cpsm.getCICSplexes();
        ArrayList<ICICSplex> plexesWithTargetRegion = new ArrayList<ICICSplex>();
        ICICSplex[] iCICSplexArray = cicsplexes;
        int n = cicsplexes.length;
        int n2 = 0;
        while (n2 < n) {
            IManagedRegion[] regions;
            ICICSplex cicsplex = iCICSplexArray[n2];
            IManagedRegion[] iManagedRegionArray = regions = cpsm.getManagedRegions(cicsplex);
            int n3 = regions.length;
            int n4 = 0;
            while (n4 < n3) {
                IManagedRegion iManagedRegion = iManagedRegionArray[n4];
                if (targetRegion.getName().equals(iManagedRegion.getName())) {
                    plexesWithTargetRegion.add(cicsplex);
                }
                ++n4;
            }
            ++n2;
        }
        if (plexesWithTargetRegion.size() > 1) {
            MoreCICSPlexesDialog dialog = new MoreCICSPlexesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), targetRegion, plexesWithTargetRegion);
            int result = dialog.open();
            if (result != 0) {
                Debug.exit((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"run");
                return;
            }
            targetPlex = dialog.getSelection();
        } else if (plexesWithTargetRegion.size() == 1) {
            targetPlex = (ICICSplex)plexesWithTargetRegion.get(0);
        } else {
            MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
            box.setText(MessageFormat.format(Messages.getString("OpenSMEditorAction.CouldntFindCICSPlex.title"), targetRegion.getName()));
            box.setMessage(MessageFormat.format(Messages.getString("OpenSMEditorAction.CouldntFindCICSPlex.message"), targetRegion.getName()));
            box.open();
            Debug.exit((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"run");
            return;
        }
        if (!(this.resource instanceof Program)) {
            Debug.exit((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"run");
            return;
        }
        ProgramType cicsType = ProgramType.getInstance();
        ScopedContext scopedContext = new ScopedContext(targetPlex.getName(), targetRegion.getName());
        IPrimaryKey primaryKey = ProgramType.getPrimaryKey((IContext)scopedContext, (String)this.resource.getName());
        try {
            IProgram cicsObject = (IProgram)cpsm.get((ICICSType)cicsType, primaryKey);
            EditCICSObjectHelper.openEditor((ICICSObject)cicsObject, (boolean)true);
        }
        catch (CICSSystemManagerException ex) {
            Debug.warning((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"run", (Throwable)ex, new HashMap());
            MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
            box.setText(MessageFormat.format(Messages.getString("OpenSMEditorAction.CounlntFindResource.title"), String.valueOf(ResourceTypeRenderer.asText(this.resource.getTypeName())) + " (" + this.resource.getName() + ")"));
            box.setMessage(MessageFormat.format(Messages.getString("OpenSMEditorAction.CouldntFindResource.message"), String.valueOf(ResourceTypeRenderer.asText(this.resource.getTypeName())) + " (" + this.resource.getName() + ")", targetRegion.getName(), targetPlex.getName()));
            box.open();
        }
        catch (PartInitException e) {
            IAPlugin.getDefault().logError("Couldn''t open CICS Object editor for " + ResourceTypeRenderer.asText(this.resource.getTypeName()) + " (" + this.resource.getTypeName() + ")", (Throwable)e);
        }
        Debug.exit((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"run");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection;
        Object firstElement;
        Debug.enter((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"selectionChanged");
        if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Resource) {
            this.resource = (Resource)firstElement;
        }
        Debug.exit((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"selectionChanged");
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"dispose");
        this.resource = null;
        Debug.exit((Logger)logger, (String)OpenSMEditorAction.class.getName(), (String)"dispose");
    }

    public void init(IWorkbenchWindow window) {
    }

    public void setResource(Resource aResource) {
        this.resource = aResource;
    }
}

