/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.ui.PurgeWizard;
import com.ibm.cics.ia.ui.actions.Messages;
import com.ibm.cics.ia.ui.actions.MoreRegionsAction;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class MoreRegionsProgramPurgeAction
extends MoreRegionsAction {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MoreRegionsProgramPurgeAction.class.getPackage().getName());
    private Program program;

    public MoreRegionsProgramPurgeAction() {
        super(Messages.getString("PurgeWizard.regionSelect.label.text"));
    }

    @Override
    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)MoreRegionsProgramPurgeAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String collectionId = IASQLCommand.getCollectionId();
        if (collectionId.isEmpty()) {
            MessageDialog.open((int)1, null, (String)"Error", (String)Messages.getString("PurgeWizard.setCurrentScopeError.message"), (int)1);
            return;
        }
        this.program = (Program)this.getResource();
        Region region = this.getRegion(false);
        if (this.returnCode == 0) {
            PurgeWizard wizard = new PurgeWizard(this.program, region);
            WizardDialog wizardDialog = new WizardDialog(null, (IWizard)wizard);
            wizardDialog.open();
        }
        Debug.exit((Logger)logger, (String)MoreRegionsProgramPurgeAction.class.getName(), (String)"run");
    }
}

