/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ExecutionTree;
import com.ibm.cics.ia.ui.MoreRegionsDialog;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class MoreRegionsAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MoreRegionsAction.class.getPackage().getName());
    private Resource resource;
    private String title;
    protected int returnCode;

    public MoreRegionsAction(String aTitle) {
        this.title = aTitle;
    }

    public MoreRegionsAction(Resource aResource) {
        this.resource = aResource;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run() {
        this.run((IAction)this);
    }

    public void run(IAction action) {
        IEditorPart editor;
        Debug.enter((Logger)logger, (String)MoreRegionsAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Resource resource = this.getResource();
        Region region = this.getRegion();
        if (this.returnCode != 1 && (editor = Activator.openEditor(ExecutionTree.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.executiontree", true)) != null) {
            ((ExecutionTree)editor).setInput(resource, region);
        }
        Debug.exit((Logger)logger, (String)MoreRegionsAction.class.getName(), (String)"run");
    }

    public Region getRegion() {
        MoreRegionsDialog dialog = new MoreRegionsDialog(Display.getCurrent().getActiveShell(), this.resource, this.title, true);
        this.returnCode = dialog.open();
        return dialog.getRegion();
    }

    public Region getRegion(boolean isSearchAllowed) {
        MoreRegionsDialog dialog = new MoreRegionsDialog(Display.getCurrent().getActiveShell(), this.resource, this.title, isSearchAllowed);
        this.returnCode = dialog.open();
        return dialog.getRegion();
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setTitle(String aTitle) {
        this.title = aTitle;
    }

    public void setResource(Resource aResource) {
        this.resource = aResource;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Debug.enter((Logger)logger, (String)MoreRegionsAction.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                action.setEnabled(false);
            } else if (action instanceof Action) {
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof Resource) {
                    this.resource = (Resource)firstElement;
                } else {
                    action.setEnabled(false);
                }
            } else {
                action.setEnabled(false);
            }
        }
        Debug.exit((Logger)logger, (String)MoreRegionsAction.class.getName(), (String)"selectionChanged");
    }
}

