/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.commands.FindPlatformsAndApplicationsUsingResourceCommand;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.actions.Messages;
import com.ibm.cics.ia.ui.actions.MorePlatformsAction;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;

public class MorePlatformsUsedByAppAction
extends MorePlatformsAction {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MorePlatformsUsedByAppAction.class.getPackage().getName());

    public MorePlatformsUsedByAppAction() {
        super(Messages.getString("MoreRegionsUsedByAppAction.title"));
    }

    public MorePlatformsUsedByAppAction(Resource aResource) {
        super(aResource);
    }

    public void run() {
        this.run((IAction)this);
    }

    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)MorePlatformsUsedByAppAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Resource resource = this.getResource();
        if (resource == null) {
            return;
        }
        Platform platform = this.getPlatform();
        if (this.returnCode != 1) {
            FindPlatformsAndApplicationsUsingResourceCommand findCommand = new FindPlatformsAndApplicationsUsingResourceCommand(null, platform, resource);
            String description = platform != null ? MessageFormat.format(Messages.getString("UsedByApplicationAction.SpecificPlatform.title"), resource.toString(), platform.getName()) : MessageFormat.format(Messages.getString("UsedByApplicationAction.AllPlatforms.title"), resource.toString());
            Presentation presentation = PresentationFactory.getInstance().createPresentation(description, "", "", (Selection)findCommand.getSelectionObject());
            QueryCommand command = new QueryCommand(presentation);
            command.setDescription(description);
            DisplayableData data = (DisplayableData)command.getAdapter(DisplayableData.class);
            data.setDescription(description);
            command.setSaveable(false);
            Activator.executeSearch((Command)command);
        }
        Debug.exit((Logger)logger, (String)MorePlatformsUsedByAppAction.class.getName(), (String)"run");
    }
}

