/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.commands.FindDeployingPlatformCommand;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class FindDeployingPlatformAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindDeployingPlatformAction.class.getPackage().getName());
    private Object resource;

    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.resource == null) {
            return;
        }
        FindDeployingPlatformCommand findCommand = new FindDeployingPlatformCommand(this.resource);
        String description = MessageFormat.format(Messages.getString("DeployedInPlatform.title"), this.resource.toString());
        Presentation presentation = PresentationFactory.getInstance().createPresentation(description, "", "", (Selection)findCommand.getSelectionObject());
        QueryCommand command = new QueryCommand(presentation);
        command.setDescription(description);
        DisplayableData data = (DisplayableData)command.getAdapter(DisplayableData.class);
        data.setDescription(description);
        command.setSaveable(false);
        Activator.executeSearch((Command)command);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            this.resource = structuredSelection.getFirstElement();
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectionChanged");
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

