/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.ep.editor.AutoCreateEventBinding;
import com.ibm.cics.ep.model.eventbinding.capture.CapturePointContextFilters;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.MoreRegionsDialog;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CreateEventAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CreateEventAction.class.getPackage().getName());
    private Resource resource;
    private String epResourceType;
    private Region region;

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        IConnectable iConnectable;
        boolean moreThanOneFound;
        Debug.enter((Logger)logger, (String)CreateEventAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String resourceType = this.epResourceType;
        String resourceName = this.resource.getName();
        String capturePoint = this.getId();
        Calendar calendar = Calendar.getInstance();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2);
        if (this.region == null) {
            if (this.resource.getRegions().size() == 1) {
                this.region = (Region)this.resource.getRegions().get(0);
            } else {
                MoreRegionsDialog dialog = new MoreRegionsDialog(Display.getCurrent().getActiveShell(), this.resource, Messages.getString("MoreRegionsDialog.message"), false);
                dialog.open();
                this.region = dialog.getRegion();
            }
        }
        if (this.region == null) {
            Debug.exit((Logger)logger, (String)CreateEventAction.class.getName(), (String)"run");
            return;
        }
        Object[] inserts = new String[]{resourceType, resourceName, this.region.toString(), dateFormat.format(calendar.getTime())};
        String description = MessageFormat.format(Messages.getString("CreateEventAction.text"), inserts);
        AutoCreateEventBinding autoCreateEventBinding = new AutoCreateEventBinding(resourceType, resourceName, capturePoint, description);
        CapturePointContextFilters contextFilters = new CapturePointContextFilters(this.getId());
        if (contextFilters.isTransactionUsed()) {
            List sourceTransactionInteractions = this.resource.getSourceTransactionInteractions();
            Transaction transid = null;
            moreThanOneFound = false;
            for (Interaction interaction : sourceTransactionInteractions) {
                if (!interaction.getRegion().equals((Object)this.region) || !interaction.getResource().equals((Object)this.resource)) continue;
                if (transid == null) {
                    transid = (Transaction)interaction.getSource();
                    continue;
                }
                if (transid.equals((Object)((Transaction)interaction.getSource()))) continue;
                moreThanOneFound = true;
                break;
            }
            if (transid != null && !moreThanOneFound) {
                autoCreateEventBinding.setTransid(transid.getName());
            }
        }
        if (contextFilters.isProgramUsed()) {
            List sourceProgramInteractions = this.resource.getSourceProgramInteractions();
            Program program = null;
            moreThanOneFound = false;
            for (Interaction interaction : sourceProgramInteractions) {
                if (!interaction.getRegion().equals((Object)this.region) || !interaction.getResource().equals((Object)this.resource)) continue;
                if (program == null) {
                    program = (Program)interaction.getSource();
                    continue;
                }
                if (program.equals((Object)((Program)interaction.getSource()))) continue;
                moreThanOneFound = true;
                break;
            }
            if (program != null && !moreThanOneFound) {
                autoCreateEventBinding.setProgram(program.getName());
            }
        }
        if (contextFilters.isUseridUsed() && (iConnectable = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2")).getConnection() != null) {
            ICredentialsManager mgr = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getCredentialsManager();
            CredentialsConfiguration credentials = mgr.findCredentialsConfigurationByID(iConnectable.getConnection().getConfiguration().getCredentialsID());
            autoCreateEventBinding.setUserid(credentials.getUserID());
        }
        autoCreateEventBinding.create();
        Debug.enter((Logger)logger, (String)CreateEventAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object firstElement;
        Debug.enter((Logger)logger, (String)CreateEventAction.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.resource = null;
        if (!selection.isEmpty() && selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof Resource) {
            this.resource = (Resource)firstElement;
        }
        Debug.exit((Logger)logger, (String)CreateEventAction.class.getName(), (String)"enclosing_method");
    }

    public void setResource(Resource aResource) {
        this.resource = aResource;
    }

    public void setEpResourceType(String aType) {
        this.epResourceType = aType;
    }

    public void setRegion(Region aRegion) {
        this.region = aRegion;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

