/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.commands.CincGetRequest;
import com.ibm.cics.ia.commands.CincPostRequest;
import com.ibm.cics.ia.commands.CintGetRequest;
import com.ibm.cics.ia.commands.CintPostRequest;
import com.ibm.cics.ia.commands.WebServiceRequest;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomEntry;
import com.ibm.cics.ia.model.AtomFeed;
import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.model.CintAlreadyInUseException;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ScenarioBasedCollectionModel;
import com.ibm.cics.ia.model.ScenarioBasedCollectionModelImpl;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.sm.comm.AtomConnection;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.CintEditor;
import com.ibm.cics.ia.ui.CollectorOptionsEditor;
import com.ibm.cics.ia.ui.CommandFlowEditor;
import com.ibm.cics.ia.ui.IAOperationsView;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.RegionExplorer;
import com.ibm.cics.ia.ui.ScenarioBasedCollectionViewImpl;
import com.ibm.cics.ia.ui.ThreadsafeReportViewImpl;
import com.ibm.cics.ia.ui.actions.ScenarioBasedCollectionPresenterImpl;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class CollectorAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Logger logger = Logger.getLogger(CollectorAction.class.getPackage().getName());
    public static String CINT_START_ACTION = "com.ibm.cics.ia.ui.cintCollector.Start";
    public static String CINT_STOP_ACTION = "com.ibm.cics.ia.ui.cintCollector.Stop";
    public static String CINT_PAUSE_ACTION = "com.ibm.cics.ia.ui.cintCollector.Pause";
    public static String CINT_CONTINUE_ACTION = "com.ibm.cics.ia.ui.cintCollector.Continue";
    public static String REFRESH_ACTION = "com.ibm.cics.ia.ui.cintCollector.Refresh";
    public static String EDIT_REGION_ACTION = "com.ibm.cics.ia.ui.cintCollector.EditRegion";
    public static String SAVE_REGION_OPTIONS_ACTION = "com.ibm.cics.ia.ui.cintCollector.SaveOptions";
    public static String CINT_START_SCENARIO_BASED_COLLECTION_ACTION = "com.ibm.cics.ia.ui.cintCollector.StartScenarioBasedCollection";
    public static String CINC_START_ACTION = "com.ibm.cics.ia.ui.cincCollector.Start";
    public static String CINC_STOP_ACTION = "com.ibm.cics.ia.ui.cincCollector.Stop";
    public static String EDIT_USER_ACTION = "com.ibm.cics.ia.ui.cincCollector.EditUser";
    public static String SAVE_OPTIONS_ACTION = "com.ibm.cics.ia.ui.cincCollector.SaveOptions";
    private CintCollector cintCollector;
    private CincCollector cincCollector;
    private AtomContentElement contentElement = null;

    public void run() {
        this.run((IAction)this);
    }

    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String requestAction = "";
        if (action.getId().equals(REFRESH_ACTION)) {
            this.runRefresh();
        } else if (action.getId().equals(CINT_START_ACTION) || action.getId().equals(CINT_STOP_ACTION) || action.getId().equals(CINT_PAUSE_ACTION) || action.getId().equals(CINT_CONTINUE_ACTION) || action.getId().equals(CINT_START_SCENARIO_BASED_COLLECTION_ACTION)) {
            this.runCintAction(action.getId());
        } else if (action.getId().equals(CINC_START_ACTION) || action.getId().equals(CINC_STOP_ACTION)) {
            this.runCincAction(action.getId());
        } else if (action.getId().equals(EDIT_USER_ACTION)) {
            this.runEditUserAction();
        } else if (action.getId().equals(EDIT_REGION_ACTION)) {
            this.runEditRegionAction();
        } else if (action.getId().equals(SAVE_OPTIONS_ACTION)) {
            this.runSaveCincOptions();
        } else if (action.getId().equals(SAVE_REGION_OPTIONS_ACTION)) {
            this.runSaveCintOptions();
        } else if (action.getId().equals(WebServiceRequest.CINT_RESET_REGION_DEFAULTS_ACTION)) {
            this.resetCintOptions();
        }
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"run");
    }

    private void runRefresh() {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"runRefresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomController controller = AtomController.getInstance();
        Collection connections = controller.getConnections();
        Iterator iterator = connections.iterator();
        final ArrayList collectors = new ArrayList();
        while (iterator.hasNext()) {
            IAtomConnection connection = (IAtomConnection)iterator.next();
            if (connection.isAtomService()) {
                final CintGetRequest cintGetRequest = new CintGetRequest(Messages.getString("IAOperationsView.fetchingCollectorInformationText"), (IConnection)connection);
                cintGetRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            final AtomFeed feed = cintGetRequest.getFeed();
                            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Debug.enter((Logger)logger, (String)"CollectorAction.runRefresh().cintGetRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                    try {
                                        if (feed != null && feed.atomEntries != null) {
                                            NavigatorView navigatorView;
                                            for (AtomEntry entry : feed.atomEntries) {
                                                if (entry.atomContent == null) continue;
                                                collectors.add(entry.atomContent);
                                            }
                                            IAOperationsView iaOperationsView = Activator.findIAOperationsView();
                                            if (iaOperationsView != null) {
                                                iaOperationsView.setInput(collectors);
                                            }
                                            if ((navigatorView = Activator.findNavigatorView()) != null) {
                                                RegionExplorer regionExplorer = navigatorView.getRegionExplorer();
                                                regionExplorer.updateCollectorStatus(collectors);
                                            }
                                        }
                                    }
                                    catch (Exception ex) {
                                        Debug.warning((Logger)logger, (String)"CollectorAction.runRefresh().cintGetRequest.JobChangeAdapter().done().syncExec", (String)"run", (Throwable)ex, new HashMap());
                                        IAPlugin.getDefault().logError(Messages.getString("IAOperationsView.errorAtRefreshingText"), (Throwable)ex);
                                    }
                                    Debug.exit((Logger)logger, (String)"CollectorAction.runRefresh().cintGetRequest.JobChangeAdapter().done().syncExec", (String)"run");
                                }
                            });
                        }
                    }
                });
                cintGetRequest.setRule((ISchedulingRule)WebServiceRequest.MUTEX_RULE);
                cintGetRequest.schedule();
                final CincGetRequest cincGetRequest = new CincGetRequest(Messages.getString("IAOperationsView.fetchingCollectorInformationText"), (IConnection)connection);
                cincGetRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            final AtomFeed feed = cincGetRequest.getFeed();
                            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Debug.enter((Logger)logger, (String)"CollectorAction.runRefresh().cincGetRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                    try {
                                        if (feed != null && feed.atomEntries != null) {
                                            for (AtomEntry entry : feed.atomEntries) {
                                                if (entry.atomContent == null) continue;
                                                collectors.add(entry.atomContent);
                                            }
                                            IAOperationsView iaOperationsView = Activator.findIAOperationsView();
                                            if (iaOperationsView != null) {
                                                iaOperationsView.setInput(collectors);
                                            }
                                        }
                                    }
                                    catch (Exception ex) {
                                        Debug.warning((Logger)logger, (String)"CollectorAction.runRefresh().cincGetRequest.JobChangeAdapter().done().syncExec", (String)"run", (Throwable)ex, new HashMap());
                                        IAPlugin.getDefault().logError(Messages.getString("IAOperationsView.errorAtRefreshingText"), (Throwable)ex);
                                    }
                                    Debug.exit((Logger)logger, (String)"CollectorAction.runRefresh().cincGetRequest.JobChangeAdapter().done().syncExec", (String)"run");
                                }
                            });
                        }
                    }
                });
                cincGetRequest.setRule((ISchedulingRule)WebServiceRequest.MUTEX_RULE);
                cincGetRequest.schedule();
                continue;
            }
            final WebServiceRequest webServiceRequest = new WebServiceRequest(Messages.getString("IAOperationsView.fetchingCollectorInformationText"), null, null, "ACTION_GET_COLLECTORS_LIST", connection);
            webServiceRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Debug.enter((Logger)logger, (String)"CollectorAction.runRefresh().webServiceRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                try {
                                    CollectorAction.updateViews(webServiceRequest.getAtomContents());
                                }
                                catch (Exception ex) {
                                    Debug.warning((Logger)logger, (String)"CollectorAction.runRefresh().webServiceRequest.JobChangeAdapter().done().syncExec", (String)"run", (String)Messages.getString("IAOperationsView.errorAtRefreshingText"), (Throwable)ex);
                                    IAPlugin.getDefault().logError(Messages.getString("IAOperationsView.errorAtRefreshingText"), (Throwable)ex);
                                }
                                Debug.exit((Logger)logger, (String)"CollectorAction.runRefresh().webServiceRequest.JobChangeAdapter().done().syncExec", (String)"run");
                            }
                        });
                    }
                }
            });
            webServiceRequest.schedule();
        }
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"runRefresh");
    }

    protected static void updateViews(List<AtomContent> collectors) {
        ThreadsafeReportViewImpl threadsafeReportView;
        NavigatorView navigatorView;
        IAOperationsView iaOperationsView = Activator.findIAOperationsView();
        if (iaOperationsView != null) {
            iaOperationsView.setInput(collectors);
        }
        if ((navigatorView = Activator.findNavigatorView()) != null) {
            RegionExplorer regionExplorer = navigatorView.getRegionExplorer();
            regionExplorer.updateCollectorStatus(collectors);
        }
        if ((threadsafeReportView = Activator.getThreadsafeReportView()) != null) {
            threadsafeReportView.getPresenter().getModel().updateCollectorStatus(collectors);
        }
    }

    private void runCintAction(String action) {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"runCintAction", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String requestAction = "";
        String userMessage = "";
        AtomContentElement element = this.cintCollector.getContentElement().getFirstElementByName("region");
        String applid = element.getAttribute("applid");
        String sysid = element.getAttribute("sysid");
        String connectionID = this.cintCollector.getConnectionID();
        IConnection connection = AtomController.getInstance().getConnection(connectionID);
        if (this.cintCollector.isConnectedToAtom()) {
            if (action.equals(CINT_START_ACTION)) {
                requestAction = "START";
                userMessage = MessageFormat.format(Messages.getString("IAOperationsView.startCintRequestTask"), applid);
            } else if (action.equals(CINT_STOP_ACTION)) {
                requestAction = "STOP";
                userMessage = MessageFormat.format(Messages.getString("IAOperationsView.stopCintRequestTask"), applid);
            } else if (action.equals(CINT_PAUSE_ACTION)) {
                requestAction = "PAUSE";
                userMessage = MessageFormat.format(Messages.getString("IAOperationsView.pauseCintRequestTask"), applid);
            } else if (action.equals(CINT_CONTINUE_ACTION)) {
                requestAction = "CONTINUE";
                userMessage = MessageFormat.format(Messages.getString("IAOperationsView.continueCintRequestTask"), applid);
            }
            final CintPostRequest collectorPostRequest = new CintPostRequest(userMessage, applid, sysid, requestAction, connection);
            final ArrayList collectors = new ArrayList();
            collectorPostRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        final AtomFeed feed = collectorPostRequest.getFeed();
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Debug.enter((Logger)logger, (String)"CollectorAction.runCintAction().cintPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                try {
                                    if (feed != null && feed.atomEntries != null) {
                                        for (AtomEntry entry : feed.atomEntries) {
                                            if (entry.atomContent == null) continue;
                                            collectors.add(entry.atomContent);
                                        }
                                        CollectorAction.updateViews(collectors);
                                    }
                                }
                                catch (Exception ex) {
                                    Debug.warning((Logger)logger, (String)"CollectorAction.runCintAction().cintPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Throwable)ex, new HashMap());
                                    IAPlugin.getDefault().logError(Messages.getString("IAOperationsView.errorAtRefreshingText"), (Throwable)ex);
                                }
                                Debug.exit((Logger)logger, (String)"CollectorAction.runCintAction().cintPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                            }
                        });
                    }
                }
            });
            collectorPostRequest.setRule((ISchedulingRule)WebServiceRequest.MUTEX_RULE);
            collectorPostRequest.schedule();
        } else {
            if (action.equals(CINT_START_ACTION)) {
                requestAction = "CINT_START_ACTION";
                userMessage = MessageFormat.format(Messages.getString("IAOperationsView.startCintRequestTask"), applid);
            } else if (action.equals(CINT_STOP_ACTION)) {
                requestAction = "CINT_STOP_ACTION";
                userMessage = MessageFormat.format(Messages.getString("IAOperationsView.stopCintRequestTask"), applid);
            } else if (action.equals(CINT_PAUSE_ACTION)) {
                requestAction = "PAUSE";
                userMessage = MessageFormat.format(Messages.getString("IAOperationsView.pauseCintRequestTask"), applid);
            } else if (action.equals(CINT_CONTINUE_ACTION)) {
                requestAction = "CONTINUE";
                userMessage = MessageFormat.format(Messages.getString("IAOperationsView.continueCintRequestTask"), applid);
            } else if (action.equals(CINT_START_SCENARIO_BASED_COLLECTION_ACTION)) {
                if (connection != null) {
                    ScenarioBasedCollectionViewImpl view = new ScenarioBasedCollectionViewImpl(Display.getCurrent().getActiveShell());
                    try {
                        ScenarioBasedCollectionModelImpl model = new ScenarioBasedCollectionModelImpl(applid, sysid, connection);
                        ScenarioBasedCollectionPresenterImpl presenter = new ScenarioBasedCollectionPresenterImpl((ScenarioBasedCollectionModel)model, view);
                        view.setPresenter(presenter);
                    }
                    catch (CintAlreadyInUseException e) {
                        Debug.warning((Logger)logger, (String)CollectorAction.class.getName(), (String)"runCintAction", (String)"cint already in use", (Throwable)e);
                        view.hide();
                    }
                    catch (Exception e) {
                        Debug.warning((Logger)logger, (String)CollectorAction.class.getName(), (String)"runCintAction", (String)"Unable to get the response from the webservice", (Throwable)e);
                        view.hide();
                        AtomController.getInstance().disconnect((IAtomConnection)connection, 0, "");
                        IAPlugin.getDefault().logError("Unable to get the response from the webservice", (Throwable)e);
                    }
                }
                Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"runCintAction");
                return;
            }
            final WebServiceRequest webServiceRequest = new WebServiceRequest(userMessage, applid, sysid, requestAction, (IAtomConnection)connection);
            webServiceRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Debug.enter((Logger)logger, (String)"CollectorAction.runCintAction().cintPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                try {
                                    CollectorAction.updateViews(webServiceRequest.getAtomContents());
                                }
                                catch (Exception ex) {
                                    Debug.warning((Logger)logger, (String)"CollectorAction.runCintAction().cintPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (String)Messages.getString("IAOperationsView.errorAtRefreshingText"), (Throwable)ex);
                                    IAPlugin.getDefault().logError(Messages.getString("IAOperationsView.errorAtRefreshingText"), (Throwable)ex);
                                }
                                Debug.exit((Logger)logger, (String)"CollectorAction.runCintAction().cintPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                            }
                        });
                    }
                }
            });
            webServiceRequest.schedule();
        }
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"runCintAction");
    }

    private void runCincAction(String action) {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"runCincAction", (Object)("ThreadId: " + Thread.currentThread().getId()));
        String requestAction = "";
        String userMessage = "";
        String connectionID = this.cincCollector.getConnectionID();
        IConnection connection = AtomController.getInstance().getConnection(connectionID);
        if (this.cincCollector.isConnectedToAtom()) {
            if (action.equals(CINC_START_ACTION)) {
                requestAction = "START";
                userMessage = Messages.getString("IAOperationsView.startCincRequestTask");
            } else if (action.equals(CINC_STOP_ACTION)) {
                requestAction = "STOP";
                userMessage = Messages.getString("IAOperationsView.stopCincRequestTask");
            }
            final CincPostRequest collectorPostRequest = new CincPostRequest(userMessage, requestAction, null, connection);
            final ArrayList collectors = new ArrayList();
            collectorPostRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        final AtomFeed feed = collectorPostRequest.getFeed();
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Debug.enter((Logger)logger, (String)"CollectorAction.runCincAction().cincPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                try {
                                    if (feed != null && feed.atomEntries != null) {
                                        for (AtomEntry entry : feed.atomEntries) {
                                            if (entry.atomContent == null) continue;
                                            collectors.add(entry.atomContent);
                                        }
                                        IAOperationsView view = Activator.findIAOperationsView();
                                        if (view != null) {
                                            view.setInput(collectors);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    Debug.warning((Logger)logger, (String)"CollectorAction.runCincAction().cincPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Throwable)ex, new HashMap());
                                    IAPlugin.getDefault().logError(Messages.getString("IAOperationsView.errorAtRefreshingText"), (Throwable)ex);
                                }
                                Debug.exit((Logger)logger, (String)"CollectorAction.runCincAction().cincPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                            }
                        });
                    }
                }
            });
            collectorPostRequest.setRule((ISchedulingRule)WebServiceRequest.MUTEX_RULE);
            collectorPostRequest.schedule();
        } else {
            if (action.equals(CINC_START_ACTION)) {
                requestAction = "CINC_START_ACTION";
                userMessage = Messages.getString("IAOperationsView.startCincRequestTask");
            } else if (action.equals(CINC_STOP_ACTION)) {
                requestAction = "CINC_STOP_ACTION";
                userMessage = Messages.getString("IAOperationsView.stopCincRequestTask");
            }
            final WebServiceRequest webServiceRequest = new WebServiceRequest(userMessage, null, null, requestAction, (IAtomConnection)connection);
            webServiceRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Debug.enter((Logger)logger, (String)"CollectorAction.runCincAction().cincPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                try {
                                    IAOperationsView view = Activator.findIAOperationsView();
                                    if (view != null) {
                                        view.setInput(webServiceRequest.getAtomContents());
                                    }
                                }
                                catch (Exception ex) {
                                    Debug.warning((Logger)logger, (String)"CollectorAction.runCincAction().cincPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)Messages.getString("IAOperationsView.errorAtRefreshingText"));
                                    IAPlugin.getDefault().logError(Messages.getString("IAOperationsView.errorAtRefreshingText"), (Throwable)ex);
                                }
                                Debug.exit((Logger)logger, (String)"CollectorAction.runCincAction().cincPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                            }
                        });
                    }
                }
            });
            webServiceRequest.schedule();
        }
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"runCincAction");
    }

    private void runSaveCincOptions() {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"runSaveCincOptions", (Object)("ThreadId: " + Thread.currentThread().getId()));
        AtomContentElement content = new AtomContentElement();
        content.setName("content");
        content.setAttribute("type", "text/xml");
        content.addElement(this.contentElement);
        String connectionID = this.cincCollector.getConnectionID();
        IConnection connection = AtomController.getInstance().getConnection(connectionID);
        if (this.cincCollector.isConnectedToAtom()) {
            final CincPostRequest collectorPostRequest = new CincPostRequest(Messages.getString("CommandFlowEditor.saveRequestTask"), content, "?cinc=y", connection);
            collectorPostRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        final AtomFeed feed = collectorPostRequest.getFeed();
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Debug.enter((Logger)logger, (String)"CollectorAction.runSaveCincOptions().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                    if (feed != null && feed.atomEntries.size() > 0) {
                                        AtomContentElement element = ((AtomEntry)feed.atomEntries.get((int)0)).atomContent.getContentElement();
                                        AtomContentElement updated = element.getFirstElementByName("updated");
                                        if (updated == null && Activator.findEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT) == null) {
                                            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 200);
                                            messageBox.setText(Messages.getString("SaveCommandFlowOptionsError.title.text"));
                                            String message = collectorPostRequest.getMessage();
                                            if (!"".equals(message)) {
                                                messageBox.setMessage(MessageFormat.format(Messages.getString("SaveCommandFlowOptionsError.message.skeleton.text"), message));
                                            } else {
                                                messageBox.setMessage(Messages.getString("SaveCommandFlowOptionsError.message.text"));
                                            }
                                            int result = messageBox.open();
                                            if (result == 128) {
                                                Debug.exit((Logger)logger, (String)"CollectorAction.runSaveCincOptions().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                                                return;
                                            }
                                            IEditorPart editor = Activator.openEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CommandFlowEditor", false);
                                            if (editor != null) {
                                                ((CommandFlowEditor)editor).setInput((AtomContent)CollectorAction.this.cincCollector);
                                                ((CommandFlowEditor)editor).updateInput(CollectorAction.this.contentElement);
                                            }
                                        } else if (Activator.findEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT) != null) {
                                            IEditorPart editor = Activator.openEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CommandFlowEditor", false);
                                            ((CommandFlowEditor)editor).setInput((AtomContent)CollectorAction.this.cincCollector);
                                            ((CommandFlowEditor)editor).updateInput(element);
                                        } else {
                                            CollectorAction.this.cincCollector.setUpdateElement(element);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"runSaveCincOptions", (Throwable)ex);
                                }
                                Debug.exit((Logger)logger, (String)"CollectorAction.runSaveCincOptions().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                            }
                        });
                    }
                }
            });
            collectorPostRequest.setRule((ISchedulingRule)WebServiceRequest.MUTEX_RULE);
            collectorPostRequest.schedule();
        } else {
            final WebServiceRequest webServiceRequest = new WebServiceRequest(Messages.getString("CommandFlowEditor.saveRequestTask"), content, "CINC_SAVE_ACTION", (IAtomConnection)((AtomConnection)connection));
            webServiceRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        final List atomContents = webServiceRequest.getAtomContents();
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Debug.enter((Logger)logger, (String)"CollectorAction.runSaveCincOptions().webServiceRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                try {
                                    if (atomContents != null && atomContents.size() > 0) {
                                        AtomContentElement element = ((AtomContent)atomContents.get(0)).getContentElement();
                                        AtomContentElement updated = element.getFirstElementByName("updated");
                                        if (updated == null && Activator.findEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT) == null) {
                                            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 200);
                                            messageBox.setText(Messages.getString("SaveCommandFlowOptionsError.title.text"));
                                            String message = webServiceRequest.getMessage();
                                            if (!"".equals(message)) {
                                                messageBox.setMessage(MessageFormat.format(Messages.getString("SaveCommandFlowOptionsError.message.skeleton.text"), message));
                                            } else {
                                                messageBox.setMessage(Messages.getString("SaveCommandFlowOptionsError.message.text"));
                                            }
                                            int result = messageBox.open();
                                            if (result == 128) {
                                                Debug.exit((Logger)logger, (String)"CollectorAction.runSaveCincOptions().webServiceRequest.JobChangeAdapter().done().syncExec", (String)"run");
                                                return;
                                            }
                                            IEditorPart editor = Activator.openEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CommandFlowEditor", false);
                                            if (editor != null) {
                                                ((CommandFlowEditor)editor).setInput((AtomContent)CollectorAction.this.cincCollector);
                                                ((CommandFlowEditor)editor).updateInput(CollectorAction.this.contentElement);
                                            }
                                        } else if (Activator.findEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT) != null) {
                                            IEditorPart editor = Activator.openEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CommandFlowEditor", false);
                                            ((CommandFlowEditor)editor).setInput((AtomContent)CollectorAction.this.cincCollector);
                                            ((CommandFlowEditor)editor).updateInput(element);
                                        } else {
                                            CollectorAction.this.cincCollector.setUpdateElement(element);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    Debug.warning((Logger)logger, (String)CollectorAction.class.getName(), (String)"runSaveCincOptions", (String)"empty catch", (Throwable)ex);
                                }
                            }
                        });
                    }
                }
            });
            webServiceRequest.schedule();
        }
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"runSaveCincOptions");
    }

    private void resetCintOptions() {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"resetCintOptions", (Object)("threadID: " + Thread.currentThread().getId()));
        String connectionID = this.cintCollector.getConnectionID();
        IConnection connection = AtomController.getInstance().getConnection(connectionID);
        final AtomContentElement contentElement = this.cintCollector.getContentElement().getFirstElementByName("region");
        final WebServiceRequest webServiceRequest = new WebServiceRequest(Messages.getString("IAOperationsView.resetRegionDefaultsCintRequestTask"), contentElement.getAttribute("applid"), contentElement.getAttribute("sysid"), WebServiceRequest.CINT_RESET_REGION_DEFAULTS_ACTION, (IAtomConnection)connection);
        webServiceRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    final List atomContents = webServiceRequest.getAtomContents();
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"CollectorAction.resetCintOptions().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            try {
                                IEditorPart view = null;
                                if (atomContents != null && atomContents.size() > 0) {
                                    AtomContentElement element = ((AtomContent)atomContents.get(0)).getContentElement();
                                    AtomContentElement updated = element.getFirstElementByName("updated");
                                    if (updated == null && Activator.findEditor(CintEditor.DEFAULT_EDITOR_INPUT) == null) {
                                        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 200);
                                        messageBox.setText(Messages.getString("SaveCintOptionsError.title.text"));
                                        String message = webServiceRequest.getMessage();
                                        if (!"".equals(message)) {
                                            messageBox.setMessage(MessageFormat.format(Messages.getString("SaveCintOptionsError.message.skeleton.text"), message));
                                        } else {
                                            messageBox.setMessage(Messages.getString("SaveCintOptionsError.message.text"));
                                        }
                                        int result = messageBox.open();
                                        if (result == 128) {
                                            Debug.exit((Logger)logger, (String)"CollectorAction.resetCintOptions().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                                            return;
                                        }
                                        view = Activator.openEditor(CintEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CintEditor", false);
                                        if (view != null) {
                                            ((CintEditor)view).setInput((AtomContent)CollectorAction.this.cintCollector);
                                            ((CintEditor)view).updateInput(contentElement);
                                        }
                                    } else {
                                        view = Activator.findEditor(CintEditor.DEFAULT_EDITOR_INPUT);
                                        if (view != null) {
                                            CintEditor cintEditor = (CintEditor)view;
                                            Region region = ((CintCollector)cintEditor.getCollector()).getRegion();
                                            if (region.equals((Object)CollectorAction.this.cintCollector.getRegion())) {
                                                cintEditor.setInput((AtomContent)CollectorAction.this.cintCollector);
                                                cintEditor.updateInput(element);
                                            }
                                        } else {
                                            CollectorAction.this.cintCollector.setUpdateElement(element);
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                Debug.warning((Logger)logger, (String)CollectorAction.class.getName(), (String)"resetCintOptions", (String)"empty catch", (Throwable)ex);
                            }
                            Debug.exit((Logger)logger, (String)"CollectorAction.resetCintOptions().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                        }
                    });
                }
            }
        });
        webServiceRequest.schedule();
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"resetCintOptions");
    }

    private void runSaveCintOptions() {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"runSaveCintOptions", (Object)("ThreadID: " + Thread.currentThread().getId()));
        AtomContentElement content = new AtomContentElement();
        content.setName("content");
        content.setAttribute("type", "text/xml");
        content.addElement(this.contentElement);
        String connectionID = this.cintCollector.getConnectionID();
        IConnection connection = AtomController.getInstance().getConnection(connectionID);
        AtomContentElement element = this.cintCollector.getContentElement().getFirstElementByName("region");
        this.contentElement.setName("action");
        this.contentElement.setAttribute("applid", element.getAttribute("applid"));
        this.contentElement.setAttribute("sysid", element.getAttribute("sysid"));
        this.contentElement.setValue("update".toUpperCase());
        if (this.cintCollector.isConnectedToAtom()) {
            final CintPostRequest collectorPostRequest = new CintPostRequest(Messages.getString("CintEditor.saveRequestTask"), content, connection);
            collectorPostRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        final AtomFeed feed = collectorPostRequest.getFeed();
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Debug.enter((Logger)logger, (String)"CollectorAction.runSaveCintOption().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                try {
                                    IEditorPart view = null;
                                    if (feed != null && feed.atomEntries.size() > 0) {
                                        AtomContentElement element = ((AtomEntry)feed.atomEntries.get((int)0)).atomContent.getContentElement();
                                        AtomContentElement updated = element.getFirstElementByName("updated");
                                        if (updated == null && Activator.findEditor(CintEditor.DEFAULT_EDITOR_INPUT) == null) {
                                            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 200);
                                            messageBox.setText(Messages.getString("SaveCintOptionsError.title.text"));
                                            String message = collectorPostRequest.getMessage();
                                            if (!"".equals(message)) {
                                                messageBox.setMessage(MessageFormat.format(Messages.getString("SaveCintOptionsError.message.skeleton.text"), message));
                                            } else {
                                                messageBox.setMessage(Messages.getString("SaveCintOptionsError.message.text"));
                                            }
                                            int result = messageBox.open();
                                            if (result == 128) {
                                                return;
                                            }
                                            view = Activator.openEditor(CintEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CintEditor", false);
                                            if (view != null) {
                                                ((CintEditor)view).setInput((AtomContent)CollectorAction.this.cintCollector);
                                                ((CintEditor)view).updateInput(CollectorAction.this.contentElement);
                                            }
                                        } else if (Activator.findEditor(CintEditor.DEFAULT_EDITOR_INPUT) != null) {
                                            view = Activator.openEditor(CintEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CintEditor", false);
                                            if (view != null) {
                                                ((CintEditor)view).setInput((AtomContent)CollectorAction.this.cintCollector);
                                                ((CintEditor)view).updateInput(element);
                                            }
                                        } else {
                                            CollectorAction.this.cintCollector.setUpdateElement(element);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"runSaveCintOptions", (String)"empty catch", (Throwable)ex);
                                }
                                Debug.exit((Logger)logger, (String)"CollectorAction.runSaveCintOptions().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                            }
                        });
                    }
                }
            });
            collectorPostRequest.setRule((ISchedulingRule)WebServiceRequest.MUTEX_RULE);
            collectorPostRequest.schedule();
        } else {
            final WebServiceRequest webServiceRequest = new WebServiceRequest(Messages.getString("CintEditor.saveRequestTask"), content, (IAtomConnection)connection);
            webServiceRequest.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        final List atomContents = webServiceRequest.getAtomContents();
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Debug.enter((Logger)logger, (String)"CollectorAction.runSaveCintOption().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                try {
                                    IEditorPart view = null;
                                    if (atomContents != null && atomContents.size() > 0) {
                                        AtomContentElement element = ((AtomContent)atomContents.get(0)).getContentElement();
                                        AtomContentElement updated = element.getFirstElementByName("updated");
                                        if (updated == null && Activator.findEditor(CintEditor.DEFAULT_EDITOR_INPUT) == null) {
                                            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 200);
                                            messageBox.setText(Messages.getString("SaveCintOptionsError.title.text"));
                                            String message = webServiceRequest.getMessage();
                                            if (!"".equals(message)) {
                                                messageBox.setMessage(MessageFormat.format(Messages.getString("SaveCintOptionsError.message.skeleton.text"), message));
                                            } else {
                                                messageBox.setMessage(Messages.getString("SaveCintOptionsError.message.text"));
                                            }
                                            int result = messageBox.open();
                                            if (result == 128) {
                                                Debug.exit((Logger)logger, (String)"CollectorAction.runSaveCintOptions().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                                                return;
                                            }
                                            view = Activator.openEditor(CintEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CintEditor", false);
                                            if (view != null) {
                                                ((CintEditor)view).setInput((AtomContent)CollectorAction.this.cintCollector);
                                                ((CintEditor)view).updateInput(CollectorAction.this.contentElement);
                                            }
                                        } else if (Activator.findEditor(CintEditor.DEFAULT_EDITOR_INPUT) != null) {
                                            view = Activator.openEditor(CintEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CintEditor", false);
                                            if (view != null) {
                                                ((CintEditor)view).setInput((AtomContent)CollectorAction.this.cintCollector);
                                                ((CintEditor)view).updateInput(element);
                                            }
                                        } else {
                                            CollectorAction.this.cintCollector.setUpdateElement(element);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    Debug.warning((Logger)logger, (String)CollectorAction.class.getName(), (String)"runSaveCintOptions", (String)"empty catch", (Throwable)ex);
                                }
                                Debug.exit((Logger)logger, (String)"CollectorAction.runSaveCintOptions().collectorPostRequest.JobChangeAdapter().done().syncExec", (String)"run");
                            }
                        });
                    }
                }
            });
            webServiceRequest.schedule();
        }
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"runSaveCintOptions");
    }

    private boolean reopenEditor(CollectorOptionsEditor editor, AtomContent collector, String title, String msg) {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"reopenEditor", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "editor: " + (editor == null ? editor : editor.getTitle()), "collector connectionId: " + (collector == null ? collector : collector.getConnectionID()), "title: " + title, "msg: " + msg});
        if (editor != null && editor.isDirty()) {
            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 200);
            messageBox.setText(title);
            String oldEntity = null;
            if (collector instanceof CincCollector) {
                oldEntity = ((CincCollector)editor.getCollector()).getUserId();
            } else if (collector instanceof CintCollector) {
                oldEntity = ((CintCollector)editor.getCollector()).getName();
            }
            messageBox.setMessage(MessageFormat.format(msg, oldEntity));
            int result = messageBox.open();
            if (result == 128) {
                Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"reopenEditor", (Object)"return false");
                return false;
            }
        }
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"reopenEditor", (Object)"return true");
        return true;
    }

    private void runEditUserAction() {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"runEditUserAction", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IEditorPart editor = Activator.findEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT);
        if (this.reopenEditor(editor == null ? null : (CommandFlowEditor)editor, (AtomContent)this.cincCollector, Messages.getString("OpenCommandFlowEditorDialog.title.text"), Messages.getString("OpenCommandFlowEditorDialog.message.text")) && (editor = Activator.openEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CommandFlowEditor", false)) != null) {
            ((CommandFlowEditor)editor).setInput((AtomContent)this.cincCollector);
        }
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"runEditUserAction");
    }

    private void runEditRegionAction() {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"runEditRegionAction", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String connectionID = this.cintCollector.getConnectionID();
        IConnection connection = AtomController.getInstance().getConnection(connectionID);
        if (connection == null) {
            Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"runEditRegionAction", (Object)"connection == null");
            return;
        }
        IEditorPart editor = Activator.findEditor(CintEditor.DEFAULT_EDITOR_INPUT);
        if (this.reopenEditor(editor == null ? null : (CintEditor)editor, (AtomContent)this.cintCollector, Messages.getString("OpenCintEditorDialog.title.text"), Messages.getString("OpenCintEditorDialog.message.text")) && (editor = Activator.openEditor(CintEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CintEditor", false)) != null) {
            ((CintEditor)editor).setInput((AtomContent)this.cintCollector);
            if (this.cintCollector.getUpdateElement() != null) {
                ((CintEditor)editor).updateInput(this.cintCollector.getUpdateElement());
                this.cintCollector.setUpdateElement(null);
            }
        }
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"runEditRegionAction");
    }

    public void setCintCollector(CintCollector aCintCollector) {
        this.cintCollector = aCintCollector;
        this.cincCollector = null;
    }

    public void setCincCollector(CincCollector aCincCollector) {
        this.cincCollector = aCincCollector;
        this.cintCollector = null;
    }

    public void setAtomContent(AtomContentElement anElement) {
        this.contentElement = anElement;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Debug.enter((Logger)logger, (String)CollectorAction.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof CintCollector) {
                this.cintCollector = (CintCollector)firstElement;
                this.cincCollector = null;
            } else if (firstElement instanceof Region) {
                this.cintCollector = ((Region)firstElement).getCollector();
                this.cincCollector = null;
            } else if (firstElement instanceof CincCollector) {
                this.cincCollector = (CincCollector)firstElement;
                this.cintCollector = null;
            }
        }
        Debug.exit((Logger)logger, (String)CollectorAction.class.getName(), (String)"selectionChanged");
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    private boolean isConnectedToAtom() {
        if (this.cincCollector != null) {
            return this.cincCollector.isConnectedToAtom();
        }
        if (this.cintCollector != null) {
            return this.cintCollector.isConnectedToAtom();
        }
        return false;
    }
}

