/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.CallAnalyzer;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.CSVUtils;
import com.ibm.cics.ia.ui.CommandHistoryManager;
import com.ibm.cics.ia.ui.DefaultEditorInputImpl;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.SelectionProvider;
import com.ibm.cics.ia.ui.TreeSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.VerbFormatter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.EditorPart;

public class UsageTree
extends EditorPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(UsageTree.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.ia.ui.usagetree";
    private static final String RESOURCE = "RESOURCE";
    public static final DefaultEditorInputImpl DEFAULT_EDITOR_INPUT = new DefaultEditorInputImpl(){};
    private Tree tree;
    private CommandHistoryManager commandHistoryManager;
    private CallAnalyzer currentAnalyzer;
    private Display display;
    private Map resourceToItems = new HashMap();
    private Label titleLabel;
    private Label totalsLabel;
    private int totalProgramsAndTransactions;
    private CallAnalyzer.Listener callAnalyzerListener;
    private Composite parent;
    private Composite c;
    private Job executionJob;
    private boolean collectTransactions;
    private boolean collectPrograms;
    private Action maximiseTreeAction;
    private Action minimiseTreeAction;
    private Action copyAction;
    private SelectionProvider selectionProvider;
    private ConnectionServiceListener connectionServiceListener;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)UsageTree.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        this.display = parent.getDisplay();
        this.commandHistoryManager = new CommandHistoryManager(){

            @Override
            void executeCommand(Command aCommand) {
                UsageTree.this.execute((CallAnalyzer)aCommand);
            }
        };
        this.c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.c.setLayout((Layout)gridLayout);
        ToolBar toolBar = UIUtilities.createToolBar(this.c);
        Composite searchComposite = new Composite(this.c, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        searchComposite.setLayout((Layout)gridLayout);
        searchComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.titleLabel = new Label(searchComposite, 64);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 100;
        this.titleLabel.setLayoutData((Object)data);
        this.totalsLabel = new Label(searchComposite, 0);
        data = new GridData(0x1000008, 0x1000000, false, false);
        this.totalsLabel.setLayoutData((Object)data);
        this.totalsLabel.setText("    ");
        this.tree = new Tree(this.c, 2564);
        this.tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
            }

            public void treeExpanded(TreeEvent e) {
            }
        });
        this.tree.addKeyListener((KeyListener)new UIUtilities.CopyListener(){

            @Override
            public void copy() {
                UsageTree.this.doCopy();
            }
        });
        data = new GridData(4, 4, true, true);
        this.tree.setLayoutData((Object)data);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.usage_tree");
        this.selectionProvider = new TreeSelectionProvider(this.tree, RESOURCE);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.maximiseTreeAction = new Action(){

            public void run() {
                UIUtilities.expandTree(UsageTree.this.tree, true);
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getExpandImage());
            }
        };
        this.maximiseTreeAction.setToolTipText(Messages.getString("Button.tooltip.maximise"));
        this.minimiseTreeAction = new Action(){

            public void run() {
                UIUtilities.expandTree(UsageTree.this.tree, false);
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getCollapseImage());
            }
        };
        this.copyAction = new Action("Copy", null){

            public void run() {
                UsageTree.this.doCopy();
            }
        };
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.minimiseTreeAction.setToolTipText(Messages.getString("Button.tooltip.minimise"));
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        toolBarManager.add((IAction)this.minimiseTreeAction);
        toolBarManager.add((IAction)this.maximiseTreeAction);
        this.commandHistoryManager.createActions((IToolBarManager)toolBarManager);
        toolBarManager.update(true);
        toolBar.pack();
        MenuManager menuMgr = new MenuManager();
        Menu popupMenu = menuMgr.createContextMenu((Control)this.tree);
        this.tree.setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Debug.exit((Logger)logger, (String)UsageTree.class.getName(), (String)"createPartControl");
    }

    public Job setInput(Resource aResource, Region aRegion, boolean collectPrograms, boolean collectTransactions) {
        Debug.enter((Logger)logger, (String)UsageTree.class.getName(), (String)"setInput", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.collectPrograms = collectPrograms;
        this.collectTransactions = collectTransactions;
        CallAnalyzer callAnalyzer = new CallAnalyzer(collectPrograms, collectTransactions);
        callAnalyzer.setRoot(aResource);
        callAnalyzer.setRegion(aRegion);
        DisplayableData displayableData = DisplayableData.getDisplayableData((IAdaptable)callAnalyzer);
        displayableData.setImage(ImageFactory.getUsedByImage());
        String description = collectPrograms ? (aRegion == null ? MessageFormat.format(Messages.getString("UsageTree.Desc.ProgramsAllRegions"), ResourceRenderer.asQualifiedName(aResource)) : MessageFormat.format(Messages.getString("UsageTree.Desc.Programs"), ResourceRenderer.asQualifiedName(aResource), aRegion.getName())) : (aRegion == null ? MessageFormat.format(Messages.getString("UsageTree.Desc.TransactionsAllRegions"), ResourceRenderer.asQualifiedName(aResource)) : MessageFormat.format(Messages.getString("UsageTree.Desc.Transactions"), ResourceRenderer.asQualifiedName(aResource), aRegion.getName()));
        callAnalyzer.setDescription(description);
        displayableData.setDescription(description);
        Debug.exit((Logger)logger, (String)UsageTree.class.getName(), (String)"setInput");
        return this.execute(callAnalyzer);
    }

    private void clear() {
        Debug.enter((Logger)logger, (String)UsageTree.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.setTitleLabel("");
        this.setTotalProgramsAndTransactions(0);
        if (this.currentAnalyzer != null) {
            this.currentAnalyzer.clear();
        }
        if (this.tree != null && !this.tree.isDisposed()) {
            this.tree.removeAll();
        }
        this.resourceToItems.clear();
        this.totalProgramsAndTransactions = 0;
        if (this.selectionProvider != null) {
            this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        Debug.exit((Logger)logger, (String)UsageTree.class.getName(), (String)"clear");
    }

    private void setTitleLabel(final String aString) {
        Debug.enter((Logger)logger, (String)UsageTree.class.getName(), (String)"setTitleLabel", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (UsageTree.this.titleLabel != null && !UsageTree.this.titleLabel.isDisposed()) {
                        UsageTree.this.titleLabel.setText(aString);
                        UsageTree.this.titleLabel.getParent().getParent().layout(true);
                    }
                }
            });
        } else if (this.titleLabel != null && !this.titleLabel.isDisposed()) {
            this.titleLabel.setText(aString);
            this.titleLabel.getParent().getParent().layout(true);
        }
        Debug.exit((Logger)logger, (String)UsageTree.class.getName(), (String)"setTitleLabel");
    }

    private Job execute(CallAnalyzer aCallAnalyzer) {
        Debug.enter((Logger)logger, (String)UsageTree.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clear();
        this.c.setCursor(this.parent.getDisplay().getSystemCursor(3));
        if (this.executionJob != null && this.executionJob.getState() != 0) {
            this.executionJob.cancel();
            this.executionJob = null;
            this.currentAnalyzer.removeListener(this.getCallAnalyzerListener());
            if (this.currentAnalyzer.status() == 0) {
                UIUtilities.cancel((Command)this.currentAnalyzer);
            }
        }
        this.commandHistoryManager.searchStarted((Command)aCallAnalyzer);
        final String searchText = DisplayableData.getDisplayableData((IAdaptable)aCallAnalyzer).getDescription();
        this.setTitleLabel(searchText);
        this.currentAnalyzer = aCallAnalyzer;
        this.currentAnalyzer.addListener(this.getCallAnalyzerListener());
        TreeItem resourceItem = new TreeItem(this.tree, 0);
        Resource aRoot = this.currentAnalyzer.getRoot();
        resourceItem.setText(ResourceRenderer.asText(aRoot));
        resourceItem.setImage(ResourceRenderer.asImage(aRoot));
        resourceItem.setData(RESOURCE, (Object)aRoot);
        ArrayList<TreeItem> resourceItems = new ArrayList<TreeItem>();
        resourceItems.add(resourceItem);
        this.resourceToItems.put(aRoot, resourceItems);
        if (this.currentAnalyzer.status() == -1) {
            this.executionJob = new JobWithCancelingSupport(searchText){

                protected void cancelingSub() {
                    super.canceling();
                    UIUtilities.cancel((Command)UsageTree.this.currentAnalyzer);
                    UsageTree.this.setTitleLabel(DisplayableData.getDisplayableData((IAdaptable)UsageTree.this.currentAnalyzer).getDescription());
                    IAPlugin.getDefault().taskEnded();
                }

                protected IStatus runSub(IProgressMonitor monitor) {
                    Debug.enter((Logger)logger, (String)"UsageTree.execute().executionJob", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    monitor.beginTask(searchText, -1);
                    UsageTree.this.currentAnalyzer.start();
                    monitor.done();
                    IAPlugin.getDefault().taskEnded();
                    Debug.exit((Logger)logger, (String)"UsageTree.execute().executionJob", (String)"runSub");
                    return Status.OK_STATUS;
                }
            };
            UIUtilities.scheduleWorkbenchPartJob((IWorkbenchPart)this, this.executionJob);
        } else {
            this.processCommandResults(true);
        }
        Debug.exit((Logger)logger, (String)UsageTree.class.getName(), (String)"execute");
        return this.executionJob;
    }

    private void processCommandResults(final boolean wasPreviouslyRun) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (wasPreviouslyRun) {
                    Debug.enter((Logger)logger, (String)"UsageTree.processCommandResults.syncExec.Runnable", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    ArrayList copyOfResults = (ArrayList)((ArrayList)UsageTree.this.currentAnalyzer.getResults()).clone();
                    Iterator iter = copyOfResults.iterator();
                    while (iter.hasNext()) {
                        UsageTree.this.processResource((CallAnalyzer.ResourceAnalysis)iter.next());
                    }
                    Debug.exit((Logger)logger, (String)"UsageTree.processCommandResults.syncExec.Runnable", (String)"run");
                }
                if (!UsageTree.this.c.isDisposed()) {
                    UsageTree.this.c.setCursor(null);
                }
                UsageTree.this.currentAnalyzer.removeListener(UsageTree.this.getCallAnalyzerListener());
            }
        });
    }

    private CallAnalyzer.Listener getCallAnalyzerListener() {
        if (this.callAnalyzerListener == null) {
            this.callAnalyzerListener = new CallAnalyzer.Listener(){

                public void completed() {
                    UsageTree.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            UsageTree.this.processCommandResults(false);
                        }
                    });
                }

                public void itemsAdded(Collection items) {
                }

                public void resourceAnalyzed(final CallAnalyzer.ResourceAnalysis resourceAnalysis) {
                    UsageTree.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            UsageTree.this.processResource(resourceAnalysis);
                        }
                    });
                }
            };
        }
        return this.callAnalyzerListener;
    }

    private void processResource(CallAnalyzer.ResourceAnalysis aResourceAnalysis) {
        Debug.enter((Logger)logger, (String)UsageTree.class.getName(), (String)"processResource", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.c.isDisposed()) {
            Resource target = aResourceAnalysis.target;
            Resource source = aResourceAnalysis.source;
            List verbs = aResourceAnalysis.verbs;
            int depth = aResourceAnalysis.depth;
            ArrayList copyOfResourcesToItems = (ArrayList)((ArrayList)this.resourceToItems.get(target)).clone();
            Iterator itemsIter = copyOfResourcesToItems.iterator();
            int childrenCreated = 0;
            while (itemsIter.hasNext()) {
                TreeItem resourceItem = (TreeItem)itemsIter.next();
                ++childrenCreated;
                TreeItem sourceItem = new TreeItem(resourceItem, 0);
                StringBuffer sb = new StringBuffer();
                sb.append(ResourceRenderer.asText(source));
                sb.append("  ");
                if (verbs != null) {
                    int i = 0;
                    for (String verb : verbs) {
                        if (!IAUtilities.hasContent((String)verb)) continue;
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(VerbFormatter.format(verb, target.getName()));
                        ++i;
                    }
                }
                sourceItem.setText(sb.toString());
                sourceItem.setImage(ResourceRenderer.asImage(source));
                sourceItem.setData(RESOURCE, (Object)source);
                ArrayList<TreeItem> sourceItems = (ArrayList<TreeItem>)this.resourceToItems.get(source);
                if (sourceItems == null) {
                    sourceItems = new ArrayList<TreeItem>();
                    this.resourceToItems.put(source, sourceItems);
                    sourceItems.add(sourceItem);
                }
                this.setTotalProgramsAndTransactions(this.totalProgramsAndTransactions + childrenCreated);
                if (depth >= 3) continue;
                resourceItem.setExpanded(true);
            }
        }
        Debug.exit((Logger)logger, (String)UsageTree.class.getName(), (String)"processResource");
    }

    private void setTotalProgramsAndTransactions(int aTotal) {
        Debug.enter((Logger)logger, (String)UsageTree.class.getName(), (String)"setTotalProgramsAndTransactions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.totalsLabel != null && !this.totalsLabel.isDisposed()) {
            this.totalsLabel.setText("(" + aTotal + ")");
            this.totalsLabel.getParent().layout();
        }
        this.totalProgramsAndTransactions = aTotal;
        Debug.exit((Logger)logger, (String)UsageTree.class.getName(), (String)"setTotalProgramsAndTransactions");
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (DEFAULT_EDITOR_INPUT != input) {
            throw new PartInitException("Invalid Input: Must be UsageTree.DEFAULT_EDITOR_INPUT");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                        this.exception();
                    }
                }
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        UsageTree.this.clear();
                        IWorkbenchPartSite site = UsageTree.this.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                        if (UsageTree.this.tree != null && !UsageTree.this.tree.isDisposed() && UsageTree.this.currentAnalyzer != null && UsageTree.this.currentAnalyzer.status() != 0) {
                            UsageTree.this.rerun();
                        }
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        UsageTree.this.commandHistoryManager.clear();
                        UsageTree.this.clear();
                        IWorkbenchPartSite site = UsageTree.this.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                });
            }

            public void exception() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (UsageTree.this.currentAnalyzer != null) {
                            if (UsageTree.this.currentAnalyzer.status() != 1) {
                                UsageTree.this.currentAnalyzer.cancel();
                            }
                            UsageTree.this.currentAnalyzer.removeListener(UsageTree.this.getCallAnalyzerListener());
                        }
                    }
                });
            }
        };
    }

    private void rerun() {
        this.c.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (UsageTree.this.currentAnalyzer != null) {
                    if (UsageTree.this.currentAnalyzer.status() == 4) {
                        UsageTree.this.clear();
                    }
                    if (UsageTree.this.currentAnalyzer.status() == 4) {
                        Resource resource = UsageTree.this.currentAnalyzer.getRoot();
                        Region region = UsageTree.this.currentAnalyzer.getRegion();
                        UsageTree.this.currentAnalyzer.reset(resource, region, UsageTree.this.collectPrograms, UsageTree.this.collectTransactions);
                        UsageTree.this.execute(UsageTree.this.currentAnalyzer);
                    }
                }
            }
        });
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)UsageTree.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        super.dispose();
        Debug.exit((Logger)logger, (String)UsageTree.class.getName(), (String)"dispose");
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.ia.connection.db2";
        }
        return super.getPartProperty(key);
    }

    private void doCopy() {
        Clipboard clipboard = new Clipboard(this.display);
        StringBuffer result = new StringBuffer();
        for (String line : CSVUtils.createCSV(this.tree, RESOURCE)) {
            result.append(String.valueOf(line) + IAUtilities.LINE_SEPARATOR);
        }
        if (result.length() > 0) {
            clipboard.setContents(new Object[]{result.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getTitleToolTip() {
        return this.getTitle();
    }
}

