/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.ui.SelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class TreeSelectionProvider
extends SelectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String[] dataKeys;
    private SelectionListener treeSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object object = TreeSelectionProvider.this.extractTreeNodeData(e);
            TreeSelectionProvider.this.setAppropriateSelection(object);
        }
    };
    private SelectionListener tableSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object object = null;
            Table table = (Table)e.widget;
            if (table.getSelectionCount() == 1) {
                if (TreeSelectionProvider.this.dataKeys != null && TreeSelectionProvider.this.dataKeys.length > 0) {
                    int i = 0;
                    while (i < TreeSelectionProvider.this.dataKeys.length && object == null) {
                        object = TreeSelectionProvider.this.dataKeys[i] == null ? table.getSelection()[0].getData() : table.getSelection()[0].getData(TreeSelectionProvider.this.dataKeys[i]);
                        ++i;
                    }
                } else {
                    object = table.getSelection()[0].getData();
                }
            }
            TreeSelectionProvider.this.setAppropriateSelection(object);
        }
    };

    public Object extractTreeNodeData(SelectionEvent e) {
        Object object = null;
        Tree tree = (Tree)e.widget;
        if (tree.getSelectionCount() == 1) {
            if (this.dataKeys != null && this.dataKeys.length > 0) {
                int i = 0;
                while (i < this.dataKeys.length && object == null) {
                    object = this.dataKeys[i] == null ? tree.getSelection()[0].getData() : tree.getSelection()[0].getData(this.dataKeys[i]);
                    ++i;
                }
            } else {
                object = tree.getSelection()[0].getData();
            }
        }
        return object;
    }

    private void setAppropriateSelection(Object object) {
        if (object == null) {
            this.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            this.setSelection((ISelection)new StructuredSelection(object));
        }
    }

    public TreeSelectionProvider(Tree tree, String ... dataKeys) {
        this.dataKeys = dataKeys;
        this.registerTree(tree);
    }

    public void registerTree(Tree tree) {
        tree.addSelectionListener(this.treeSelectionListener);
    }

    public void registerTable(Table table) {
        table.addSelectionListener(this.tableSelectionListener);
    }
}

