/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.TreeNode;
import com.ibm.cics.ia.model.threadsafe.Summary;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ShowDetailsStrategy;
import com.ibm.cics.ia.ui.ThreadsafeReportPresenter;
import com.ibm.cics.ia.ui.ThreadsafeReportView;
import com.ibm.cics.ia.ui.ThreadsafeReportViewInput;
import com.ibm.cics.ia.ui.TreeSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.EditorPart;

public class ThreadsafeReportViewImpl
extends EditorPart
implements ThreadsafeReportView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ThreadsafeReportViewImpl.class.getPackage().getName());
    private Composite rootComp;
    private Clipboard clipboard;
    private Action copyAction;
    private ThreadsafeReportPresenter presenter;
    private Action expandAction;
    private Action collapseAction;
    private String[] summaryColumns = new String[]{"PROGRAM", "LIB_DATASET_NAME", "APIST", "CONCURRENCY", "EXECUTION_KEY", "CICS_STORPROTECT", "REENTRANT", "CICS_RELEASE"};
    private String[] detailedColumns = new String[]{"COMMAND_TYPE", "FUNCTION", "TYPE", "OBJECT", "OFFSET", "USECOUNT", "THREADSAFE_FLAG", "INHIBITOR_FLAG"};
    private TreeViewer treeViewer;
    private TableViewer tableViewer;
    private Display display;
    public static final String ID = "com.ibm.cics.ia.ui.ThreadsafeReportView";
    private TreeSelectionProvider selectionProvider;
    private Composite parent;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        this.setPresenter(((ThreadsafeReportViewInput)this.getEditorInput()).getPresenter());
        this.presenter.setView(this);
        this.setPartName(this.getEditorInput().getName());
        this.rootComp = new Composite(parent, 0);
        this.rootComp.setLayout((Layout)new GridLayout());
        this.display = parent.getDisplay();
        this.clipboard = new Clipboard(this.display);
        this.createToolBar();
        SashForm sash = new SashForm(this.rootComp, 512);
        GridData data = new GridData(4, 4, true, true);
        sash.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer((Composite)sash, 68356);
        this.treeViewer.setColumnProperties(this.summaryColumns);
        int i = 0;
        while (i < this.summaryColumns.length) {
            TreeColumn column = new TreeColumn(this.treeViewer.getTree(), 0);
            column.setText(Messages.getString("ThreadsafeReportViewImpl.Column." + this.summaryColumns[i]));
            column.pack();
            ++i;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
                ThreadsafeReportViewImpl.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeColumn[] treeColumnArray = treeColumns;
                        int n = treeColumns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn treeColumn = treeColumnArray[n2];
                            treeColumn.pack();
                            ++n2;
                        }
                    }
                });
            }
        };
        this.treeViewer.getTree().addListener(17, listener);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ThreadsafeReportViewImpl.this.presenter.onTreeItemSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite bottomComp = new Composite((Composite)sash, 0);
        bottomComp.setLayout((Layout)new GridLayout(1, true));
        this.tableViewer = new TableViewer(bottomComp, 68356);
        ArrayList summaryArrayList = new ArrayList();
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        int i2 = 0;
        while (i2 < this.detailedColumns.length) {
            TableColumn column = new TableColumn(this.tableViewer.getTable(), 0);
            column.setText(Messages.getString("ThreadsafeReportViewImpl.Column." + this.detailedColumns[i2]));
            column.setMoveable(true);
            column.pack();
            ++i2;
        }
        this.tableViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ThreadsafeReportViewImpl.this.presenter.onTableItemSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new ShowDetailsStrategy((Control)this.treeViewer.getTree()){

            @Override
            public Object extractSource() {
                return 4.extractSourceFromTree(ThreadsafeReportViewImpl.this.treeViewer.getTree(), "PROGRAM");
            }
        };
        TreeSelectionProvider selectionProvider = new TreeSelectionProvider(this.treeViewer.getTree(), new String[0]){

            @Override
            public Object extractTreeNodeData(SelectionEvent e) {
                Object object = null;
                Tree tree = (Tree)e.widget;
                if (tree.getSelectionCount() == 1 && (object = tree.getSelection()[0].getData()) != null && object instanceof TreeNode && (object = ((TreeNode)object).getData()) instanceof Summary) {
                    object = ResourceFactory.getSingleton().getProgram(((Summary)object).getProgram());
                }
                return object;
            }
        };
        selectionProvider.registerTree(this.treeViewer.getTree());
        this.getSite().setSelectionProvider((ISelectionProvider)selectionProvider);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu popupMenu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)selectionProvider);
        new ShowDetailsStrategy((Control)this.treeViewer.getTree()){

            @Override
            public Object extractSource() {
                TreeNode node;
                Object data;
                ISelection iSelection = ThreadsafeReportViewImpl.this.treeViewer.getSelection();
                if (iSelection != null && iSelection instanceof StructuredSelection && (data = (node = (TreeNode)((StructuredSelection)iSelection).getFirstElement()).getData()) instanceof Summary) {
                    return ResourceFactory.getSingleton().getProgram(((Summary)data).getProgram());
                }
                return null;
            }
        };
        this.copyAction = new Action(Messages.getString("QueryResultsView.action.copy"), ImageDescriptor.createFromImage((Image)ImageFactory.getSaveImage())){

            public void run() {
                ThreadsafeReportViewImpl.this.presenter.onCopyRequest();
            }
        };
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.presenter.onViewCreation();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createPartControl");
    }

    @Override
    public Action getCopyAction() {
        return this.copyAction;
    }

    @Override
    public Clipboard getClipboard() {
        return this.clipboard;
    }

    private void createToolBar() {
        ToolBar toolBar = UIUtilities.createToolBar(this.rootComp);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        this.collapseAction = new Action(Messages.getString("Button.tooltip.minimise")){

            public void run() {
                ThreadsafeReportViewImpl.this.treeViewer.collapseAll();
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getCollapseImage());
            }

            public String getToolTipText() {
                return this.getText();
            }
        };
        this.expandAction = new Action(Messages.getString("Button.tooltip.maximise")){

            public void run() {
                ThreadsafeReportViewImpl.this.treeViewer.expandAll();
                TreeColumn[] treeColumnArray = ThreadsafeReportViewImpl.this.treeViewer.getTree().getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    column.pack();
                    ++n2;
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getExpandImage());
            }

            public String getToolTipText() {
                return this.getText();
            }
        };
        toolBarManager.add((IAction)this.expandAction);
        toolBarManager.add((IAction)this.collapseAction);
        toolBarManager.update(true);
        toolBar.pack();
    }

    public void setFocus() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"init", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "site: " + site.getId(), "input: " + input.getName()});
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"init");
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public String getTitleToolTip() {
        return this.getTitle();
    }

    public void doSave(IProgressMonitor arg0) {
    }

    public void doSaveAs() {
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    @Override
    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    @Override
    public void setPresenter(ThreadsafeReportPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setHelp(String contextHelpId) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setHelp", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.parent, contextHelpId);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setHelp");
    }

    @Override
    public ThreadsafeReportPresenter getPresenter() {
        return this.presenter;
    }
}

