/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.runtime.IAUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class TextDialog
extends Dialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String oldText = "";
    private String title = "";
    private String newText = "";
    private boolean allowEmpty;
    private int textLimit;

    public TextDialog(Shell parentShell, String title, String oldText, boolean allowEmpty, int textLimit) {
        super(parentShell);
        this.oldText = oldText;
        this.title = title;
        this.newText = oldText;
        this.allowEmpty = allowEmpty;
        this.textLimit = textLimit;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        final Text text = new Text(container, 2048);
        text.setText(this.oldText);
        GridData gridData = new GridData(4, 128, true, false);
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextDialog.this.newText = text.getText();
                TextDialog.this.updateOKStatus();
            }
        });
        text.selectAll();
        text.setTextLimit(this.textLimit);
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Point getInitialSize() {
        return new Point(400, 120);
    }

    public String getText() {
        return this.newText;
    }

    private void updateOKStatus() {
        this.getButton(0).setEnabled(this.allowEmpty || IAUtilities.hasContent((String)this.newText));
    }
}

