/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.ui.actions.ShowDetailsAction;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ShowDetailsStrategy
extends OpenStrategy {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ShowDetailsStrategy(Control control) {
        super(control);
        this.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                Object source = ShowDetailsStrategy.this.extractSource();
                ShowDetailsStrategy.showDetails(source);
            }
        });
    }

    public static void showDetails(Object source) {
        if (source != null && source instanceof Program) {
            ShowDetailsAction action = new ShowDetailsAction();
            action.setSource(source);
            action.run();
        }
    }

    public abstract Object extractSource();

    protected static Object extractSourceFromTree(Tree tree, String key) {
        TreeItem[] selectedItems = tree.getSelection();
        if (selectedItems.length > 0) {
            if (key == null) {
                return selectedItems[0].getData();
            }
            return selectedItems[0].getData(key);
        }
        return null;
    }

    protected static Object extractSourceFromTable(Table table, String key) {
        TableItem[] selectedItems = table.getSelection();
        if (selectedItems.length > 0) {
            if (key == null) {
                return selectedItems[0].getData();
            }
            return selectedItems[0].getData(key);
        }
        return null;
    }
}

