/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.DB2Resource;
import com.ibm.cics.ia.model.IAApplication;
import com.ibm.cics.ia.model.MQResource;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceAndVerb;
import com.ibm.cics.ia.model.Service;
import com.ibm.cics.ia.model.TDQueue;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.TSQueue;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.Webservice;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import java.util.WeakHashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;

public class ResourceRenderer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static WeakHashMap<Image, Image> errors = new WeakHashMap();
    private static WeakHashMap<Image, Image> tcbs = new WeakHashMap();
    private static WeakHashMap<Image, Image> tcbError = new WeakHashMap();
    private static WeakHashMap<Image, Image> eventables = new WeakHashMap();
    private static Image regionStopped = null;
    private static Image regionStarted = null;
    private static Image regionPaused = null;
    private static Image regionUnknown = null;
    private static Image userStopped = null;
    private static Image userStarted = null;
    private static Image userUnknown = null;

    public static String asText(Resource aResource) {
        String result = aResource instanceof Platform ? (!IAUtilities.hasContent((String)aResource.getName()) ? Messages.getString("ResourceRenderer.undefinedPlatform") : aResource.getName()) : (aResource instanceof TSApplication ? (!IAUtilities.hasContent((String)aResource.getName()) ? Messages.getString("ResourceRenderer.undefinedApplication") : ((TSApplication)aResource).getFullName()) : aResource.getName());
        result = result.trim();
        if (result.length() == 0) {
            result = " ";
        }
        return result;
    }

    public static String asQualifiedName(Resource aResource) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ResourceTypeRenderer.asText(aResource.getTypeName()));
        buffer.append("(");
        buffer.append(aResource.getName());
        buffer.append(")");
        return buffer.toString();
    }

    public static Image asImage(Object aResource) {
        Resource resource;
        if (aResource instanceof ResourceAndVerb) {
            ResourceAndVerb resourceAndVerb = (ResourceAndVerb)aResource;
            Resource resource2 = resourceAndVerb.getResource();
            if (resource2 == null) {
                return ImageFactory.getVerbImage();
            }
            aResource = resource2;
        }
        if (aResource instanceof Throwable) {
            return ImageFactory.getErrorImage();
        }
        if (aResource instanceof Region) {
            return ImageFactory.getRegionImage();
        }
        if (aResource instanceof Platform) {
            if (IAUtilities.hasContent((String)((Platform)aResource).getName())) {
                return ImageFactory.getPlatformImage();
            }
            return ImageFactory.getPlatformUnknownImage();
        }
        if (aResource instanceof Program) {
            return ResourceRenderer.asImage((Program)aResource);
        }
        if (aResource instanceof Transaction) {
            return ImageFactory.getTransactionImage();
        }
        if (aResource instanceof Webservice) {
            return ImageFactory.getWebserviceImage();
        }
        if (aResource instanceof Service) {
            return ImageFactory.getWebserviceImage();
        }
        if (aResource instanceof IAApplication) {
            return ImageFactory.getApplicationImage();
        }
        if (aResource instanceof TSApplication) {
            if (IAUtilities.hasContent((String)((TSApplication)aResource).getName())) {
                return ImageFactory.getApplicationCloudImage();
            }
            return ImageFactory.getApplicationCloudUnknownImage();
        }
        if (aResource instanceof TDQueue) {
            return ImageFactory.getTDQImage();
        }
        if (aResource instanceof TSQueue) {
            return ImageFactory.getTSQImage();
        }
        if (aResource instanceof MQResource) {
            return ImageFactory.getQueueImage();
        }
        if (aResource instanceof DB2Resource) {
            if (((DB2Resource)aResource).getTypeName().equals("CURSOR")) {
                return ImageFactory.getDatabaseCursorImage();
            }
            if (((DB2Resource)aResource).getTypeName().equals("TABLE")) {
                return ImageFactory.getDatabaseTableImage();
            }
            if (((DB2Resource)aResource).getTypeName().equals("VIEW")) {
                return ImageFactory.getDatabaseViewImage();
            }
            if (((DB2Resource)aResource).getTypeName().equals("STATEMENT")) {
                return ImageFactory.getDatabaseDomainImage();
            }
            if (((DB2Resource)aResource).getTypeName().equals("DB2ENTRY")) {
                return ImageFactory.getDB2EntryImage();
            }
        }
        if ("FILE".equals((resource = (Resource)aResource).getTypeName())) {
            return ImageFactory.getFileImage();
        }
        if ("MAP".equals(resource.getTypeName())) {
            return ImageFactory.getMapImage();
        }
        if ("TD".equals(resource.getTypeName())) {
            return ImageFactory.getTDQImage();
        }
        if ("ATOMSERVICE".equals(resource.getTypeName())) {
            return ImageFactory.getAtomserviceImage();
        }
        if ("IPCONN".equals(resource.getTypeName())) {
            return ImageFactory.getIpconnImage();
        }
        if ("JVMPROFILE".equals(resource.getTypeName())) {
            return ImageFactory.getJvmProfImage();
        }
        if ("PIPELINE".equals(resource.getTypeName())) {
            return ImageFactory.getPipelineImage();
        }
        return ImageFactory.getResourceImage();
    }

    public static Image getOverLaidImage(Image image, boolean error, boolean tcb, boolean eventable) {
        DecorationOverlayIcon overlay;
        ImageDescriptor descriptor;
        Image overLaidImage = null;
        Image eventableImage = null;
        if (tcb && error) {
            overLaidImage = tcbError.get(image);
        } else if (tcb) {
            overLaidImage = tcbs.get(image);
        } else if (error) {
            overLaidImage = errors.get(image);
        }
        if (overLaidImage == null) {
            if (tcb) {
                descriptor = ImageDescriptor.createFromImage((Image)ImageFactory.getTCBModeSwapImage());
                overlay = new DecorationOverlayIcon(image, descriptor, 3);
                overLaidImage = overlay.createImage();
            }
            if (error) {
                descriptor = ImageDescriptor.createFromImage((Image)ImageFactory.getRespErrorImage());
                overlay = overLaidImage == null ? new DecorationOverlayIcon(image, descriptor, 2) : new DecorationOverlayIcon(overLaidImage, descriptor, 2);
                overLaidImage = overlay.createImage();
            }
            if (overLaidImage == null) {
                overLaidImage = image;
            } else if (tcb && error) {
                tcbError.put(image, overLaidImage);
            } else if (tcb) {
                tcbs.put(image, overLaidImage);
            } else if (error) {
                errors.put(image, overLaidImage);
            }
        }
        if (eventable) {
            eventableImage = eventables.get(overLaidImage);
            if (eventableImage == null) {
                descriptor = ImageDescriptor.createFromImage((Image)ImageFactory.getAsteriskImage());
                overlay = new DecorationOverlayIcon(image, descriptor, 1);
                eventableImage = overlay.createImage();
            }
            if (eventableImage == null) {
                eventableImage = overLaidImage;
            } else {
                eventables.put(overLaidImage, eventableImage);
            }
            overLaidImage = eventableImage;
        }
        return overLaidImage;
    }

    public static Image getOverlaidImageForComparison(Image image, Image typeOfOverlay) {
        Image overLaidImage = null;
        ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)typeOfOverlay);
        DecorationOverlayIcon overlay = new DecorationOverlayIcon(image, descriptor, 1);
        overLaidImage = overlay.createImage();
        return overLaidImage;
    }

    public static Image asImage(Region aRegion) {
        CintCollector collector = aRegion.getCollector();
        Image overlayIcon = null;
        if (collector != null) {
            String collectorState = collector.getState();
            if ("RUNNING".equals(collectorState)) {
                if (regionStarted == null) {
                    overlayIcon = ImageFactory.getCollectorStartedOverlayImage();
                    ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)overlayIcon);
                    Image image = ImageFactory.getRegionImage();
                    DecorationOverlayIcon overlay = new DecorationOverlayIcon(image, descriptor, 3);
                    regionStarted = overlay.createImage();
                }
                return regionStarted;
            }
            if ("PAUSED".equals(collectorState)) {
                if (regionPaused == null) {
                    overlayIcon = ImageFactory.getCollectorPausedOverlayImage();
                    ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)overlayIcon);
                    Image image = ImageFactory.getRegionImage();
                    DecorationOverlayIcon overlay = new DecorationOverlayIcon(image, descriptor, 3);
                    regionPaused = overlay.createImage();
                }
                return regionPaused;
            }
            if ("STOPPED".equals(collectorState)) {
                if (regionStopped == null) {
                    overlayIcon = ImageFactory.getCollectorStoppedOverlayImage();
                    ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)overlayIcon);
                    Image image = ImageFactory.getRegionImage();
                    DecorationOverlayIcon overlay = new DecorationOverlayIcon(image, descriptor, 3);
                    regionStopped = overlay.createImage();
                }
                return regionStopped;
            }
        }
        if (regionUnknown == null) {
            overlayIcon = ImageFactory.getCollectorUnknownOverlayImage();
            ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)overlayIcon);
            Image image = ImageFactory.getRegionImage();
            DecorationOverlayIcon overlay = new DecorationOverlayIcon(image, descriptor, 3);
            regionUnknown = overlay.createImage();
        }
        return regionUnknown;
    }

    public static Image userImage(CincCollector collector) {
        Image overlayIcon = null;
        String state = collector.getState();
        if ("ACTIVE".equals(collector.getState()) || "RUNNING".equals(collector.getState()) || "PARTLY STARTED".equals(collector.getState())) {
            if (userStarted == null) {
                overlayIcon = ImageFactory.getCollectorStartedOverlayImage();
                ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)overlayIcon);
                Image image = ImageFactory.getUserImage();
                DecorationOverlayIcon overlay = new DecorationOverlayIcon(image, descriptor, 3);
                userStarted = overlay.createImage();
            }
            return userStarted;
        }
        if ("STOPPED".equals(state) || "START FAILED".equals(state) || "NO APPLIDS".equals(state) || "NO CONNECTIONS".equals(state) || "NOT ACTIVE".equals(state)) {
            if (userStopped == null) {
                overlayIcon = ImageFactory.getCollectorStoppedOverlayImage();
                ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)overlayIcon);
                Image image = ImageFactory.getUserImage();
                DecorationOverlayIcon overlay = new DecorationOverlayIcon(image, descriptor, 3);
                userStopped = overlay.createImage();
            }
            return userStopped;
        }
        if (userUnknown == null) {
            overlayIcon = ImageFactory.getCollectorUnknownOverlayImage();
            ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)overlayIcon);
            Image image = ImageFactory.getUserImage();
            DecorationOverlayIcon overlay = new DecorationOverlayIcon(image, descriptor, 3);
            userUnknown = overlay.createImage();
        }
        return userUnknown;
    }

    public static Image asImage(Program aProgram) {
        return ImageFactory.getProgramImage();
    }

    public static String asText(ResourceAndVerb resourceAndVerb) {
        String verb = Messages.getVerb(resourceAndVerb.getVerb());
        Resource resource = resourceAndVerb.getResource();
        if (resource == null) {
            return verb;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(verb);
        buffer.append(" ");
        buffer.append(ResourceRenderer.asQualifiedName(resource));
        if (buffer.toString().replaceAll("\\s", "").equals("()")) {
            return "True()";
        }
        return buffer.toString();
    }

    public static String asVerb(String verb, String type) {
        if (verb.equals("START OF TRANSACTION")) {
            return Messages.getVerb(verb);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.getVerb(verb));
        buffer.append(" ");
        buffer.append(ResourceTypeRenderer.asText(type));
        return buffer.toString();
    }
}

