/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.eclipse.common.ui.fieldassist.HistoryContentProposalRegistry;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.ICollectionIdListener;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ExplorerQueryContext;
import com.ibm.cics.ia.ui.ExplorerQueryContextComposite;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.Resource2CSV;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.SelectionProvider;
import com.ibm.cics.ia.ui.TableSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.composites.HistoryBox;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public abstract class ResourceExplorer
extends ViewPart {
    private static final Logger logger = Logger.getLogger(ResourceExplorer.class.getPackage().getName());
    private SQLCommand findCommand;
    private EngineShell.EngineListener commandListener;
    private Display display;
    Table table;
    private Composite c;
    private UIUtilities.FocusKeeper focusKeeper;
    private HistoryBox searchHB;
    private Label searchLabel;
    private HistoryBox contextHB;
    private List programs = new ArrayList();
    private TableItem dummyTableItem;
    private boolean isPopulated = false;
    private ScrollLimitManager scrollLimitManager;
    private Action runAction;
    private Action copyAction;
    private Composite parent;
    private Job findResourcesJob;
    protected ExplorerQueryContextComposite contextComposite;
    private ExplorerQueryContext currentContext = ExplorerQueryContext.REGION;
    private SelectionProvider selectionProvider;
    private ConnectionServiceListener connectionServiceListener;
    private ICollectionIdListener collectionIdListener;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.c = new Composite(parent, 0);
        this.parent = parent;
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.c.setLayout((Layout)gridLayout);
        Composite topComposite = new Composite(this.c, 0);
        GridData data = new GridData(4, 0, true, false);
        topComposite.setLayoutData((Object)data);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        topComposite.setLayout((Layout)gridLayout);
        this.searchHB = new HistoryBox(topComposite, 128);
        this.searchHB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                AccessibleEvent i = e;
                i.toString();
                e.result = Messages.getString("ResourceExplorer.access.msg.filterbyname");
            }
        });
        this.searchHB.setToolTipText(com.ibm.cics.ia.controller.Messages.getString("FindResourceContributionItem.tooltiptxt.usewildcardname"));
        EnumSet<ExplorerQueryContext> contexts = EnumSet.of(ExplorerQueryContext.REGION, ExplorerQueryContext.APPLICATION);
        this.contextComposite = new ExplorerQueryContextComposite(topComposite, contexts, ExplorerQueryContext.REGION, true);
        this.contextComposite.addListener(new ExplorerQueryContextComposite.Listener(){

            @Override
            public void contextChanged(ExplorerQueryContext context) {
                ResourceExplorer.this.currentContext = context;
            }
        });
        this.contextHB = this.contextComposite.contextHB;
        this.contextHB.setToolTipText(com.ibm.cics.ia.controller.Messages.getString("FindResourceContributionItem.tooltiptxt.usewildcardname"));
        this.searchLabel = new Label(topComposite, 0);
        data = new GridData(0x1000008, 0x1000000, true, false);
        this.searchLabel.setLayoutData((Object)data);
        this.searchLabel.setText("     ");
        SelectionAdapter selectionRunListener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
                if (!resourceManager.isConnected()) {
                    Activator.getDefault().ensureConnected();
                } else {
                    ResourceExplorer.this.runSearch();
                }
                HistoryContentProposalRegistry.addValue((String)ResourceExplorer.this.searchHB.getText(true), (String)"com.ibm.cics.eclipse.common.programhistory");
            }
        };
        this.searchHB.addSelectionListener((SelectionListener)selectionRunListener);
        this.contextHB.addSelectionListener((SelectionListener)selectionRunListener);
        this.table = new Table(this.c, 2048);
        data = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)data);
        this.scrollLimitManager = new ScrollLimitManager(this.c, this.getResourceTypesDescription(), (IViewPart)this){

            public void scrollLimitReached(Command command) {
                super.scrollLimitReached(command);
                ResourceExplorer.this.c.layout(new Control[]{ResourceExplorer.this.table, ((ResourceExplorer)ResourceExplorer.this).scrollLimitManager.scrollLimitComposite});
            }

            public void dispose() {
                ResourceExplorer.this.c.layout(new Control[]{ResourceExplorer.this.table});
                super.dispose();
            }
        };
        this.display = parent.getDisplay();
        this.createActions();
        this.table.addKeyListener((KeyListener)new UIUtilities.CopyListener(){

            @Override
            public void copy() {
                if (ResourceExplorer.this.copyAction.isEnabled()) {
                    Resource2CSV.parse(ResourceExplorer.this.table, ResourceExplorer.this.display);
                }
            }
        });
        this.table.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ResourceExplorer.this.copyAction.setEnabled(true);
            }

            public void focusGained(FocusEvent e) {
                if (ResourceExplorer.this.table.getSelectionIndex() < 0 && ResourceExplorer.this.table.getItemCount() > 0) {
                    ResourceExplorer.this.table.setSelection(0);
                }
                if (ResourceExplorer.this.dummyTableItem != null) {
                    ResourceExplorer.this.copyAction.setEnabled(false);
                } else {
                    ResourceExplorer.this.copyAction.setEnabled(true);
                }
            }
        });
        this.selectionProvider = new TableSelectionProvider(this.table);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu popupMenu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        this.setHelpContextIDs(parent);
        this.focusKeeper = new UIUtilities.FocusKeeper(new Composite[]{this.searchHB, this.contextHB, this.table});
        this.focusKeeper.setDefault((Composite)this.table);
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        IAPlugin.getDefault().addCollectionIDListener(this.getCollectionIdListener());
        Debug.exit((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"createPartControl");
    }

    private void createActions() {
        this.runAction = new Action(){

            public void run() {
                ResourceExplorer.this.runSearch();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.run", (IAction)this.runAction);
        this.copyAction = new Action("Copy", null){

            public void run() {
                if (ResourceExplorer.this.table.isFocusControl()) {
                    Resource2CSV.parse(ResourceExplorer.this.table, ResourceExplorer.this.display);
                } else if (ResourceExplorer.this.searchHB.isFocusControl()) {
                    ResourceExplorer.this.searchHB.copyToClipboard();
                } else if (ResourceExplorer.this.contextHB.isFocusControl()) {
                    ResourceExplorer.this.contextHB.copyToClipboard();
                }
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
    }

    protected abstract String getResourceTypesDescription();

    public void setInput(String programName, String regionName) {
        Debug.enter((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"setInput", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "programName: " + programName, "regionName: " + regionName});
        this.contextComposite.forceContext(ExplorerQueryContext.REGION);
        this.currentContext = ExplorerQueryContext.REGION;
        if (IAUtilities.hasContent((String)programName)) {
            this.searchHB.setText(programName);
        } else {
            this.searchHB.setText(IAUtilities.USER_WILD_STRING);
        }
        if (IAUtilities.hasContent((String)regionName)) {
            this.contextHB.setText(regionName);
        }
        this.runSearch();
        Debug.exit((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"setInput");
    }

    public void setApplicationInput(String programName, String applicationName) {
        Debug.enter((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"setApplicationInput", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "programName: " + programName, "applicationName: " + applicationName});
        this.contextComposite.forceContext(ExplorerQueryContext.APPLICATION);
        this.currentContext = ExplorerQueryContext.APPLICATION;
        if (IAUtilities.hasContent((String)programName)) {
            this.searchHB.setText(programName);
        } else {
            this.searchHB.setText(IAUtilities.USER_WILD_STRING);
        }
        if (IAUtilities.hasContent((String)applicationName)) {
            this.contextHB.setText(applicationName);
        }
        this.runSearch();
        Debug.exit((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"setApplicationInput");
    }

    public Job runSearch() {
        Debug.enter((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"runSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clear();
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            Debug.exit((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"runSearch", (Object)("findResourcesJob: " + (this.findResourcesJob == null ? this.findResourcesJob : this.findResourcesJob.getName())));
            return this.findResourcesJob;
        }
        this.dummyTableItem = UIUtilities.createDummyTableItem(this.table);
        this.findCommand = this.createFindCommand(this.searchHB.getText(true), this.contextHB.getText(true), this.currentContext);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getTaskName());
        String description = null;
        if (IAUtilities.hasContent((String)this.searchHB.getText(true))) {
            buffer.append(" " + this.searchHB.getText(true));
        }
        description = IAUtilities.hasContent((String)this.contextHB.getText(true)) ? MessageFormat.format(Messages.getString("ResourceExplorer.findCommand.description"), buffer, this.contextHB.getText(true)) : buffer.toString();
        this.findCommand.setDescription(description);
        this.findCommand.addListener(this.getCommandListener());
        this.c.setCursor(this.parent.getDisplay().getSystemCursor(3));
        this.findResourcesJob = new JobWithCancelingSupport(this.getTaskName()){

            protected void cancelingSub() {
                if (ResourceExplorer.this.findCommand != null) {
                    ResourceExplorer.this.findCommand.cancel();
                }
                IAPlugin.getDefault().taskEnded();
            }

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"ResourceExplorer.runSearch().findResourcesJob", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                Activator.getDefault().ensureConnected();
                monitor.beginTask(ResourceExplorer.this.getTaskName(), -1);
                if (ResourceExplorer.this.findCommand != null) {
                    ResourceExplorer.this.findCommand.setAsync(false);
                    ResourceExplorer.this.findCommand.start();
                }
                monitor.done();
                IAPlugin.getDefault().taskEnded();
                Debug.enter((Logger)logger, (String)"ResourceExplorer.runSearch().findResourcesJob", (String)"runSub");
                return Status.OK_STATUS;
            }
        };
        this.scrollLimitManager.setTaskName(this.getTaskName());
        UIUtilities.scheduleWorkbenchPartJob((IWorkbenchPart)this, this.findResourcesJob);
        this.isPopulated = true;
        Debug.exit((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"runSearch", (Object)("findResourcesJob: " + this.findResourcesJob.getName()));
        return this.findResourcesJob;
    }

    protected abstract String getTaskName();

    protected abstract SQLCommand createFindCommand(String var1, String var2, ExplorerQueryContext var3);

    private EngineShell.EngineListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new EngineShell.EngineListener(){

                public void dataAvailable(final Collection<Object> items) {
                    ResourceExplorer.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResourceExplorer.this.programsFound(items);
                        }
                    });
                }

                public void notifyResultCount(int count) {
                }

                public void statusUpdate(EngineShell.EngineStatus es) {
                    switch (es) {
                        case Paused: {
                            ResourceExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ResourceExplorer.this.c.isDisposed()) {
                                        if (ResourceExplorer.this.scrollLimitManager != null) {
                                            ResourceExplorer.this.scrollLimitManager.scrollLimitReached((Command)ResourceExplorer.this.findCommand);
                                        }
                                        ResourceExplorer.this.c.setCursor(null);
                                    }
                                }
                            });
                            break;
                        }
                        case Complete: {
                            ResourceExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ResourceExplorer.this.c.isDisposed()) {
                                        if (ResourceExplorer.this.scrollLimitManager != null) {
                                            ResourceExplorer.this.scrollLimitManager.dispose();
                                        }
                                        ResourceExplorer.this.searchLabel.setEnabled(true);
                                        ResourceExplorer.this.c.setCursor(null);
                                        if ((this).ResourceExplorer.this.table.getItemCount() == 0) {
                                            ResourceExplorer.this.dummyTableItem = new TableItem((this).ResourceExplorer.this.table, 0);
                                            String noResourcesFoundMessage = MessageFormat.format(Messages.getString("ResourceExplorer.none.found.message"), ResourceExplorer.this.getResourceTypesDescription());
                                            ResourceExplorer.this.dummyTableItem.setText(noResourcesFoundMessage);
                                        }
                                    }
                                }
                            });
                            break;
                        }
                        case Error: {
                            ResourceExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ResourceExplorer.this.c.isDisposed()) {
                                        if (ResourceExplorer.this.scrollLimitManager != null) {
                                            ResourceExplorer.this.scrollLimitManager.dispose();
                                        }
                                        ResourceExplorer.this.c.setCursor(null);
                                        ResourceExplorer.this.clear();
                                    }
                                    ResourceExplorer.this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(MessageFormat.format(Messages.getString("QueryResultsView.errorMessage"), ""));
                                }
                            });
                            break;
                        }
                        case Cancelled: {
                            ResourceExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ResourceExplorer.this.c.isDisposed()) {
                                        if (ResourceExplorer.this.scrollLimitManager != null) {
                                            ResourceExplorer.this.scrollLimitManager.dispose();
                                        }
                                        ResourceExplorer.this.c.setCursor(null);
                                    }
                                }
                            });
                        }
                    }
                }
            };
        }
        return this.commandListener;
    }

    private void programsFound(Collection items) {
        Debug.enter((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"programsFound", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "items size: " + items.size()});
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setRedraw(false);
            if (this.dummyTableItem != null) {
                this.dummyTableItem.dispose();
                this.dummyTableItem = null;
            }
            for (Resource resource : items) {
                if (this.programs.contains(resource)) continue;
                this.programs.add(resource);
                TableItem item = new TableItem(this.table, 0);
                item.setText(resource.getName());
                item.setData((Object)resource);
                item.setImage(ResourceRenderer.asImage(resource));
            }
            this.searchLabel.setText("(" + this.table.getItemCount() + ")");
            this.searchLabel.getParent().layout(new Control[]{this.searchLabel});
            this.table.setRedraw(true);
        }
        Debug.exit((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"programsFound");
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        IAPlugin.getDefault().removeCollectionIDListener(this.getCollectionIdListener());
        super.dispose();
        Debug.exit((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"dispose");
    }

    public void init(IViewSite site) throws PartInitException {
        Debug.enter((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"init", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "site: " + site.getId()});
        super.init(site);
        this.setTitleToolTip(this.getTitle());
        Debug.exit((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"init");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    }
                }
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        ResourceExplorer.this.clear();
                        IWorkbenchPartSite site = ResourceExplorer.this.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                        if ((this).ResourceExplorer.this.table != null) {
                            if (ResourceExplorer.this.findCommand == null) {
                                ResourceExplorer.this.runSearch();
                            } else if (ResourceExplorer.this.findCommand != null && ResourceExplorer.this.findCommand.status() != 0 && ResourceExplorer.this.findCommand.status() != 3 && ResourceExplorer.this.findCommand.status() != 1) {
                                ResourceExplorer.this.runSearch();
                            }
                        }
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        ResourceExplorer.this.clear();
                        IWorkbenchPartSite site = ResourceExplorer.this.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                });
            }
        };
    }

    private ICollectionIdListener getCollectionIdListener() {
        if (this.collectionIdListener == null) {
            this.collectionIdListener = new ICollectionIdListener(){

                public void collectionIdChanged(String collectionID) {
                    if (ResourceExplorer.this.findCommand == null) {
                        ResourceExplorer.this.runSearch();
                    } else if (ResourceExplorer.this.findCommand != null && ResourceExplorer.this.findCommand.status() != 0 && ResourceExplorer.this.findCommand.status() != 3) {
                        ResourceExplorer.this.runSearch();
                    }
                }
            };
        }
        return this.collectionIdListener;
    }

    private void clear() {
        Debug.enter((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.table != null && !this.table.isDisposed()) {
            this.table.removeAll();
            if (this.scrollLimitManager != null) {
                this.scrollLimitManager.dispose();
            }
        }
        if (this.dummyTableItem != null && !this.dummyTableItem.isDisposed()) {
            this.dummyTableItem.dispose();
        }
        if (this.programs != null) {
            this.programs.clear();
        }
        if (this.searchLabel != null && !this.searchLabel.isDisposed()) {
            this.searchLabel.setText("    ");
            this.searchLabel.setEnabled(false);
        }
        if (this.findResourcesJob != null) {
            this.findResourcesJob.cancel();
            this.findResourcesJob = null;
        }
        if (this.findCommand != null) {
            if (this.findCommand.status() == 0) {
                this.findCommand.removeListener(this.getCommandListener());
                this.findCommand.cancel();
            }
            this.findCommand = null;
        }
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        this.isPopulated = false;
        if (this.selectionProvider != null) {
            this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        Debug.exit((Logger)logger, (String)ResourceExplorer.class.getName(), (String)"clear");
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.ia.connection.db2";
        }
        return super.getPartProperty(key);
    }

    public void setFocus() {
        if (!this.isPopulated) {
            this.runSearch();
        }
        this.focusKeeper.setFocus();
    }

    protected abstract void setHelpContextIDs(Composite var1);
}

