/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class Resource2CSV {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Resource2CSV.class.getPackage().getName());

    Resource2CSV() {
    }

    public static void parse(Table table, Display display) {
        Debug.enter((Logger)logger, (String)Resource2CSV.class.getName(), (String)"parse", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Clipboard clipboard = new Clipboard(display);
        StringBuffer result = new StringBuffer();
        String title = "";
        int k = 0;
        while (k < table.getItemCount()) {
            Resource resource = (Resource)table.getItem(k).getData();
            Object propSource = null;
            Object propDesc = null;
            result.append(String.valueOf(resource.getName()) + "," + IAUtilities.LINE_SEPARATOR);
            ++k;
        }
        clipboard.setContents(new Object[]{";Name," + title + IAUtilities.LINE_SEPARATOR + result}, new Transfer[]{TextTransfer.getInstance()});
        Debug.exit((Logger)logger, (String)Resource2CSV.class.getName(), (String)"parse");
    }

    public static void parse(TreeItem treeItem, StringBuffer result, String tabs) {
        Debug.enter((Logger)logger, (String)Resource2CSV.class.getName(), (String)"parse", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "treeItem: " + treeItem.getText(), "result: " + result, "tabs: " + tabs});
        int k = 0;
        while (k < treeItem.getItemCount()) {
            Object data = treeItem.getItem(k).getData();
            if (data instanceof Resource) {
                Resource resource = (Resource)data;
                Object propSource = null;
                Object propDesc = null;
                result.append(String.valueOf(tabs) + resource.getName() + "," + IAUtilities.LINE_SEPARATOR);
            } else if (data instanceof String) {
                String str = treeItem.getItem(k).getText();
                result.append(String.valueOf(tabs) + "+ " + str + IAUtilities.LINE_SEPARATOR);
            }
            Resource2CSV.parse(treeItem.getItem(k), result, String.valueOf(tabs) + "\t");
            ++k;
        }
        if (tabs.length() > 0) {
            tabs = tabs.substring(0, tabs.length() - 1);
        }
        Debug.exit((Logger)logger, (String)Resource2CSV.class.getName(), (String)"parse", (Object)("result: " + result));
    }

    public static void parse(Tree tree, Display display) {
        Debug.enter((Logger)logger, (String)Resource2CSV.class.getName(), (String)"parse", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Clipboard clipboard = new Clipboard(display);
        StringBuffer result = new StringBuffer();
        String title = "";
        String tabs = "";
        int k = 0;
        while (k < tree.getItemCount()) {
            Object data = tree.getItem(k).getData();
            if (data instanceof Resource) {
                Resource resource = (Resource)data;
                Object propSource = null;
                Object propDesc = null;
                result.append(String.valueOf(resource.getName()) + "," + IAUtilities.LINE_SEPARATOR);
            } else if (data instanceof String) {
                String str = tree.getItem(k).getText();
                result.append(String.valueOf(str) + IAUtilities.LINE_SEPARATOR);
            }
            Resource2CSV.parse(tree.getItem(k), result, String.valueOf(tabs) + "\t");
            ++k;
        }
        clipboard.setContents(new Object[]{";Name," + title + IAUtilities.LINE_SEPARATOR + result}, new Transfer[]{TextTransfer.getInstance()});
        Debug.exit((Logger)logger, (String)Resource2CSV.class.getName(), (String)"parse");
    }
}

