/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.controller.AffinityReportGenerator;
import com.ibm.cics.ia.model.AffinityReport;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ReportManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ReportManager.class.getPackage().getName());
    public static final String REPORTS_FOLDER = "Interdependency Analyzer Reports";
    public static final String THR_EXTENSION = "thr";
    public static final String HTML_EXTENSION = "html";
    private static final String HTM_EXTENSION = "htm";
    public static final String XML_EXTENSION = "xml";
    public static final String BLD_EXTENSION = "bld";
    public static final String IRESOURCE = "IRESOURCE";
    public static final String TYPE = "TYPE";
    public static final String TYPE_REPORT_THREADSAFE = "TYPE_REPORT_THREADSAFE";
    public static final String TYPE_REPORT_HTML = "TYPE_REPORT_HTML";
    public static final String TYPE_REPORT_XML = "TYPE_REPORT_XML";
    public static final String TYPE_BUILD = "TYPE_BUILD";
    public static final String TYPE_FOLDER = "TYPE_FOLDER";
    private Tree tree = null;
    private Type type;
    private static final Pattern pattern = Pattern.compile("_\\d{12}");
    public static final String PROPERTY_AFFINITY_REPORT_HLQ = "com.ibm.cics.ia.affinityReport";
    public static final String PROPERTY_REGION_FOLDER = "regionFolder";
    private HashMap<IResource, TreeItem> resourcesToTreeItems;
    private HashMap<String, IResource> fileNamesToResources;
    private static Set<ReportManager> REPORT_MANAGERS = new HashSet<ReportManager>();
    private TreeItem rootItem;

    private ReportManager(Type aType) {
        this.type = aType;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public void setRootItem(TreeItem root) {
        this.rootItem = root;
    }

    public Tree getTree() {
        return this.tree;
    }

    private void createRootFolder(String name, IProject reportsProject) {
        Debug.enter((Logger)logger, (String)ReportManager.class.getName(), (String)"createRootFolder", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "name: " + name, "reportsProject: " + reportsProject.getName()});
        Path path = new Path("/");
        IFolder rootFolder = reportsProject.getFolder(path.append(name));
        if (!rootFolder.exists()) {
            try {
                rootFolder.create(true, true, null);
            }
            catch (CoreException e1) {
                Debug.warning((Logger)logger, (String)ReportManager.class.getName(), (String)"createRootFolder", (Throwable)e1, new HashMap());
            }
        }
        Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"createRootFolder");
    }

    private boolean migrateReportsFolder(IProject reportsProject) {
        Debug.enter((Logger)logger, (String)ReportManager.class.getName(), (String)"createRootFolder", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "reportsProject: " + reportsProject.getName()});
        Path path = new Path("/");
        IFolder reportsFolder = reportsProject.getFolder(path.append(Messages.getString("ReportManager.reports.oldReportsFolder")));
        IFolder threadsafeReportsFolder = reportsProject.getFolder(path.append(Messages.getString("ReportManager.reports.threadsafeReportsFolder")));
        if (reportsFolder.exists() && !threadsafeReportsFolder.exists()) {
            String threadsafeReportsStr = threadsafeReportsFolder.getLocation().toOSString();
            String reportsStr = reportsFolder.getLocation().toOSString();
            File threadsafeFile = new File(threadsafeReportsStr);
            File reportsFile = new File(reportsStr);
            if (!threadsafeFile.exists()) {
                Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"createRootFolder", (Object)("return " + reportsFile.renameTo(threadsafeFile)));
                return reportsFile.renameTo(threadsafeFile);
            }
        }
        Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"createRootFolder", (Object)"return false");
        return false;
    }

    public static void refreshAll() {
        for (ReportManager manager : REPORT_MANAGERS) {
            manager.refresh();
        }
    }

    public static void refreshAll(IContainer container) {
        for (ReportManager manager : REPORT_MANAGERS) {
            manager.refresh(container);
        }
    }

    public void refresh() {
        Debug.enter((Logger)logger, (String)ReportManager.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.resourcesToTreeItems = new HashMap();
        this.fileNamesToResources = new HashMap();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject reportsProject = null;
        try {
            reportsProject = root.getProject(REPORTS_FOLDER);
            reportsProject.refreshLocal(1, null);
            reportsProject.open(null);
        }
        catch (CoreException ex) {
            Debug.warning((Logger)logger, (String)ReportManager.class.getName(), (String)"refresh", (String)"project does not exist or was removed", (Throwable)ex);
            try {
                if (!reportsProject.exists()) {
                    reportsProject.create(null);
                } else {
                    String str = reportsProject.getLocation().toOSString();
                    File file = new File(str);
                    if (!file.exists()) {
                        reportsProject.delete(true, null);
                        reportsProject.create(null);
                    }
                }
                reportsProject.open(null);
            }
            catch (CoreException ex2) {
                Debug.warning((Logger)logger, (String)ReportManager.class.getName(), (String)"refresh", (String)"Unable to create Interdependency Analyzer Reports project", (Throwable)ex2);
                IAPlugin.getDefault().logError("Unable to create Interdependency Analyzer Reports project", (Throwable)ex2);
            }
        }
        try {
            boolean migrated = this.migrateReportsFolder(reportsProject);
            this.createRootFolder(Messages.getString("ReportManager.reports.affinityReportsFolder"), reportsProject);
            this.createRootFolder(Messages.getString("ReportManager.reports.buildsFolder"), reportsProject);
            if (!migrated) {
                this.createRootFolder(Messages.getString("ReportManager.reports.threadsafeReportsFolder"), reportsProject);
            }
            this.tree.setData(IRESOURCE, (Object)reportsProject);
            reportsProject.refreshLocal(1, null);
            this.processReportsFolder((IContainer)reportsProject, null);
        }
        catch (Exception ex) {
            Debug.warning((Logger)logger, (String)ReportManager.class.getName(), (String)"refresh", (String)"Unable to process Interdependency Analyzer Reports", (Throwable)ex);
            IAPlugin.getDefault().logError("Unable to process Interdependency Analyzer Reports", (Throwable)ex);
        }
        Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"refresh");
    }

    public void refresh(IContainer folder) {
        Debug.enter((Logger)logger, (String)ReportManager.class.getName(), (String)"refresh", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "folder: " + folder.getName()});
        ArrayList<ReportManager> managersToDelete = new ArrayList<ReportManager>();
        for (ReportManager manager : REPORT_MANAGERS) {
            TreeItem treeItem;
            boolean isNotObsolete = manager.processReportsFolder(folder, treeItem = manager.getTreeItem((IResource)folder));
            if (isNotObsolete) continue;
            managersToDelete.add(manager);
        }
        if (managersToDelete.size() > 0) {
            for (ReportManager reportManager : managersToDelete) {
                ReportManager.removeReportManager(reportManager);
            }
        }
        Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"refresh");
    }

    private boolean processReportsFolder(IContainer parentFolder, TreeItem parentItem) {
        TreeItem[] items;
        IResource[] resources;
        HashSet childItems;
        block16: {
            Debug.enter((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportsFolder", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "parentFolder: " + (parentFolder == null ? parentFolder : parentFolder.getName()), "parentItem: " + (parentItem != null && !parentItem.isDisposed() ? parentItem.getText() : parentItem)});
            childItems = new HashSet();
            parentFolder.refreshLocal(1, null);
            resources = parentFolder.members();
            if (parentItem != null && !parentItem.isDisposed()) {
                items = parentItem.getItems();
                break block16;
            }
            if (this.rootItem != null && !this.rootItem.isDisposed()) {
                items = this.rootItem.getItems();
                break block16;
            }
            if (this.tree != null && !this.tree.isDisposed()) {
                items = this.tree.getItems();
                break block16;
            }
            Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportsFolder");
            return false;
        }
        try {
            if (items != null) {
                Collections.addAll(childItems, items);
            }
            ArrayList<IFolder> folders = new ArrayList<IFolder>();
            ArrayList<IFile> files = new ArrayList<IFile>();
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource instanceof IFolder) {
                    folders.add((IFolder)iResource);
                } else {
                    files.add((IFile)iResource);
                }
                ++n2;
            }
            for (IFolder iFolder : folders) {
                if (this.tree == null || this.tree.isDisposed()) continue;
                TreeItem folderItem = this.resourcesToTreeItems.get(iFolder);
                if (folderItem != null && folderItem.isDisposed()) {
                    this.resourcesToTreeItems.remove(iFolder);
                    this.fileNamesToResources.remove(iFolder.getLocation().toOSString());
                    folderItem = null;
                }
                if (folderItem == null) {
                    folderItem = parentItem == null ? (this.rootItem != null ? new TreeItem(this.rootItem, 0) : new TreeItem(this.tree, 0)) : new TreeItem(parentItem, 0);
                }
                folderItem.setImage(ImageFactory.getFolderImage());
                folderItem.setText(iFolder.getName());
                folderItem.setData(IRESOURCE, (Object)iFolder);
                folderItem.setData(TYPE, (Object)TYPE_FOLDER);
                this.resourcesToTreeItems.put((IResource)iFolder, folderItem);
                this.fileNamesToResources.put(iFolder.getLocation().toOSString(), (IResource)iFolder);
                this.processReportsFolder((IContainer)iFolder, folderItem);
                childItems.remove(folderItem);
            }
            if (!this.type.equals((Object)Type.folders)) {
                for (IFile iFile : files) {
                    TreeItem fileItem = this.processReportFile(iFile, parentItem);
                    childItems.remove(fileItem);
                }
            }
            for (TreeItem treeItem : childItems) {
                treeItem.dispose();
            }
        }
        catch (Exception ex) {
            Debug.warning((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportsFolder", (String)"Unable to process Interdependency Analyzer Report folder", (Throwable)ex);
            IAPlugin.getDefault().logError("Unable to process Interdependency Analyzer Report folder: " + parentFolder.getName(), (Throwable)ex);
        }
        Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportsFolder");
        return true;
    }

    private TreeItem processReportFile(IFile iFile, TreeItem parentItem) {
        Debug.enter((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportFile", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "iFile: " + (iFile == null ? iFile : iFile.getName()), "parentItem: " + (parentItem == null ? parentItem : parentItem.getText())});
        try {
            if (!Type.affinityFilesAndFolders.equals((Object)this.type) && (HTML_EXTENSION.equals(iFile.getFileExtension()) || HTM_EXTENSION.equals(iFile.getFileExtension()))) {
                String fullFileName = iFile.getLocation().toOSString();
                File file = new File(fullFileName);
                if (file.exists()) {
                    TreeItem fileItem = this.resourcesToTreeItems.get(iFile);
                    if (fileItem == null || fileItem.isDisposed()) {
                        fileItem = parentItem == null ? (this.rootItem != null ? new TreeItem(this.rootItem, 0) : new TreeItem(this.tree, 0)) : new TreeItem(parentItem, 0);
                    }
                    fileItem.setImage(ImageFactory.getWebpageImage());
                    IPath fileWithoutExtension = iFile.getLocation().removeFileExtension();
                    fileItem.setText(fileWithoutExtension.lastSegment());
                    fileItem.setData(IRESOURCE, (Object)iFile);
                    fileItem.setData(TYPE, (Object)TYPE_REPORT_HTML);
                    this.resourcesToTreeItems.put((IResource)iFile, fileItem);
                    this.fileNamesToResources.put(iFile.getLocation().toOSString(), (IResource)iFile);
                    Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportFile", (Object)("return " + fileItem.getText()));
                    return fileItem;
                }
                iFile.delete(true, null);
            } else if (!Type.affinityFilesAndFolders.equals((Object)this.type) && THR_EXTENSION.equals(iFile.getFileExtension())) {
                String fullFileName = iFile.getLocation().toOSString();
                File file = new File(fullFileName);
                if (file.exists()) {
                    TreeItem fileItem = this.resourcesToTreeItems.get(iFile);
                    if (fileItem == null || fileItem.isDisposed()) {
                        fileItem = parentItem == null ? (this.rootItem != null ? new TreeItem(this.rootItem, 0) : new TreeItem(this.tree, 0)) : new TreeItem(parentItem, 0);
                    }
                    fileItem.setImage(ImageFactory.getReportsImage());
                    IPath fileWithoutExtension = iFile.getLocation().removeFileExtension();
                    fileItem.setText(fileWithoutExtension.lastSegment());
                    fileItem.setData(IRESOURCE, (Object)iFile);
                    fileItem.setData(TYPE, (Object)TYPE_REPORT_THREADSAFE);
                    this.resourcesToTreeItems.put((IResource)iFile, fileItem);
                    this.fileNamesToResources.put(iFile.getLocation().toOSString(), (IResource)iFile);
                    Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportFile", (Object)("return " + fileItem.getText()));
                    return fileItem;
                }
                iFile.delete(true, null);
            } else if (XML_EXTENSION.equals(iFile.getFileExtension())) {
                String fullFileName = iFile.getLocation().toOSString();
                File file = new File(fullFileName);
                if (file.exists()) {
                    TreeItem fileItem = this.resourcesToTreeItems.get(iFile);
                    if (fileItem == null || fileItem.isDisposed()) {
                        fileItem = parentItem == null ? (this.rootItem != null ? new TreeItem(this.rootItem, 0) : new TreeItem(this.tree, 0)) : new TreeItem(parentItem, 0);
                    }
                    fileItem.setImage(ImageFactory.getAffinityReportImage());
                    String nameWithoutTimestamp = ReportManager.getNameWithoutTimestamp(iFile);
                    String timestamp = ReportManager.getUserTimeStamp(iFile);
                    fileItem.setText(String.valueOf(nameWithoutTimestamp) + timestamp);
                    fileItem.setData(IRESOURCE, (Object)iFile);
                    fileItem.setData(TYPE, (Object)TYPE_REPORT_XML);
                    this.resourcesToTreeItems.put((IResource)iFile, fileItem);
                    this.fileNamesToResources.put(iFile.getLocation().toOSString(), (IResource)iFile);
                    Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportFile", (Object)("return " + fileItem.getText()));
                    return fileItem;
                }
                iFile.delete(true, null);
            } else if (BLD_EXTENSION.equals(iFile.getFileExtension())) {
                String fullFileName = iFile.getLocation().toOSString();
                File file = new File(fullFileName);
                if (file.exists()) {
                    TreeItem fileItem = this.resourcesToTreeItems.get(iFile);
                    if (fileItem == null || fileItem.isDisposed()) {
                        fileItem = parentItem == null ? (this.rootItem != null ? new TreeItem(this.rootItem, 0) : new TreeItem(this.tree, 0)) : new TreeItem(parentItem, 0);
                    }
                    fileItem.setImage(ImageFactory.getBuildImage());
                    IPath fileWithoutExtension = iFile.getLocation().removeFileExtension();
                    fileItem.setText(fileWithoutExtension.lastSegment());
                    fileItem.setData(IRESOURCE, (Object)iFile);
                    fileItem.setData(TYPE, (Object)TYPE_BUILD);
                    this.resourcesToTreeItems.put((IResource)iFile, fileItem);
                    this.fileNamesToResources.put(iFile.getLocation().toOSString(), (IResource)iFile);
                    Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportFile", (Object)("return " + fileItem.getText()));
                    return fileItem;
                }
                iFile.delete(true, null);
            }
        }
        catch (Exception ex) {
            Debug.warning((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportFile", (String)"Unable to process Interdependency Analyzer Report file", (Throwable)ex);
            IAPlugin.getDefault().logError("Unable to process Interdependency Analyzer Report file: " + iFile.getName(), (Throwable)ex);
        }
        Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"processReportFile", (Object)"return null");
        return null;
    }

    public static String getNameWithoutTimestamp(IFile iFile) {
        Debug.enter((Logger)logger, (String)ReportManager.class.getName(), (String)"getNameWithoutTimestamp", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "iFile: " + iFile.getName()});
        IPath fileWithoutExtension = iFile.getLocation().removeFileExtension();
        String fileName = fileWithoutExtension.lastSegment();
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"getNameWithoutTimestamp", (Object)("return " + fileName.substring(0, matcher.start())));
            return fileName.substring(0, matcher.start());
        }
        Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"getNameWithoutTimestamp", (Object)("return " + fileName));
        return fileName;
    }

    public static String getRawTimeStamp(IFile iFile) {
        Debug.enter((Logger)logger, (String)ReportManager.class.getName(), (String)"getRawTimestamp", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "iFile: " + iFile.getName()});
        IPath fileWithoutExtension = iFile.getLocation().removeFileExtension();
        String fileName = fileWithoutExtension.lastSegment();
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"getRawTimestamp", (Object)("return " + fileName.substring(matcher.start(), fileName.length())));
            return fileName.substring(matcher.start(), fileName.length());
        }
        Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"getRawTimestamp", (Object)"return \"\"");
        return "";
    }

    public static String getUserTimeStamp(IFile iFile) {
        Debug.enter((Logger)logger, (String)ReportManager.class.getName(), (String)"getUserTimeStamp", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "iFile: " + iFile.getName()});
        IPath fileWithoutExtension = iFile.getLocation().removeFileExtension();
        String fileName = fileWithoutExtension.lastSegment();
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            try {
                String result = " : " + AffinityReport.DATE_FORMAT.format(AffinityReportGenerator.DATE_FORMAT.parse(fileName.substring(matcher.start() + 1, fileName.length())));
                Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"getUserTimeStamp", (Object)("return " + result));
                return result;
            }
            catch (ParseException e) {
                Debug.warning((Logger)logger, (String)ReportManager.class.getName(), (String)"getUserTimeStamp", (String)"return \"\"", (Throwable)e);
                Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"getUserTimeStamp", (Object)"return \"\"");
                return "";
            }
        }
        Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"getUserTimeStamp", (Object)"return \"\"");
        return "";
    }

    public TreeItem getTreeItem(IResource resource) {
        return this.resourcesToTreeItems != null ? this.resourcesToTreeItems.get(resource) : null;
    }

    public void setTreeItem(IResource resource, TreeItem treeItem) {
        if (this.resourcesToTreeItems == null) {
            this.resourcesToTreeItems = new HashMap();
        }
        this.resourcesToTreeItems.put(resource, treeItem);
        this.fileNamesToResources.put(resource.getLocation().toOSString(), resource);
    }

    public void removeTreeItem(IResource resource) {
        this.resourcesToTreeItems.remove(resource);
        this.fileNamesToResources.remove(resource.getLocation().toOSString());
    }

    public IResource getResource(String filePath) {
        return this.fileNamesToResources.get(filePath);
    }

    public boolean fileExists(IContainer container, String fileName) {
        IFile file = container.getFile((IPath)new Path(fileName));
        Resource resource = (Resource)file;
        return this.resourceExists(container, resource);
    }

    public boolean folderExists(IContainer container, String folderName) {
        IFolder folder = container.getFolder((IPath)new Path(folderName));
        Resource resource = (Resource)folder;
        return this.resourceExists(container, resource);
    }

    public boolean resourceExists(IContainer container, Resource resource) {
        Debug.enter((Logger)logger, (String)ReportManager.class.getName(), (String)"resourceExists", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "container: " + container.getName(), "resource: " + resource.getName()});
        try {
            resource.checkDoesNotExist(resource.getFlags(resource.getResourceInfo(false, false)), false);
        }
        catch (CoreException e) {
            Debug.warning((Logger)logger, (String)ReportManager.class.getName(), (String)"resourceExists", (String)"return true", (Throwable)e);
            Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"resourceExists", (Object)"return true");
            return true;
        }
        if (Workspace.caseSensitive) {
            Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"resourceExists", (Object)"return false");
            return false;
        }
        boolean result = resource.findExistingResourceVariant(resource.getFullPath()) != null;
        Debug.exit((Logger)logger, (String)ReportManager.class.getName(), (String)"resourceExists", (Object)("return " + result));
        return result;
    }

    public static ReportManager createReportManager(Type aType) {
        ReportManager reportManager = new ReportManager(aType);
        REPORT_MANAGERS.add(reportManager);
        return reportManager;
    }

    public static void removeReportManager(ReportManager aReportManager) {
        REPORT_MANAGERS.remove(aReportManager);
    }

    public static enum Type {
        folders,
        filesAndFolders,
        affinityFilesAndFolders;

    }
}

