/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.commands.QueryResultsCommand;
import com.ibm.cics.ia.controller.FixedLineBufferedReader;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.query.QueryResultRow;
import com.ibm.cics.ia.query.QueryResults;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.QueryResultsView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.undo.MoveResourcesOperation;
import org.osgi.framework.Bundle;

public class QueryManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(QueryManager.class.getPackage().getName());
    public static final String FOLDER_QUERIES = "queries";
    public static final String XML_FILE_EXTENSION = "xml";
    public static final String QUERY_RESULTS_FILE_EXTENSIUON = "csv";
    public static final String NAME_KEY = "Name";
    public static final String SCOPE_KEY = "Scope";
    public static final String DATE_KEY = "Date";
    public static final String PROGRAM_INDEX_KEY = "ProgramIndex";
    public static final String TRANSACTION_INDEX_KEY = "TransactionIndex";
    public static final String TASK_INDEX_KEY = "TaskIndex";
    public static final String OBJECT_INDEX_KEY = "ObjectIndex";
    public static final String TYPE_INDEX_KEY = "TypeIndex";
    public static final String BEGIN_DATA = "<BEGIN_DATA>";
    private static QueryManager singleton = new QueryManager();
    private Map queriesToResources = new HashMap();
    private Map filesToQueries = new HashMap();
    private Map queryResults = new HashMap();
    private IFolder queriesFolder;
    private List listeners = new ArrayList();

    private QueryManager() {
    }

    public static QueryManager getSingleton() {
        return singleton;
    }

    public void addListener(Listener aListener) {
        this.listeners.add(aListener);
    }

    public void removeListener(Listener aListener) {
        this.listeners.remove(aListener);
    }

    public IFolder getQueriesFolder() {
        if (this.queriesFolder == null) {
            this.loadQueriesFromFileSystem();
        }
        return this.queriesFolder;
    }

    private void loadQueriesFromFileSystem() {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"loadQueriesFromFileSystem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.queriesToResources.clear();
        this.filesToQueries.clear();
        this.queryResults.clear();
        try {
            IProject oldProject;
            IProject rootProject = IAPlugin.getDefault().getRootProject();
            this.queriesFolder = rootProject.getFolder(FOLDER_QUERIES);
            IResource resource = rootProject.findMember(this.queriesFolder.getProjectRelativePath());
            if (resource == null && (oldProject = ResourcesPlugin.getWorkspace().getRoot().getProject("com.ibm.cics.ia.runtime")).exists()) {
                this.moveQueriesFrom(oldProject, rootProject);
            }
            this.createDefaultQueries(this.queriesFolder);
            rootProject.refreshLocal(2, null);
            this.loadQueriesFromFolder(this.queriesFolder);
        }
        catch (Exception exc) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"loadQueriesFromFileSystem ", (String)"Unable to open folder containing the queries", (Throwable)exc);
            IAPlugin.getDefault().logError("Unable to open folder containing the queries", (Throwable)exc);
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"loadQueriesFromFileSystem");
    }

    private void createDefaultQueries(IFolder queriesFolder2) {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"createDefaultQueries", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "folder: " + queriesFolder2.getName()});
        Bundle plugin = Activator.getDefault().getBundle();
        try {
            this.processEntry(plugin, "/queries", queriesFolder2.getParent().getLocation().toOSString());
        }
        catch (IOException ex) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"createDefaultQueries ", (String)"Unable to create sample queries", (Throwable)ex);
            IAPlugin.getDefault().logError("Unable to create sample queries", (Throwable)ex);
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"createDefaultQueries");
    }

    private void processEntry(Bundle plugin, String sourceEntry, String targetPath) throws IOException {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"processEntry", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "sourceEntry: " + sourceEntry, " targetPath: " + targetPath});
        File target = new File(String.valueOf(targetPath) + "/" + sourceEntry);
        if (!sourceEntry.endsWith(XML_FILE_EXTENSION)) {
            Enumeration entries;
            if (!target.exists()) {
                target.mkdir();
            }
            if ((entries = plugin.getEntryPaths(sourceEntry)) != null) {
                while (entries.hasMoreElements()) {
                    String entry = (String)entries.nextElement();
                    this.processEntry(plugin, entry, targetPath);
                }
            }
        } else if (!target.exists()) {
            int len;
            Path relativePath = new Path(sourceEntry);
            InputStream in = FileLocator.openStream((Bundle)plugin, (IPath)relativePath, (boolean)true);
            FileOutputStream out = new FileOutputStream(target);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"processEntry");
    }

    private void moveQueriesFrom(IProject oldProject, IProject newProject) {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"moveQueriesFrom", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "oldProject: " + oldProject.toString(), "newProject: " + newProject.toString()});
        IFolder oldProjectQueriesFolder = oldProject.getFolder(FOLDER_QUERIES);
        IPath newProjectQueriesFolder = newProject.getFolder(FOLDER_QUERIES).getFullPath();
        MoveResourcesOperation moveResourcesOperation = new MoveResourcesOperation((IResource)oldProjectQueriesFolder, newProjectQueriesFolder, Messages.getString("EarlyStartup.LoadIAQueriesMessage"));
        try {
            moveResourcesOperation.execute(null, null);
            oldProject.delete(true, null);
        }
        catch (ExecutionException e) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"moveQueriesFrom", (String)"empty catch", (Throwable)e);
        }
        catch (CoreException e) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"moveQueriesFrom", (String)"empty catch", (Throwable)e);
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"moveQueriesFrom");
    }

    private void checkFoldersFor(IFolder rootFolder, IPath path) throws CoreException {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"checkFoldersFor", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId()}, (Object)("rootFolder: " + (rootFolder == null ? rootFolder : rootFolder.getName())), (Object)("path: " + path));
        path.segmentCount();
        int i = 0;
        while (i < path.segmentCount() - 1) {
            String folder = path.segment(i);
            if (!(rootFolder = rootFolder.getFolder(path.segment(i))).exists()) {
                rootFolder.create(true, true, null);
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"checkFoldersFor");
    }

    private void loadQueriesFromFolder(IFolder folder) {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"loadQueriesFromFolder", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "folder: " + (folder == null ? folder : folder.getName())});
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFolder) {
                    this.loadQueriesFromFolder((IFolder)resource);
                } else {
                    Presentation presentationObject = this.getXMLQuery(resource);
                    if (presentationObject != null) {
                        this.queriesToResources.put(presentationObject, resource);
                    }
                }
                ++i;
            }
        }
        catch (CoreException exc) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"loadQUeriesFromFolder ", (String)"Unable to load saved queries from folder", (Throwable)exc);
            IAPlugin.getDefault().logError("Unable to load saved queries from folder " + folder.getName(), (Throwable)exc);
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"loadQueriesFromFolder");
    }

    public Presentation getXMLQuery(IResource resource) {
        String presentationObject;
        block7: {
            Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"getXMLQuery", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "resource: " + (resource == null ? resource : resource.getName())});
            presentationObject = null;
            if (XML_FILE_EXTENSION.equals(resource.getFileExtension().toLowerCase())) {
                Presentation existingPresentation = (Presentation)this.filesToQueries.get(resource.getFullPath().toOSString());
                if (existingPresentation != null) {
                    return existingPresentation;
                }
                try {
                    IFile iFile = (IFile)resource;
                    File file = new File(iFile.getLocation().toOSString());
                    if (file.exists()) {
                        presentationObject = (Presentation)PresentationFactory.getInstance().getPresentation(file);
                        String fileName = file.getName();
                        int index = fileName.lastIndexOf(46);
                        if (index > 0 && index <= fileName.length() - 2) {
                            fileName = fileName.substring(0, index);
                        }
                        if (!fileName.equals(presentationObject.getTitle())) {
                            presentationObject.setTitle(fileName);
                        }
                        ArrayList queryResultList = new ArrayList();
                        this.queryResults.put(presentationObject, queryResultList);
                        this.getQueryResults((Presentation)presentationObject, (IFile)resource);
                        this.filesToQueries.put(resource.getFullPath().toOSString(), presentationObject);
                        this.queriesToResources.put(presentationObject, resource);
                        break block7;
                    }
                    return null;
                }
                catch (Exception ex) {
                    Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"getXMLQuery exit ", (String)"return null", (Throwable)ex);
                    Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"getXMLQuery");
                    return null;
                }
            }
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"getXMLQuery", (Object)("presentation: " + (presentationObject == null ? presentationObject : presentationObject.getTitle())));
        return presentationObject;
    }

    public void getQueryResults(Presentation aPresentation, IFile queryFile) {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"getQueryResults", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "Presenteation: " + aPresentation.getTitle(), "queryFile: " + queryFile.getName()});
        try {
            String COMMA = Character.toString(',');
            String queryFileName = queryFile.getName().substring(0, queryFile.getName().length() - 4);
            IResource[] members = queryFile.getParent().members();
            int i = 0;
            while (i < members.length) {
                if (members[i].getName().startsWith(queryFileName) && members[i].getType() == 1 && members[i].getFileExtension().toLowerCase().equals(QUERY_RESULTS_FILE_EXTENSIUON)) {
                    String[] columnNames = null;
                    int programIndex = -1;
                    int transactionIndex = -1;
                    int objectIndex = -1;
                    int typeIndex = -1;
                    ArrayList<QueryResultRow> interactions = new ArrayList<QueryResultRow>();
                    Date queryDate = null;
                    String queryName = null;
                    String queryScope = null;
                    boolean isReadingData = false;
                    IFile queryResultsFile = (IFile)members[i];
                    InputStream contents = queryResultsFile.getContents();
                    InputStreamReader reader = new InputStreamReader(contents);
                    try (FixedLineBufferedReader bufferedReader = new FixedLineBufferedReader(reader, 10240);){
                        String nextLine = bufferedReader.readLine();
                        while (nextLine != null) {
                            StringTokenizer stringTokenizer;
                            if (BEGIN_DATA.equals(nextLine)) {
                                isReadingData = true;
                                nextLine = bufferedReader.readLine();
                                continue;
                            }
                            if (!isReadingData) {
                                stringTokenizer = new StringTokenizer(nextLine, "=");
                                String key = stringTokenizer.nextToken();
                                String value = stringTokenizer.nextToken();
                                if (NAME_KEY.equals(key)) {
                                    queryName = value;
                                } else if (SCOPE_KEY.equals(key)) {
                                    queryScope = value;
                                } else if (DATE_KEY.equals(key)) {
                                    long millisecondTime = Long.parseLong(value);
                                    queryDate = new Date(millisecondTime);
                                } else if (PROGRAM_INDEX_KEY.equals(key)) {
                                    programIndex = Integer.parseInt(value);
                                } else if (TRANSACTION_INDEX_KEY.equals(key)) {
                                    transactionIndex = Integer.parseInt(value);
                                } else if (TYPE_INDEX_KEY.equals(key)) {
                                    typeIndex = Integer.parseInt(value);
                                } else if (OBJECT_INDEX_KEY.equals(key)) {
                                    objectIndex = Integer.parseInt(value);
                                }
                            } else if (columnNames == null) {
                                stringTokenizer = new StringTokenizer(nextLine, COMMA);
                                columnNames = new String[stringTokenizer.countTokens()];
                                int n = 0;
                                while (stringTokenizer.hasMoreElements()) {
                                    columnNames[n] = stringTokenizer.nextToken();
                                    ++n;
                                }
                            } else {
                                QueryResultRow row = new QueryResultRow();
                                Object[] rowData = new Object[columnNames.length];
                                StringTokenizer stringTokenizer2 = new StringTokenizer(nextLine, COMMA, true);
                                String typeName = null;
                                String objectID = null;
                                int n = 0;
                                int objectColumn = -1;
                                while (stringTokenizer2.hasMoreElements()) {
                                    String column = stringTokenizer2.nextToken();
                                    if (COMMA.equals(column)) {
                                        if (n != 0 && (n != columnNames.length - 1 || stringTokenizer2.hasMoreElements())) continue;
                                        rowData[n] = "";
                                        ++n;
                                        continue;
                                    }
                                    column = column.replace('\t', ',');
                                    if (n == programIndex) {
                                        rowData[n] = ResourceFactory.getSingleton().getProgram(column);
                                    } else if (n == transactionIndex) {
                                        rowData[n] = ResourceFactory.getSingleton().getTransaction(column);
                                    } else if (n == objectIndex) {
                                        objectColumn = n;
                                        objectID = column;
                                        rowData[n] = column;
                                    } else if (n == typeIndex) {
                                        typeName = column;
                                        rowData[n] = column;
                                    } else {
                                        rowData[n] = column;
                                    }
                                    ++n;
                                }
                                if (rowData[rowData.length - 1] == null) {
                                    rowData[rowData.length - 1] = IAUtilities.EMPTY_STRING;
                                }
                                if (objectColumn != -1 && typeName != null) {
                                    com.ibm.cics.ia.model.Resource resource = ResourceFactory.getSingleton().getResource(typeName, objectID);
                                    rowData[objectColumn] = resource;
                                }
                                row.setData(rowData);
                                interactions.add(row);
                            }
                            nextLine = bufferedReader.readLine();
                        }
                        QueryResults queryResults = new QueryResults(queryName, interactions, aPresentation, queryScope);
                        queryResults.setDate(queryDate);
                        queryResults.setColumnNames(columnNames);
                        queryResults.setUserColumnNames(columnNames);
                        List queryResultsList = (List)this.queryResults.get(aPresentation);
                        queryResultsList.add(queryResults);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"getQueryResults ", (String)"Unable to load result data", (Throwable)e);
            IAPlugin.getDefault().logError("Unable to load result data for " + aPresentation.getTitle(), (Throwable)e);
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"getQueryResults", (Object)("queryResults size: " + this.queryResults.size()));
    }

    public void deleteXMLQuery(Presentation presentationObject) {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"deleteXMLQuery", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "presentationObject: " + presentationObject.getTitle()});
        IResource resource = (IResource)this.queriesToResources.get(presentationObject);
        try {
            if (resource != null) {
                IEditorPart editor = Activator.findEditor(QueryResultsView.DEFAULT_EDITOR_INPUT);
                Command command = editor != null ? ((QueryResultsView)editor).getCurrentSearch() : null;
                Presentation presentation = null;
                if (command instanceof QueryCommand) {
                    presentation = ((QueryCommand)command).getQuery();
                } else if (command instanceof QueryResultsCommand) {
                    presentation = ((QueryResultsCommand)command).getQuery();
                }
                if (command != null && presentation.equals(presentationObject)) {
                    ((QueryResultsView)editor).unDirty();
                }
                List results = (List)this.queryResults.get(presentationObject);
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    QueryResults queryResults = (QueryResults)iterator.next();
                    try {
                        this.deleteQueryResults(queryResults, iterator);
                    }
                    catch (IOException ex) {
                        Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"deleteXMLQuery ", (String)"Unable to delete query results", (Throwable)ex);
                        IAPlugin.getDefault().logError("Unable to delete query results " + queryResults.getDisplayName(), (Throwable)ex);
                    }
                }
                resource.delete(true, null);
                Iterator iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    ((Listener)iter.next()).queryDeleted(presentationObject);
                }
                this.queriesToResources.remove(presentationObject);
                Collection values = this.filesToQueries.values();
                values.remove(presentationObject);
            }
        }
        catch (CoreException e) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"deleteXMLQuery ", (String)"Unable to delete query", (Throwable)e);
            IAPlugin.getDefault().logError("Unable to delete query " + presentationObject.getTitle(), (Throwable)e);
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"deleteXMLQuery");
    }

    public void deleteQueryResults(QueryResults queryResult, Iterator iterator) throws IOException, CoreException {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"deleteQueryResults", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "queryResult: " + queryResult.getName()});
        IContainer queryFolder = ((IFile)this.queriesToResources.get(queryResult.getQuery())).getParent();
        String queryResultsFileName = this.getFileName(queryResult);
        IPath queryResultsNamePath = new Path(queryResultsFileName).addFileExtension(QUERY_RESULTS_FILE_EXTENSIUON);
        IResource queryResultsResource = queryFolder.findMember(queryResultsNamePath);
        if (queryResultsResource != null) {
            queryResultsResource.delete(true, null);
        }
        if (iterator != null) {
            iterator.remove();
        } else {
            this.getQueryResults(queryResult.getQuery()).remove(queryResult);
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((Listener)iter.next()).queryResultsDeleted(queryResult);
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"deleteQueryResults");
    }

    public void saveXMLQuery(Presentation presentationObject, IContainer folder) throws IOException, CoreException {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"saveXMLQuery", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "Presentation: " + presentationObject.toString(), "folder: " + folder.getName()});
        Path queryNamePath = new Path(presentationObject.getTitle());
        IPath filePath = queryNamePath.addFileExtension(XML_FILE_EXTENSION);
        IFile file = folder.getFile(filePath);
        try {
            PresentationFactory.getInstance().write(file, presentationObject);
        }
        catch (Exception ex) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"saveXMLQuery ", (String)"empty catch", (Throwable)ex);
        }
        IResource resource = folder.findMember(filePath);
        if (resource == null) {
            resource = folder.getFile(filePath);
            resource.createProxy();
        }
        this.queriesToResources.put(presentationObject, resource);
        this.filesToQueries.put(file, presentationObject);
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"saveXMLQuery");
    }

    public void updateXMLQuery(Presentation presentationObject, IContainer container, String oldName) throws IOException, CoreException {
        IFile file;
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"updateXMLQuery", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "Presentation: " + presentationObject.getTitle(), "container: " + container.getName(), "oldName: " + oldName});
        Path queryNamePath = new Path(presentationObject.getTitle());
        IPath filePath = queryNamePath.addFileExtension(XML_FILE_EXTENSION);
        if (oldName == null) {
            file = container.getFile(filePath);
        } else {
            Path oldQueryNamePath = new Path(oldName);
            IPath oldFilePath = oldQueryNamePath.addFileExtension(XML_FILE_EXTENSION);
            file = container.getFile(oldFilePath);
            this.filesToQueries.remove(file.getFullPath().toOSString());
            file.delete(true, null);
            file = container.getFile(filePath);
            this.filesToQueries.put(file.getFullPath().toOSString(), presentationObject);
            this.queriesToResources.remove(presentationObject);
            this.queriesToResources.put(presentationObject, file);
        }
        try {
            file.delete(true, null);
            PresentationFactory.getInstance().write(file, presentationObject);
        }
        catch (Exception ex) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"UpdateXMLQuery", (String)"empty catch", (Throwable)ex);
        }
        for (QueryResults queryResult : this.getQueryResults(presentationObject)) {
            String queryResultsOldFileName = this.getFileName(queryResult, oldName);
            String queryResultsNewFileName = this.getFileName(queryResult);
            IPath queryResultsOldFilePath = new Path(queryResultsOldFileName).addFileExtension(QUERY_RESULTS_FILE_EXTENSIUON);
            IPath queryResultsNewFilePath = new Path(queryResultsNewFileName).addFileExtension(QUERY_RESULTS_FILE_EXTENSIUON);
            IResource queryResultsResource = container.findMember(queryResultsOldFilePath);
            if (queryResultsOldFilePath.equals((Object)queryResultsNewFilePath)) continue;
            queryResultsResource.move(queryResultsNewFilePath, true, null);
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"updateXMLQuery");
    }

    public synchronized void refresh() {
        this.loadQueriesFromFileSystem();
    }

    public void saveQueryResults(Presentation aPresentation, QueryResults queryResult) throws IOException, CoreException {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"saveQueryResults", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "presentation: " + aPresentation.getTitle(), "queryResult: " + queryResult.toString()});
        IResource resource = (IResource)this.queriesToResources.get(aPresentation);
        String queryResultsFileName = this.getFileName(queryResult);
        IPath queryResultsNamePath = new Path(queryResultsFileName).addFileExtension(QUERY_RESULTS_FILE_EXTENSIUON);
        IResource queryResultsResource = resource.getParent().findMember(queryResultsNamePath);
        IFile file = resource.getParent().getFile(queryResultsNamePath);
        StringBuffer buffer = new StringBuffer();
        buffer.append(NAME_KEY);
        buffer.append('=');
        buffer.append(queryResult.getName());
        buffer.append(IAUtilities.LINE_SEPARATOR);
        if (queryResult.getScope() != null) {
            buffer.append(SCOPE_KEY);
            buffer.append('=');
            buffer.append(queryResult.getScope());
            buffer.append(IAUtilities.LINE_SEPARATOR);
        }
        buffer.append(DATE_KEY);
        buffer.append('=');
        buffer.append(queryResult.getDate().getTime());
        buffer.append(IAUtilities.LINE_SEPARATOR);
        String[] columns = queryResult.getColumnNames();
        String[] userColumns = queryResult.getUserColumnNames();
        int i = 0;
        while (i < userColumns.length) {
            if (columns[i].equals("PROGRAM")) {
                buffer.append(PROGRAM_INDEX_KEY);
                buffer.append('=');
                buffer.append(Integer.toString(i));
                buffer.append(IAUtilities.LINE_SEPARATOR);
            } else if (columns[i].equals("TASKID")) {
                buffer.append(TASK_INDEX_KEY);
                buffer.append('=');
                buffer.append(Integer.toString(i));
                buffer.append(IAUtilities.LINE_SEPARATOR);
            } else if (columns[i].equals("TRANSID")) {
                buffer.append(TRANSACTION_INDEX_KEY);
                buffer.append('=');
                buffer.append(Integer.toString(i));
                buffer.append(IAUtilities.LINE_SEPARATOR);
            } else if (columns[i].equals("OBJECT")) {
                buffer.append(OBJECT_INDEX_KEY);
                buffer.append('=');
                buffer.append(Integer.toString(i));
                buffer.append(IAUtilities.LINE_SEPARATOR);
            } else if (columns[i].equals("TYPE")) {
                buffer.append(TYPE_INDEX_KEY);
                buffer.append('=');
                buffer.append(Integer.toString(i));
                buffer.append(IAUtilities.LINE_SEPARATOR);
            }
            ++i;
        }
        buffer.append(BEGIN_DATA);
        buffer.append(IAUtilities.LINE_SEPARATOR);
        if (columns.length == userColumns.length) {
            i = 0;
            while (i < columns.length) {
                if (i > 0 & i < columns.length) {
                    buffer.append(',');
                }
                buffer.append(columns[i]);
                ++i;
            }
            buffer.append(IAUtilities.LINE_SEPARATOR);
            for (QueryResultRow row : queryResult.getInteractions()) {
                int i2 = 0;
                while (i2 < row.getData().length) {
                    Object rowItem;
                    if (i2 > 0 && i2 < row.getData().length) {
                        buffer.append(',');
                    }
                    String rawData = (rowItem = row.getData()[i2]) instanceof com.ibm.cics.ia.model.Resource ? ((com.ibm.cics.ia.model.Resource)rowItem).getName() : rowItem.toString();
                    buffer.append(rawData.replace(',', '\t'));
                    ++i2;
                }
                buffer.append(IAUtilities.LINE_SEPARATOR);
            }
        } else {
            int typeIndex = -1;
            int i3 = 0;
            while (i3 < columns.length) {
                if (i3 > 0 & i3 < columns.length) {
                    buffer.append(',');
                }
                buffer.append(columns[i3]);
                if ("TYPE".equals(columns[i3])) {
                    typeIndex = i3;
                }
                ++i3;
            }
            buffer.append(IAUtilities.LINE_SEPARATOR);
            for (QueryResultRow row : queryResult.getInteractions()) {
                String typeName = "";
                int i4 = 0;
                while (i4 < row.getData().length) {
                    Object rowItem = row.getData()[i4];
                    if (rowItem instanceof com.ibm.cics.ia.model.Resource) {
                        typeName = ((com.ibm.cics.ia.model.Resource)rowItem).getTypeName();
                    }
                    ++i4;
                }
                int j = 0;
                int i5 = 0;
                while (i5 < columns.length) {
                    if (i5 > 0 & i5 < columns.length) {
                        buffer.append(',');
                    }
                    if (i5 == typeIndex) {
                        buffer.append(typeName);
                    } else {
                        Object rowItem = row.getData()[j];
                        String rawData = rowItem instanceof com.ibm.cics.ia.model.Resource ? ((com.ibm.cics.ia.model.Resource)rowItem).getName() : rowItem.toString();
                        buffer.append(rawData);
                        ++j;
                    }
                    ++i5;
                }
                buffer.append(IAUtilities.LINE_SEPARATOR);
            }
        }
        StringBufferInputStream fileInput = new StringBufferInputStream(buffer.toString());
        if (queryResultsResource == null) {
            file.create((InputStream)fileInput, true, null);
        } else {
            file.delete(true, null);
            file.create((InputStream)fileInput, true, null);
        }
        fileInput.close();
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((Listener)iter.next()).queryResultsCreated(queryResult);
        }
        List<QueryResults> results = this.getQueryResults(aPresentation);
        results.add(queryResult);
        IEditorPart editor = Activator.findEditor(QueryResultsView.DEFAULT_EDITOR_INPUT);
        if (editor != null) {
            ((QueryResultsView)editor).unDirty();
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"saveQueryResults");
    }

    private String getFileName(QueryResults queryResults) {
        return this.getFileName(queryResults, null);
    }

    private String getFileName(QueryResults queryResults, String queryName) {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"getFileName", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "query.Results: " + queryResults.getName(), "queryName: " + queryName});
        StringBuffer sb = new StringBuffer();
        sb.append(queryName == null ? queryResults.getQuery().getTitle() : queryName);
        sb.append('_');
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
        sb.append(dateFormat.format(queryResults.getDate()));
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"getFileName");
        return sb.toString();
    }

    public Presentation copyXMLQuery(Presentation presentationObject) throws Exception {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"copyXMLQuery", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "Presentation: " + presentationObject.getTitle()});
        try {
            IFile iFile = IAPlugin.getDefault().getRootProject().getFile("FILE_TO_COPY");
            File file = new File(iFile.getLocation().toOSString());
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            PresentationFactory.getInstance().write(file, presentationObject);
            Presentation newQuery = (Presentation)PresentationFactory.getInstance().getPresentation(file);
            file.delete();
            Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"copyXMLQuery");
            return newQuery;
        }
        catch (Exception e) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"copyXMLQuery ", (String)"Error during copy", (Throwable)e);
            IAPlugin.getDefault().logError("Error during copy", (Throwable)e);
            Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"copyXMLQuery");
            throw e;
        }
    }

    public boolean existsXML(IContainer container, String queryName) {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"existsXML", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "container: " + container.getName(), "queryName: " + queryName});
        IFile file = container.getFile(new Path(queryName).addFileExtension(XML_FILE_EXTENSION));
        Resource resource = (Resource)file;
        try {
            resource.checkDoesNotExist(resource.getFlags(resource.getResourceInfo(false, false)), false);
        }
        catch (CoreException e) {
            Debug.warning((Logger)logger, (String)QueryManager.class.getName(), (String)"existsXML", (String)"return true", (Throwable)e);
            Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"existsXML", (Object)"return true");
            return true;
        }
        if (Workspace.caseSensitive) {
            Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"existsXML", (Object)"return false");
            return false;
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"existsXML", (Object)("return " + (resource.findExistingResourceVariant(resource.getFullPath()) != null)));
        return resource.findExistingResourceVariant(resource.getFullPath()) != null;
    }

    public List<QueryResults> getQueryResults(Presentation aPresentation) {
        Debug.enter((Logger)logger, (String)QueryManager.class.getName(), (String)"getQueryResults", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "presentation: " + aPresentation.getTitle()});
        ArrayList<QueryResults> results = (ArrayList<QueryResults>)this.queryResults.get(aPresentation);
        if (results == null) {
            results = new ArrayList<QueryResults>();
            this.queryResults.put(aPresentation, results);
        }
        Debug.exit((Logger)logger, (String)QueryManager.class.getName(), (String)"getQueryResults");
        return results;
    }

    public static interface Listener {
        public void queryDeleted(Presentation var1);

        public void queryResultsDeleted(QueryResults var1);

        public void queryResultsCreated(QueryResults var1);
    }
}

