/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.commands.QueryResultsCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.controller.QueryTreeController;
import com.ibm.cics.ia.query.Query;
import com.ibm.cics.ia.query.QueryCompatibilityHelper;
import com.ibm.cics.ia.query.QueryResults;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.EditAffinityQueryDialog;
import com.ibm.cics.ia.ui.EditCICSQueryDialog;
import com.ibm.cics.ia.ui.EditCommandFlowQueryDialog;
import com.ibm.cics.ia.ui.EditDB2QueryDialog;
import com.ibm.cics.ia.ui.EditIMSQueryDialog;
import com.ibm.cics.ia.ui.EditMQQueryDialog;
import com.ibm.cics.ia.ui.EditNaturalQueryDialog;
import com.ibm.cics.ia.ui.EditQueryDialog;
import com.ibm.cics.ia.ui.EditScannerQueryDialog;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.QueryManager;
import com.ibm.cics.ia.ui.UIUtilities;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class QueryExplorer
extends ViewPart {
    private static final Logger logger = Logger.getLogger(QueryExplorer.class.getPackage().getName());
    private TreeItem itemToRename;
    private Tree tree;
    private TreeItem root;
    private Action deleteAction;
    private Action copyAction;
    private Action refreshAction;
    private Action runAction;
    private Action pasteAction;
    private Map fileLocationsToResources = new HashMap();
    private Map queriesToTreeItems = new HashMap();
    private Clipboard clipboard;
    private Action editAction;
    private Action newCICSQueryAction;
    private Action newScannerQueryAction;
    private Action newIMSQueryAction;
    private Action newMQQueryAction;
    private Action newAffinityQueryAction;
    private Action newDB2QueryAction;
    private QueryTreeController queryTreeController;
    private Action newFolderAction;
    private TreeEditor treeEditor;
    private Action renameAction;
    private Composite editComposite;
    private Action newTaskQueryAction;
    private Action newNaturalQueryAction;
    private Action maximiseTreeAction;
    private Action minimiseTreeAction;
    private SelectionListener treeSelectionListener;
    private NavigatorView navigatorView;

    public QueryExplorer(NavigatorView navigatorView) {
        this.navigatorView = navigatorView;
        this.tree = navigatorView.getTree();
        this.root = UIUtilities.createTreeItem(this.tree, Messages.getString("NavigatorView.category.queries"), ImageFactory.getResourceImage());
    }

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clipboard = new Clipboard(this.navigatorView.getComposite().getDisplay());
        this.treeEditor = new TreeEditor(this.tree);
        this.tree.addListener(8, new Listener(){

            public void handleEvent(Event e) {
                QueryExplorer.this.runAction.run();
            }
        });
        this.treeSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryExplorer.this.updateEnablement();
            }
        };
        this.tree.addSelectionListener(this.treeSelectionListener);
        this.createActions();
        this.createPopupMenu();
        this.tree.addKeyListener((KeyListener)new UIUtilities.CopyListener(){

            @Override
            public void copy() {
                QueryExplorer.this.doCopy();
            }
        });
        QueryManager.getSingleton().addListener(new QueryManager.Listener(){

            @Deprecated
            public void queryDeleted(Query aQuery) {
                TreeItem queryTreeItem = (TreeItem)QueryExplorer.this.queriesToTreeItems.get(aQuery);
                queryTreeItem.dispose();
                QueryExplorer.this.queriesToTreeItems.remove(aQuery);
            }

            @Override
            public void queryDeleted(Presentation aPresentation) {
                TreeItem queryTreeItem = (TreeItem)QueryExplorer.this.queriesToTreeItems.get(aPresentation);
                if (queryTreeItem != null && !queryTreeItem.isDisposed()) {
                    queryTreeItem.dispose();
                }
                QueryExplorer.this.queriesToTreeItems.remove(aPresentation);
            }

            @Override
            public void queryResultsDeleted(QueryResults result) {
                Presentation presentationObject = result.getQuery();
                TreeItem queryTreeItem = (TreeItem)QueryExplorer.this.queriesToTreeItems.get(presentationObject);
                QueryExplorer.this.queryTreeController.deleteQueryResultItem(result);
                queryTreeItem.setExpanded(true);
            }

            @Override
            public void queryResultsCreated(QueryResults result) {
                Presentation presentationObject = result.getQuery();
                TreeItem queryTreeItem = (TreeItem)QueryExplorer.this.queriesToTreeItems.get(presentationObject);
                QueryExplorer.this.queryTreeController.createQueryResultItem(result, queryTreeItem);
                queryTreeItem.setExpanded(true);
                TreeItem[] queryChildItems = queryTreeItem.getItems();
                int i = 0;
                while (i < queryChildItems.length) {
                    if (queryChildItems[i].getData() == result) {
                        QueryExplorer.this.tree.setSelection(queryChildItems[i]);
                        QueryExplorer.this.updateEnablement();
                        break;
                    }
                    ++i;
                }
            }
        });
        this.queryTreeController = new QueryTreeController();
        this.queryTreeController.addListener(new QueryTreeController.Listener(){

            @Override
            public void queryFolderCreated(IContainer queryFolder, TreeItem treeItem) {
            }

            @Override
            @Deprecated
            public void queryItemCreated(IFile queryFile, Query aQuery, TreeItem treeItem) {
                QueryExplorer.this.fileLocationsToResources.put(queryFile.getLocation().toOSString(), queryFile);
                QueryExplorer.this.queriesToTreeItems.put(aQuery, treeItem);
            }

            @Override
            public void queryItemCreated(IFile queryFile, Presentation aPresentation, TreeItem treeItem) {
                QueryExplorer.this.fileLocationsToResources.put(queryFile.getLocation().toOSString(), queryFile);
                QueryExplorer.this.queriesToTreeItems.put(aPresentation, treeItem);
            }
        });
        this.queryTreeController.setTree(this.tree);
        this.queryTreeController.setRootItem(this.root);
        this.refresh(new Action(){});
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"createPartControl");
    }

    public void init(IViewSite site) throws PartInitException {
    }

    private void createPopupMenu() {
        if (this.tree.getMenu() != null) {
            this.tree.getMenu().dispose();
        }
        Preferences preferenceStore = IAPlugin.getDefault().getPluginPreferences();
    }

    private void renameTreeItem(final TreeItem aTreeItem) {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"renameTreeItem", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), " aTreeItem: " + aTreeItem.getText()});
        this.editComposite = new Composite((Composite)this.tree, 0);
        final Text editText = new Text(this.editComposite, 2048);
        this.editComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = QueryExplorer.this.editComposite.getClientArea();
                editText.setBounds(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
            }
        });
        Listener focusOutListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"QueryExplorer.renameTreeItem.focusOutListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                String name = editText.getText();
                IResource resource = (IResource)aTreeItem.getData("IRESOURCE");
                if (resource instanceof IFolder) {
                    QueryExplorer.this.itemToRename = aTreeItem;
                    IContainer parent2 = resource.getParent();
                    if (parent2.findMember(name) != null) {
                        QueryExplorer.this.editComposite.dispose();
                        event.doit = false;
                        Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
                        return;
                    }
                    if (!QueryExplorer.this.checkUserInput(name, event)) {
                        Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
                        return;
                    }
                    aTreeItem.setText(editText.getText());
                    QueryExplorer.this.updateName(editText.getText(), aTreeItem);
                    QueryExplorer.this.editComposite.dispose();
                    event.doit = false;
                    Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
                    return;
                }
                if (!QueryExplorer.this.checkUserInput(name, event)) {
                    Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
                    return;
                }
                aTreeItem.setText(editText.getText());
                QueryExplorer.this.updateName(editText.getText(), aTreeItem);
                QueryExplorer.this.editComposite.dispose();
                event.doit = false;
                Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
                Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.focusOutListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        };
        Listener verifyListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"QueryExplorer.renameTreeItem.verifyListener", (String)"handleEvent", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "event: " + event.toString()});
                String newText = editText.getText();
                String leftText = newText.substring(0, event.start);
                String rightText = newText.substring(event.end, newText.length());
                GC gc = new GC((Drawable)editText);
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                size = editText.computeSize(size.x, -1);
                ((QueryExplorer)QueryExplorer.this).treeEditor.horizontalAlignment = 16384;
                Rectangle itemRect = aTreeItem.getBounds();
                Rectangle rect = QueryExplorer.this.tree.getClientArea();
                ((QueryExplorer)QueryExplorer.this).treeEditor.minimumWidth = Math.max(size.x, itemRect.width) + 2;
                int left = itemRect.x;
                int right = rect.x + rect.width;
                ((QueryExplorer)QueryExplorer.this).treeEditor.minimumWidth = Math.min(((QueryExplorer)QueryExplorer.this).treeEditor.minimumWidth, right - left);
                ((QueryExplorer)QueryExplorer.this).treeEditor.minimumHeight = size.y + 2;
                QueryExplorer.this.treeEditor.layout();
                Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.verifyListener", (String)"handleEvent");
            }
        };
        Listener traverseListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"QueryExplorer.renameTreeItem.traverseListener", (String)"handleEvent", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "event: " + event.toString()});
                if (event.detail == 4) {
                    String name = editText.getText();
                    IResource resource = (IResource)aTreeItem.getData("IRESOURCE");
                    if (resource instanceof IFolder) {
                        QueryExplorer.this.itemToRename = aTreeItem;
                        IContainer parent2 = resource.getParent();
                        if (parent2.findMember(name) != null) {
                            QueryExplorer.this.editComposite.dispose();
                            event.doit = false;
                            Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                            return;
                        }
                        if (!QueryExplorer.this.checkUserInput(name, event)) {
                            Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                            return;
                        }
                        aTreeItem.setText(editText.getText());
                        QueryExplorer.this.updateName(editText.getText(), aTreeItem);
                        QueryExplorer.this.editComposite.dispose();
                        event.doit = false;
                        Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                        return;
                    }
                    if (!QueryExplorer.this.checkUserInput(name, event)) {
                        Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                        return;
                    }
                    aTreeItem.setText(editText.getText());
                    QueryExplorer.this.updateName(editText.getText(), aTreeItem);
                    QueryExplorer.this.editComposite.dispose();
                    event.doit = false;
                    Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                } else if (event.detail == 2) {
                    QueryExplorer.this.editComposite.dispose();
                    event.doit = false;
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.renameTreeItem.traverseListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        };
        editText.addListener(16, focusOutListener);
        editText.addListener(25, verifyListener);
        editText.addListener(31, traverseListener);
        this.treeEditor.setEditor((Control)this.editComposite, aTreeItem);
        editText.setText(aTreeItem.getText());
        editText.selectAll();
        editText.setFocus();
        this.updatePasteActionState();
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"renameTreeItem");
    }

    public void dispose() {
        if (this.clipboard != null && !this.clipboard.isDisposed()) {
            this.clipboard.dispose();
        }
    }

    private void updatePasteActionState() {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"updatePasteActionState", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean isOneItemSelected = this.tree.getSelectionCount() == 1;
        boolean canPaste = false;
        if (this.editComposite != null && !this.editComposite.isDisposed()) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            Object object = this.clipboard.getContents((Transfer)textTransfer);
            if (object instanceof String) {
                canPaste = true;
            }
        } else {
            FileTransfer fileTransfer = FileTransfer.getInstance();
            String[] fileData = (String[])this.clipboard.getContents((Transfer)fileTransfer);
            if (fileData != null && fileData.length == 1 && fileData[0].endsWith("xml") && isOneItemSelected) {
                canPaste = true;
            }
        }
        this.pasteAction.setEnabled(canPaste);
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"updatePasteActionState", (Object)("canPaste: " + canPaste));
    }

    private void updateEnablement() {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"updateEnablement", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean isOneItemSelected = this.tree.getSelectionCount() == 1;
        boolean isQueryResultSelected = isOneItemSelected && this.tree.getSelection()[0].getData() instanceof QueryResults;
        boolean isQuerySelected = this.tree.getSelectionCount() == 1 && this.tree.getSelection()[0].getData() instanceof Presentation;
        this.deleteAction.setEnabled(isOneItemSelected);
        this.copyAction.setEnabled(isQuerySelected || isQueryResultSelected);
        if (isQueryResultSelected) {
            this.runAction.setText(Messages.getString("QueryExplorer.action.runopen"));
            this.runAction.setEnabled(true);
            this.renameAction.setEnabled(false);
        } else if (isQuerySelected) {
            this.runAction.setText(Messages.getString("QueryExplorer.action.run"));
            this.runAction.setEnabled(true);
            this.renameAction.setEnabled(true);
        } else {
            this.runAction.setEnabled(false);
            this.renameAction.setEnabled(true);
        }
        this.editAction.setEnabled(isQuerySelected);
        this.updatePasteActionState();
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"updateEnablement");
    }

    public void updateName(String newName, TreeItem selectedItem) {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"updateName", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "newName: " + newName, "selectedItem: " + selectedItem.getText()});
        IResource resource = (IResource)selectedItem.getData("IRESOURCE");
        Object newPresentationName = null;
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            Path path = new Path(newName);
            IPath newPath = path.addTrailingSeparator();
            try {
                folder.refreshLocal(2, null);
                folder.move(newPath, true, null);
                folder = folder.getParent().getFolder(newPath);
                selectedItem.setData("IRESOURCE", (Object)folder);
                this.queryTreeController.setTreeItem((IContainer)folder, selectedItem);
                this.refresh(this.getCurrentContainer(), null);
            }
            catch (Exception e) {
                Debug.warning((Logger)logger, (String)QueryExplorer.class.getName(), (String)"updateName", (String)"Unable to rename query", (Throwable)e);
                IAPlugin.getDefault().logError("Unable to rename folder", (Throwable)e);
            }
        } else {
            try {
                Presentation presentation = (Presentation)selectedItem.getData();
                String oldName = presentation.getTitle();
                presentation.setTitle(newName);
                QueryManager.getSingleton().updateXMLQuery(presentation, this.getContainerForItemToRename(), oldName);
                this.refresh(this.getContainerForItemToRename(), presentation);
            }
            catch (Exception e) {
                Debug.warning((Logger)logger, (String)QueryExplorer.class.getName(), (String)"updateName", (String)"Unable to rename query", (Throwable)e);
                IAPlugin.getDefault().logError("Unable to rename query", (Throwable)e);
            }
        }
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"updateName");
    }

    private void createActions() {
        final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.maximiseTreeAction = new Action(Messages.getString("Button.tooltip.maximise")){

            public void run() {
                UIUtilities.expandTree(QueryExplorer.this.root, true);
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getExpandImage());
            }
        };
        this.minimiseTreeAction = new Action(Messages.getString("Button.tooltip.minimise")){

            public void run() {
                UIUtilities.expandTree(QueryExplorer.this.root, false);
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getCollapseImage());
            }
        };
        this.refreshAction = new Action(Messages.getString("QueryExplorer.action.refresh"), ImageDescriptor.createFromImage((Image)ImageFactory.getRefreshImage())){

            public void run() {
                QueryExplorer.this.tree.forceFocus();
                QueryExplorer.this.refresh(new Action(){});
            }
        };
        this.newCICSQueryAction = new Action(Messages.getString("QueryExplorer.action.cuicsquery"), ImageDescriptor.createFromImage((Image)ImageFactory.getQueryImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().newCICSQueryAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = QueryExplorer.this.getCurrentContainer();
                EditCICSQueryDialog dialog = new EditCICSQueryDialog(QueryExplorer.this.tree.getShell(), null, currentContainer);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    Presentation presentationObject = dialog.getPresentation();
                    QueryExplorer.this.refresh(currentContainer, presentationObject);
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().newCICSQueryAction", (String)"run");
            }
        };
        this.newScannerQueryAction = new Action(Messages.getString("QueryExplorer.action.scannerquery"), ImageDescriptor.createFromImage((Image)ImageFactory.getQueryImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().newScannerQueryAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = QueryExplorer.this.getCurrentContainer();
                EditScannerQueryDialog dialog = new EditScannerQueryDialog(QueryExplorer.this.tree.getShell(), null, currentContainer);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    Presentation presentationObject = dialog.getPresentation();
                    QueryExplorer.this.refresh(currentContainer, presentationObject);
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().newScannerQueryAction", (String)"run");
            }
        };
        this.newAffinityQueryAction = new Action(Messages.getString("QueryExplorer.action.affinityquery"), ImageDescriptor.createFromImage((Image)ImageFactory.getQueryImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().newAffinityQueryAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = QueryExplorer.this.getCurrentContainer();
                EditAffinityQueryDialog dialog = new EditAffinityQueryDialog(QueryExplorer.this.tree.getShell(), null, currentContainer);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    Presentation presentationObject = dialog.getPresentation();
                    QueryExplorer.this.refresh(currentContainer, presentationObject);
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().newAffinityQueryAction", (String)"run");
            }
        };
        this.newIMSQueryAction = new Action(Messages.getString("QueryExplorer.action.imsquery"), ImageDescriptor.createFromImage((Image)ImageFactory.getQueryImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().newIMSQueryAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = QueryExplorer.this.getCurrentContainer();
                EditIMSQueryDialog dialog = new EditIMSQueryDialog(QueryExplorer.this.tree.getShell(), null, currentContainer);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    Presentation presentationObject = dialog.getPresentation();
                    QueryExplorer.this.refresh(currentContainer, presentationObject);
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().newIMSQueryAction", (String)"run");
            }
        };
        this.newMQQueryAction = new Action(Messages.getString("QueryExplorer.action.mqquery"), ImageDescriptor.createFromImage((Image)ImageFactory.getQueryImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().newMQQueryAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = QueryExplorer.this.getCurrentContainer();
                EditMQQueryDialog dialog = new EditMQQueryDialog(QueryExplorer.this.tree.getShell(), null, currentContainer);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    Presentation presentationObject = dialog.getPresentation();
                    QueryExplorer.this.refresh(currentContainer, presentationObject);
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().newMQQueryAction", (String)"run");
            }
        };
        this.newDB2QueryAction = new Action(Messages.getString("QueryExplorer.action.db2query"), ImageDescriptor.createFromImage((Image)ImageFactory.getQueryImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().newDB2ueryAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = QueryExplorer.this.getCurrentContainer();
                EditDB2QueryDialog dialog = new EditDB2QueryDialog(QueryExplorer.this.tree.getShell(), null, currentContainer);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    Presentation presentationObject = dialog.getPresentation();
                    QueryExplorer.this.refresh(currentContainer, presentationObject);
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().newDB2QueryAction", (String)"run");
            }
        };
        this.newTaskQueryAction = new Action(Messages.getString("QueryExplorer.action.commandflowquery"), ImageDescriptor.createFromImage((Image)ImageFactory.getQueryImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().newTaskQueryAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = QueryExplorer.this.getCurrentContainer();
                EditCommandFlowQueryDialog dialog = new EditCommandFlowQueryDialog(QueryExplorer.this.tree.getShell(), null, currentContainer);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    Presentation presentationObject = dialog.getPresentation();
                    QueryExplorer.this.refresh(currentContainer, presentationObject);
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().newTaskQueryAction", (String)"run");
            }
        };
        this.newNaturalQueryAction = new Action(Messages.getString("QueryExplorer.action.naturalquery"), ImageDescriptor.createFromImage((Image)ImageFactory.getQueryImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().newNaturalQueryAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = QueryExplorer.this.getCurrentContainer();
                EditNaturalQueryDialog dialog = new EditNaturalQueryDialog(QueryExplorer.this.tree.getShell(), null, currentContainer);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    Presentation presentationObject = dialog.getPresentation();
                    QueryExplorer.this.refresh(currentContainer, presentationObject);
                }
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().newNaturalQueryAction", (String)"run");
            }
        };
        this.newFolderAction = new Action(Messages.getString("QueryExplorer.action.newfolder"), ImageDescriptor.createFromImage((Image)ImageFactory.getNewWizard())){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().newFolderAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = QueryExplorer.this.getCurrentContainer();
                if (currentContainer instanceof IFolder) {
                    try {
                        IFolder folder = (IFolder)currentContainer;
                        IFolder newFolder = folder.getFolder(Messages.getString("QueryExplorer.ifolder.newfolder"));
                        int i = 2;
                        while (newFolder.exists()) {
                            newFolder = folder.getFolder(MessageFormat.format(Messages.getString("QueryExplorer.newFolderNum"), Integer.toString(i++)));
                        }
                        newFolder.create(true, true, null);
                        QueryExplorer.this.refresh(currentContainer, null);
                        TreeItem newFolderItem = QueryExplorer.this.queryTreeController.getContainerItem((IContainer)newFolder);
                        QueryExplorer.this.fireRenameFocusEvent(newFolderItem);
                    }
                    catch (Exception e) {
                        Debug.warning((Logger)logger, (String)QueryExplorer.class.getName(), (String)" createActions().newFolderAction run", (String)"Unable to create new folder", (Throwable)e);
                        IAPlugin.getDefault().logError("Unable to create new folder", (Throwable)e);
                    }
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().newFolderAction", (String)"run");
            }
        };
        this.editAction = new Action(Messages.getString("QueryExplorer.action.editquery")){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().editAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                Presentation presentationObject = (Presentation)QueryExplorer.this.tree.getSelection()[0].getData();
                IContainer currentContainer = QueryExplorer.this.getCurrentContainer();
                EditQueryDialog dialog = null;
                String queryType = presentationObject.getParameter("query_type");
                if (queryType.equals("com.ibm.cics.query.type.cics")) {
                    dialog = new EditCICSQueryDialog(QueryExplorer.this.tree.getShell(), presentationObject, currentContainer);
                } else if (queryType.equals("com.ibm.cics.query.type.scanner")) {
                    dialog = new EditScannerQueryDialog(QueryExplorer.this.tree.getShell(), presentationObject, currentContainer);
                } else if (queryType.equals("com.ibm.cics.query.type.affinity")) {
                    dialog = new EditAffinityQueryDialog(QueryExplorer.this.tree.getShell(), presentationObject, currentContainer);
                } else if (queryType.equals("com.ibm.cics.query.type.db2")) {
                    dialog = new EditDB2QueryDialog(QueryExplorer.this.tree.getShell(), presentationObject, currentContainer);
                } else if (queryType.equals("com.ibm.cics.query.type.ims")) {
                    dialog = new EditIMSQueryDialog(QueryExplorer.this.tree.getShell(), presentationObject, currentContainer);
                } else if (queryType.equals("com.ibm.cics.query.type.mq")) {
                    dialog = new EditMQQueryDialog(QueryExplorer.this.tree.getShell(), presentationObject, currentContainer);
                } else if (queryType.equals("com.ibm.cics.query.type.commandflow")) {
                    dialog = new EditCommandFlowQueryDialog(QueryExplorer.this.tree.getShell(), presentationObject, currentContainer);
                } else if (queryType.equals("com.ibm.cics.query.type.natural")) {
                    dialog = new EditNaturalQueryDialog(QueryExplorer.this.tree.getShell(), presentationObject, currentContainer);
                }
                dialog.open();
                presentationObject = dialog.getPresentation();
                QueryExplorer.this.refresh(currentContainer, presentationObject);
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().editAction", (String)"run");
            }

            public String getText() {
                return super.getText();
            }
        };
        this.deleteAction = new Action(Messages.getString("QueryExplorer.action.delete"), sharedImages.getImageDescriptor("IMG_TOOL_DELETE")){

            public void run() {
                int returnCode;
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().deleteAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                TreeItem selectedItem = QueryExplorer.this.tree.getSelection()[0];
                IResource resource = (IResource)selectedItem.getData("IRESOURCE");
                MessageBox box = null;
                if (resource instanceof IFolder) {
                    IFolder folder = (IFolder)resource;
                    box = new MessageBox(QueryExplorer.this.tree.getShell(), 196);
                    box.setText(Messages.getString("QueryExplorer.action.deletefolder"));
                    box.setMessage(MessageFormat.format(Messages.getString("QueryExplorer.message.confirm.folder.deletion"), folder.getName()));
                } else {
                    Object itemData = selectedItem.getData();
                    if (itemData instanceof Presentation) {
                        Presentation presentationObject = (Presentation)selectedItem.getData();
                        box = new MessageBox(QueryExplorer.this.tree.getShell(), 196);
                        box.setText(Messages.getString("QueryExplorer.msg.deletequery"));
                        box.setMessage(MessageFormat.format(Messages.getString("QueryExplorer.message.confirm.query.deletion"), presentationObject.getTitle()));
                    } else if (itemData instanceof QueryResults) {
                        QueryResults queryResult = (QueryResults)itemData;
                        box = new MessageBox(QueryExplorer.this.tree.getShell(), 196);
                        box.setText(Messages.getString("QueryExplorer.box.deletequery"));
                        box.setMessage(MessageFormat.format(Messages.getString("QueryExplorer.sureWantToDeleteMessage"), queryResult.getName(), queryResult.getQuery().getTitle()));
                    }
                }
                if (box != null && (returnCode = box.open()) == 64) {
                    this.delete(selectedItem);
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().deleteAction", (String)"run");
            }

            private void delete(TreeItem selectedItem) {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().deleteAction", (String)"delete", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "selectedItem: " + selectedItem.getText()});
                IResource resource = (IResource)selectedItem.getData("IRESOURCE");
                try {
                    if (resource instanceof IFolder) {
                        IResource[] members = ((IFolder)resource).members();
                        if (members != null) {
                            int i = 0;
                            while (i < members.length) {
                                TreeItem treeItem = QueryExplorer.this.queryTreeController.getTreeItem(members[i]);
                                if (treeItem != null) {
                                    this.delete(treeItem);
                                } else {
                                    IAPlugin.getDefault().logInformation("Was unable to delete sub treeitem  for folder " + resource.getName());
                                }
                                ++i;
                            }
                        }
                        resource.delete(true, null);
                        selectedItem.clearAll(true);
                        selectedItem.dispose();
                    } else {
                        Object itemData = selectedItem.getData();
                        if (itemData instanceof Presentation) {
                            String[] fileData;
                            Presentation presentation = (Presentation)selectedItem.getData();
                            selectedItem.clearAll(true);
                            QueryManager.getSingleton().deleteXMLQuery(presentation);
                            String fileLocation = resource.getLocation().toOSString();
                            QueryExplorer.this.fileLocationsToResources.remove(fileLocation);
                            FileTransfer fileTransfer = FileTransfer.getInstance();
                            Object object = QueryExplorer.this.clipboard.getContents((Transfer)fileTransfer);
                            if (object != null && object instanceof String[] && (fileData = (String[])object).length == 1 && fileData[0].equals(fileLocation)) {
                                QueryExplorer.this.clipboard.clearContents();
                            }
                        } else if (itemData instanceof QueryResults) {
                            QueryResults queryResult = (QueryResults)itemData;
                            try {
                                selectedItem.clearAll(true);
                                QueryManager.getSingleton().deleteQueryResults(queryResult, null);
                            }
                            catch (Exception e) {
                                Debug.event((Logger)logger, (Level)Level.FINEST, (String)QueryExplorer.class.getName(), (String)"createActions().deleteAction delete", (Object[])new String[]{e.toString(), (String)(queryResult == null ? queryResult : queryResult.getName()), (String)(queryResult == null ? queryResult : queryResult.getQuery().getTitle())});
                                IAPlugin.getDefault().logError("Unable to delete query results " + queryResult.getName() + " for query " + queryResult.getQuery().getTitle(), (Throwable)e);
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    Debug.warning((Logger)logger, (String)QueryExplorer.class.getName(), (String)"createActions().deleteAction delete", (String)"Unable to delete folder", (Throwable)e);
                    IAPlugin.getDefault().logError("Unable to delete folder " + resource.getName(), (Throwable)e);
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().deleteAction", (String)"delete");
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED");
            }
        };
        this.copyAction = new Action(Messages.getString("QueryExplorer.action.copy"), sharedImages.getImageDescriptor("IMG_TOOL_COPY")){

            public void run() {
                QueryExplorer.this.doCopy();
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED");
            }
        };
        this.pasteAction = new Action(Messages.getString("QueryExplorer.action.paste"), sharedImages.getImageDescriptor("IMG_TOOL_PASTE")){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().pasteAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if (QueryExplorer.this.editComposite != null && !QueryExplorer.this.editComposite.isDisposed()) {
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Object object = QueryExplorer.this.clipboard.getContents((Transfer)textTransfer);
                    if (object instanceof String) {
                        String text = (String)object;
                        Text editText = (Text)QueryExplorer.this.editComposite.getChildren()[0];
                        Point selection = editText.getSelection();
                        String oldText = editText.getText();
                        String newText = String.valueOf(oldText.substring(0, selection.x)) + text + oldText.substring(selection.y);
                        editText.setText(newText);
                        editText.setSelection(selection.x + text.length(), selection.x + text.length());
                    }
                } else {
                    FileTransfer fileTransfer = FileTransfer.getInstance();
                    String[] fileData = (String[])QueryExplorer.this.clipboard.getContents((Transfer)fileTransfer);
                    if (fileData != null) {
                        IContainer container = QueryExplorer.this.getCurrentContainer();
                        String fileToCopy = fileData[0];
                        IResource resourceToCopy = (IResource)QueryExplorer.this.fileLocationsToResources.get(fileToCopy);
                        if (resourceToCopy != null) {
                            Presentation presentationToCopy = QueryManager.getSingleton().getXMLQuery(resourceToCopy);
                            try {
                                presentationToCopy = QueryManager.getSingleton().copyXMLQuery(presentationToCopy);
                                presentationToCopy.setTitle(this.getCopiedFileName(presentationToCopy.getTitle(), container));
                                QueryManager.getSingleton().saveXMLQuery(presentationToCopy, container);
                                QueryExplorer.this.refresh(container, presentationToCopy);
                                container.refreshLocal(1, null);
                            }
                            catch (Exception e) {
                                Debug.warning((Logger)logger, (String)QueryExplorer.class.getName(), (String)" createActions().pasteAction run ", (String)"Unable to save new query", (Throwable)e);
                                IAPlugin.getDefault().logError("Unable to save new query " + presentationToCopy.getTitle(), (Throwable)e);
                            }
                        }
                    }
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().pasteAction", (String)"run");
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED");
            }

            private String getCopiedFileName(String queryName, IContainer container) {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().pasteAction", (String)"getCopiedFileName", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "queryName:" + queryName, "container: " + container.getName()});
                if (!QueryManager.getSingleton().existsXML(container, queryName)) {
                    Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().pasteAction", (String)"getCopiedFileName");
                    return queryName;
                }
                if (queryName.startsWith(Messages.getString("QueryExplorer.txt.copyof"))) {
                    String rawName = queryName.substring(8);
                    queryName = String.valueOf(Messages.getString("QueryExplorer.txt.copy2of")) + rawName;
                } else if (queryName.startsWith(Messages.getString("QueryExplorer.txt.copynum"))) {
                    int indexOfCloseParen = queryName.indexOf(41);
                    int numberOfCopy = new Integer(queryName.substring(6, indexOfCloseParen));
                    queryName = String.valueOf(Messages.getString("QueryExplorer.txt.copynum")) + (numberOfCopy + 1) + queryName.substring(indexOfCloseParen);
                } else {
                    queryName = String.valueOf(Messages.getString("QueryExplorer.txt.copyof")) + queryName;
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().pasteAction", (String)"getCopiedFileName");
                return this.getCopiedFileName(queryName, container);
            }
        };
        this.runAction = new Action(Messages.getString("QueryExplorer.action.run"), ImageDescriptor.createFromImage((Image)ImageFactory.getRunImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)"QueryExplorer.createActions().runAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if (QueryExplorer.this.tree.getSelectionCount() != 1) {
                    Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().runAction", (String)"run");
                    return;
                }
                Object data = QueryExplorer.this.tree.getSelection()[0].getData();
                if (data instanceof Presentation) {
                    Presentation presentationObject = (Presentation)data;
                    if (presentationObject != null) {
                        StringBuilder reason = new StringBuilder();
                        boolean compatible = QueryCompatibilityHelper.isCompatible((Presentation)presentationObject, (StringBuilder)reason);
                        if (!compatible) {
                            MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 40);
                            messageBox.setMessage(MessageFormat.format(Messages.getString("QueryExplorer.version.message.text"), reason.toString()));
                            messageBox.setText(Messages.getString("QueryExplorer.version.message.title"));
                            messageBox.open();
                            Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().runAction", (String)"run");
                            return;
                        }
                        QueryCommand queryCommand = new QueryCommand(presentationObject);
                        List collectionIdAffectedTables = queryCommand.getTablesAffectedByCollectionID();
                        StringBuilder descriptionSB = new StringBuilder();
                        descriptionSB = descriptionSB.append(presentationObject.getTitle());
                        if (!collectionIdAffectedTables.isEmpty()) {
                            descriptionSB.append(" ");
                            descriptionSB = descriptionSB.append(MessageFormat.format(Messages.getString("QueryResyltsView.scopeText"), IASQLCommand.getCollectionId()));
                        }
                        DisplayableData.setData((IAdaptable)queryCommand, ImageFactory.getQueryImage(), descriptionSB.toString());
                        queryCommand.setDescription(presentationObject.getTitle());
                        Activator.executeSearch((Command)queryCommand);
                    }
                } else if (data instanceof QueryResults) {
                    QueryResults queryResult = (QueryResults)data;
                    QueryResultsCommand queryResultCommand = new QueryResultsCommand(queryResult);
                    String queryResultName = queryResult.getScope() != null ? String.valueOf(queryResult.getQuery().getTitle()) + " " + MessageFormat.format(Messages.getString("QueryResyltsView.scopeText"), queryResult.getScope()) + IAUtilities.LINE_SEPARATOR + queryResult.getDisplayName() : String.valueOf(queryResult.getQuery().getTitle()) + IAUtilities.LINE_SEPARATOR + queryResult.getDisplayName();
                    DisplayableData.setData((IAdaptable)queryResultCommand, ImageFactory.getQueryResultImage(), queryResultName);
                    Activator.executeSearch((Command)queryResultCommand);
                }
                Debug.exit((Logger)logger, (String)"QueryExplorer.createActions().runAction", (String)"run");
            }
        };
        this.renameAction = new Action(Messages.getString("QueryExplorer.action.rename")){

            public void run() {
                QueryExplorer.this.itemToRename = QueryExplorer.this.tree.getSelection()[0];
                QueryExplorer.this.fireRenameFocusEvent(QueryExplorer.this.itemToRename);
            }
        };
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.run", (IAction)this.runAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.newfolder", (IAction)this.newFolderAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.newcicsquery", (IAction)this.newCICSQueryAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.newscannerquery", (IAction)this.newScannerQueryAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.newdb2query", (IAction)this.newDB2QueryAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.newmqquery", (IAction)this.newMQQueryAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.newaffinityquery", (IAction)this.newAffinityQueryAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.newimsquery", (IAction)this.newIMSQueryAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.newcommandquery", (IAction)this.newTaskQueryAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.newnaturalquery", (IAction)this.newNaturalQueryAction);
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.editquery", (IAction)this.editAction);
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"createActions");
    }

    protected void fireRenameFocusEvent(TreeItem newFolderItem) {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"fireRenameFocusEvent", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "newFolderItem: " + (newFolderItem == null ? newFolderItem : newFolderItem.getText())});
        if (this.editComposite != null && !this.editComposite.isDisposed()) {
            this.editComposite.dispose();
        }
        Event e = new Event();
        e.item = newFolderItem;
        this.tree.setSelection(newFolderItem);
        this.renameTreeItem(newFolderItem);
        this.tree.setSelection(newFolderItem);
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"fireRenameFocusEvent");
    }

    protected String getQueryString(Presentation presentationObject) {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"getQueryString", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "presentationObject: " + presentationObject.getTitle()});
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        if (DB2Host.getDefault((String)ConnectionsPlugin.getDefault().getActiveConnectionCategoryService().getActiveConnectionCategory()).getConnectionStatus() == DB2Host.CONNECTED) {
            map.put(":schema", DB2Host.getDefault((String)ConnectionsPlugin.getDefault().getActiveConnectionCategoryService().getActiveConnectionCategory()).getSchema());
            sb.append(presentationObject.getSelection().getSQLString(map, false));
        } else {
            sb.append(presentationObject.getSelection().getSQLString(map, false).replace(":schema.", ""));
        }
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"getQueryString");
        return sb.toString();
    }

    private void refresh(IContainer aResource, Presentation presentation) {
        TreeItem[] queryItems;
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"refresh", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "aResource: " + (aResource == null ? aResource : aResource.getName()), "presentation: " + (presentation == null ? presentation : presentation.getTitle())});
        String selectedQueryName = presentation != null ? presentation.getTitle() : "";
        TreeItem folderTreeItem = this.queryTreeController.getContainerItem(aResource);
        TreeItem oldItem = (TreeItem)this.queriesToTreeItems.get(presentation);
        boolean expanded = false;
        if (oldItem != null && !oldItem.isDisposed()) {
            expanded = oldItem.getExpanded();
        }
        if ((queryItems = folderTreeItem.getItems()) != null) {
            int i = 0;
            while (i < queryItems.length) {
                TreeItem queryItem = queryItems[i];
                Presentation presentationObject = (Presentation)queryItem.getData();
                this.queriesToTreeItems.remove(presentationObject);
                ++i;
            }
        }
        folderTreeItem.removeAll();
        TreeItem item = this.queryTreeController.refresh(aResource, selectedQueryName);
        if (item != null && !item.isDisposed()) {
            this.tree.setSelection(item);
            item.setExpanded(expanded);
            this.treeSelectionListener.widgetSelected(null);
        }
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"refresh");
    }

    public void refresh(final Action afterRefreshAction) {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.refreshAction.setEnabled(false);
        this.root.removeAll();
        this.fileLocationsToResources.clear();
        this.queriesToTreeItems.clear();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                QueryExplorer.this.queryTreeController.refresh();
                QueryExplorer.this.refreshAction.setEnabled(true);
                afterRefreshAction.run();
            }
        });
        t.start();
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"refresh");
    }

    public void setFocus() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (QueryExplorer.this.tree != null && !QueryExplorer.this.tree.isDisposed()) {
                    QueryExplorer.this.tree.setFocus();
                }
            }
        });
    }

    private IContainer getCurrentContainer() {
        IResource resource = (IResource)this.tree.getSelection()[0].getData("IRESOURCE");
        if (resource == null) {
            resource = (IResource)this.tree.getSelection()[0].getParentItem().getData("IRESOURCE");
        }
        return resource instanceof IFolder ? (IContainer)resource : resource.getParent();
    }

    public void doCopy() {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"doCopy", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.editComposite != null && !this.editComposite.isDisposed()) {
            Text editText = (Text)this.editComposite.getChildren()[0];
            String text = editText.getSelectionText();
            if (IAUtilities.hasContent((String)text)) {
                this.clipboard.setContents((Object[])new String[]{text}, new Transfer[]{TextTransfer.getInstance()});
                this.updatePasteActionState();
            }
        } else {
            TreeItem selectedItem = this.tree.getSelection()[0];
            Object selectedItemData = selectedItem.getData();
            if (selectedItemData instanceof Presentation) {
                String queryString = this.getQueryString((Presentation)selectedItemData);
                IResource resource = (IResource)selectedItem.getData("IRESOURCE");
                String[] fileLocations = new String[]{resource.getLocation().toOSString()};
                this.clipboard.setContents(new Object[]{fileLocations, queryString}, new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()});
                this.updatePasteActionState();
            } else if (selectedItemData instanceof QueryResults) {
                QueryResults queryResult = (QueryResults)selectedItemData;
                String resultString = UIUtilities.getClipboardData(queryResult.getColumnNames(), queryResult.getInteractions());
                this.clipboard.setContents(new Object[]{resultString}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"doCopy");
    }

    private IContainer getContainerForItemToRename() {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"getContainerForItemToRename", (Object)("ThreadId: " + Thread.currentThread().getId()));
        if (this.itemToRename != null) {
            IResource resource = (IResource)this.itemToRename.getData("IRESOURCE");
            Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"getContainerForItemToRename", (Object)("resource: " + resource.getName()));
            return resource instanceof IFolder ? (IContainer)resource : resource.getParent();
        }
        Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"getContainerForItemToRename", (Object)"item not found");
        return null;
    }

    private boolean checkUserInput(String name, Event event) {
        IPath fullPath = this.getCurrentContainer().getLocation().append(name);
        if (!IAUtilities.hasContent((String)name) || IAUtilities.startsWithANumber((String)name) || !IAUtilities.isValidFilePath((String)fullPath.toOSString()) || !IAUtilities.isValidFilename((String)name) || QueryManager.getSingleton().existsXML(this.getContainerForItemToRename(), name)) {
            this.editComposite.dispose();
            event.doit = false;
            return false;
        }
        return true;
    }

    public TreeItem getRoot() {
        return this.root;
    }

    public void buildPopupMenu(IMenuManager manager, TreeItem[] selectedItems) {
        Debug.enter((Logger)logger, (String)QueryExplorer.class.getName(), (String)"buildPopupMenu", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "manager: " + manager, "selecetdItems length:  " + selectedItems.length});
        if (selectedItems.length > 0) {
            if (selectedItems[0] == this.root) {
                manager.add((IAction)this.minimiseTreeAction);
                manager.add((IAction)this.maximiseTreeAction);
                manager.add((IAction)this.refreshAction);
            } else {
                MenuManager newMenuManager = new MenuManager(Messages.getString("QueryExplorer.action.new"));
                newMenuManager.add((IAction)this.newFolderAction);
                newMenuManager.add((IContributionItem)new Separator());
                newMenuManager.add((IAction)this.newCICSQueryAction);
                newMenuManager.add((IAction)this.newScannerQueryAction);
                newMenuManager.add((IAction)this.newAffinityQueryAction);
                newMenuManager.add((IAction)this.newIMSQueryAction);
                newMenuManager.add((IAction)this.newDB2QueryAction);
                newMenuManager.add((IAction)this.newMQQueryAction);
                newMenuManager.add((IAction)this.newTaskQueryAction);
                newMenuManager.add((IAction)this.newNaturalQueryAction);
                manager.add((IContributionItem)newMenuManager);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.editAction);
                manager.add((IAction)this.runAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.copyAction);
                manager.add((IAction)this.pasteAction);
                manager.add((IAction)this.deleteAction);
                manager.add((IAction)this.renameAction);
            }
            Debug.exit((Logger)logger, (String)QueryExplorer.class.getName(), (String)"buildPopupMenu");
        }
    }

    public void selected() {
        this.navigatorView.createDummyTopComposite();
    }
}

