/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.ui.Messages;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PurgeQueueByPrefixDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PurgeQueueByPrefixDialog.class.getPackage().getName());
    private HashMap<String, String> parameters;
    private String prefix;
    private Combo types;
    private Text prefixText;
    private String pType;
    private String[] data = new String[]{"ENQ/DEQ", "TSQUEUE"};

    public PurgeQueueByPrefixDialog(Shell parentShell) {
        super(parentShell);
    }

    private void resizeAndMoveToCenter(Shell shell) {
        Debug.enter((Logger)logger, (String)PurgeQueueByPrefixDialog.class.getName(), (String)"resizeAndMoveToCenter", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Rectangle monitorArea = shell.getDisplay().getPrimaryMonitor().getBounds();
        shell.setSize(monitorArea.width / 4, monitorArea.height / 4);
        Rectangle shellArea = shell.getBounds();
        int x = monitorArea.x + (monitorArea.width - shellArea.width) / 2;
        int y = monitorArea.y + (monitorArea.height - shellArea.height) / 2;
        shell.setLocation(x, y);
        Debug.exit((Logger)logger, (String)PurgeQueueByPrefixDialog.class.getName(), (String)"resizeAndMoveToCenter");
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("PurgeQueueByPrefixDialog.title"));
        this.resizeAndMoveToCenter(newShell);
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return createButtonBar;
    }

    protected void updateOKStus() {
        if (!this.prefixText.getText().isEmpty() && this.types.getSelectionIndex() >= 0) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setMessage(Messages.getString("PurgeQueryByPrefixDialog.message"));
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)PurgeQueueByPrefixDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 16384;
        gridData.verticalAlignment = 0x1000000;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Label pTypeLabel = new Label(composite, 4);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        pTypeLabel.setLayoutData((Object)new GridData(16384, 4, true, true));
        pTypeLabel.setText(Messages.getString("PurgeQueueByPrefixDialog.SelectType.label"));
        this.types = new Combo(composite, 268);
        this.types.setItems(this.data);
        this.types.setLayoutData((Object)layoutData);
        this.types.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PurgeQueueByPrefixDialog.this.setTypesFromInterface();
                PurgeQueueByPrefixDialog.this.updateOKStus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label prefixLabel = new Label(composite, 0);
        prefixLabel.setLayoutData((Object)new GridData(16384, 4, true, true));
        prefixLabel.setText(Messages.getString("PurgeQueueByPrefixDiaolg.EnterPrefix.label"));
        this.prefixText = new Text(composite, 2052);
        this.prefixText.setEditable(true);
        this.prefixText.setLayoutData((Object)layoutData);
        this.prefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PurgeQueueByPrefixDialog.this.setPrefixFromInterface();
                PurgeQueueByPrefixDialog.this.updateOKStus();
            }
        });
        Debug.exit((Logger)logger, (String)PurgeQueueByPrefixDialog.class.getName(), (String)"createDialogArea");
        return composite;
    }

    public HashMap<String, String> getParameters() {
        this.parameters = new HashMap();
        this.parameters.put("IN_PTYPE", this.pType);
        this.parameters.put("IN_PREOBJ", this.prefix);
        return this.parameters;
    }

    protected void setPrefixFromInterface() {
        this.prefix = this.prefixText.getText();
    }

    protected void setTypesFromInterface() {
        this.pType = this.data[this.types.getSelectionIndex()];
    }
}

