/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.ia.ui.ApplicationExplorer;
import com.ibm.cics.ia.ui.CloudExplorer;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.QueryExplorer;
import com.ibm.cics.ia.ui.RegionExplorer;
import com.ibm.cics.ia.ui.ReportExplorer;
import com.ibm.cics.ia.ui.ScannerView;
import com.ibm.cics.ia.ui.SelectionProvider;
import com.ibm.cics.ia.ui.TreeSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.UserCommandFlowView;
import com.ibm.cics.ia.ui.actions.RequestSchedulingRule;
import com.ibm.cics.ia.ui.compareresources.CompareCollectionResDialog;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.ViewPart;

public class NavigatorView
extends ViewPart {
    public static final String ID = "com.ibm.cics.ia.ui.navigatorview";
    private static final Logger logger = Logger.getLogger(NavigatorView.class.getPackage().getName());
    private Tree tree;
    private Composite parent;
    private QueryExplorer queryExplorer;
    private RegionExplorer regionExplorer;
    private ApplicationExplorer applicationExplorer;
    private CloudExplorer cloudExplorer;
    private UserCommandFlowView userCommandFlowView;
    private ScannerView scannerView;
    private ReportExplorer reportExplorer;
    private SelectionProvider selectionProvider;
    private Action collapseTreeAction;
    private Action refreshAction;
    private Action compareResourcesAction;
    private Composite topComposite;
    private Composite dummyTopComposite;
    public static final RequestSchedulingRule mutexRule = new RequestSchedulingRule();
    public static final int NUMBER_OF_CATEGORIES = 7;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout());
        this.tree = new Tree(parent, 2048);
        GridData data = new GridData(4, 4, true, true);
        this.tree.setLayoutData((Object)data);
        this.queryExplorer = new QueryExplorer(this);
        this.queryExplorer.createPartControl(parent);
        this.regionExplorer = new RegionExplorer(this);
        this.regionExplorer.createPartControl(parent);
        this.applicationExplorer = new ApplicationExplorer(this);
        this.applicationExplorer.createPartControl(parent);
        this.cloudExplorer = new CloudExplorer(this);
        this.cloudExplorer.createPartControl(parent);
        this.userCommandFlowView = new UserCommandFlowView(this);
        this.userCommandFlowView.createPartControl(parent);
        this.scannerView = new ScannerView(this);
        this.scannerView.createPartControl(parent);
        this.reportExplorer = new ReportExplorer(this);
        this.reportExplorer.createPartControl(parent);
        this.selectionProvider = new TreeSelectionProvider(this.tree, null, "RESOURCE", "PROGRAM", "CSECT");
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.createPopupMenu();
        this.refreshAction = new Action(Messages.getString("Button.tooltip.refresh")){

            public void run() {
                NavigatorView.this.refreshAction.setEnabled(false);
                NavigatorView.this.collapseTreeAction.setEnabled(false);
                Action afterRefreshAction = new Action(){
                    private int count = 0;

                    public synchronized void run() {
                        if (++this.count >= 7) {
                            NavigatorView.this.refreshAction.setEnabled(true);
                            NavigatorView.this.collapseTreeAction.setEnabled(true);
                        }
                    }
                };
                NavigatorView.this.queryExplorer.refresh(afterRefreshAction);
                NavigatorView.this.regionExplorer.refresh(afterRefreshAction);
                NavigatorView.this.applicationExplorer.refresh(afterRefreshAction);
                NavigatorView.this.cloudExplorer.refresh(afterRefreshAction);
                NavigatorView.this.userCommandFlowView.refresh(afterRefreshAction);
                NavigatorView.this.scannerView.refresh(afterRefreshAction);
                NavigatorView.this.reportExplorer.refresh(afterRefreshAction);
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getRefreshImage());
            }
        };
        this.refreshAction.setToolTipText(Messages.getString("Button.tooltip.refresh"));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.refreshAction);
        this.compareResourcesAction = new Action(Messages.getString("ComparisonResource.dialogTitle")){

            public void run() {
                CompareCollectionResDialog compareDialog = new CompareCollectionResDialog(Display.getDefault().getActiveShell());
                compareDialog.open();
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getCompareResourceImage());
            }
        };
        this.compareResourcesAction.setToolTipText(Messages.getString("ComparisonResource.dialogTitle"));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.compareResourcesAction);
        this.collapseTreeAction = new Action(Messages.getString("Button.tooltip.minimise")){

            public void run() {
                UIUtilities.expandTree(NavigatorView.this.tree, false);
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getCollapseImage());
            }
        };
        this.collapseTreeAction.setToolTipText(Messages.getString("Button.tooltip.minimise"));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.collapseTreeAction);
        this.tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                if (event.item != null) {
                    if (event.item == NavigatorView.this.regionExplorer.getRoot()) {
                        NavigatorView.this.regionExplorer.rootExpanded();
                    } else if (event.item == NavigatorView.this.applicationExplorer.getRoot()) {
                        NavigatorView.this.applicationExplorer.rootExpanded();
                    } else if (event.item == NavigatorView.this.cloudExplorer.getRoot()) {
                        NavigatorView.this.cloudExplorer.rootExpanded();
                    } else if (event.item == NavigatorView.this.userCommandFlowView.getRoot()) {
                        NavigatorView.this.userCommandFlowView.rootExpanded();
                    } else if (event.item == NavigatorView.this.scannerView.getRoot()) {
                        NavigatorView.this.scannerView.rootExpanded();
                    }
                }
            }
        });
        this.tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeItem[] selectedItems = NavigatorView.this.tree.getSelection();
                if (selectedItems.length > 0) {
                    TreeItem root = UIUtilities.getRoot(selectedItems[0]);
                    if (root.equals(NavigatorView.this.queryExplorer.getRoot())) {
                        NavigatorView.this.queryExplorer.selected();
                    } else if (root.equals(NavigatorView.this.regionExplorer.getRoot())) {
                        NavigatorView.this.regionExplorer.selected();
                    } else if (root.equals(NavigatorView.this.applicationExplorer.getRoot())) {
                        NavigatorView.this.applicationExplorer.selected();
                    } else if (root.equals(NavigatorView.this.cloudExplorer.getRoot())) {
                        NavigatorView.this.cloudExplorer.selected();
                    } else if (root.equals(NavigatorView.this.userCommandFlowView.getRoot())) {
                        NavigatorView.this.userCommandFlowView.selected();
                    } else if (root.equals(NavigatorView.this.scannerView.getRoot())) {
                        NavigatorView.this.scannerView.selected();
                    } else if (root.equals(NavigatorView.this.reportExplorer.getRoot())) {
                        NavigatorView.this.reportExplorer.selected();
                    }
                }
            }
        });
        this.createDummyTopComposite();
        this.setHelpContextIDs();
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createPartControl");
    }

    public void init(IViewSite site) throws PartInitException {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
        super.init(site);
        this.setTitleToolTip(this.getTitle());
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init");
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.queryExplorer.dispose();
        this.regionExplorer.dispose();
        this.applicationExplorer.dispose();
        this.cloudExplorer.dispose();
        this.userCommandFlowView.dispose();
        this.scannerView.dispose();
        this.reportExplorer.dispose();
        super.dispose();
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"dispose");
    }

    public void setFocus() {
    }

    private void setHelpContextIDs() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setHelpContextIDs", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.tree, "com.ibm.cics.ia.help.navigator_view");
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setHelpContextIDs");
    }

    public Tree getTree() {
        return this.tree;
    }

    public Composite getComposite() {
        return this.parent;
    }

    public RegionExplorer getRegionExplorer() {
        return this.regionExplorer;
    }

    private void createPopupMenu() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createPopupMenu", (Object)("Thread ID: " + Thread.currentThread().getId()));
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeItem[] selectedItems = NavigatorView.this.tree.getSelection();
                if (selectedItems.length > 0) {
                    TreeItem root = UIUtilities.getRoot(selectedItems[0]);
                    if (root.equals(NavigatorView.this.queryExplorer.getRoot())) {
                        NavigatorView.this.queryExplorer.buildPopupMenu(manager, selectedItems);
                    } else if (root.equals(NavigatorView.this.regionExplorer.getRoot())) {
                        NavigatorView.this.regionExplorer.buildPopupMenu(manager, selectedItems);
                    } else if (root.equals(NavigatorView.this.applicationExplorer.getRoot())) {
                        NavigatorView.this.applicationExplorer.buildPopupMenu(manager, selectedItems);
                    } else if (root.equals(NavigatorView.this.cloudExplorer.getRoot())) {
                        NavigatorView.this.cloudExplorer.buildPopupMenu(manager, selectedItems);
                    } else if (root.equals(NavigatorView.this.userCommandFlowView.getRoot())) {
                        NavigatorView.this.userCommandFlowView.buildPopupMenu(manager, selectedItems);
                    } else if (root.equals(NavigatorView.this.scannerView.getRoot())) {
                        NavigatorView.this.scannerView.buildPopupMenu(manager, selectedItems);
                    } else if (root.equals(NavigatorView.this.reportExplorer.getRoot())) {
                        NavigatorView.this.reportExplorer.buildPopupMenu(manager, selectedItems);
                    }
                }
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.tree);
        this.tree.setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.selectionProvider);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setHelpContextIDs");
    }

    public String getPartProperty(String key) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getPartProperty", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (IConnectionCategory.class.getName().equals(key)) {
            Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getPartProperty");
            return "com.ibm.cics.ia.connection.db2";
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getPartProperty");
        return super.getPartProperty(key);
    }

    public static boolean canRunCommand(SQLCommand command) {
        return command == null || command != null && command.status() != 0 && command.status() != 3;
    }

    public static boolean isConnected() {
        return ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2").isConnected();
    }

    public static boolean isAtomConnected() {
        return ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.atom").isConnected();
    }

    public static TreeItem createDummyIfNotExists(TreeItem item, TreeItem root) {
        if (!UIUtilities.widgetExists((Widget)item)) {
            item = UIUtilities.createDummyTreeItem(root);
            UIUtilities.expandTree(root, false);
        }
        return item;
    }

    public void setTopComposite(Composite topComposite) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setTopComposite", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.topComposite != null) {
            this.topComposite.dispose();
        }
        topComposite.moveAbove((Control)this.tree);
        this.parent.layout();
        this.topComposite = topComposite;
        this.dummyTopComposite = null;
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setTopComposite");
    }

    public Composite getTopComposite() {
        return this.topComposite;
    }

    public void createDummyTopComposite() {
        if (this.dummyTopComposite == null) {
            if (this.topComposite != null) {
                this.topComposite.dispose();
            }
            this.topComposite = new Composite(this.parent, 0);
            GridData data = new GridData(4, 0, true, false);
            data.heightHint = 25;
            this.topComposite.setLayoutData((Object)data);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 2;
            this.topComposite.setLayout((Layout)gridLayout);
            this.topComposite.moveAbove((Control)this.tree);
            this.parent.layout();
            this.dummyTopComposite = this.topComposite;
        }
    }

    public SelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public CloudExplorer getCloudExplorer() {
        return this.cloudExplorer;
    }

    public ReportExplorer getReportExplorer() {
        return this.reportExplorer;
    }
}

