/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.actions.Messages;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MoreResourcesDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MoreResourcesDialog.class.getPackage().getName());
    private String titleMessage;
    private List<Resource> resources;
    private Table resourcesTable;
    private Resource resource;
    private TableItem dummyTableItem;

    public MoreResourcesDialog(Shell parentShell) {
        super(parentShell);
    }

    public MoreResourcesDialog(Shell parentShell, List<Resource> resources, String titleMessage) {
        super(parentShell);
        this.setTitle(Messages.getString("MoreResourcesDialog.title.text"));
        this.titleMessage = titleMessage;
        this.resources = resources;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.titleMessage);
    }

    private void fillTableWithResources() {
        for (Resource resource : this.resources) {
            TableItem item = new TableItem(this.resourcesTable, 0);
            item.setImage(ResourceRenderer.asImage(resource));
            item.setText(resource.getName());
            item.setData("RESOURCE", (Object)resource);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)MoreResourcesDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.resourcesTable = toolkit.createTable(composite, 2820);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.resourcesTable.setLayoutData((Object)gridData);
        this.fillTableWithResources();
        this.resourcesTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = MoreResourcesDialog.this.resourcesTable.getSelection();
                if (selection.length > 0 && selection[0] == MoreResourcesDialog.this.dummyTableItem) {
                    return;
                }
                MoreResourcesDialog.this.setSelectedResource();
                MoreResourcesDialog.this.updateOkStatus();
            }
        });
        this.setHelpAvailable(false);
        Debug.exit((Logger)logger, (String)MoreResourcesDialog.class.getName(), (String)"createDialogArea");
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return createButtonBar;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setMessage(Messages.getString("MoreResourcesDialog.message"));
        return result;
    }

    protected void updateOkStatus() {
        if (this.resourcesTable.isEnabled() && this.resourcesTable.getSelectionCount() == 1) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    private void setSelectedResource() {
        this.resource = this.resourcesTable.isEnabled() && this.resourcesTable.getSelectionCount() == 1 ? (Resource)this.resourcesTable.getSelection()[0].getData("RESOURCE") : null;
    }
}

