/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MoreRegionsDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MoreRegionsDialog.class.getPackage().getName());
    private Resource resource;
    private Table regionsTable;
    protected List<Region> regions;
    private JobWithCancelingSupport job;
    private Region region;
    private TableItem dummyTableItem;
    private String titleMessage;
    private Button selectAllButton;
    private boolean searchAllAlowed;
    private String connectionId;
    private Source source;
    private CintCollector collector;
    private static final String REGION = "region";
    private static final String COLLECTOR = "collector";

    protected MoreRegionsDialog(Shell parentShell) {
        super(parentShell);
    }

    public MoreRegionsDialog(Shell parentShell, Resource aResource, String aTitleMessage, boolean isSerchAllAlowed) {
        super(parentShell);
        this.setTitle(Messages.getString("MoreRegionsDialog.MoreRegionsDialog.title.text"));
        this.setTitleImage(ImageFactory.getSelectRegionsImage());
        this.titleMessage = aTitleMessage;
        this.searchAllAlowed = isSerchAllAlowed;
        this.resource = aResource;
        this.source = Source.Database;
        this.connectionId = null;
    }

    public MoreRegionsDialog(Shell parentShell, String connectionId) {
        super(parentShell);
        this.setTitle(Messages.getString("MoreRegionsDialog.MoreRegionsDialog.title.text"));
        this.setTitleImage(ImageFactory.getSelectRegionsImage());
        this.titleMessage = Messages.getString("MoreRegionsDialog.MoreRegionsDialog.title.text");
        this.searchAllAlowed = false;
        this.resource = null;
        this.source = Source.Atom;
        this.connectionId = connectionId;
    }

    public MoreRegionsDialog(Shell parentShell, List<Region> regions, String titleMsg, boolean isSearchAllowed) {
        super(parentShell);
        this.setTitle(Messages.getString("MoreRegionsDialog.MoreRegionsDialog.title.text"));
        this.setTitleImage(ImageFactory.getSelectRegionsImage());
        this.regions = regions;
        this.titleMessage = titleMsg;
        this.searchAllAlowed = isSearchAllowed;
        this.source = null;
        this.connectionId = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(this.titleMessage) + " " + this.resource);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public Resource getResource() {
        return this.resource;
    }

    private void fillTableWithRegions() {
        for (Region region : this.regions) {
            TableItem item = new TableItem(this.regionsTable, 0);
            item.setImage(ImageFactory.getRegionImage());
            item.setText(region.getName());
            item.setData(REGION, (Object)region);
        }
    }

    private void filltableWithRegionsFromAtom() {
        Debug.enter((Logger)logger, (String)MoreRegionsDialog.class.getName(), (String)"filltableWithRegionsFromAtom", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Map map = ResourceFactory.getSingleton().getCintCollectors(this.connectionId);
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!IAUtilities.hasContent((String)((String)entry.getKey()))) continue;
            TableItem item = new TableItem(this.regionsTable, 0);
            item.setImage(ImageFactory.getRegionImage());
            item.setText((String)entry.getKey());
            item.setData(COLLECTOR, entry.getValue());
        }
        Debug.exit((Logger)logger, (String)MoreRegionsDialog.class.getName(), (String)"filltableWithRegionsFromAtom");
    }

    private void fillTableWithRegionsFromDatabase() {
        Debug.enter((Logger)logger, (String)MoreRegionsDialog.class.getName(), (String)"fillTableWithRegionsFromDatabase", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String fetchRegionsMsg = Messages.getString("FetchRegionsFor.msg");
        final String fetchRegionsForResourceMsg = MessageFormat.format(fetchRegionsMsg, this.resource.getName());
        this.dummyTableItem = new TableItem(this.regionsTable, 0);
        this.dummyTableItem.setText(Messages.getString("MoreRegionsDialog.dummyTableItem.text"));
        this.dummyTableItem.setImage(ImageFactory.getDatabaseBusyImage());
        this.job = new JobWithCancelingSupport(fetchRegionsForResourceMsg){

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"MoreRegionsDialog.fillTableWithRegionsFromDatabase().JobWithCancellingSupport", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(fetchRegionsForResourceMsg, -1);
                MoreRegionsDialog.this.regions = MoreRegionsDialog.this.resource.getRegions();
                if (MoreRegionsDialog.this.regionsTable != null && !MoreRegionsDialog.this.regionsTable.isDisposed()) {
                    MoreRegionsDialog.this.regionsTable.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"MoreRegionsDialog.fillTableWithRegionsFromDatabase().JobWithCancellingSupport.run.asyncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            MoreRegionsDialog.this.dummyTableItem.dispose();
                            MoreRegionsDialog.this.dummyTableItem = null;
                            if ((this).MoreRegionsDialog.this.regions.size() > 0) {
                                for (Region region : (this).MoreRegionsDialog.this.regions) {
                                    TableItem item = new TableItem(MoreRegionsDialog.this.regionsTable, 0);
                                    item.setImage(ImageFactory.getRegionImage());
                                    item.setText(region.getName());
                                    item.setData(MoreRegionsDialog.REGION, (Object)region);
                                }
                            } else {
                                MoreRegionsDialog.this.dummyTableItem = new TableItem(MoreRegionsDialog.this.regionsTable, 0);
                                MoreRegionsDialog.this.dummyTableItem.setText(Messages.getString("MoreRegionsDialog.dummyTableItem.NotFound.text"));
                            }
                            Debug.exit((Logger)logger, (String)"MoreRegionsDialog.fillTableWithRegionsFromDatabase().JobWithCancellingSupport.run.asyncExec", (String)"run");
                        }
                    });
                }
                Debug.exit((Logger)logger, (String)"MoreRegionsDialog.fillTableWithRegionsFromDatabase().JobWithCancellingSupport", (String)"runSub");
                return Status.OK_STATUS;
            }

            protected void cancelingSub() {
                IAPlugin.getDefault().taskEnded();
            }
        };
        this.job.schedule();
        Debug.exit((Logger)logger, (String)MoreRegionsDialog.class.getName(), (String)"fillTableWithRegionsFromDatabase");
    }

    private void setRegion(Region aRegion) {
        this.region = aRegion;
    }

    private void setCollector(CintCollector aCollector) {
        this.collector = aCollector;
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)MoreRegionsDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(this.source == Source.Database ? Messages.getString("MoreRegionsDialog.label.text") : Messages.getString("MoreRegionsDialog.label.text.atom"));
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.regionsTable = toolkit.createTable(composite, 2820);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.regionsTable.setLayoutData((Object)gridData);
        if (this.source == Source.Database) {
            this.fillTableWithRegionsFromDatabase();
        } else if (this.source == Source.Atom) {
            this.filltableWithRegionsFromAtom();
        } else {
            this.fillTableWithRegions();
        }
        this.regionsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = MoreRegionsDialog.this.regionsTable.getSelection();
                if (selection.length > 0 && selection[0] == MoreRegionsDialog.this.dummyTableItem) {
                    return;
                }
                MoreRegionsDialog.this.setSelectedRegion();
                MoreRegionsDialog.this.updateOkStatus();
            }
        });
        if (this.searchAllAlowed) {
            this.selectAllButton = new Button(composite, 32);
            this.selectAllButton.setText(Messages.getString("MoreRegionsDialog.selectAllButton.text"));
            this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = MoreRegionsDialog.this.selectAllButton.getSelection();
                    MoreRegionsDialog.this.regionsTable.setEnabled(!selected);
                    MoreRegionsDialog.this.setSelectedRegion();
                    MoreRegionsDialog.this.updateOkStatus();
                }
            });
        }
        this.setHelpAvailable(false);
        Debug.exit((Logger)logger, (String)MoreRegionsDialog.class.getName(), (String)"createDialogArea");
        return composite;
    }

    protected void updateOkStatus() {
        if (this.regionsTable.isEnabled() && this.regionsTable.getSelectionCount() == 1 || this.selectAllButton.getSelection()) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return createButtonBar;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setMessage(Messages.getString("MoreRegionsDialog.message"));
        return result;
    }

    public Region getRegion() {
        return this.region;
    }

    public CintCollector getCollector() {
        return this.collector;
    }

    private void setSelectedRegion() {
        if (this.regionsTable.isEnabled() && this.regionsTable.getSelectionCount() == 1) {
            this.setRegion((Region)this.regionsTable.getSelection()[0].getData(REGION));
            this.setCollector((CintCollector)this.regionsTable.getSelection()[0].getData(COLLECTOR));
        } else {
            this.setRegion(null);
            this.setCollector(null);
        }
    }

    private static enum Source {
        Database,
        Atom;

    }
}

