/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.ui.CollectionIdLabelProvider;
import com.ibm.cics.ia.ui.CommandFlowIndexLabelProvider;
import com.ibm.cics.ia.ui.DB2ResourceTypeLabelProvider;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.OperationLabelProvider;
import com.ibm.cics.ia.ui.PlatformLabelProvider;
import com.ibm.cics.ia.ui.ProgramLabelProvider;
import com.ibm.cics.ia.ui.RegionLabelProvider;
import com.ibm.cics.ia.ui.ResourceLabelProvider;
import com.ibm.cics.ia.ui.TSApplicationLabelProvider;
import com.ibm.cics.ia.ui.TaskLabelProvider;
import com.ibm.cics.ia.ui.TimeStampLabelProvider;
import com.ibm.cics.ia.ui.TransactionLabelProvider;
import com.ibm.cics.ia.ui.UserLabelProvider;
import com.ibm.cics.ia.ui.VerbLabelProvider;
import com.ibm.cics.ia.ui.WebserviceLabelProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class LabelProviderFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(LabelProviderFactory.class.getPackage().getName());
    private static Map labelProviders = new HashMap();

    public static LabelProvider getLabelProvider(String columnID) {
        Debug.enter((Logger)logger, (String)LabelProviderFactory.class.getName(), (String)"getLabelProvider", (Object)("Thread ID: " + Thread.currentThread().getId()));
        LabelProvider labelProvider = (LabelProvider)labelProviders.get(columnID);
        if (labelProvider != null) {
            return labelProvider;
        }
        if ("PROGRAM".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new ProgramLabelProvider());
        }
        if ("FUNCTION".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new VerbLabelProvider());
        }
        if ("OBJECT".equals(columnID) || "RESOURCE".equals(columnID) || "RESOURCE_NAME".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new ResourceLabelProvider());
        }
        if ("TASKID".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new TaskLabelProvider());
        }
        if ("TRANSID".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new TransactionLabelProvider());
        }
        if ("NAME".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new WebserviceLabelProvider());
        }
        if ("APPLID".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new RegionLabelProvider());
        }
        if ("DB2ID".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new DefaultLabelProvider(columnID, ImageFactory.getDatabaseImage()));
        }
        if ("RESNAME".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new DB2ResourceTypeLabelProvider(columnID));
        }
        if ("CMDFLOW_ID".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new CommandFlowIndexLabelProvider());
        }
        if ("CMD_TIME_LOCAL".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new TimeStampLabelProvider());
        }
        if ("COLLECTION_ID".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new CollectionIdLabelProvider());
        }
        if ("APPL_NAME".equals(columnID) || "APP_NAME".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new TSApplicationLabelProvider());
        }
        if ("APPL_OPER".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new OperationLabelProvider());
        }
        if ("PLATFORM".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new PlatformLabelProvider());
        }
        if ("USERID".equals(columnID) || "OWNER_USERID".equals(columnID)) {
            return LabelProviderFactory.installLabelProvider(columnID, new UserLabelProvider(columnID));
        }
        return LabelProviderFactory.installLabelProvider(columnID, new DefaultLabelProvider(columnID, ImageFactory.getFolderImage()));
    }

    private static LabelProvider installLabelProvider(String columnID, LabelProvider aLabelProvider) {
        labelProviders.put(columnID, aLabelProvider);
        return aLabelProvider;
    }

    private static class DefaultLabelProvider
    extends LabelProvider {
        private Image image;
        private String columnID;

        public DefaultLabelProvider(String columnID, Image anImage) {
            this.columnID = columnID;
            this.image = anImage;
        }

        public Image getImage(Object element) {
            return this.image;
        }

        public String getText(Object element) {
            StringBuffer sb = new StringBuffer();
            sb.append(SQLDefinitions.getColumnDescription((String)this.columnID));
            sb.append(' ');
            sb.append('(');
            sb.append(element);
            sb.append(')');
            return sb.toString();
        }
    }
}

