/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.controller.QueryCompositeImageDescriptor;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.composites.QueryTimeComposite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Image FILE_TYPE_GRAY_IMG;
    private static Map images;
    private static Image DATABASE_BUSY_IMG;
    private static Map overlaidImagesByOverlay;

    static {
        images = new HashMap();
        overlaidImagesByOverlay = new HashMap();
    }

    public static Image getImageFromURL(String aURLString) {
        try {
            Image result = (Image)images.get(aURLString);
            if (result == null) {
                result = ImageDescriptor.createFromURL((URL)new URL(aURLString)).createImage();
                images.put(aURLString, result);
            }
            return result;
        }
        catch (MalformedURLException e) {
            IAPlugin.getDefault().logError("Unable to get Image from URL " + aURLString, (Throwable)e);
            return null;
        }
    }

    public static Image getOverlaidImage(Image originalImage, Image overlaidImage) {
        Map overlaidImages = (Map)overlaidImagesByOverlay.get(overlaidImage);
        if (overlaidImages == null) {
            images = new HashMap();
            overlaidImagesByOverlay.put(overlaidImage, images);
            Image result = new QueryCompositeImageDescriptor(originalImage, overlaidImage).createImage();
            images.put(overlaidImage, result);
            return result;
        }
        Image result = (Image)overlaidImages.get(originalImage);
        if (result == null) {
            result = new QueryCompositeImageDescriptor(originalImage, overlaidImage).createImage();
            overlaidImages.put(originalImage, result);
        }
        return result;
    }

    public static Image getMapTypeImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/map_type.gif");
    }

    public static Image getTDQTypeImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/tdq.gif");
    }

    public static Image getVerbImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/verb.gif");
    }

    public static Image getEventImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/event.gif");
    }

    public static Image getFileTypeImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/file_type.gif");
    }

    public static Image getGrayFileImage() {
        if (FILE_TYPE_GRAY_IMG == null) {
            FILE_TYPE_GRAY_IMG = new Image(null, ImageFactory.getFileTypeImage(), 2);
        }
        return FILE_TYPE_GRAY_IMG;
    }

    public static Image getInformationImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/info.gif");
    }

    public static Image getErrorImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/error.gif");
    }

    public static Image getWarningImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/warn.gif");
    }

    public static Image getWaitingImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/waiting.gif");
    }

    public static Image getNextItemImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/search_next.gif");
    }

    public static Image getPreviousItemImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/search_prev.gif");
    }

    public static Image getNextItemImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/search_next.gif");
    }

    public static Image getPreviousItemImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/search_prev.gif");
    }

    public static Image getDatabaseBusyImage() {
        if (DATABASE_BUSY_IMG == null) {
            DATABASE_BUSY_IMG = ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/database.ico");
            DATABASE_BUSY_IMG = new Image(null, DATABASE_BUSY_IMG, 2);
        }
        return DATABASE_BUSY_IMG;
    }

    public static Image getSearchImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/search.gif");
    }

    public static Image getHiearchyLayoutImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/hierarchicalLayout.gif");
    }

    public static Image getMapImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/map.gif");
    }

    public static Image getTDQImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/tdqueue.gif");
    }

    public static Image getTSQImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/tsqueue.gif");
    }

    public static Image getQueueImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/mq.gif");
    }

    public static Image getFileImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/file_type.gif");
    }

    public static Image getRegionImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/region_obj.gif");
    }

    public static Image getRegionsImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/cicsplex.gif");
    }

    public static Image getOrderByRegionImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/region_sort.gif");
    }

    public static Image getProgramImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/program.gif");
    }

    public static Image getTransactionImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/transaction.gif");
    }

    public static Image getWebserviceImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/webservice.gif");
    }

    public static Image getTDQueueImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/tdqeueue.gif");
    }

    public static Image getQueryImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/database_query.gif");
    }

    public static Image getSearchHistoryImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/search_history.gif");
    }

    public static Image getHistoryImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/history.gif");
    }

    public static Image getForwardImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/forward_nav.gif");
    }

    public static Image getForwardImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/forward_nav.gif");
    }

    public static Image getBackwardImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/backward_nav.gif");
    }

    public static Image getBackwardImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/backward_nav.gif");
    }

    public static Image getFolderImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/fldr_obj.gif");
    }

    public static Image getResourceImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/resource_obj.gif");
    }

    public static Image getSevereErrorImageOverlay() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/error_overlay.gif");
    }

    public static Image getWarningErrorImageOverlay() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/warning_overlay.gif");
    }

    public static Image getRunImageOverlay() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/run_overlay.gif");
    }

    public static Image getStopImageOverlay() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/stop_overlay.gif");
    }

    public static Image getStopSearchImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/progress_stop.gif");
    }

    public static Image getStopSearchImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/progress_stop.gif");
    }

    public static Image getRunImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/run.gif");
    }

    public static Image getRefreshImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/refresh.gif");
    }

    public static Image getCopySQLStringImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/copysqlstring.gif");
    }

    public static Image getGoImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/go.gif");
    }

    public static Image getSaveImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/save.gif");
    }

    public static Image getSaveImageDisabled() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/save.gif");
    }

    public static Image getCopySQLStringDisabled() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/copysqlstring.gif");
    }

    public static Image getRunImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/run.gif");
    }

    public static Image getFieldImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/field.gif");
    }

    public static Image getQueryResultImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/table.gif");
    }

    public static Image getResourcesBannerImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/resources_banner.gif");
    }

    public static Image getAndExpression() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/andexpression.gif");
    }

    public static Image getOKImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/tick.gif");
    }

    public static Image getQueryWizardBanner() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/wizban/query_wiz.png");
    }

    public static Image getNewWizard() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/newfolder.gif");
    }

    public static Image getResumeImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/resume.gif");
    }

    public static Image getResumeImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/resume.gif");
    }

    public static Image getSuspendImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/suspend.gif");
    }

    public static Image getSuspendImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/suspend.gif");
    }

    public static Image getCopyImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/copy.gif");
    }

    public static Image getCopyImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/copy.gif");
    }

    public static Image getColumnImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/activity.gif");
    }

    public static Image getAddImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/add.gif");
    }

    public static Image getClearImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/clear_co.gif");
    }

    public static Image getClearImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/clear_co.gif");
    }

    public static Image getDeleteImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/delete.gif");
    }

    public static Image getDeleteImage_DISABLED() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/delete.gif");
    }

    public static Image getEmptyImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/empty.gif");
    }

    public static Image getHelpLinkImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/linkto_help.gif");
    }

    public static Image getUsesImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/callers.gif");
    }

    public static Image getUsedByImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/callees.gif");
    }

    public static Image getCompareImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/compare.gif");
    }

    public static Image getDropDownArrowImage() {
        if (Display.getCurrent().getHighContrast()) {
            return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/dropdownarrow_white.png");
        }
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/dropdownarrow.png");
    }

    public static Image getActiveConnectionImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/activeconnection_1.gif");
    }

    public static Image getInactiveConnectionImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/inactiveconnection_1.gif");
    }

    public static Image getProgressConnectionImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/progressconnection.gif");
    }

    public static Image getPasswordRequiredImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/wizban/keylock.png");
    }

    public static Image getDatabaseImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/database.gif");
    }

    public static Image getDatabaseSchemaImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/schema.gif");
    }

    public static Image getDatabaseViewImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/view.gif");
    }

    public static Image getDatabaseTableImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/table.gif");
    }

    public static Image getDatabaseCursorImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/index.gif");
    }

    public static Image getDatabaseDomainImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/domain.gif");
    }

    public static Image getWelcomeOpenConnectionsImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/migrate.gif");
    }

    public static Image getWelcomeLaunchExplorerImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/workbench.gif");
    }

    public static Image getSelectRegionsImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/wizban/show_region_wiz.gif");
    }

    public static Image getCincUsersImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/wizban/cinc_users_wiz.gif");
    }

    public static Image getTaskImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/task.gif");
    }

    public static Image getEqualImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/equal.gif");
    }

    public static Image getNotEqualImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/notequal.gif");
    }

    public static Image getExpandImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/expandall_co.gif");
    }

    public static Image getCollapseImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/collapse_all.gif");
    }

    public static Image getApplicationImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/application.gif");
    }

    public static Image getApplicationCloudImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/application_cloud.gif");
    }

    public static Image getApplicationCloudUnknownImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/application_cloud_unknown.png");
    }

    public static Image getApplicationFolderImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/application_folder.gif");
    }

    public static Image getCommandFlowImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/commandflow.gif");
    }

    public static Image getTCBModeSwapImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/local_remote_conflict_ovr.gif");
    }

    public static Image getRespErrorImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/warning_ovr.gif");
    }

    public static Image getAsteriskImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/asterisk.gif");
    }

    public static Image getTimeStampImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/datatype_datetime.gif");
    }

    public static Image getViewMenu() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/dropdown_co.gif");
    }

    public static Image getCollectorStartImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/collector_start.gif");
    }

    public static Image getCollectorStartScenarioBasedCollectionImage() {
        return ImageFactory.getCollectorStartImage();
    }

    public static Image getCollectorStopImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/collector_stop.gif");
    }

    public static Image getCollectorPauseImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/collector_pause.gif");
    }

    public static Image getCollectorContinueImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/collector_continue.gif");
    }

    public static Image getCollectorStatsImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/collector_stats.gif");
    }

    public static Image getCollectorStartedOverlayImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/col_started_ovr.gif");
    }

    public static Image getCollectorPausedOverlayImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/col_paused_ovr.gif");
    }

    public static Image getCollectorStoppedOverlayImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/col_stopped_ovr.gif");
    }

    public static Image getCollectorUnknownOverlayImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/col_unknown_ovr.gif");
    }

    public static Image getUsersImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/users.gif");
    }

    public static Image getUserImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/cview16/user.gif");
    }

    public static Image getImageForOperator(QueryTimeComposite.Operator operator) {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/" + operator.getIconImageName());
    }

    public static Image getCSectImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/csect.gif");
    }

    public static Image getConnectionImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/connection.gif");
    }

    public static Image getCollectionIdImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/collection_id.gif");
    }

    public static Image getConnectionWizardImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/wizban/conn_management_wiz.gif");
    }

    public static Image getWebpageImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/webpage.gif");
    }

    public static Image getApplicationsImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/applications.gif");
    }

    public static Image getReportImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/report.gif");
    }

    public static Image getReportsImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/reports.gif");
    }

    public static Image getReportWizardImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/wizban/report_wiz.png");
    }

    public static Image getOperationImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/operation.gif");
    }

    public static Image getCICSPlexImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/cicsplex.gif");
    }

    public static Image getCICSPlexesWizardImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/wizban/cicsplexes_wiz.gif");
    }

    public static Image getCollapseSingleImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/collapse.gif");
    }

    public static Image getExpandSingleImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/expand.gif");
    }

    public static Image getOperationCandidateImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/operation_candidate.png");
    }

    public static Image getFilterImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/filter.png");
    }

    public static Image getSwapImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/swap.png");
    }

    public static Image getHorizontalLayoutImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/horiz_layout.gif");
    }

    public static Image getVerticalLayoutImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/vert_layout.gif");
    }

    public static Image getAtomserviceImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/atomservice.gif");
    }

    public static Image getDB2EntryImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/db2entry.gif");
    }

    public static Image getIpconnImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/ipconn.gif");
    }

    public static Image getJvmProfImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/jvmprof.gif");
    }

    public static Image getPipelineImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/pipeline.gif");
    }

    public static Image getResourceConnectionsImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/resource_con.gif");
    }

    public static Image getPlatformImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/platform.gif");
    }

    public static Image getPlatformUnknownImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/platform_unknown.png");
    }

    public static Image getPlatformWizardImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/wizban/platform_wiz.png");
    }

    public static Image getAffinityReportImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/affinity_report.png");
    }

    public static Image getAffinityReportDisabledImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/affinity_report_disabled.png");
    }

    public static Image getAffinityReportWizardImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/wizban/affinity_report.png");
    }

    public static Image getBuildImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/build.png");
    }

    public static Image getBuildReportImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/build_affinity_report.png");
    }

    public static Image getBuildReportDisabledImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/dlcl16/build_affinity_report.png");
    }

    public static Image getBuilderWizardImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/wizban/build_wiz.png");
    }

    public static Image getOpenDatasetImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/open_data_set.gif");
    }

    public static Image getCreateDatasetImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/create_data_set.gif");
    }

    public static Image getArrowRightImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/forward_nav.gif");
    }

    public static Image getArrowDownImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/search_next.gif");
    }

    public static Image getScannerImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/scanner.gif");
    }

    public static Image getCloudImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/cloud.gif");
    }

    public static Image getUserCommandFlowImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/commandflowuser.gif");
    }

    public static Image getIAOperationsImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/iaoperations.gif");
    }

    public static Image getEnabledAndCheckedCheckboxImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/checkbox_enabled_checked.gif");
    }

    public static Image getEnabledAndUncheckedCheckboxImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/checkbox_enabled_unchecked.gif");
    }

    public static Image getDisabledAndCheckedCheckboxImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/checkbox_disabled_checked.gif");
    }

    public static Image getDisabledAndUncheckedCheckboxImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/checkbox_disabled_unchecked.gif");
    }

    public static Image getCompareResourceImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/Compare_16_transp.gif");
    }

    public static Image getCompareResourceSimilarImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/Similar_16_transp.gif");
    }

    public static Image getDifferenceImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/Different_16_transp.gif");
    }

    public static Image getAllImage() {
        return ImageFactory.getImageFromURL("platform:/plugin/com.ibm.cics.ia.ui/icons/full/elcl16/All_16_transp.gif");
    }
}

