/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.ia.commands.WebServiceRequest;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.IAtomControllerListener;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.TreeSelectionProvider;
import com.ibm.cics.ia.ui.actions.CollectorAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.ViewPart;

public class IAOperationsView
extends ViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(IAOperationsView.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.ia.ui.IAOperationsView";
    private static final String COLLECTOR_ACTION = "COLLECTOR_ACTION";
    private static final String REGIONS = "REGIONS";
    private static final String USERS = "USERS";
    private Composite parent;
    private Composite topComposite;
    private Composite fillComposite;
    private ToolBar topToolBar;
    private ToolBarManager toolBar;
    private Tree collectorTree;
    private Display display;
    private IAtomControllerListener atomControllerListener;
    private ConnectionManagerListener connectionManagerListener;
    private CollectorAction startAction;
    private CollectorAction stopAction;
    private CollectorAction pauseAction;
    private CollectorAction continueAction;
    private CollectorAction refreshAction;
    private CollectorAction editCollectorAction;
    private CollectorAction startScenarioBasedCollectionAction;
    private CollectorAction resetDefaultsAction;
    private CintCollector selectedCintCollector;
    private CincCollector selectedCincCollector;
    private SelectionListener treeSelectionListener;
    private TreeSelectionProvider selectionProvider;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.selectedCintCollector = null;
        this.fillComposite = new Composite(parent, 0);
        this.parent = parent;
        this.display = parent.getDisplay();
        FormLayout formLayout = new FormLayout();
        this.fillComposite.setLayout((Layout)formLayout);
        this.topComposite = new Composite(this.fillComposite, 0);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.topComposite.setLayout((Layout)formLayout);
        this.topComposite.setLayoutData((Object)formData);
        this.topToolBar = new ToolBar(this.topComposite, 0x800100);
        this.toolBar = new ToolBarManager(this.topToolBar);
        this.startAction = new CollectorAction();
        this.startAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getCollectorStartImage()));
        this.startAction.setToolTipText(Messages.getString("IAOperationsView.startButtonText"));
        this.startAction.setText(Messages.getString("IAOperationsView.startButtonText"));
        this.startAction.setId(CollectorAction.CINT_START_ACTION);
        this.startAction.setCintCollector(this.selectedCintCollector);
        this.startAction.setEnabled(false);
        this.stopAction = new CollectorAction();
        this.stopAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getCollectorStopImage()));
        this.stopAction.setToolTipText(Messages.getString("IAOperationsView.stopButtonText"));
        this.stopAction.setText(Messages.getString("IAOperationsView.stopButtonText"));
        this.stopAction.setId(CollectorAction.CINT_STOP_ACTION);
        this.stopAction.setCintCollector(this.selectedCintCollector);
        this.stopAction.setEnabled(false);
        this.pauseAction = new CollectorAction();
        this.pauseAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getCollectorPauseImage()));
        this.pauseAction.setToolTipText(Messages.getString("IAOperationsView.pauseButtonText"));
        this.pauseAction.setText(Messages.getString("IAOperationsView.pauseButtonText"));
        this.pauseAction.setId(CollectorAction.CINT_PAUSE_ACTION);
        this.pauseAction.setCintCollector(this.selectedCintCollector);
        this.pauseAction.setEnabled(false);
        this.continueAction = new CollectorAction();
        this.continueAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getCollectorContinueImage()));
        this.continueAction.setToolTipText(Messages.getString("IAOperationsView.continueButtonText"));
        this.continueAction.setText(Messages.getString("IAOperationsView.continueButtonText"));
        this.continueAction.setId(CollectorAction.CINT_CONTINUE_ACTION);
        this.continueAction.setCintCollector(this.selectedCintCollector);
        this.continueAction.setEnabled(false);
        this.refreshAction = new CollectorAction();
        this.refreshAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getRefreshImage()));
        this.refreshAction.setToolTipText(Messages.getString("IAOperationsView.refreshButtonText"));
        this.refreshAction.setText(Messages.getString("IAOperationsView.refreshButtonText"));
        this.refreshAction.setId(CollectorAction.REFRESH_ACTION);
        this.refreshAction.setCintCollector(this.selectedCintCollector);
        this.refreshAction.setEnabled(true);
        this.editCollectorAction = new CollectorAction();
        this.editCollectorAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getCollectorStatsImage()));
        this.editCollectorAction.setToolTipText(Messages.getString("IAOperationsView.editCollectorOptionsButtonText"));
        this.editCollectorAction.setText(Messages.getString("IAOperationsView.editCollectorOptionsButtonText"));
        this.editCollectorAction.setEnabled(false);
        this.startScenarioBasedCollectionAction = new CollectorAction();
        this.startScenarioBasedCollectionAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getCollectorStartScenarioBasedCollectionImage()));
        this.startScenarioBasedCollectionAction.setToolTipText(Messages.getString("IAOperationsView.startScenarioBasedCollectionButtonText"));
        this.startScenarioBasedCollectionAction.setText(Messages.getString("IAOperationsView.startScenarioBasedCollectionButtonText"));
        this.startScenarioBasedCollectionAction.setId(CollectorAction.CINT_START_SCENARIO_BASED_COLLECTION_ACTION);
        this.startScenarioBasedCollectionAction.setCintCollector(this.selectedCintCollector);
        this.startScenarioBasedCollectionAction.setEnabled(false);
        this.resetDefaultsAction = new CollectorAction();
        this.resetDefaultsAction.setToolTipText(Messages.getString("IAOperationsView.resetDefaultsButtonText"));
        this.resetDefaultsAction.setText(Messages.getString("IAOperationsView.resetDefaultsButtonText"));
        this.resetDefaultsAction.setId(WebServiceRequest.CINT_RESET_REGION_DEFAULTS_ACTION);
        this.resetDefaultsAction.setCintCollector(this.selectedCintCollector);
        this.resetDefaultsAction.setEnabled(false);
        this.toolBar.add((IAction)this.startAction);
        this.toolBar.add((IAction)this.stopAction);
        this.toolBar.add((IAction)this.pauseAction);
        this.toolBar.add((IAction)this.continueAction);
        this.toolBar.add((IAction)this.editCollectorAction);
        this.toolBar.add((IContributionItem)new Separator());
        this.toolBar.add((IAction)this.refreshAction);
        this.toolBar.add((IContributionItem)new Separator());
        this.toolBar.update(true);
        this.topToolBar.pack();
        this.toolBar.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID > -1) {
                    ActionContributionItem action = (ActionContributionItem)IAOperationsView.this.toolBar.getItems()[e.childID];
                    if (action.getAction().equals((Object)IAOperationsView.this.startAction)) {
                        e.result = String.valueOf(IAOperationsView.this.getContentDescription()) + Messages.getString("IAOperationsView.startButtonText");
                    } else if (action.getAction().equals((Object)IAOperationsView.this.stopAction)) {
                        e.result = String.valueOf(IAOperationsView.this.getContentDescription()) + Messages.getString("IAOperationsView.stopButtonText");
                    } else if (action.getAction().equals((Object)IAOperationsView.this.pauseAction)) {
                        e.result = String.valueOf(IAOperationsView.this.getContentDescription()) + Messages.getString("IAOperationsView.pauseButtonText");
                    } else if (action.getAction().equals((Object)IAOperationsView.this.continueAction)) {
                        e.result = String.valueOf(IAOperationsView.this.getContentDescription()) + Messages.getString("IAOperationsView.continueButtonText");
                    } else if (action.getAction().equals((Object)IAOperationsView.this.editCollectorAction)) {
                        e.result = String.valueOf(IAOperationsView.this.getContentDescription()) + Messages.getString("IAOperationsView.editCollectorOptionsButtonText");
                    } else if (action.getAction().equals((Object)IAOperationsView.this.refreshAction)) {
                        e.result = String.valueOf(IAOperationsView.this.getContentDescription()) + Messages.getString("IAOperationsView.refreshButtonText");
                    } else if (action.getAction().equals((Object)IAOperationsView.this.startScenarioBasedCollectionAction)) {
                        e.result = String.valueOf(IAOperationsView.this.getContentDescription()) + Messages.getString("IAOperationsView.startScenarioBasedCollectionButtonText");
                    } else if (action.getAction().equals((Object)IAOperationsView.this.resetDefaultsAction)) {
                        e.result = String.valueOf(IAOperationsView.this.getContentDescription()) + Messages.getString("IAOperationsView.resetDefaultsButtonText");
                    }
                }
            }
        });
        this.collectorTree = new Tree(this.fillComposite, 2564);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.topComposite);
        formData.bottom = new FormAttachment(100, 0);
        this.collectorTree.setLayoutData((Object)formData);
        final TreeColumn collectorTreeCol1 = new TreeColumn(this.collectorTree, 0);
        TreeColumn collectorTreeCol2 = new TreeColumn(this.collectorTree, 0);
        this.collectorTree.setHeaderVisible(false);
        this.collectorTree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                collectorTreeCol1.setWidth((int)Math.round((double)((IAOperationsView)IAOperationsView.this).collectorTree.getClientArea().width * 0.7));
            }
        });
        this.treeSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = IAOperationsView.this.collectorTree.getSelection();
                if (items.length == 1) {
                    TreeItem item = items[0];
                    Object itemData = item.getData();
                    IAOperationsView.this.refreshActions(itemData);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.collectorTree.addSelectionListener(this.treeSelectionListener);
        this.collectorTree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem[] items = IAOperationsView.this.collectorTree.getSelection();
                if (items.length == 1) {
                    TreeItem item = items[0];
                    Object itemData = item.getData();
                    if (itemData instanceof CincCollector) {
                        CincCollector collector = (CincCollector)itemData;
                        IAOperationsView.this.editCollectorAction.setCincCollector(collector);
                    } else if (itemData instanceof CintCollector) {
                        CintCollector collector = (CintCollector)itemData;
                        IAOperationsView.this.editCollectorAction.setCintCollector(collector);
                    }
                    if (IAOperationsView.this.editCollectorAction.isEnabled()) {
                        IAOperationsView.this.editCollectorAction.run();
                    }
                }
            }
        });
        this.collectorTree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                TreeItem[] treeItems = IAOperationsView.this.collectorTree.getSelection();
                if (treeItems.length == 1) {
                    TreeItem treeItem = treeItems[0];
                    Object data = treeItem.getData();
                    if (data instanceof CintCollector) {
                        CintCollector collector = (CintCollector)data;
                        e.result = String.valueOf(collector.getName()) + " " + collector.getState().toLowerCase();
                    } else if (data instanceof CincCollector) {
                        CincCollector collector = (CincCollector)data;
                        e.result = String.valueOf(collector.getUserId()) + " " + collector.getState().toLowerCase();
                    } else {
                        e.result = treeItem.getText();
                    }
                }
            }
        });
        this.selectionProvider = new TreeSelectionProvider(this.collectorTree, new String[0]);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        MenuManager menuMgr = new MenuManager();
        Menu popupMenu = menuMgr.createContextMenu((Control)this.collectorTree);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeItem[] items = IAOperationsView.this.collectorTree.getSelection();
                if (items.length == 1) {
                    TreeItem item = items[0];
                    Object itemData = item.getData();
                    IAOperationsView.this.showCollectorSubMenu(manager, itemData);
                }
            }
        });
        this.collectorTree.setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.operation_explorer");
        AtomController.getInstance().addAtomControllerListener(this.getAtomControllerListener());
        ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().addListener(this.getConnectionManagerListener());
        this.refresh();
        CollectorAction action = new CollectorAction();
        action.setId(CollectorAction.REFRESH_ACTION);
        action.run();
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"createPartControl");
    }

    public void setFocus() {
        this.collectorTree.setFocus();
    }

    public void setInput(Collection<AtomContent> collectors) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"setInput", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Iterator<AtomContent> iter = collectors.iterator();
        AtomController controller = AtomController.getInstance();
        while (iter.hasNext()) {
            CincCollector cincCollector;
            TreeItem regionsItem;
            TreeItem connectionItem;
            String connectionName;
            IConnection connection;
            String connectionID;
            AtomContent content = iter.next();
            if (content instanceof CintCollector) {
                CintCollector cintCollector = (CintCollector)content;
                connectionID = cintCollector.getConnectionID();
                connection = controller.getConnection(connectionID);
                if (connection == null) continue;
                connectionName = connection.getConfiguration().getName();
                connectionItem = this.getConnectionTreeItem(this.collectorTree, connectionID, connectionName);
                regionsItem = this.getRegionsTreeItem(connectionItem);
                connectionItem.setExpanded(true);
                TreeItem treeItem = this.getRegionItem(regionsItem, cintCollector);
                continue;
            }
            if (!(content instanceof CincCollector) || (connection = controller.getConnection(connectionID = (cincCollector = (CincCollector)content).getConnectionID())) == null) continue;
            connectionName = controller.getConnection(connectionID).getConfiguration().getName();
            connectionItem = this.getConnectionTreeItem(this.collectorTree, connectionID, connectionName);
            regionsItem = this.getRegionsTreeItem(connectionItem);
            TreeItem usersItem = this.getUsersTreeItem(connectionItem);
            connectionItem.setExpanded(true);
            TreeItem treeItem = this.getUserItem(usersItem, cincCollector);
        }
        if (this.collectorTree.getSelection().length == 1) {
            this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
            this.treeSelectionListener.widgetSelected(null);
            this.selectionProvider.setSelection((ISelection)new StructuredSelection(this.collectorTree.getSelection()[0].getData()));
            this.treeSelectionListener.widgetSelected(null);
        }
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"setInput");
    }

    public void refresh() {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.collectorTree != null) {
            AtomController controller = AtomController.getInstance();
            List connConfigurations = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getConnectionProfiles("com.ibm.cics.ia.collectorConnection");
            Iterator iter = connConfigurations.iterator();
            this.collectorTree.setRedraw(false);
            TreeItem[] currentItems = this.collectorTree.getItems();
            int i = 0;
            while (i < currentItems.length) {
                String connectionID = (String)currentItems[i].getData();
                boolean exists = false;
                for (ConnectionProfile config : connConfigurations) {
                    if (!config.getId().equals(connectionID)) continue;
                    exists = true;
                }
                if (!exists) {
                    currentItems[i].removeAll();
                    currentItems[i].dispose();
                    currentItems[i] = null;
                }
                ++i;
            }
            while (iter.hasNext()) {
                ConnectionProfile configuration = (ConnectionProfile)iter.next();
                String connectionName = configuration.getName();
                String connectionID = configuration.getId();
                TreeItem item = this.getConnectionTreeItem(this.collectorTree, connectionID, connectionName);
                if (controller.getConnection(connectionID) != null) continue;
                item.removeAll();
            }
            this.collectorTree.setRedraw(true);
            if (this.selectionProvider != null) {
                this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"refresh");
    }

    public void refresh(String configurationId, String name) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem connectionTreeItem = this.getConnectionTreeItem(this.collectorTree, configurationId, name);
        connectionTreeItem.removeAll();
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"refresh");
    }

    private TreeItem getConnectionTreeItem(Tree tree, String connectionID, String connectionName) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getConnectionTreeItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem[] items = tree.getItems();
        TreeItem item = null;
        int i = 0;
        while (i < items.length) {
            if (connectionID.equals(items[i].getData())) {
                item = items[i];
            }
            ++i;
        }
        if (item == null) {
            int position = items.length;
            int i2 = 0;
            while (i2 < items.length) {
                if (items[i2].getText().compareTo(connectionName) > 0) {
                    position = i2;
                    break;
                }
                ++i2;
            }
            item = new TreeItem(tree, 0, position);
            Image connectionImage = ImageFactory.getConnectionImage();
            item.setData((Object)connectionID);
            item.setText(connectionName);
            item.setImage(connectionImage);
        } else if (item.getText() != connectionName) {
            item.setText(connectionName);
        }
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getConnectionTreeItem");
        return item;
    }

    private TreeItem getRegionsTreeItem(TreeItem connectionItem) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getRegionsTreeItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem[] items = connectionItem.getItems();
        TreeItem item = null;
        int i = 0;
        while (i < items.length) {
            if (REGIONS.equals(items[i].getData())) {
                item = items[i];
            }
            ++i;
        }
        if (item == null) {
            item = new TreeItem(connectionItem, 0);
            item.setData((Object)REGIONS);
            item.setText(Messages.getString("IAOperationsView.Regions.MenuItem.Text"));
            item.setImage(ImageFactory.getRegionsImage());
        }
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getRegionsTreeItem");
        return item;
    }

    private TreeItem getUsersTreeItem(TreeItem connectionItem) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getUsersTreeItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem[] items = connectionItem.getItems();
        TreeItem item = null;
        int i = 0;
        while (i < items.length) {
            if (USERS.equals(items[i].getData())) {
                item = items[i];
            }
            ++i;
        }
        if (item == null) {
            item = new TreeItem(connectionItem, 0);
            item.setData((Object)USERS);
            item.setText(Messages.getString("IAOperationsView.Users.MenuItem.Text"));
            item.setImage(ImageFactory.getUsersImage());
        }
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getUsersTreeItem");
        return item;
    }

    private TreeItem getRegionItem(TreeItem regionsItem, CintCollector collector) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getRegionItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem[] items = regionsItem.getItems();
        TreeItem item = null;
        int i = 0;
        while (i < items.length) {
            CintCollector data = (CintCollector)items[i].getData();
            if (data.getRegion().equals((Object)collector.getRegion())) {
                item = items[i];
            }
            ++i;
        }
        if (item == null) {
            item = new TreeItem(regionsItem, 0);
        } else {
            item.setData(null);
        }
        item.setText(collector.getRegion().getName());
        item.setData((Object)collector);
        item.setImage(ResourceRenderer.asImage(collector.getRegion()));
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getRegionItem");
        return item;
    }

    private TreeItem getUserItem(TreeItem usersItem, CincCollector collector) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getUserItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!"".equals(collector.getUserId())) {
            TreeItem[] items = usersItem.getItems();
            TreeItem item = null;
            int i = 0;
            while (i < items.length) {
                CincCollector data = (CincCollector)items[i].getData();
                if (data.getUserId().equals(collector.getUserId())) {
                    item = items[i];
                    break;
                }
                ++i;
            }
            if (collector.isDeleted()) {
                if (item != null) {
                    item.dispose();
                }
                Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getUserItem");
                return null;
            }
            if (item == null) {
                item = new TreeItem(usersItem, 0);
            } else {
                item.setData(null);
            }
            item.setData((Object)collector);
            item.setImage(ResourceRenderer.userImage(collector));
            item.setText(collector.getUserId());
            Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getUserItem");
            return item;
        }
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"getUserItem");
        return null;
    }

    private void refreshActions(Object itemData) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"refreshActions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (itemData instanceof CintCollector) {
            boolean enabledEditRegionAction = false;
            this.selectedCintCollector = (CintCollector)itemData;
            this.startAction.setCintCollector(this.selectedCintCollector);
            this.startAction.setId(CollectorAction.CINT_START_ACTION);
            this.stopAction.setCintCollector(this.selectedCintCollector);
            this.stopAction.setId(CollectorAction.CINT_STOP_ACTION);
            this.pauseAction.setCintCollector(this.selectedCintCollector);
            this.continueAction.setCintCollector(this.selectedCintCollector);
            this.refreshAction.setCintCollector(this.selectedCintCollector);
            this.editCollectorAction.setCintCollector(this.selectedCintCollector);
            String state = this.selectedCintCollector.getState();
            if (state.equals("RUNNING")) {
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(true);
                this.pauseAction.setEnabled(true);
                this.continueAction.setEnabled(false);
            } else if (state.equals("FAILING") || state.equals("STOPFAIL")) {
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(true);
                this.pauseAction.setEnabled(false);
                this.continueAction.setEnabled(false);
            } else if (state.equals("STOPPED")) {
                this.startAction.setEnabled(true);
                this.stopAction.setEnabled(false);
                this.pauseAction.setEnabled(false);
                this.continueAction.setEnabled(false);
                enabledEditRegionAction = true;
            } else if (state.equals("PAUSED")) {
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(true);
                this.pauseAction.setEnabled(false);
                this.continueAction.setEnabled(true);
            } else {
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(false);
                this.pauseAction.setEnabled(false);
                this.continueAction.setEnabled(false);
            }
            this.editCollectorAction.setEnabled(enabledEditRegionAction);
            this.editCollectorAction.setId(CollectorAction.EDIT_REGION_ACTION);
            this.startScenarioBasedCollectionAction.setEnabled(this.startAction.isEnabled() && !this.selectedCintCollector.isConnectedToAtom());
            this.startScenarioBasedCollectionAction.setCintCollector(this.selectedCintCollector);
            this.resetDefaultsAction.setEnabled(this.startAction.isEnabled() && !this.selectedCintCollector.isConnectedToAtom());
            this.resetDefaultsAction.setCintCollector(this.selectedCintCollector);
        } else if (itemData instanceof CincCollector) {
            this.selectedCincCollector = (CincCollector)itemData;
            this.startAction.setCincCollector(this.selectedCincCollector);
            this.startAction.setId(CollectorAction.CINC_START_ACTION);
            this.stopAction.setCincCollector(this.selectedCincCollector);
            this.stopAction.setId(CollectorAction.CINC_STOP_ACTION);
            this.pauseAction.setCincCollector(this.selectedCincCollector);
            this.continueAction.setCincCollector(this.selectedCincCollector);
            this.refreshAction.setCincCollector(this.selectedCincCollector);
            this.editCollectorAction.setCincCollector(this.selectedCincCollector);
            String state = this.selectedCincCollector.getState();
            if (this.selectedCincCollector.isControllable()) {
                if ("STOPPED".equals(state) || "START FAILED".equals(state) || "NO APPLIDS".equals(state) || "NO CONNECTIONS".equals(state) || "NOT ACTIVE".equals(state)) {
                    this.startAction.setEnabled(true);
                    this.stopAction.setEnabled(false);
                    this.editCollectorAction.setEnabled(true);
                } else if ("RUNNING".equals(state) || "PARTLY STARTED".equals(state) || "ACTIVE".equals(state)) {
                    this.startAction.setEnabled(false);
                    this.stopAction.setEnabled(true);
                    this.editCollectorAction.setEnabled(false);
                } else {
                    this.startAction.setEnabled(false);
                    this.stopAction.setEnabled(true);
                    this.editCollectorAction.setEnabled(true);
                }
            } else {
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(false);
                this.editCollectorAction.setEnabled(false);
            }
            this.pauseAction.setEnabled(false);
            this.continueAction.setEnabled(false);
            this.editCollectorAction.setId(CollectorAction.EDIT_USER_ACTION);
        } else {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(false);
            this.pauseAction.setEnabled(false);
            this.continueAction.setEnabled(false);
            this.editCollectorAction.setEnabled(false);
        }
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"refreshActions");
    }

    private void showCollectorSubMenu(IMenuManager mgr, Object itemData) {
        if (itemData instanceof CincCollector) {
            mgr.add((IAction)this.startAction);
            mgr.add((IAction)this.stopAction);
            mgr.add((IAction)this.editCollectorAction);
        } else if (itemData instanceof CintCollector) {
            mgr.add((IAction)this.startAction);
            mgr.add((IAction)this.stopAction);
            mgr.add((IAction)this.pauseAction);
            mgr.add((IAction)this.continueAction);
            mgr.add((IAction)this.editCollectorAction);
            mgr.add((IAction)this.startScenarioBasedCollectionAction);
            mgr.add((IAction)this.resetDefaultsAction);
        }
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.ia.connection.atom";
        }
        return super.getPartProperty(key);
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomController.getInstance().removeAtomControllerListener(this.getAtomControllerListener());
        this.getConnectionManagerListener().makeStale();
        super.dispose();
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"dispose");
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.setTitleToolTip(this.getTitle());
    }

    private ConnectionManagerListener getConnectionManagerListener() {
        if (this.connectionManagerListener == null) {
            this.connectionManagerListener = new ConnectionManagerListener(){

                public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
                    if ("com.ibm.cics.ia.connection.atom".equals(event.getConnectionProfile().getConnectionDescriptor().getCategory().getId())) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Debug.enter((Logger)logger, (String)"IAOperationsView.getConnectionManagerListener().event().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                IAOperationsView.this.refresh();
                                Debug.exit((Logger)logger, (String)"IAOperationsView.getConnectionManagerListener().event().syncExec", (String)"run");
                            }
                        });
                    }
                }
            };
        }
        return this.connectionManagerListener;
    }

    private IAtomControllerListener getAtomControllerListener() {
        if (this.atomControllerListener == null) {
            this.atomControllerListener = new IAtomControllerListener(){

                public void disconnected(IConnection connection) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IAOperationsView.this.refresh();
                        }
                    });
                }

                public void connected(final IConnection connection) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"IAOperationsView.getAtomControllerListener().Runnable().asyncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            if (IAOperationsView.this.collectorTree != null && !IAOperationsView.this.collectorTree.isDisposed()) {
                                if (connection != null) {
                                    String conf = connection.getConfiguration().getID();
                                    String name = connection.getConfiguration().getName();
                                    IAOperationsView.this.refresh(conf, name);
                                }
                                CollectorAction action = new CollectorAction();
                                action.setId(CollectorAction.REFRESH_ACTION);
                                action.run();
                            }
                            Debug.exit((Logger)logger, (String)"IAOperationsView.getAtomControllerListener().Runnable().asyncExec", (String)"run");
                        }
                    });
                }
            };
        }
        return this.atomControllerListener;
    }

    public void expandConnectionNode(String connectionID) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"expandConnectionNode", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem[] items = this.collectorTree.getItems();
        TreeItem item = null;
        int i = 0;
        while (i < items.length) {
            if (connectionID.equals(items[i].getData())) {
                item = items[i];
            }
            ++i;
        }
        if (item != null) {
            item.setExpanded(true);
        }
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"expandConnectionNode");
    }

    public void expandRegionsNode(String connectionID) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"expandRegionsNode", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem[] items = this.collectorTree.getItems();
        TreeItem item = null;
        int i = 0;
        while (i < items.length) {
            if (connectionID.equals(items[i].getData())) {
                item = items[i];
            }
            ++i;
        }
        if (item != null) {
            TreeItem regionsItem = this.getRegionsTreeItem(item);
            item.setExpanded(true);
            regionsItem.setExpanded(true);
        }
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"expandRegionsNode");
    }

    public void expandUsersNode(String connectionID) {
        Debug.enter((Logger)logger, (String)IAOperationsView.class.getName(), (String)"expandUsersNode", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem[] items = this.collectorTree.getItems();
        TreeItem item = null;
        int i = 0;
        while (i < items.length) {
            if (connectionID.equals(items[i].getData())) {
                item = items[i];
            }
            ++i;
        }
        if (item != null) {
            TreeItem usersItem = this.getUsersTreeItem(item);
            item.setExpanded(true);
            usersItem.setExpanded(true);
        }
        Debug.exit((Logger)logger, (String)IAOperationsView.class.getName(), (String)"expandUsersNode");
    }
}

