/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.UIUtilities;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IntroPart;

public class IAIntroPart
extends IntroPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite c;

    public void createPartControl(final Composite parent) {
        this.c = new Composite(parent, 0);
        final Color backgroundColor = new Color((Device)parent.getDisplay(), 211, 230, 235);
        this.c.setBackground(backgroundColor);
        this.c.setLayout((Layout)new GridLayout(1, false));
        Label titleLabel = new Label(this.c, 64);
        titleLabel.setBackground(backgroundColor);
        titleLabel.setText(Messages.getString("Welcome.banner.text"));
        final Font titleFont = new Font((Device)parent.getDisplay(), "Verdana", 24, 1);
        GridData titleData = new GridData(0x1000000, 0, true, false);
        titleData.verticalIndent = 10;
        titleLabel.setLayoutData((Object)titleData);
        titleLabel.setFont(titleFont);
        Composite bottomComposite = new Composite(this.c, 0);
        bottomComposite.setBackground(backgroundColor);
        GridLayout bottomCompositeLayout = new GridLayout(2, false);
        bottomCompositeLayout.verticalSpacing = 40;
        bottomComposite.setLayout((Layout)bottomCompositeLayout);
        GridData bottomCompositeData = new GridData(0x1000000, 0x1000000, true, true);
        bottomComposite.setLayoutData((Object)bottomCompositeData);
        Label connectionLabel = new Label(bottomComposite, 0x100000);
        connectionLabel.setToolTipText(Messages.getString("Welcome.connection.tooltip"));
        connectionLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        connectionLabel.setBackground(backgroundColor);
        final Image welcomeOpenConnectionsImage = ImageFactory.getWelcomeOpenConnectionsImage();
        connectionLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(welcomeOpenConnectionsImage, 0, 0);
            }
        });
        connectionLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                UIUtilities.openConnectionPreferences();
            }
        });
        GridData connectionLabelData = new GridData(4, 4, false, false);
        connectionLabelData.widthHint = welcomeOpenConnectionsImage.getBounds().width;
        connectionLabelData.heightHint = welcomeOpenConnectionsImage.getBounds().height;
        connectionLabel.setLayoutData((Object)connectionLabelData);
        final Label connectionText = new Label(bottomComposite, 64);
        connectionText.setBackground(backgroundColor);
        final GridData textData = new GridData(16384, 0x1000000, false, false);
        textData.widthHint = 450;
        connectionText.setLayoutData((Object)textData);
        final Font labelFont = new Font((Device)parent.getDisplay(), "Verdana", 12, 0);
        connectionText.setFont(labelFont);
        connectionText.setText(Messages.getString("Welcome.connection.text"));
        Label explorerLabel = new Label(bottomComposite, 0x100000);
        explorerLabel.setToolTipText(Messages.getString("Welcome.startexplorer.tooltip"));
        explorerLabel.setBackground(backgroundColor);
        final Image welcomeLaunchExplorerImage = ImageFactory.getWelcomeLaunchExplorerImage();
        explorerLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(welcomeLaunchExplorerImage, 0, 0);
            }
        });
        explorerLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IWorkbenchPage welcomePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                welcomePage.getActivePart().dispose();
            }
        });
        explorerLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        GridData launchExplorerLabelData = new GridData(4, 4, false, false);
        launchExplorerLabelData.widthHint = welcomeLaunchExplorerImage.getBounds().width;
        launchExplorerLabelData.heightHint = welcomeLaunchExplorerImage.getBounds().height;
        explorerLabel.setLayoutData((Object)launchExplorerLabelData);
        final Label explorerText = new Label(bottomComposite, 64);
        explorerText.setFont(labelFont);
        explorerText.setLayoutData((Object)textData);
        explorerText.setBackground(backgroundColor);
        explorerText.setText(Messages.getString("Welcome.startexplorer.text"));
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int totalWidth = parent.getBounds().width;
                if (totalWidth < 600) {
                    textData.widthHint = totalWidth - 150;
                    connectionText.setLayoutData((Object)textData);
                    explorerText.setLayoutData((Object)textData);
                    parent.layout(new Control[]{connectionText, explorerText});
                } else {
                    textData.widthHint = 450;
                    explorerText.setLayoutData((Object)textData);
                    parent.layout(new Control[]{connectionText, explorerText});
                }
            }
        });
        this.c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                backgroundColor.dispose();
                titleFont.dispose();
                labelFont.dispose();
            }
        });
    }

    public void setFocus() {
        this.c.setFocus();
    }

    public void standbyStateChanged(boolean standby) {
    }
}

