/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.controller.Messages;
import com.ibm.cics.ia.query.Query;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.composites.HistoryBox;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.part.ViewPart;

public class FindResourceSearchBar
extends WorkbenchWindowControlContribution {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindResourceSearchBar.class.getPackage().getName());
    protected static final String TYPE = "TYPE";
    private Composite c;
    private SelectionAdapter runQuerySelectionListener;
    private String searchType;
    private FocusListener focusListener;
    private Action runAction;
    private ToolItem runButtonToolItem;
    private HistoryBox resourceHB;
    private HistoryBox regionHB;
    private IAction prevCopyAction;
    private IAction prevRunAction;

    protected Control createControl(Composite parent) {
        Debug.enter((Logger)logger, (String)FindResourceSearchBar.class.getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        parent.getParent().setRedraw(true);
        if (this.c != null && !this.c.isDisposed()) {
            this.c.dispose();
        }
        this.c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(8, false);
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.c.setLayout((Layout)gridLayout);
        Label l = new Label(this.c, 0);
        l.setText(Messages.getString("FindResourceContributionItem.txt.find"));
        GridData data = new GridData(0, 0x1000000, false, true);
        l.setLayoutData((Object)data);
        String longestItem = "";
        String[] types = this.getFilterTypes();
        int i = 0;
        while (i < types.length) {
            String renderedText = ResourceTypeRenderer.asText(types[i]);
            if (longestItem.length() < renderedText.length()) {
                longestItem = renderedText;
            }
            ++i;
        }
        Text testLabel = new Text(this.c, 0);
        testLabel.setText(longestItem);
        Point point = testLabel.computeSize(-1, -1);
        int maxWidth = point.x;
        testLabel.dispose();
        final Text resourceTypeLabel = new Text(this.c, 0x1000800);
        resourceTypeLabel.setEditable(false);
        resourceTypeLabel.setText(Messages.getString("FindResourceContributionItem.txt.resource"));
        data = new GridData();
        data.widthHint = maxWidth;
        resourceTypeLabel.setLayoutData((Object)data);
        final ToolBar toolBar = new ToolBar(this.c, 0x800000);
        data = new GridData(4, 4, true, true);
        toolBar.setLayoutData((Object)data);
        ToolItem typeToolItem = new ToolItem(toolBar, 0x800008);
        typeToolItem.setImage(ImageFactory.getDropDownArrowImage());
        typeToolItem.setToolTipText(Messages.getString("FindResourceContributionItem.txt.filterbytype"));
        SelectionAdapter typeSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem selectedMenuItem = (MenuItem)e.getSource();
                FindResourceSearchBar.this.setSearchType((String)selectedMenuItem.getData());
                resourceTypeLabel.setText(ResourceTypeRenderer.asText((String)selectedMenuItem.getData()));
                toolBar.getParent().layout(true);
            }
        };
        final Menu menu = new Menu((Decorations)this.c.getShell(), 8);
        int i2 = 0;
        while (i2 < types.length) {
            if (i2 == 3 || i2 == 7 || i2 == 11 || i2 == 12) {
                MenuItem menuItem = new MenuItem(menu, 2);
            }
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setData((Object)types[i2]);
            menuItem.setText(ResourceTypeRenderer.asText(types[i2]));
            Image image = this.getTypeImage(types[i2]);
            menuItem.setImage(image);
            menuItem.addSelectionListener((SelectionListener)typeSelectionListener);
            ++i2;
        }
        typeToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = resourceTypeLabel.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = FindResourceSearchBar.this.c.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    try {
                        String toolTip;
                        ToolItem item = toolBar.getItem(e.childID);
                        if (item != null && (toolTip = item.getToolTipText()) != null) {
                            e.result = FindResourceSearchBar.this.searchType == null ? MessageFormat.format(Messages.getString("FindResourceSearchBar.currentSelectionResource"), toolTip) : MessageFormat.format(Messages.getString("FindResourceSearchBar.currentSelectionIs"), toolTip, FindResourceSearchBar.this.searchType);
                        }
                    }
                    catch (IllegalArgumentException ee) {
                        IAPlugin.getDefault().logError("Unable to get toolbar item", (Throwable)ee);
                    }
                }
            }
        });
        Label l2 = new Label(this.c, 0);
        l2.setText(Messages.getString("FindResourceContributionItem.txt.withid"));
        data = new GridData(0, 0x1000000, false, true);
        l2.setLayoutData((Object)data);
        this.resourceHB = new HistoryBox(this.c, 128);
        data = new GridData(4, 0x1000000, false, true);
        data.widthHint = 80;
        this.resourceHB.setLayoutData(data);
        this.resourceHB.setToolTipText(Messages.getString("FindResourceContributionItem.tooltiptxt.usewildcardname"));
        this.resourceHB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                AccessibleEvent i = e;
                i.toString();
                e.result = Messages.getString("FindResourceContributionItem.txt.withid");
            }
        });
        l = new Label(this.c, 0);
        l.setText(Messages.getString("FindResourceContributionItem.txt.inregion"));
        data = new GridData(0, 0x1000000, false, true);
        l.setLayoutData((Object)data);
        this.regionHB = new HistoryBox(this.c, 128);
        data = new GridData(4, 0x1000000, false, true);
        data.widthHint = 80;
        this.regionHB.setLayoutData(data);
        this.regionHB.setToolTipText(Messages.getString("FindResourceContributionItem.txt.usewildcardregion"));
        this.regionHB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                AccessibleEvent i = e;
                i.toString();
                e.result = Messages.getString("FindResourceContributionItem.txt.inregion");
            }
        });
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                FindResourceSearchBar.this.receiveFocus(true);
            }

            public void focusLost(FocusEvent e) {
                FindResourceSearchBar.this.receiveFocus(false);
            }
        };
        final ToolBar runButtonToolBar = new ToolBar(this.c, 0x800000);
        this.runButtonToolItem = new ToolItem(runButtonToolBar, 8);
        this.runButtonToolItem.setImage(ImageFactory.getRunImage());
        this.runButtonToolItem.setToolTipText(Messages.getString("FindResourceContributionItem.tooltiptxt.runsearch"));
        runButtonToolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    try {
                        String toolTip;
                        ToolItem item = runButtonToolBar.getItem(e.childID);
                        if (item != null && (toolTip = item.getToolTipText()) != null) {
                            e.result = toolTip;
                        }
                    }
                    catch (IllegalArgumentException ee) {
                        IAPlugin.getDefault().logError("Unable to get toolbar item", (Throwable)ee);
                    }
                }
            }
        });
        this.runQuerySelectionListener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.processSelection(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == FindResourceSearchBar.this.runButtonToolItem) {
                    this.processSelection(e);
                }
            }

            private void processSelection(SelectionEvent e) {
                Widget selectedItem = (Widget)e.getSource();
                if (selectedItem instanceof MenuItem) {
                    String typeToSearch = FindResourceSearchBar.this.searchType;
                    if (typeToSearch != null) {
                        FindResourceSearchBar.this.runQuery(typeToSearch);
                    }
                } else if (selectedItem instanceof Text) {
                    FindResourceSearchBar.this.runQuery(FindResourceSearchBar.this.searchType);
                } else if (selectedItem instanceof ToolItem && e.detail != 4) {
                    FindResourceSearchBar.this.runQuery(FindResourceSearchBar.this.searchType);
                }
            }
        };
        this.resourceHB.addFocusListener(this.focusListener);
        this.regionHB.addFocusListener(this.focusListener);
        this.runButtonToolItem.addSelectionListener((SelectionListener)this.runQuerySelectionListener);
        this.resourceHB.addSelectionListener((SelectionListener)this.runQuerySelectionListener);
        this.regionHB.addSelectionListener((SelectionListener)this.runQuerySelectionListener);
        this.createActions();
        Debug.exit((Logger)logger, (String)FindResourceSearchBar.class.getName(), (String)"createControl");
        return this.c;
    }

    private Image getTypeImage(String string) {
        if (string == null) {
            return ImageFactory.getResourceImage();
        }
        if ("FILE".equals(string)) {
            return ImageFactory.getFileImage();
        }
        if ("MAP".equals(string)) {
            return ImageFactory.getMapImage();
        }
        if ("PROGRAM".equals(string)) {
            return ImageFactory.getProgramImage();
        }
        if ("TRANSID".equals(string)) {
            return ImageFactory.getTransactionImage();
        }
        if ("WEBSERVICE".equals(string)) {
            return ImageFactory.getWebserviceImage();
        }
        if ("SERVICE".equals(string)) {
            return ImageFactory.getWebserviceImage();
        }
        if ("TSQUEUE".equals(string)) {
            return ImageFactory.getTSQImage();
        }
        if ("TDQUEUE".equals(string)) {
            return ImageFactory.getTDQImage();
        }
        if ("TABLE".equals(string)) {
            return ImageFactory.getDatabaseTableImage();
        }
        if ("VIEW".equals(string)) {
            return ImageFactory.getDatabaseViewImage();
        }
        if ("CURSOR".equals(string)) {
            return ImageFactory.getDatabaseCursorImage();
        }
        if ("STATEMENT".equals(string)) {
            return ImageFactory.getDatabaseDomainImage();
        }
        if ("QUEUE".equals(string)) {
            return ImageFactory.getQueueImage();
        }
        return ImageFactory.getResourceImage();
    }

    private void receiveFocus(boolean enable) {
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
        if (activePart instanceof ViewPart) {
            ViewPart new_name = (ViewPart)activePart;
            IActionBars actionBars = new_name.getViewSite().getActionBars();
            if (enable) {
                this.prevCopyAction = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
                actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
                this.prevRunAction = actionBars.getGlobalActionHandler("com.ibm.cics.ia.action.run");
                actionBars.setGlobalActionHandler("com.ibm.cics.ia.action.run", (IAction)this.getRunAction());
            } else {
                actionBars.setGlobalActionHandler("com.ibm.cics.ia.action.run", this.prevRunAction);
                actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.prevCopyAction);
            }
            actionBars.updateActionBars();
        }
    }

    private String[] getFilterTypes() {
        String[] stringArray = new String[16];
        stringArray[1] = "PROGRAM";
        stringArray[2] = "TRANSID";
        stringArray[3] = "FILE";
        stringArray[4] = "MAP";
        stringArray[5] = "TSQUEUE";
        stringArray[6] = "TDQUEUE";
        stringArray[7] = "CURSOR";
        stringArray[8] = "TABLE";
        stringArray[9] = "VIEW";
        stringArray[10] = "STATEMENT";
        stringArray[11] = "WEBSERVICE";
        stringArray[12] = "SERVICE";
        stringArray[13] = "QUEUE";
        stringArray[14] = "PCB";
        stringArray[15] = "PSB";
        return stringArray;
    }

    private void runQuery(String type) {
        Presentation presentation;
        String table;
        Debug.enter((Logger)logger, (String)FindResourceSearchBar.class.getName(), (String)"runQuery", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String resourceTableType = this.getResourceTableType();
        String likeField = "OBJECT";
        if (resourceTableType.equals("CICS")) {
            table = IAUtilities.getCICSDataTableName();
            presentation = Query.createPresentation((String)this.getCommandDescription(), (String)table, (String[])new String[]{TYPE, "OBJECT"});
            if (type.equals("TSQUEUE")) {
                presentation.getSelection().appendCondition(TYPE, table, ColumnReference.DataType.String, Comparator.IN, new Object[]{type, "TSQUEUE AUX", "TSQUEUE SHARED"}, QueryElement.Predicate.AND, false);
            } else {
                presentation.getSelection().appendCondition(TYPE, table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{type}, QueryElement.Predicate.AND, false);
            }
        } else if (resourceTableType.equals("MQ")) {
            table = IAUtilities.getMQDataTableName();
            presentation = Query.createPresentation((String)this.getCommandDescription(), (String)table, (String[])new String[]{TYPE, "OBJECT"});
            presentation.getSelection().appendCondition(TYPE, table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{type}, QueryElement.Predicate.AND, false);
        } else if (resourceTableType.equals("DB2")) {
            likeField = "RESNAME";
            table = IAUtilities.getDB2DataTableName();
            presentation = Query.createPresentation((String)this.getCommandDescription(), (String)table, (String[])new String[]{"RESTYPE", "RESNAME"});
            presentation.getSelection().appendCondition("RESTYPE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{type}, QueryElement.Predicate.AND, false);
        } else if (resourceTableType.equals("IMS")) {
            table = IAUtilities.getIMSDataTableName();
            presentation = Query.createPresentation((String)this.getCommandDescription(), (String)table, (String[])new String[]{TYPE, "OBJECT"});
            presentation.getSelection().appendCondition(TYPE, table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{type}, QueryElement.Predicate.AND, false);
        } else if (resourceTableType.equals("PROGRAM")) {
            table = IAUtilities.getResourcesTableName();
            presentation = Query.createPresentation((String)this.getCommandDescription(), (String)table, (String[])new String[]{TYPE, "OBJECT"});
            presentation.getSelection().appendCondition(TYPE, table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{type}, QueryElement.Predicate.AND, false);
            presentation.getSelection().addGroupByCondition("OBJECT", table);
        } else if (resourceTableType.equals("TRANSID") || resourceTableType.equals("WEBSERVICE") || resourceTableType.equals("WEBSERVICE") || resourceTableType.equals("SERVICE")) {
            table = IAUtilities.getResourcesTableName();
            presentation = Query.createPresentation((String)this.getCommandDescription(), (String)table, (String[])new String[]{TYPE, "OBJECT"});
            presentation.getSelection().appendCondition(TYPE, table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{type}, QueryElement.Predicate.AND, false);
        } else {
            table = IAUtilities.getResourcesTableName();
            presentation = Query.createPresentation((String)this.getCommandDescription(), (String)table, (String[])new String[]{TYPE, "OBJECT"});
        }
        if (IAUtilities.hasContent((String)this.resourceHB.getText(true))) {
            presentation.getSelection().appendCondition(likeField, table, ColumnReference.DataType.String, IAUtilities.isExactName((String)this.resourceHB.getText(true)) ? Comparator.EQ : Comparator.LI, new Object[]{this.resourceHB.getText(true)}, QueryElement.Predicate.AND, false);
        }
        if (IAUtilities.hasContent((String)this.regionHB.getText(true))) {
            presentation.getSelection().appendCondition("APPLID", table, ColumnReference.DataType.String, IAUtilities.isExactName((String)this.regionHB.getText(true)) ? Comparator.EQ : Comparator.LI, new Object[]{this.regionHB.getText(true)}, QueryElement.Predicate.AND, false);
        }
        QueryCommand command = new QueryCommand(presentation);
        command.setSaveable(false);
        DisplayableData displayableData = (DisplayableData)command.getAdapter(DisplayableData.class);
        displayableData.setDescription(this.getCommandDescription());
        displayableData.setImage(ImageFactory.getSearchImage());
        command.setDescription(this.getCommandDescription());
        Activator.executeSearch((Command)command);
        Debug.exit((Logger)logger, (String)FindResourceSearchBar.class.getName(), (String)"runQuery");
    }

    private String getResourceTableType() {
        if (this.searchType != null) {
            if (this.searchType.equals("FILE") || this.searchType.equals("MAP") || this.searchType.equals("TDQUEUE") || this.searchType.equals("TSQUEUE")) {
                return "CICS";
            }
            if (this.searchType.equals("QUEUE")) {
                return "MQ";
            }
            if (this.searchType.equals("STATEMENT") || this.searchType.equals("TABLE") || this.searchType.equals("CURSOR") || this.searchType.equals("VIEW")) {
                return "DB2";
            }
            if (this.searchType.equals("PCB") || this.searchType.equals("PSB")) {
                return "IMS";
            }
            return this.searchType;
        }
        return Messages.getString("FindResourceSearchBar.resource");
    }

    private String getCommandDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.getString("FindResourceSearchBar.find"));
        if (this.searchType != null) {
            buffer.append(ResourceTypeRenderer.asText(this.searchType));
        }
        if (IAUtilities.hasContent((String)this.resourceHB.getText(true))) {
            buffer.append(' ');
            buffer.append(this.resourceHB.getText(true));
        }
        if (IAUtilities.hasContent((String)this.regionHB.getText(true))) {
            buffer.append(MessageFormat.format("", this.regionHB.getText(true)));
        }
        return buffer.toString();
    }

    private void createActions() {
        this.runAction = new Action(){

            public void run() {
                FindResourceSearchBar.this.runQuery(FindResourceSearchBar.this.searchType);
            }
        };
    }

    public Action getRunAction() {
        return this.runAction;
    }

    protected void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public boolean isDynamic() {
        return true;
    }
}

