/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.bundle.ui.BundleUIMessages;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.SimpleValidationHelper;
import com.ibm.cics.ia.model.CicsBundleResource;
import com.ibm.cics.ia.model.EntryPoint;
import com.ibm.cics.ia.model.EntryPointTreeItem;
import com.ibm.cics.ia.model.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class EntryPointsTreeUtilities {
    private static final Logger logger = Logger.getLogger(EntryPointsTreeUtilities.class.getPackage().getName());

    public static boolean containsInvalidCharsInOper(EntryPointTreeItem entryPoint) {
        Debug.enter((Logger)logger, (String)EntryPointsTreeUtilities.class.getName(), (String)"containsInvalidCharsInOper", (Object)("Thread ID: " + Thread.currentThread().getId()));
        try {
            if (entryPoint.getOperation().isEmpty()) {
                throw new IllegalArgumentException(Messages.getString((String)"ApplicationCreationModel.error.operationEmpty"));
            }
            int operation_max_length = 64;
            String regularExpression = "[a-zA-Z0-9._#@-]+";
            SimpleValidationHelper.validateMaxLength((String)entryPoint.getOperation(), (int)operation_max_length, (String)BundleUIMessages.EntryPointDialog_operationLabel);
            SimpleValidationHelper.validateWhiteSpace((String)entryPoint.getOperation(), (String)"a-z, A-Z, 0-9, ._#@-", (String)BundleUIMessages.EntryPointDialog_operationLabel);
            SimpleValidationHelper.validateCharacters((String)entryPoint.getOperation(), (String)regularExpression, (String)"a-z, A-Z, 0-9, ._#@-", (String)BundleUIMessages.EntryPointDialog_operationLabel);
        }
        catch (IllegalArgumentException e) {
            entryPoint.setError(e.getMessage());
            Debug.exit((Logger)logger, (String)EntryPointsTreeUtilities.class.getName(), (String)"containsInvalidCharsInOper");
            return true;
        }
        Debug.exit((Logger)logger, (String)EntryPointsTreeUtilities.class.getName(), (String)"containsInvalidCharsInOper");
        return false;
    }

    public static List<EntryPointTreeItem> prepareTreeInput(Object input, String string) {
        if (((List)input).size() == 0) {
            return new ArrayList<EntryPointTreeItem>();
        }
        if (string.equals(TreeTypes.ByRegion.toString())) {
            return EntryPointsTreeUtilities.prepareTreeInputByRegion(input);
        }
        if (string.equals(TreeTypes.ByApp.toString())) {
            return EntryPointsTreeUtilities.prepareTreeInputByApp(input);
        }
        if (string.equals(TreeTypes.ByAppWithDep.toString())) {
            return EntryPointsTreeUtilities.prepareTreeInputByAppWithDep(input);
        }
        return null;
    }

    private static List<EntryPointTreeItem> prepareTreeInputByAppWithDep(Object input) {
        int i;
        int size;
        Debug.enter((Logger)logger, (String)EntryPointsTreeUtilities.class.getName(), (String)"prepareTreeInputByAppWithDep", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        ArrayList<EntryPointTreeItem> inputTreeList = new ArrayList<EntryPointTreeItem>();
        ArrayList<EntryPoint> inputList = new ArrayList<EntryPoint>();
        if (((List)input).get(0) instanceof EntryPoint) {
            size = ((List)input).size();
            i = 0;
            while (i < size) {
                EntryPoint entryPoint = (EntryPoint)((List)input).get(i);
                inputList.add(entryPoint);
                ++i;
            }
        } else {
            size = ((List)input).size();
            i = 0;
            while (i < size) {
                CicsBundleResource res = (CicsBundleResource)((List)input).get(i);
                EntryPoint entryPoint = new EntryPoint(res.getName(), res.getApplOperation(), res.getUserFriendlyType(), res.getAdditionalAttributes());
                entryPoint.setIsDep(true);
                entryPoint.setDep(res);
                if (entryPoint.getOperation() == null) {
                    entryPoint.setOperation("");
                }
                inputList.add(entryPoint);
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < inputList.size()) {
            EntryPoint entry = new EntryPoint((EntryPoint)inputList.get(i2));
            entry.setError(((EntryPoint)inputList.get(i2)).getError());
            EntryPointTreeItem entryPointTreeItem = new EntryPointTreeItem(entry);
            if (inputTreeList.isEmpty()) {
                EntryPointTreeItem newCollectionParent = EntryPointsTreeUtilities.createCollectionParent(entry);
                EntryPointTreeItem newPlatformParent = EntryPointsTreeUtilities.createPlatformParent(entry);
                EntryPointTreeItem newApplicationParent = EntryPointsTreeUtilities.createApplicationParent(entry);
                EntryPointTreeItem newOperationParent = EntryPointsTreeUtilities.createOperationParent(entry, entryPointTreeItem, newApplicationParent);
                newApplicationParent.setParent(newPlatformParent);
                newPlatformParent.addChidren(newApplicationParent);
                newPlatformParent.setParent(newCollectionParent);
                newCollectionParent.addChidren(newPlatformParent);
                inputTreeList.add(newCollectionParent);
            } else {
                boolean hasCollection = false;
                int j = 0;
                while (j < inputTreeList.size()) {
                    EntryPointTreeItem item = (EntryPointTreeItem)inputTreeList.get(j);
                    if (item.getCollectionID().equals(entry.getCollectionId())) {
                        EntryPointTreeItem newApplicationParent;
                        EntryPointTreeItem newOperationParent;
                        hasCollection = true;
                        EntryPointTreeItem platformParent = null;
                        for (EntryPointTreeItem child : item.getChildren()) {
                            if (!child.getPlatform().equals(entry.getPlatform())) continue;
                            platformParent = new EntryPointTreeItem(child);
                            break;
                        }
                        if (platformParent != null) {
                            EntryPointTreeItem appParent = null;
                            for (EntryPointTreeItem child : platformParent.getChildren()) {
                                if (!child.getApplication().equals(entry.getFullApplName())) continue;
                                appParent = new EntryPointTreeItem(child);
                                break;
                            }
                            if (appParent != null) {
                                EntryPointTreeItem operationParent = null;
                                for (EntryPointTreeItem child : appParent.getChildren()) {
                                    if (!child.getOperation().equals(entry.getOperation())) continue;
                                    operationParent = new EntryPointTreeItem(child);
                                    break;
                                }
                                if (operationParent != null) {
                                    operationParent.addChidren(entryPointTreeItem);
                                    entryPointTreeItem.setParent(operationParent);
                                    break;
                                }
                                newOperationParent = EntryPointsTreeUtilities.createOperationParent(entry, entryPointTreeItem, appParent);
                                break;
                            }
                            newApplicationParent = EntryPointsTreeUtilities.createApplicationParent(entry);
                            newOperationParent = EntryPointsTreeUtilities.createOperationParent(entry, entryPointTreeItem, newApplicationParent);
                            newApplicationParent.addChidren(newOperationParent);
                            newApplicationParent.setParent(platformParent);
                            platformParent.addChidren(newApplicationParent);
                            break;
                        }
                        EntryPointTreeItem newPlatformParent = EntryPointsTreeUtilities.createPlatformParent(entry);
                        newApplicationParent = EntryPointsTreeUtilities.createApplicationParent(entry);
                        newOperationParent = EntryPointsTreeUtilities.createOperationParent(entry, entryPointTreeItem, newApplicationParent);
                        newApplicationParent.addChidren(newOperationParent);
                        newApplicationParent.setParent(newPlatformParent);
                        newPlatformParent.addChidren(newApplicationParent);
                        newPlatformParent.setParent(item);
                        item.addChidren(newPlatformParent);
                        break;
                    }
                    ++j;
                }
                if (!hasCollection) {
                    EntryPointTreeItem newCollectionParent = EntryPointsTreeUtilities.createCollectionParent(entry);
                    EntryPointTreeItem newPlatformParent = EntryPointsTreeUtilities.createPlatformParent(entry);
                    EntryPointTreeItem newApplicationParent = EntryPointsTreeUtilities.createApplicationParent(entry);
                    EntryPointTreeItem newOperationParent = EntryPointsTreeUtilities.createOperationParent(entry, entryPointTreeItem, newApplicationParent);
                    newApplicationParent.setParent(newPlatformParent);
                    newPlatformParent.addChidren(newApplicationParent);
                    newPlatformParent.setParent(newCollectionParent);
                    newCollectionParent.addChidren(newPlatformParent);
                    inputTreeList.add(newCollectionParent);
                }
            }
            ++i2;
        }
        Debug.exit((Logger)logger, (String)EntryPointsTreeUtilities.class.getName(), (String)"prepareTreeInputByAppWithDep");
        return inputTreeList;
    }

    private static List<EntryPointTreeItem> prepareTreeInputByApp(Object input) {
        int i;
        int size;
        Debug.enter((Logger)logger, (String)EntryPointsTreeUtilities.class.getName(), (String)"prepareTreeInputByApp", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        ArrayList<EntryPointTreeItem> inputTreeList = new ArrayList<EntryPointTreeItem>();
        ArrayList<EntryPoint> inputList = new ArrayList<EntryPoint>();
        if (((List)input).get(0) instanceof EntryPoint) {
            size = ((List)input).size();
            i = 0;
            while (i < size) {
                EntryPoint entryPoint = (EntryPoint)((List)input).get(i);
                inputList.add(entryPoint);
                ++i;
            }
        } else {
            size = ((List)input).size();
            i = 0;
            while (i < size) {
                CicsBundleResource res = (CicsBundleResource)((List)input).get(i);
                EntryPoint entryPoint = new EntryPoint(res.getName(), res.getApplOperation(), res.getBundlePartType(), res.getAdditionalAttributes());
                entryPoint.setIsDep(true);
                entryPoint.setDep(res);
                if (entryPoint.getOperation() == null) {
                    entryPoint.setOperation("");
                }
                entryPoint.setEnabled(true);
                inputList.add(entryPoint);
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < inputList.size()) {
            EntryPoint entry = new EntryPoint((EntryPoint)inputList.get(i2));
            entry.setError(((EntryPoint)inputList.get(i2)).getError());
            EntryPointTreeItem entryPointTreeItem = new EntryPointTreeItem(entry);
            if (inputTreeList.isEmpty()) {
                EntryPointTreeItem newCollectionParent = EntryPointsTreeUtilities.createCollectionParent(entry);
                EntryPointTreeItem newPlatformParent = EntryPointsTreeUtilities.createPlatformParent(entry);
                EntryPointTreeItem newApplicationParent = EntryPointsTreeUtilities.createApplicationParent(entry);
                EntryPointTreeItem newOperationParent = EntryPointsTreeUtilities.createOperationParent(entry, entryPointTreeItem, newApplicationParent);
                newApplicationParent.setParent(newPlatformParent);
                newPlatformParent.addChidren(newApplicationParent);
                newPlatformParent.setParent(newCollectionParent);
                newCollectionParent.addChidren(newPlatformParent);
                inputTreeList.add(newCollectionParent);
            } else {
                boolean hasCollection = false;
                int j = 0;
                while (j < inputTreeList.size()) {
                    EntryPointTreeItem item = (EntryPointTreeItem)inputTreeList.get(j);
                    if (item.getCollectionID().equals(entry.getCollectionId())) {
                        EntryPointTreeItem newApplicationParent;
                        EntryPointTreeItem newOperationParent;
                        hasCollection = true;
                        EntryPointTreeItem platformParent = null;
                        for (EntryPointTreeItem child : item.getChildren()) {
                            if (!child.getPlatform().equals(entry.getPlatform())) continue;
                            platformParent = new EntryPointTreeItem(child);
                            break;
                        }
                        if (platformParent != null) {
                            EntryPointTreeItem appParent = null;
                            for (EntryPointTreeItem child : platformParent.getChildren()) {
                                if (!child.getApplication().equals(entry.getFullApplName())) continue;
                                appParent = new EntryPointTreeItem(child);
                                break;
                            }
                            if (appParent != null) {
                                EntryPointTreeItem operationParent = null;
                                for (EntryPointTreeItem child : appParent.getChildren()) {
                                    if (!child.getOperation().equals(entry.getOperation())) continue;
                                    operationParent = new EntryPointTreeItem(child);
                                    break;
                                }
                                if (operationParent != null) {
                                    operationParent.addChidren(entryPointTreeItem);
                                    entryPointTreeItem.setParent(operationParent);
                                    break;
                                }
                                newOperationParent = EntryPointsTreeUtilities.createOperationParent(entry, entryPointTreeItem, appParent);
                                break;
                            }
                            newApplicationParent = EntryPointsTreeUtilities.createApplicationParent(entry);
                            newOperationParent = EntryPointsTreeUtilities.createOperationParent(entry, entryPointTreeItem, newApplicationParent);
                            newApplicationParent.addChidren(newOperationParent);
                            newApplicationParent.setParent(platformParent);
                            platformParent.addChidren(newApplicationParent);
                            break;
                        }
                        EntryPointTreeItem newPlatformParent = EntryPointsTreeUtilities.createPlatformParent(entry);
                        newApplicationParent = EntryPointsTreeUtilities.createApplicationParent(entry);
                        newOperationParent = EntryPointsTreeUtilities.createOperationParent(entry, entryPointTreeItem, newApplicationParent);
                        newApplicationParent.addChidren(newOperationParent);
                        newApplicationParent.setParent(newPlatformParent);
                        newPlatformParent.addChidren(newApplicationParent);
                        newPlatformParent.setParent(item);
                        item.addChidren(newPlatformParent);
                        break;
                    }
                    ++j;
                }
                if (!hasCollection) {
                    EntryPointTreeItem newCollectionParent = EntryPointsTreeUtilities.createCollectionParent(entry);
                    EntryPointTreeItem newPlatformParent = EntryPointsTreeUtilities.createPlatformParent(entry);
                    EntryPointTreeItem newApplicationParent = EntryPointsTreeUtilities.createApplicationParent(entry);
                    EntryPointTreeItem newOperationParent = EntryPointsTreeUtilities.createOperationParent(entry, entryPointTreeItem, newApplicationParent);
                    newApplicationParent.setParent(newPlatformParent);
                    newPlatformParent.addChidren(newApplicationParent);
                    newPlatformParent.setParent(newCollectionParent);
                    newCollectionParent.addChidren(newPlatformParent);
                    inputTreeList.add(newCollectionParent);
                }
            }
            ++i2;
        }
        Debug.exit((Logger)logger, (String)EntryPointsTreeUtilities.class.getName(), (String)"prepareTreeInputByApp");
        return inputTreeList;
    }

    private static List<EntryPointTreeItem> prepareTreeInputByRegion(Object input) {
        int i;
        int size;
        Debug.enter((Logger)logger, (String)EntryPointsTreeUtilities.class.getName(), (String)"prepareTreeInputByRegion", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        ArrayList<EntryPoint> inputList = new ArrayList<EntryPoint>();
        if (((List)input).get(0) instanceof EntryPoint) {
            size = ((List)input).size();
            i = 0;
            while (i < size) {
                EntryPoint entryPoint = (EntryPoint)((List)input).get(i);
                inputList.add(entryPoint);
                ++i;
            }
        } else {
            size = ((List)input).size();
            i = 0;
            while (i < size) {
                CicsBundleResource res = (CicsBundleResource)((List)input).get(i);
                EntryPoint entryPoint = new EntryPoint(res.getName(), res.getApplOperation(), res.getBundlePartType(), res.getAdditionalAttributes());
                entryPoint.setEnabled(true);
                entryPoint.setIsDep(true);
                entryPoint.setDep(res);
                if (entryPoint.getOperation() == null) {
                    entryPoint.setOperation("");
                }
                inputList.add(entryPoint);
                ++i;
            }
        }
        ArrayList<EntryPointTreeItem> inputTreeList = new ArrayList<EntryPointTreeItem>();
        i = 0;
        while (i < inputList.size()) {
            EntryPoint entry = new EntryPoint((EntryPoint)inputList.get(i));
            entry.setError(((EntryPoint)inputList.get(i)).getError());
            EntryPointTreeItem entryPointTreeItem = new EntryPointTreeItem(entry);
            if (!inputTreeList.isEmpty()) {
                EntryPointTreeItem newRegionParent;
                int collectionParentIndex = -1;
                int j = 0;
                block3: while (j < inputTreeList.size()) {
                    EntryPointTreeItem item = (EntryPointTreeItem)inputTreeList.get(j);
                    if (item.getCollectionID().equals(entryPointTreeItem.getCollectionID())) {
                        collectionParentIndex = j;
                        int k = 0;
                        while (k < item.getChildren().size()) {
                            EntryPointTreeItem regionParent = (EntryPointTreeItem)item.getChildren().get(k);
                            if (regionParent.getRegion().equals(entryPointTreeItem.getRegion())) {
                                entryPointTreeItem.setParent(regionParent);
                                regionParent.addChidren(entryPointTreeItem);
                                break block3;
                            }
                            ++k;
                        }
                        break;
                    }
                    ++j;
                }
                if (collectionParentIndex > -1) {
                    EntryPointTreeItem item = (EntryPointTreeItem)inputTreeList.get(collectionParentIndex);
                    newRegionParent = EntryPointsTreeUtilities.createRegionParent(entry, entryPointTreeItem, item);
                    entryPointTreeItem.setParent(newRegionParent);
                    collectionParentIndex = -1;
                } else {
                    EntryPointTreeItem newCollectionParent = EntryPointsTreeUtilities.createCollectionParent(entry);
                    newRegionParent = EntryPointsTreeUtilities.createRegionParent(entry, entryPointTreeItem, newCollectionParent);
                    newCollectionParent.addChidren(newRegionParent);
                    inputTreeList.add(newCollectionParent);
                }
            } else {
                EntryPointTreeItem newCollectionParent = EntryPointsTreeUtilities.createCollectionParent(entry);
                EntryPointTreeItem newRegionParent = EntryPointsTreeUtilities.createRegionParent(entry, entryPointTreeItem, newCollectionParent);
                newCollectionParent.addChidren(newRegionParent);
                inputTreeList.add(newCollectionParent);
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)EntryPointsTreeUtilities.class.getName(), (String)"prepareTreeInput");
        return inputTreeList;
    }

    private static EntryPointTreeItem createCollectionParent(EntryPoint entry) {
        EntryPointTreeItem newCollectionParent = new EntryPointTreeItem(entry);
        newCollectionParent.setApplication("");
        newCollectionParent.setApplOperation("");
        newCollectionParent.setName("");
        newCollectionParent.setOperation("");
        newCollectionParent.setPlatform("");
        newCollectionParent.setType("");
        newCollectionParent.setRegion("");
        newCollectionParent.setEntryPoint(null);
        return newCollectionParent;
    }

    private static EntryPointTreeItem createRegionParent(EntryPoint entry, EntryPointTreeItem entryPointTreeItem, EntryPointTreeItem newCollectionParent) {
        EntryPointTreeItem newRegionParent = new EntryPointTreeItem(entry);
        newRegionParent.setCollectionID("");
        newRegionParent.setApplication("");
        newRegionParent.setApplOperation("");
        newRegionParent.setName("");
        newRegionParent.setOperation("");
        newRegionParent.setPlatform("");
        newRegionParent.setType("");
        newRegionParent.setParent(newCollectionParent);
        newRegionParent.addChidren(entryPointTreeItem);
        newRegionParent.setEntryPoint(null);
        entryPointTreeItem.setParent(newRegionParent);
        return newRegionParent;
    }

    private static EntryPointTreeItem createOperationParent(EntryPoint entry, EntryPointTreeItem entryPointTreeItem, EntryPointTreeItem newApplicationParent) {
        EntryPointTreeItem newOperationParent = new EntryPointTreeItem(entry);
        newOperationParent.setCollectionID("");
        newOperationParent.setApplication("");
        newOperationParent.setApplOperation("");
        newOperationParent.setType("");
        newOperationParent.setRegion("");
        newOperationParent.setName("");
        newOperationParent.setEntryPoint(null);
        newOperationParent.setPlatform("");
        newOperationParent.addChidren(entryPointTreeItem);
        entryPointTreeItem.setParent(newOperationParent);
        newOperationParent.setParent(newApplicationParent);
        newApplicationParent.addChidren(newOperationParent);
        return newOperationParent;
    }

    private static EntryPointTreeItem createApplicationParent(EntryPoint entry) {
        EntryPointTreeItem newApplicationParent = new EntryPointTreeItem(entry);
        newApplicationParent.setCollectionID("");
        newApplicationParent.setApplOperation("");
        newApplicationParent.setName("");
        newApplicationParent.setOperation("");
        newApplicationParent.setType("");
        newApplicationParent.setRegion("");
        newApplicationParent.setEntryPoint(null);
        newApplicationParent.setPlatform("");
        return newApplicationParent;
    }

    private static EntryPointTreeItem createPlatformParent(EntryPoint entry) {
        EntryPointTreeItem newPlatformParent = new EntryPointTreeItem(entry);
        newPlatformParent.setApplication("");
        newPlatformParent.setApplOperation("");
        newPlatformParent.setName("");
        newPlatformParent.setOperation("");
        newPlatformParent.setType("");
        newPlatformParent.setRegion("");
        newPlatformParent.setEntryPoint(null);
        newPlatformParent.setCollectionID("");
        return newPlatformParent;
    }

    static enum TreeTypes {
        ByRegion("Tree by region"),
        ByApp("Tree by apllication"),
        ByAppWithDep("Tree by application with dependencies");

        private final String userFriendlyName;

        private TreeTypes(String userFriendlyName) {
            this.userFriendlyName = userFriendlyName;
        }

        public String toString() {
            return this.userFriendlyName;
        }
    }
}

