/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.ui.DetailsSheet;
import com.ibm.cics.ia.ui.DetailsView;
import java.util.TreeMap;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.graphics.Color;

public abstract class DetailsPresenter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public abstract void handleViewClosing();

    public abstract String getViewTitle();

    public abstract Color getHighlightColor();

    public abstract void handleViewCreation();

    public abstract void setView(DetailsView var1);

    public Version getCurrentVersion() {
        return Version.getInstance();
    }

    protected static ResourceFilter[] createFilters(DetailsSheet sheet, String groupBy) {
        TreeMap<String, ResourceFilter> rootFilters = new TreeMap<String, ResourceFilter>();
        int i = 0;
        while (i < sheet.getRowValues().size()) {
            if (sheet.getRowValues().get(i)[0].equals(groupBy)) {
                int j = 1;
                while (j < sheet.getRowValues().get(i).length) {
                    ResourceFilter rootFilter;
                    String parentDescription = String.valueOf(sheet.getRowValues().get(i)[0]) + " " + sheet.getRowValues().get(i)[j];
                    if (!rootFilters.containsKey(parentDescription)) {
                        rootFilter = new ResourceFilter();
                        rootFilter.setName(sheet.getRowValues().get(i)[j]);
                        rootFilter.setDescription(parentDescription);
                        rootFilter.setParent(null);
                        rootFilters.put(parentDescription, rootFilter);
                    }
                    rootFilter = (ResourceFilter)rootFilters.get(parentDescription);
                    ResourceFilter childFilter = new ResourceFilter();
                    childFilter.setName(sheet.getColumnIds().get(j));
                    childFilter.setDescription(sheet.getHeaders().get(j));
                    childFilter.setParent(rootFilter);
                    rootFilter.getChildren().add(childFilter);
                    ++j;
                }
            }
            ++i;
        }
        for (ResourceFilter filter : rootFilters.values()) {
            filter.sortSubtreeByDescription();
        }
        return rootFilters.values().toArray(new ResourceFilter[rootFilters.size()]);
    }

    protected static void addFiltersListener(final DetailsView.DetailsPage page) {
        if (page.getFilter() != null) {
            page.getFilter().addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ResourceFilter filter = (ResourceFilter)event.getElement();
                    filter.setCheckedSubtree(event.getChecked());
                    page.showFilteredColumns();
                }
            });
        }
    }

    public abstract String getViewContextHelpId();
}

