/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.ui.CreateThreadsafeReportPresenter;
import com.ibm.cics.ia.ui.ExplorerQueryContext;
import com.ibm.cics.ia.ui.ExplorerQueryContextComposite;
import com.ibm.cics.ia.ui.Messages;
import java.util.EnumSet;
import java.util.logging.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CreateThreadsafeReportParametersPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(CreateThreadsafeReportParametersPage.class.getPackage().getName());
    private Combo cicsTsLevelCombo;
    private Text collectionIdText;
    private Text regionText;
    private ExplorerQueryContextComposite resourceTypeCombo;
    private Button checkBox;
    private CreateThreadsafeReportPresenter presenter;

    protected CreateThreadsafeReportParametersPage(String pageName, CreateThreadsafeReportPresenter presenter) {
        super(pageName);
        this.setTitle(Messages.getString("ThreadsafeReportWizard.parameters.title"));
        this.setDescription(Messages.getString("ThreadsafeReportWizard.parameters.description"));
        this.presenter = presenter;
    }

    public void createControl(Composite parent) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 27;
        layout.verticalSpacing = 20;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.getString("ThreadsafeReportWizard.parameters.cicsTsLevel"));
        GridData layoutData = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)layoutData);
        this.cicsTsLevelCombo = new Combo(container, 8);
        layoutData = new GridData(4, 0x1000000, false, false);
        this.cicsTsLevelCombo.setLayoutData((Object)layoutData);
        label = new Label(container, 0);
        label.setText(Messages.getString("ThreadsafeReportWizard.parameters.collectionId"));
        layoutData = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)layoutData);
        this.collectionIdText = new Text(container, 2048);
        this.collectionIdText.setToolTipText(Messages.getString("ThreadsafeReportWizard.parameters.searchBox.tooltip"));
        layoutData = new GridData(4, 0x1000000, false, false);
        this.collectionIdText.setLayoutData((Object)layoutData);
        label = new Label(container, 0);
        label.setText(Messages.getString("ThreadsafeReportWizard.parameters.region"));
        layoutData = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)layoutData);
        this.regionText = new Text(container, 2048);
        this.regionText.setToolTipText(Messages.getString("ThreadsafeReportWizard.parameters.searchBox.tooltip"));
        layoutData = new GridData(4, 0x1000000, false, false);
        this.regionText.setLayoutData((Object)layoutData);
        EnumSet<ExplorerQueryContext> contexts = EnumSet.of(ExplorerQueryContext.TRANSACTION, ExplorerQueryContext.PROGRAM);
        this.resourceTypeCombo = new ExplorerQueryContextComposite(container, contexts, ExplorerQueryContext.PROGRAM, false);
        this.resourceTypeCombo.contextText.setToolTipText(Messages.getString("ThreadsafeReportWizard.parameters.searchBox.tooltip"));
        layoutData = new GridData(16384, 0x1000000, false, false, 2, 1);
        this.resourceTypeCombo.setLayoutData(layoutData);
        this.checkBox = new Button(container, 32);
        this.checkBox.setText(Messages.getString("ThreadsafeReportWizard.parameters.showDetailed"));
        layoutData = new GridData(16384, 0x1000000, false, false, 2, 1);
        this.checkBox.setLayoutData((Object)layoutData);
        this.presenter.onParametersPageCreation();
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createControl");
    }

    public void setHelpContextId(String helpContextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), helpContextId);
    }

    public Combo getCicsTsLevelCombo() {
        return this.cicsTsLevelCombo;
    }

    public Text getCollectionIdText() {
        return this.collectionIdText;
    }

    public Text getRegionText() {
        return this.regionText;
    }

    public ExplorerQueryContextComposite getResourceTypeCombo() {
        return this.resourceTypeCombo;
    }

    public Button getCheckBox() {
        return this.checkBox;
    }

    public CreateThreadsafeReportPresenter getPresenter() {
        return this.presenter;
    }
}

