/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.commands.FindRegionsCommand;
import com.ibm.cics.ia.model.AffinityType;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.CreateAffinityReportWizard;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.actions.Messages;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class CreateAffinityReportParametersPage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Table regionsTable;
    private Table affinityTypesTable;
    private JobWithCancelingSupport job;
    private TableItem dummyTableItem;
    private CreateAffinityReportWizard wizard;
    private Button affinityTypesSelectAll;
    private Button affinityTypesDeselectAll;
    private Button regionsSelectAll;
    private Button regionsDeselectAll;
    private static final String PAGE_NAME = "AFFINITY_REPORT_PARAMETERS";
    private static final String REGION = "REGION";
    private static final Logger logger = Logger.getLogger(CreateAffinityReportParametersPage.class.getPackage().getName());

    protected CreateAffinityReportParametersPage(CreateAffinityReportWizard wizard) {
        super(PAGE_NAME);
        this.wizard = wizard;
        this.setTitle(Messages.getString("AffinityReportWizard.Parameters.title"));
        this.setDescription(Messages.getString("AffinityReportWizard.Parameters.description"));
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getReportWizardImage()));
    }

    public void createControl(Composite parent) {
        Debug.enter((Logger)logger, (String)CreateAffinityReportParametersPage.class.getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.marginLeft = 10;
        gridLayout.marginRight = 10;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Label regionLabel = new Label(composite, 0);
        regionLabel.setText(Messages.getString("AffinityReportWizard.RegionLabel.text"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        regionLabel.setLayoutData((Object)gridData);
        this.regionsSelectAll = new Button(composite, 0);
        this.regionsSelectAll.setEnabled(false);
        this.regionsSelectAll.setText(Messages.getString("AffinityReportWizard.SelectAllButton.text"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 131072;
        gridData.horizontalSpan = 1;
        this.regionsSelectAll.setLayoutData((Object)gridData);
        this.regionsSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = CreateAffinityReportParametersPage.this.regionsTable.getItems();
                CreateAffinityReportParametersPage.this.wizard.getRegions().clear();
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(true);
                    CreateAffinityReportParametersPage.this.wizard.getRegions().add((Region)items[i].getData(CreateAffinityReportParametersPage.REGION));
                    ++i;
                }
                CreateAffinityReportParametersPage.this.setPageComplete(CreateAffinityReportParametersPage.this.canFlipToNextPage());
                CreateAffinityReportParametersPage.this.regionsSelectAll.setEnabled(false);
                CreateAffinityReportParametersPage.this.regionsDeselectAll.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.regionsDeselectAll = new Button(composite, 0);
        this.regionsDeselectAll.setEnabled(false);
        this.regionsDeselectAll.setText(Messages.getString("AffinityReportWizard.DeselectAllButton.text"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 131072;
        gridData.horizontalSpan = 1;
        this.regionsDeselectAll.setLayoutData((Object)gridData);
        this.regionsDeselectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = CreateAffinityReportParametersPage.this.regionsTable.getItems();
                CreateAffinityReportParametersPage.this.wizard.getRegions().clear();
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(false);
                    ++i;
                }
                CreateAffinityReportParametersPage.this.setPageComplete(CreateAffinityReportParametersPage.this.canFlipToNextPage());
                CreateAffinityReportParametersPage.this.regionsSelectAll.setEnabled(true);
                CreateAffinityReportParametersPage.this.regionsDeselectAll.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.regionsTable = toolkit.createTable(composite, 2852);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 5;
        gridData.heightHint = 100;
        this.regionsTable.setLayoutData((Object)gridData);
        this.fillRegionTable();
        this.regionsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = CreateAffinityReportParametersPage.this.regionsTable.getItems();
                if (items.length > 0) {
                    if (items[0] == CreateAffinityReportParametersPage.this.dummyTableItem) {
                        return;
                    }
                    CreateAffinityReportParametersPage.this.wizard.getRegions().clear();
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem tableItem = tableItemArray[n2];
                        if (tableItem.getChecked()) {
                            CreateAffinityReportParametersPage.this.wizard.getRegions().add((Region)tableItem.getData(CreateAffinityReportParametersPage.REGION));
                        }
                        ++n2;
                    }
                    if (CreateAffinityReportParametersPage.this.wizard.getRegions().size() == 0) {
                        CreateAffinityReportParametersPage.this.regionsSelectAll.setEnabled(true);
                        CreateAffinityReportParametersPage.this.regionsDeselectAll.setEnabled(false);
                    } else if (CreateAffinityReportParametersPage.this.wizard.getRegions().size() < items.length) {
                        CreateAffinityReportParametersPage.this.regionsSelectAll.setEnabled(true);
                        CreateAffinityReportParametersPage.this.regionsDeselectAll.setEnabled(true);
                    } else {
                        CreateAffinityReportParametersPage.this.regionsSelectAll.setEnabled(false);
                        CreateAffinityReportParametersPage.this.regionsDeselectAll.setEnabled(true);
                    }
                    CreateAffinityReportParametersPage.this.setPageComplete(CreateAffinityReportParametersPage.this.canFlipToNextPage());
                }
            }
        });
        Label affinityTypesLabel = new Label(composite, 0);
        affinityTypesLabel.setText(Messages.getString("AffinityReportWizard.AffinityTypesLabel.text"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        affinityTypesLabel.setLayoutData((Object)gridData);
        this.affinityTypesSelectAll = new Button(composite, 0);
        this.affinityTypesSelectAll.setEnabled(true);
        this.affinityTypesSelectAll.setText(Messages.getString("AffinityReportWizard.SelectAllButton.text"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 131072;
        gridData.horizontalSpan = 1;
        this.affinityTypesSelectAll.setLayoutData((Object)gridData);
        this.affinityTypesSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = CreateAffinityReportParametersPage.this.affinityTypesTable.getItems();
                CreateAffinityReportParametersPage.this.wizard.getAffinityTypes().clear();
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(true);
                    CreateAffinityReportParametersPage.this.wizard.getAffinityTypes().add((AffinityType)items[i].getData());
                    ++i;
                }
                CreateAffinityReportParametersPage.this.setPageComplete(CreateAffinityReportParametersPage.this.canFlipToNextPage());
                CreateAffinityReportParametersPage.this.affinityTypesSelectAll.setEnabled(false);
                CreateAffinityReportParametersPage.this.affinityTypesDeselectAll.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.affinityTypesDeselectAll = new Button(composite, 0);
        this.affinityTypesDeselectAll.setEnabled(false);
        this.affinityTypesDeselectAll.setText(Messages.getString("AffinityReportWizard.DeselectAllButton.text"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 131072;
        gridData.horizontalSpan = 1;
        this.affinityTypesDeselectAll.setLayoutData((Object)gridData);
        this.affinityTypesDeselectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = CreateAffinityReportParametersPage.this.affinityTypesTable.getItems();
                CreateAffinityReportParametersPage.this.wizard.getAffinityTypes().clear();
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(false);
                    ++i;
                }
                CreateAffinityReportParametersPage.this.setPageComplete(CreateAffinityReportParametersPage.this.canFlipToNextPage());
                CreateAffinityReportParametersPage.this.affinityTypesSelectAll.setEnabled(true);
                CreateAffinityReportParametersPage.this.affinityTypesDeselectAll.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.affinityTypesTable = toolkit.createTable(composite, 2852);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 5;
        gridData.heightHint = 200;
        this.affinityTypesTable.setLayoutData((Object)gridData);
        this.fillAffinityTypesTable();
        this.affinityTypesTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = CreateAffinityReportParametersPage.this.affinityTypesTable.getItems();
                if (items.length > 0) {
                    if (items[0] == CreateAffinityReportParametersPage.this.dummyTableItem) {
                        return;
                    }
                    CreateAffinityReportParametersPage.this.wizard.getAffinityTypes().clear();
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem tableItem = tableItemArray[n2];
                        if (tableItem.getChecked()) {
                            CreateAffinityReportParametersPage.this.wizard.getAffinityTypes().add((AffinityType)tableItem.getData());
                        }
                        ++n2;
                    }
                    if (CreateAffinityReportParametersPage.this.wizard.getAffinityTypes().size() == 0) {
                        CreateAffinityReportParametersPage.this.affinityTypesSelectAll.setEnabled(true);
                        CreateAffinityReportParametersPage.this.affinityTypesDeselectAll.setEnabled(false);
                    } else if (CreateAffinityReportParametersPage.this.wizard.getAffinityTypes().size() < items.length) {
                        CreateAffinityReportParametersPage.this.affinityTypesSelectAll.setEnabled(true);
                        CreateAffinityReportParametersPage.this.affinityTypesDeselectAll.setEnabled(true);
                    } else {
                        CreateAffinityReportParametersPage.this.affinityTypesSelectAll.setEnabled(false);
                        CreateAffinityReportParametersPage.this.affinityTypesDeselectAll.setEnabled(true);
                    }
                    CreateAffinityReportParametersPage.this.setPageComplete(CreateAffinityReportParametersPage.this.canFlipToNextPage());
                }
            }
        });
        this.setControl((Control)composite);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.affinity_report_wizard");
        Debug.exit((Logger)logger, (String)CreateAffinityReportParametersPage.class.getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void fillRegionTable() {
        Debug.enter((Logger)logger, (String)CreateAffinityReportParametersPage.class.getName(), (String)"fillRegionTable", (Object)("Thread ID: " + Thread.currentThread().getId()));
        final String fetchRegionsMsg = Messages.getString("AffinityReportWizard.dummyTableItem.text");
        this.dummyTableItem = new TableItem(this.regionsTable, 0);
        this.dummyTableItem.setText(Messages.getString("AffinityReportWizard.dummyTableItem.text"));
        this.dummyTableItem.setImage(ImageFactory.getDatabaseBusyImage());
        this.job = new JobWithCancelingSupport(fetchRegionsMsg){

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"JobWithCancelingSupport()", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(fetchRegionsMsg, -1);
                FindRegionsCommand command = new FindRegionsCommand();
                command.setAsync(false);
                command.start();
                final List regions = command.getResults();
                if (CreateAffinityReportParametersPage.this.regionsTable != null && !CreateAffinityReportParametersPage.this.regionsTable.isDisposed()) {
                    CreateAffinityReportParametersPage.this.regionsTable.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"CreateAffinityReportParametersPage.fillRegionTable()JobWithCancelingSupport().Runnable()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            CreateAffinityReportParametersPage.this.dummyTableItem.dispose();
                            CreateAffinityReportParametersPage.this.dummyTableItem = null;
                            if (regions != null && regions.size() > 0) {
                                CreateAffinityReportParametersPage.this.regionsSelectAll.setEnabled(true);
                                for (Region region : regions) {
                                    TableItem item = new TableItem(CreateAffinityReportParametersPage.this.regionsTable, 0);
                                    item.setImage(ImageFactory.getRegionImage());
                                    item.setText(region.getName());
                                    item.setData(CreateAffinityReportParametersPage.REGION, (Object)region);
                                    Region[] regionArray = CreateAffinityReportParametersPage.this.wizard.getStartRegions();
                                    int n = regionArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Region startRegion = regionArray[n2];
                                        if (region.equals((Object)startRegion)) {
                                            item.setChecked(true);
                                            CreateAffinityReportParametersPage.this.wizard.getRegions().add(region);
                                            CreateAffinityReportParametersPage.this.regionsDeselectAll.setEnabled(true);
                                        }
                                        ++n2;
                                    }
                                }
                            } else {
                                CreateAffinityReportParametersPage.this.dummyTableItem = new TableItem(CreateAffinityReportParametersPage.this.regionsTable, 0);
                                CreateAffinityReportParametersPage.this.dummyTableItem.setText(Messages.getString("AffinityReportWizard.dummyTableItem.NotFound.text"));
                                CreateAffinityReportParametersPage.this.regionsSelectAll.setEnabled(false);
                                CreateAffinityReportParametersPage.this.regionsDeselectAll.setEnabled(false);
                            }
                            Debug.exit((Logger)logger, (String)"CreateAffinityReportParametersPage.fillRegionTable()JobWithCancelingSupport().Runnable()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        }
                    });
                }
                Debug.exit((Logger)logger, (String)"JobWithCancelingSupport()", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                return Status.OK_STATUS;
            }

            protected void cancelingSub() {
                IAPlugin.getDefault().taskEnded();
            }
        };
        this.job.schedule();
        Debug.exit((Logger)logger, (String)CreateAffinityReportParametersPage.class.getName(), (String)"fillRegionTable", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void fillAffinityTypesTable() {
        Debug.enter((Logger)logger, (String)CreateAffinityReportParametersPage.class.getName(), (String)"fillAffinityTypesTable", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AffinityType[] affinityTypes = AffinityType.values();
        int i = 0;
        while (i < affinityTypes.length) {
            TableItem item = new TableItem(this.affinityTypesTable, 0);
            item.setText(affinityTypes[i].getName());
            item.setData((Object)affinityTypes[i]);
            ++i;
        }
        Debug.exit((Logger)logger, (String)CreateAffinityReportParametersPage.class.getName(), (String)"fillAffinityTypesTable", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public boolean canFlipToNextPage() {
        return this.wizard.getRegions().size() > 0 && this.wizard.getAffinityTypes().size() > 0;
    }
}

