/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.CreateAffinityReportDescriptionPage;
import com.ibm.cics.ia.ui.CreateAffinityReportWizard;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.ReportManager;
import com.ibm.cics.ia.ui.SaveReportDialog;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class CreateAffinityReportLocationPage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CreateAffinityReportWizard wizard;
    private static final String PAGE_NAME = "AFFINITY_REPORT_LOCATION";
    private static final Logger logger = Logger.getLogger(CreateAffinityReportLocationPage.class.getPackage().getName());
    private Composite editComposite;
    private TreeItem itemToRename;
    private TreeEditor treeEditor;
    private Tree tree;
    private Button newFolderButton;
    private Button addTimestampButton;
    private Text nameText;
    private IContainer container = null;
    private ReportManager reportManager;
    private boolean inError;
    private String errorMessage;

    protected CreateAffinityReportLocationPage(CreateAffinityReportWizard wizard) {
        super(PAGE_NAME);
        this.wizard = wizard;
        this.setTitle(Messages.getString("AffinityReportWizard.Location.title"));
        this.setDescription(Messages.getString("AffinityReportWizard.Location.description"));
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getReportWizardImage()));
    }

    public void createControl(Composite parent) {
        Debug.enter((Logger)logger, (String)CreateAffinityReportLocationPage.class.getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 10;
        gridLayout.marginRight = 10;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Label folderLabel = new Label(composite, 0);
        folderLabel.setText(Messages.getString("AffinityReportWizard.Location.message"));
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        folderLabel.setLayoutData((Object)gridData);
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.tree = new Tree(composite, 2048);
        this.treeEditor = new TreeEditor(this.tree);
        this.reportManager = ReportManager.createReportManager(ReportManager.Type.folders);
        this.reportManager.setTree(this.tree);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 350;
        this.tree.setLayoutData((Object)gridData);
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IContainer container = CreateAffinityReportLocationPage.this.getCurrentContainer();
                if (container != null) {
                    CreateAffinityReportLocationPage.this.wizard.setRootFolder(container);
                    CreateAffinityReportLocationPage.this.validate();
                    CreateAffinityReportLocationPage.this.setPageComplete(CreateAffinityReportLocationPage.this.canFlipToNextPage());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.newFolderButton = new Button(composite, 0);
        this.newFolderButton.setText(Messages.getString("AffinityReportWizard.Location.IFolder.newfolder"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 16384;
        gridData.horizontalSpan = 2;
        this.newFolderButton.setLayoutData((Object)gridData);
        this.newFolderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Debug.enter((Logger)logger, (String)"CreateAffinityReportLocationPage.createControl().newFolderButton.SelectionListener()", (String)"widgetSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = CreateAffinityReportLocationPage.this.getCurrentContainer();
                try {
                    IResource resource;
                    Path path = new Path("/");
                    IFolder newFolder = currentContainer.getFolder(path.append(Messages.getString("AffinityReportWizard.Location.IFolder.newfolder")));
                    int i = 2;
                    while (CreateAffinityReportLocationPage.this.reportManager.folderExists(currentContainer, newFolder.getName())) {
                        newFolder = currentContainer.getFolder(path.append(MessageFormat.format(Messages.getString("AffinityReportWizard.Location.IFolder.newFolderNum"), Integer.toString(i++))));
                    }
                    newFolder.create(true, true, null);
                    TreeItem[] items = CreateAffinityReportLocationPage.this.tree.getSelection();
                    TreeItem item = null;
                    if (items.length > 0 && !((resource = (IResource)(item = items[0]).getData("IRESOURCE")) instanceof IFolder)) {
                        item = item.getParentItem();
                    }
                    CreateAffinityReportLocationPage.this.reportManager.refresh(currentContainer);
                    TreeItem newFolderItem = CreateAffinityReportLocationPage.this.reportManager.getTreeItem((IResource)newFolder);
                    CreateAffinityReportLocationPage.this.fireRenameFocusEvent(newFolderItem);
                }
                catch (Exception ex) {
                    Debug.warning((Logger)logger, (String)"SaveReportDialog.createDialogArea().newFolderButton", (String)"widgetSelected", (Throwable)ex, new HashMap());
                    IAPlugin.getDefault().logError("Unable to create new folder", (Throwable)ex);
                }
                Debug.exit((Logger)logger, (String)"CreateAffinityReportLocationPage.createControl().newFolderButton.SelectionListener()", (String)"widgetSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("AffinityReportWizard.NameLabel.text"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        nameLabel.setLayoutData((Object)gridData);
        this.nameText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        this.nameText.setLayoutData((Object)gridData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateAffinityReportLocationPage.this.wizard.setTitle(CreateAffinityReportLocationPage.this.nameText.getText());
                CreateAffinityReportLocationPage.this.validate();
                if (!CreateAffinityReportLocationPage.this.inError) {
                    CreateAffinityReportLocationPage.this.setPageComplete(true);
                }
            }
        });
        this.addTimestampButton = new Button(composite, 32);
        this.addTimestampButton.setText(Messages.getString("AffinityReportWizard.Location.addTimeStamp"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 16384;
        gridData.horizontalSpan = 2;
        this.addTimestampButton.setLayoutData((Object)gridData);
        this.addTimestampButton.setSelection(this.wizard.isAddTimeStamp());
        this.addTimestampButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateAffinityReportLocationPage.this.wizard.setAddTimeStamp(CreateAffinityReportLocationPage.this.addTimestampButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refresh();
        this.setControl((Control)composite);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.affinity_report_wizard");
        Debug.exit((Logger)logger, (String)CreateAffinityReportLocationPage.class.getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void refresh() {
        this.tree.removeAll();
        this.reportManager.refresh();
        UIUtilities.expandTree(this.tree, true);
    }

    private IContainer getCurrentContainer() {
        Debug.enter((Logger)logger, (String)CreateAffinityReportLocationPage.class.getName(), (String)"getCurrentContainer", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem[] items = this.tree.getSelection();
        if (items.length == 0) {
            return (IContainer)this.tree.getData("IRESOURCE");
        }
        TreeItem item = items[0];
        IResource resource = (IResource)item.getData("IRESOURCE");
        Debug.exit((Logger)logger, (String)CreateAffinityReportLocationPage.class.getName(), (String)"getCurrentContainer", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return resource instanceof IFolder ? (IContainer)resource : resource.getParent();
    }

    protected void fireRenameFocusEvent(TreeItem newFolderItem) {
        Debug.enter((Logger)logger, (String)CreateAffinityReportLocationPage.class.getName(), (String)"fireRenameFocusEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.editComposite != null && !this.editComposite.isDisposed()) {
            this.editComposite.dispose();
        }
        Event e = new Event();
        e.item = newFolderItem;
        this.tree.setSelection(newFolderItem);
        this.renameTreeItem(newFolderItem);
        this.tree.setSelection(newFolderItem);
        Debug.exit((Logger)logger, (String)CreateAffinityReportLocationPage.class.getName(), (String)"fireRenameFocusEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void renameTreeItem(final TreeItem aTreeItem) {
        Debug.enter((Logger)logger, (String)CreateAffinityReportLocationPage.class.getName(), (String)"renameTreeItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.editComposite = new Composite((Composite)this.tree, 0);
        final Text editText = new Text(this.editComposite, 2048);
        this.editComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = CreateAffinityReportLocationPage.this.editComposite.getClientArea();
                editText.setBounds(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
            }
        });
        Listener focusOutListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"CreateAffinityReportLocationPage.renameTreeItem().focusOutListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                String name = editText.getText();
                IResource resource = (IResource)aTreeItem.getData("IRESOURCE");
                if (resource instanceof IFolder) {
                    CreateAffinityReportLocationPage.this.itemToRename = aTreeItem;
                    IContainer parent2 = resource.getParent();
                    if (parent2.findMember(name) != null) {
                        CreateAffinityReportLocationPage.this.editComposite.dispose();
                        event.doit = false;
                        Debug.exit((Logger)logger, (String)"CreateAffinityReportLocationPage.renameTreeItem().focusOutListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        return;
                    }
                    aTreeItem.setText(editText.getText());
                    CreateAffinityReportLocationPage.this.updateName(editText.getText(), aTreeItem);
                    CreateAffinityReportLocationPage.this.editComposite.dispose();
                    Debug.exit((Logger)logger, (String)"CreateAffinityReportLocationPage.renameTreeItem().focusOutListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    event.doit = false;
                    IContainer container = CreateAffinityReportLocationPage.this.getCurrentContainer();
                    if (container != null) {
                        CreateAffinityReportLocationPage.this.wizard.setRootFolder(container);
                        CreateAffinityReportLocationPage.this.setPageComplete(true);
                    }
                }
            }
        };
        Listener verifyListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"CreateAffinityReportLocationPage.renameTreeItem().verifyListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                String newText = editText.getText();
                String leftText = newText.substring(0, event.start);
                String rightText = newText.substring(event.end, newText.length());
                GC gc = new GC((Drawable)editText);
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                size = editText.computeSize(size.x, -1);
                ((CreateAffinityReportLocationPage)CreateAffinityReportLocationPage.this).treeEditor.horizontalAlignment = 16384;
                Rectangle itemRect = aTreeItem.getBounds();
                Rectangle rect = CreateAffinityReportLocationPage.this.tree.getClientArea();
                ((CreateAffinityReportLocationPage)CreateAffinityReportLocationPage.this).treeEditor.minimumWidth = Math.max(size.x, itemRect.width) + 2;
                int left = itemRect.x;
                int right = rect.x + rect.width;
                ((CreateAffinityReportLocationPage)CreateAffinityReportLocationPage.this).treeEditor.minimumWidth = Math.min(((CreateAffinityReportLocationPage)CreateAffinityReportLocationPage.this).treeEditor.minimumWidth, right - left);
                ((CreateAffinityReportLocationPage)CreateAffinityReportLocationPage.this).treeEditor.minimumHeight = size.y + 2;
                CreateAffinityReportLocationPage.this.treeEditor.layout();
                IContainer container = CreateAffinityReportLocationPage.this.getCurrentContainer();
                if (container != null) {
                    CreateAffinityReportLocationPage.this.wizard.setRootFolder(container);
                    CreateAffinityReportLocationPage.this.setPageComplete(true);
                }
                Debug.exit((Logger)logger, (String)"CreateAffinityReportLocationPage.renameTreeItem().verifyListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        };
        Listener traverseListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"CreateAffinityReportLocationPage.renameTreeItem().traverseListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if (event.detail == 4) {
                    String name = editText.getText();
                    IResource resource = (IResource)aTreeItem.getData("IRESOURCE");
                    if (resource instanceof IFolder) {
                        CreateAffinityReportLocationPage.this.itemToRename = aTreeItem;
                        IContainer parent2 = resource.getParent();
                        if (parent2.findMember(name) != null) {
                            CreateAffinityReportLocationPage.this.editComposite.dispose();
                            event.doit = false;
                            Debug.exit((Logger)logger, (String)"CreateAffinityReportLocationPage.renameTreeItem().traverseListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            return;
                        }
                    }
                    if (!CreateAffinityReportLocationPage.this.checkUserInput(name)) {
                        event.doit = false;
                        Debug.exit((Logger)logger, (String)"CreateAffinityReportLocationPage.renameTreeItem().traverseListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        return;
                    }
                    IFolder folder = CreateAffinityReportLocationPage.this.getCurrentContainer().getFolder(new Path(name).addTrailingSeparator());
                    if (folder.exists()) {
                        CreateAffinityReportLocationPage.this.editComposite.dispose();
                        event.doit = false;
                        Debug.exit((Logger)logger, (String)"CreateAffinityReportLocationPage.renameTreeItem().traverseListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        return;
                    }
                    aTreeItem.setText(editText.getText());
                    CreateAffinityReportLocationPage.this.updateName(editText.getText(), aTreeItem);
                    CreateAffinityReportLocationPage.this.editComposite.dispose();
                    event.doit = false;
                    IContainer container = CreateAffinityReportLocationPage.this.getCurrentContainer();
                    if (container != null) {
                        CreateAffinityReportLocationPage.this.wizard.setRootFolder(container);
                        CreateAffinityReportLocationPage.this.setPageComplete(true);
                    }
                } else if (event.detail == 2) {
                    CreateAffinityReportLocationPage.this.editComposite.dispose();
                    event.doit = false;
                }
                Debug.exit((Logger)logger, (String)"CreateAffinityReportLocationPage.renameTreeItem().traverseListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        };
        editText.addListener(16, focusOutListener);
        editText.addListener(25, verifyListener);
        editText.addListener(31, traverseListener);
        this.treeEditor.setEditor((Control)this.editComposite, aTreeItem);
        editText.setText(aTreeItem.getText());
        editText.selectAll();
        editText.setFocus();
        Debug.exit((Logger)logger, (String)CreateAffinityReportLocationPage.class.getName(), (String)"renameTreeItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private boolean checkUserInput(String name) {
        if (!IAUtilities.hasContent((String)name) || !IAUtilities.isValidFilename((String)name)) {
            this.editComposite.dispose();
            return false;
        }
        return true;
    }

    private IContainer getContainerForItemToRename() {
        if (this.itemToRename != null) {
            IResource resource = (IResource)this.itemToRename.getData("IRESOURCE");
            return resource instanceof IFolder ? (IContainer)resource : resource.getParent();
        }
        return null;
    }

    public void updateName(String newName, TreeItem selectedItem) {
        Debug.enter((Logger)logger, (String)CreateAffinityReportLocationPage.class.getName(), (String)"updateName", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IResource resource = (IResource)selectedItem.getData("IRESOURCE");
        IFolder folder = (IFolder)resource;
        Path path = new Path(newName);
        IPath newPath = path.addTrailingSeparator();
        try {
            this.reportManager.removeTreeItem((IResource)folder);
            folder.refreshLocal(2, null);
            folder.move(newPath, true, null);
            folder = folder.getParent().getFolder(newPath);
            selectedItem.setData("IRESOURCE", (Object)folder);
            this.reportManager.setTreeItem((IResource)folder, selectedItem);
            this.reportManager.refresh(folder.getParent());
        }
        catch (Exception e) {
            Debug.warning((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"updateName", (Throwable)e, new HashMap());
            IAPlugin.getDefault().logError("Unable to rename folder", (Throwable)e);
        }
        Debug.exit((Logger)logger, (String)CreateAffinityReportLocationPage.class.getName(), (String)"updateName", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public boolean canFlipToNextPage() {
        return this.wizard.getRootFolder() != null;
    }

    public void dispose() {
        ReportManager.removeReportManager(this.reportManager);
        super.dispose();
    }

    public void validate() {
        if (!IAUtilities.hasContent((String)this.nameText.getText())) {
            this.inError = true;
            this.errorMessage = Messages.getString("AffinityReportWizard.Name.Error.NameMustBeEntered");
            this.setErrorMessage(this.errorMessage);
            this.setPageComplete(this.canFlipToNextPage());
            Debug.exit((Logger)logger, (String)CreateAffinityReportDescriptionPage.class.getName(), (String)"validate", (Object)("Thread ID: " + Thread.currentThread().getId()));
            return;
        }
        if (!IAUtilities.isValidFilename((String)this.nameText.getText())) {
            this.inError = true;
            this.errorMessage = Messages.getString("AffinityReportWizard.Name.Error.NameContainsIllegalCharacters");
            this.setErrorMessage(this.errorMessage);
            Debug.exit((Logger)logger, (String)CreateAffinityReportDescriptionPage.class.getName(), (String)"validate", (Object)("Thread ID: " + Thread.currentThread().getId()));
            return;
        }
        List<Region> regions = this.wizard.getRegions();
        IContainer rootFolder = this.wizard.getRootFolder();
        if (rootFolder != null) {
            for (Region region : regions) {
                IPath regionPath = rootFolder.getProjectRelativePath().append(region.getName());
                IPath reportPath = regionPath.append(this.nameText.getText()).addFileExtension("xml");
                if (!rootFolder.exists(reportPath)) continue;
                this.inError = true;
                this.errorMessage = MessageFormat.format(Messages.getString("AffinityReportWizard.Name.Error.NameAlreadyUsedInFolder"), this.wizard.getTitle(), region.getName());
                Debug.exit((Logger)logger, (String)CreateAffinityReportDescriptionPage.class.getName(), (String)"validate", (Object)("Thread ID: " + Thread.currentThread().getId()));
                return;
            }
        }
        this.inError = false;
        this.errorMessage = null;
        this.setErrorMessage(null);
        this.wizard.setTitle(this.nameText.getText());
    }
}

