/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.ia.commands.IColumnResultsCommand;
import com.ibm.cics.ia.commands.QueryDifferenceCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.UIUtilities;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class CompareResourcesDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CompareResourcesDialog.class.getPackage().getName());
    private static final String COMMAND = "COMMAND";
    private Tree treeIn;
    private Tree treeNotIn;
    private List searchHistory;
    private IColumnResultsCommand currentSearch;

    public CompareResourcesDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("CompareResourcesDialog.compareSearchResults"));
    }

    protected Control createHelpControl(Composite parent) {
        Image helpImage = JFaceResources.getImage((String)"dialog_help_image");
        if (helpImage == null) {
            JFaceResources.getImageRegistry().put("dialog_help_image", ImageFactory.getHelpLinkImage());
        }
        return super.createHelpControl(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)CompareResourcesDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.setTitle(Messages.getString("CompareResourcesDialog.combineSearchResultsTitle"));
        this.setMessage(Messages.getString("CompareResourcesDialog.selectResultsMessage"));
        this.setTitleImage(ImageFactory.getResourcesBannerImage());
        Composite c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        c.setLayout((Layout)gridLayout);
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        Label l = new Label(c, 0);
        l.setText(Messages.getString("CompareResourcesDialog.showResourcesInText"));
        Label l1 = new Label(c, 0);
        l1.setText(Messages.getString("CompareResourcesDialog.andNotInText"));
        this.treeIn = new Tree(c, 2080);
        GridData treeData = new GridData(4, 4, true, true);
        treeData.heightHint = 250;
        treeData.widthHint = 250;
        this.treeIn.setLayoutData((Object)treeData);
        this.treeNotIn = new Tree(c, 2080);
        this.treeNotIn.setLayoutData((Object)treeData);
        SelectionAdapter treeSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        };
        this.treeNotIn.addSelectionListener((SelectionListener)treeSelectionListener);
        this.treeIn.addSelectionListener((SelectionListener)treeSelectionListener);
        Iterator iter = this.searchHistory.iterator();
        String[] primaryColumns = this.currentSearch.getColumns();
        while (iter.hasNext()) {
            DisplayableData displayableData;
            IColumnResultsCommand command = (IColumnResultsCommand)iter.next();
            if (!this.columnsEqual(command.getColumns(), primaryColumns)) continue;
            boolean sqlCommandComparable = true;
            if (command instanceof SQLCommand) {
                boolean bl = sqlCommandComparable = ((SQLCommand)command).status() == 1 && command.getResults() != null;
            }
            if (!sqlCommandComparable || (displayableData = DisplayableData.getDisplayableData((IAdaptable)command)) == null) continue;
            TreeItem treeInItem = new TreeItem(this.treeIn, 0);
            treeInItem.setData(COMMAND, (Object)command);
            treeInItem.setImage(displayableData.getImage());
            String treeItemText = command instanceof Command ? UIUtilities.asFormattedDescription((Command)command, displayableData, Integer.MAX_VALUE) : UIUtilities.asFormattedDescription(displayableData, Integer.MAX_VALUE);
            treeInItem.setText(treeItemText);
            if (command == this.currentSearch) {
                treeInItem.setChecked(true);
            }
            TreeItem treeNotInItem = new TreeItem(this.treeNotIn, 0);
            treeNotInItem.setData(COMMAND, (Object)command);
            treeNotInItem.setImage(displayableData.getImage());
            treeNotInItem.setText(treeItemText);
        }
        Dialog.applyDialogFont((Control)parent);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent.getShell(), "com.ibm.cics.ia.help.compare_resources");
        Debug.exit((Logger)logger, (String)CompareResourcesDialog.class.getName(), (String)"createDialogArea");
        return c;
    }

    protected void okPressed() {
        Debug.enter((Logger)logger, (String)CompareResourcesDialog.class.getName(), (String)"okPressed", (Object)("Thread ID: " + Thread.currentThread().getId()));
        QueryDifferenceCommand queryDiffCommand = new QueryDifferenceCommand();
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.getString("CompareResourcesDialog.comparisonOfText"));
        TreeItem[] items = this.treeIn.getItems();
        boolean inItemFound = false;
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                DisplayableData displayableData;
                Command command = (Command)items[i].getData(COMMAND);
                queryDiffCommand.getInCommands().add(command);
                if (!inItemFound) {
                    buffer.append(IAUtilities.LINE_SEPARATOR);
                    buffer.append(Messages.getString("CompareResourcesDialog.inText"));
                    inItemFound = true;
                }
                if ((displayableData = (DisplayableData)command.getAdapter(DisplayableData.class)) != null) {
                    buffer.append(displayableData.getDescription());
                    if (i < items.length - 1) {
                        buffer.append(",");
                    }
                }
            }
            ++i;
        }
        if (inItemFound) {
            if (buffer.toString().endsWith(",")) {
                buffer = buffer.delete(buffer.length() - 1, buffer.length());
            }
            buffer.append("}");
        }
        items = this.treeNotIn.getItems();
        boolean notInItemFound = false;
        int i2 = 0;
        while (i2 < items.length) {
            if (items[i2].getChecked()) {
                DisplayableData displayableData;
                Command command = (Command)items[i2].getData(COMMAND);
                queryDiffCommand.getNotInCommands().add(command);
                if (!notInItemFound) {
                    buffer.append(IAUtilities.LINE_SEPARATOR);
                    buffer.append(Messages.getString("CompareResourcesDialog.notInText"));
                    notInItemFound = true;
                }
                if ((displayableData = (DisplayableData)command.getAdapter(DisplayableData.class)) != null) {
                    buffer.append(displayableData.getDescription());
                    if (i2 < items.length - 1) {
                        buffer.append(",");
                    }
                }
            }
            ++i2;
        }
        if (notInItemFound) {
            if (buffer.toString().endsWith(",")) {
                buffer = buffer.delete(buffer.length() - 1, buffer.length());
            }
            buffer.append("}");
        }
        DisplayableData displayableData = (DisplayableData)queryDiffCommand.getAdapter(DisplayableData.class);
        displayableData.setImage(ImageFactory.getResourceImage());
        displayableData.setDescription(buffer.toString());
        queryDiffCommand.setDescription(buffer.toString());
        Activator.executeSearch((Command)queryDiffCommand);
        Debug.exit((Logger)logger, (String)CompareResourcesDialog.class.getName(), (String)"okPressed");
        super.okPressed();
    }

    private boolean columnsEqual(String[] array1, String[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (!array1[i].equals(array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setSearchHistory(List searchHistory) {
        this.searchHistory = searchHistory;
    }

    public void setCurrentSearch(IColumnResultsCommand currentSearch) {
        this.currentSearch = currentSearch;
    }
}

