/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.ia.commands.CommandExecutionForTaskCommand;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.ui.CommandFlowView;
import com.ibm.cics.ia.ui.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbench;

public class CommandFlowViewColumnDialog
extends TrayDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CommandFlowViewColumnDialog.class.getPackage().getName());
    private static final int RESET = 12345;
    public static final int DEFAULT_TABLE_WIDTH = 150;
    public static final int DEFAULT_TABLE_HEIGHT = 200;
    private Table unUsedColumnsTable;
    private Table usedColumnsTable;
    private Button addButton;
    private Button removeButton;
    private List<String> usedColumnsNames = new ArrayList<String>();
    private CommandFlowView commandFlowView;
    private static final String[] DEFAULT_COLUMN_NAMES = "TCBMODE,PREV_TCBMODE,CMD_TIME_LOCAL".split(",");

    public CommandFlowViewColumnDialog(Shell parentShell, CommandFlowView commandFlowView) {
        super(parentShell);
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"CommandFlowViewColumnDialog", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getName(), "commandFlowView: " + commandFlowView.getTitle()});
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.commandFlowView = commandFlowView;
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"CommandFlowViewColumnDialog");
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createDialogArea");
        this.getShell().setText(Messages.getString("CommandFlowViewColumnDialog.title"));
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tablesArea = new Composite(c, 0);
        tablesArea.setLayoutData((Object)new GridData(4, 4, true, true));
        tablesArea.setLayout((Layout)new GridLayout(3, false));
        Label LHSLabel = new Label(tablesArea, 0);
        LHSLabel.setText(Messages.getString("CommandFlowViewColumnDialog.label.availableColumns"));
        Label l = new Label(tablesArea, 0);
        Label RHSLabel = new Label(tablesArea, 0);
        RHSLabel.setText(Messages.getString("CommandFlowViewColumnDialog.label.currentColumns"));
        this.unUsedColumnsTable = new Table(tablesArea, 2818);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 150;
        this.unUsedColumnsTable.setLayoutData((Object)data);
        Composite buttonArea = new Composite(tablesArea, 0);
        buttonArea.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(0, 4, false, true);
        buttonArea.setLayoutData((Object)data);
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText(String.valueOf(Messages.getString("CommandFlowViewColumnDialog.addColumn")) + " -->");
        data = new GridData(4, 0, true, false);
        this.addButton.setEnabled(false);
        this.addButton.setLayoutData((Object)data);
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setText("<-- " + Messages.getString("CommandFlowViewColumnDialog.removeColumn"));
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)data);
        this.usedColumnsTable = new Table(tablesArea, 2818);
        data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 150;
        this.usedColumnsTable.setLayoutData((Object)data);
        this.addListeners();
        this.initialize();
        this.setHelpAvailable(false);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createDialogArea");
        return c;
    }

    private void addListeners() {
        this.unUsedColumnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandFlowViewColumnDialog.this.addButton.setEnabled(CommandFlowViewColumnDialog.this.unUsedColumnsTable.getSelectionCount() >= 1);
            }
        });
        this.usedColumnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandFlowViewColumnDialog.this.removeButton.setEnabled(CommandFlowViewColumnDialog.this.usedColumnsTable.getSelectionCount() >= 1);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandFlowViewColumnDialog.this.addSelectedColumns();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandFlowViewColumnDialog.this.removeSelectedColumns();
            }
        });
    }

    private void addSelectedColumns() {
        TableItem[] selection;
        TableItem[] tableItemArray = selection = this.unUsedColumnsTable.getSelection();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem selectedItem = tableItemArray[n2];
            String itemName = this.moveItem(selectedItem, this.usedColumnsTable, false);
            this.usedColumnsNames.add(itemName);
            this.commandFlowView.addColumn(itemName, 140);
            ++n2;
        }
        this.addButton.setEnabled(false);
    }

    private void removeSelectedColumns() {
        TableItem[] selection;
        TableItem[] tableItemArray = selection = this.usedColumnsTable.getSelection();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem selectedItem = tableItemArray[n2];
            String itemName = this.moveItem(selectedItem, this.unUsedColumnsTable, true);
            this.usedColumnsNames.remove(itemName);
            this.commandFlowView.removeColumn(itemName);
            ++n2;
        }
        this.removeButton.setEnabled(false);
    }

    private String moveItem(TableItem item, Table target, boolean keepOrder) {
        TableItem newItem;
        Debug.enter((Logger)logger, (String)CommandFlowViewColumnDialog.class.getName(), (String)"moveItem", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "item: " + item.getText(), "target.getRegion(): " + target.getRegion(), "keepOrder: " + keepOrder});
        String itemName = (String)item.getData();
        item.dispose();
        String newText = SQLDefinitions.getColumnDescription((String)itemName);
        if (keepOrder) {
            TableItem[] items = target.getItems();
            int position = items.length;
            int i = 0;
            while (i < items.length) {
                if (items[i].getText().compareTo(newText) > 0) {
                    position = i;
                    break;
                }
                ++i;
            }
            newItem = new TableItem(target, 0, position);
        } else {
            newItem = new TableItem(target, 0);
        }
        newItem.setText(newText);
        newItem.setData((Object)itemName);
        Debug.exit((Logger)logger, (String)CommandFlowViewColumnDialog.class.getName(), (String)"moveItem", (Object)("itemName: " + itemName));
        return itemName;
    }

    private void initialize() {
        Debug.enter((Logger)logger, (String)CommandFlowViewColumnDialog.class.getName(), (String)"initialize", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (TreeColumn treeColumn : this.commandFlowView.getUsedColumns()) {
            TableItem tableItem = new TableItem(this.usedColumnsTable, 0);
            String column = (String)treeColumn.getData();
            tableItem.setText(SQLDefinitions.getColumnDescription((String)column));
            tableItem.setData((Object)column);
            this.usedColumnsNames.add(column);
        }
        ArrayList<String> allColumns = new ArrayList<String>();
        allColumns.addAll(Arrays.asList(CommandExecutionForTaskCommand.getColumns()));
        if (allColumns.contains("CMD_TCB_CPUTIME_AFTER") && !allColumns.contains("CMD_TCB_CPUTIME")) {
            allColumns.add("CMD_TCB_CPUTIME");
        }
        Collections.sort(allColumns, new ColumnsComparator());
        LinkedHashMap<String, Integer> savedColumnData = this.commandFlowView.getSavedColumnData();
        String[] stringArray = savedColumnData.keySet().toArray(new String[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            if (!this.usedColumnsNames.contains(column) || !allColumns.contains(column)) {
                allColumns.add(column);
            }
            ++n2;
        }
        for (String column : allColumns) {
            if (this.usedColumnsNames.contains(column)) continue;
            TableItem tableItem = new TableItem(this.unUsedColumnsTable, 0);
            tableItem.setText(SQLDefinitions.getColumnDescription((String)column));
            tableItem.setData((Object)column);
        }
        Debug.exit((Logger)logger, (String)CommandFlowViewColumnDialog.class.getName(), (String)"createButtonsForButtonBar");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button resetButton = this.createButton(parent, 12345, Messages.getString("CommandFlowViewColumnDialog.buttonReset"), false);
        resetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                while (!CommandFlowViewColumnDialog.this.usedColumnsNames.isEmpty()) {
                    String column = (String)CommandFlowViewColumnDialog.this.usedColumnsNames.get(0);
                    CommandFlowViewColumnDialog.this.usedColumnsNames.remove(0);
                    CommandFlowViewColumnDialog.this.moveItem(CommandFlowViewColumnDialog.this.usedColumnsTable.getItem(0), CommandFlowViewColumnDialog.this.unUsedColumnsTable, true);
                    CommandFlowViewColumnDialog.this.commandFlowView.removeColumn(column);
                }
                String[] stringArray = DEFAULT_COLUMN_NAMES;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String columnName = stringArray[n2];
                    int i = 0;
                    while (i < CommandFlowViewColumnDialog.this.unUsedColumnsTable.getItemCount()) {
                        if (CommandFlowViewColumnDialog.this.unUsedColumnsTable.getItem(i).getData().equals(columnName)) {
                            CommandFlowViewColumnDialog.this.moveItem(CommandFlowViewColumnDialog.this.unUsedColumnsTable.getItem(i), CommandFlowViewColumnDialog.this.usedColumnsTable, false);
                            CommandFlowViewColumnDialog.this.usedColumnsNames.add(columnName);
                            CommandFlowViewColumnDialog.this.commandFlowView.addColumn(columnName, 140);
                        }
                        ++i;
                    }
                    ++n2;
                }
                CommandFlowViewColumnDialog.this.commandFlowView.setInitialColumnOrder();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    public void init(IWorkbench workbench) {
    }

    class ColumnsComparator
    implements Comparator<String> {
        ColumnsComparator() {
        }

        @Override
        public int compare(String arg0, String arg1) {
            String userString0 = SQLDefinitions.getColumnDescription((String)arg0);
            String userString1 = SQLDefinitions.getColumnDescription((String)arg1);
            int result = userString0.compareTo(userString1);
            return result;
        }
    }
}

