/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomDefinitions;
import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.ui.CollectorOptionsEditor;
import com.ibm.cics.ia.ui.DefaultEditorInputImpl;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.actions.SaveCommandFlowOptionsAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class CommandFlowEditor
extends CollectorOptionsEditor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.ia.ui.CommandFlowEditor";
    private static final Logger logger = Logger.getLogger(CommandFlowEditor.class.getPackage().getName());
    public static final DefaultEditorInputImpl DEFAULT_EDITOR_INPUT = new DefaultEditorInputImpl(){};

    public CincCollector getCollector() {
        return (CincCollector)super.getCollector();
    }

    @Override
    public String getEditorTitle() {
        return this.getCollector().getUserId();
    }

    @Override
    public String getEditorMessage() {
        return MessageFormat.format(Messages.getString("CommandFlowEditor.title.text"), this.getCollector().getUserId());
    }

    @Override
    public String[] getCollectorAttributes() {
        Map properties = this.getCollector().getProperties();
        properties.get("details");
        ArrayList availableProperties = new ArrayList(((Map)properties.get("details")).keySet());
        availableProperties.retainAll(Arrays.asList(AtomDefinitions.CMDFLOW_ATTRIBUTES));
        return availableProperties.toArray(new String[availableProperties.size()]);
    }

    @Override
    public void saveOptions(AtomContentElement element) {
        SaveCommandFlowOptionsAction saveAction = new SaveCommandFlowOptionsAction(this.getCollector());
        saveAction.run(element);
    }

    @Override
    public AtomContentElement getGeneralOptionsRootElement() {
        return this.getCollector().getContentElement().getFirstElementByName("group");
    }

    @Override
    public void setEditorHelp(Composite parent) {
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.command_flow_editor");
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (DEFAULT_EDITOR_INPUT != input) {
            throw new PartInitException("Invalid Input: Must be CommandFlowEditor.DEFAULT_EDITOR_INPUT");
        }
        super.init(site, input);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init");
    }
}

