/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.ia.commands.CommandFlowApplicationSwitchAnalyzer;
import com.ibm.cics.ia.commands.CommandFlowRegionSwitchAnalyzer;
import com.ibm.cics.ia.commands.CommandFlowTCBSwitchAnalyzer;
import com.ibm.cics.ia.commands.ICommandFlowAnalyzer;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.viz.IConnectionsAnalyzerListener;
import com.ibm.cics.ia.model.viz.RootNode;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.viz.CommandFlowDiagramEditPartFactory;
import com.ibm.cics.ia.ui.viz.CommandFlowDiagramEditorInput;
import com.ibm.cics.ia.ui.viz.CommandFlowDiagramKeyHandler;
import com.ibm.cics.ia.ui.viz.editparts.SortedGraphRootEditPart;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SelectionManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CommandFlowDiagram
extends GraphicalEditor
implements IConnectionsAnalyzerListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CommandFlowDiagram.class.getPackage().getName());
    public static String ID = "com.ibm.cics.ia.ui.CommandFlowDiagram";
    private ScrollingGraphicalViewer viewer;
    private Display display;
    private Action printAction;
    private Action changeOrientation;
    private boolean vertical;
    private ToolBar toolbar;
    private ToolBarManager toolbarManager;
    private ICommandFlowAnalyzer analyzer;
    Control viewerControl;
    private RootNode rootNode;
    private OutlinePage outlinePage;
    private Composite viewComp;
    private Composite rootComp;
    private ConnectionServiceListener connectionServiceListener;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)CommandFlowDiagram.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.display = parent.getDisplay();
        this.rootComp = new Composite(parent, 4);
        this.rootComp.setLayout((Layout)new GridLayout(1, true));
        this.toolbar = new ToolBar(this.rootComp, 8388928);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.toolbar.setLayoutData((Object)data);
        Composite viewComp = new Composite(this.rootComp, 2052);
        viewComp.setLayout((Layout)new GridLayout(1, true));
        viewComp.setBackground(ColorConstants.white);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        viewComp.setLayoutData((Object)data);
        this.viewer = new ScrollingGraphicalViewer();
        this.viewerControl = this.viewer.createControl(viewComp);
        this.viewer.getControl().setBackground(ColorConstants.white);
        this.viewer.setEditPartFactory((EditPartFactory)new CommandFlowDiagramEditPartFactory());
        this.viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        this.viewer.setKeyHandler((KeyHandler)new CommandFlowDiagramKeyHandler((GraphicalViewer)this.viewer));
        this.viewerControl.setLayoutData((Object)data);
        DefaultEditDomain eDomain = new DefaultEditDomain(null);
        eDomain.addViewer((EditPartViewer)this.viewer);
        this.createActions();
        this.viewer.setSelectionManager(new SelectionManager(){

            public void appendSelection(EditPart editpart) {
                this.deselectAll();
                super.appendSelection(editpart);
            }
        });
        final MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                menuMgr.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.rootComp.pack();
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.commandflow_diagram");
        Debug.exit((Logger)logger, (String)CommandFlowDiagram.class.getName(), (String)"createPartControl");
    }

    public String getTitleToolTip() {
        return this.getTitle();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            this.outlinePage = new OutlinePage((EditPartViewer)new TreeViewer());
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public void setFocus() {
        if (this.rootComp != null && !this.rootComp.isDisposed()) {
            this.rootComp.setFocus();
        }
    }

    public void clear() {
        this.viewer.setContents(null);
    }

    public void createActions() {
        Debug.enter((Logger)logger, (String)CommandFlowDiagram.class.getName(), (String)"createActions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.changeOrientation = new Action(Messages.getString("ResourceConnectionsView.Action.VerticalOrientation.Action.Text"), 0){

            public void run() {
                Debug.enter((Logger)logger, (String)"CommandFlowDiagram.createActions().changeOrientation", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                CommandFlowDiagram commandFlowDiagram = CommandFlowDiagram.this;
                boolean bl = commandFlowDiagram.vertical ^ true;
                commandFlowDiagram.vertical = bl;
                if (bl) {
                    this.setToolTipText(Messages.getString("CommandFlowDiagram.Action.HorizontalOrientation.Action.Text"));
                    this.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getArrowRightImage()));
                } else {
                    this.setToolTipText(Messages.getString("CommandFlowDiagram.Action.VerticalOrientation.Action.Text"));
                    this.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getArrowDownImage()));
                }
                ((FigureCanvas)CommandFlowDiagram.this.viewer.getControl()).getViewport().setViewLocation(new Point(0, 0));
                SortedGraphRootEditPart diagram = (SortedGraphRootEditPart)CommandFlowDiagram.this.viewer.getContents();
                if (diagram != null) {
                    diagram.setDirection(CommandFlowDiagram.this.getLayoutOrientation());
                }
                Debug.exit((Logger)logger, (String)"CommandFlowDiagram.createActions().changeOrientation", (String)"run");
            }
        };
        this.changeOrientation.setId("CommandFlowDiagram.action.changeorientation");
        this.changeOrientation.setToolTipText(Messages.getString("CommandFlowDiagram.Action.VerticalOrientation.Action.Text"));
        this.changeOrientation.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getArrowDownImage()));
        this.printAction = new Action(){

            public void run() {
                int style = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getStyle();
                Shell shell = new Shell((style & 0x8000000) != 0 ? 0x4000000 : 0);
                PrintDialog dialog = new PrintDialog(shell, 0);
                PrinterData data = dialog.open();
                if (data != null) {
                    PrintGraphicalViewerOperation operation = new PrintGraphicalViewerOperation(new Printer(data), (GraphicalViewer)CommandFlowDiagram.this.viewer);
                    operation.setPrintMode(1);
                    operation.run(Messages.getString("Printing.Operation"));
                }
            }
        };
        this.printAction.setText(Messages.getString("Print.Action"));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)this.printAction);
        this.printAction.setEnabled(true);
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            this.toolbarManager = new ToolBarManager(this.toolbar);
            this.toolbarManager.add((IAction)this.changeOrientation);
            this.toolbarManager.update(true);
            this.toolbarManager.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    if (e.childID > -1) {
                        String id = CommandFlowDiagram.this.toolbarManager.getItems()[e.childID].getId();
                        ActionContributionItem action = (ActionContributionItem)CommandFlowDiagram.this.toolbarManager.getItems()[e.childID];
                        if (id.equals("CommandFlowDiagram.action.changeorientation")) {
                            e.result = String.valueOf(CommandFlowDiagram.this.getContentDescription()) + CommandFlowDiagram.this.changeOrientation.getToolTipText();
                        }
                    }
                }
            });
            this.toolbar.pack();
        }
        Debug.exit((Logger)logger, (String)CommandFlowDiagram.class.getName(), (String)"createActions");
    }

    private int getLayoutOrientation() {
        return this.vertical ? 4 : 16;
    }

    public Job runSearch() {
        Debug.enter((Logger)logger, (String)CommandFlowDiagram.class.getName(), (String)"runSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clear();
        RootNode rootNode = new RootNode();
        CommandFlowDiagramEditorInput input = (CommandFlowDiagramEditorInput)this.getEditorInput();
        Transaction transaction = input.getTransaction();
        Task task = input.getTask();
        CommandFlowDiagramEditorInput.Mode mode = input.getMode();
        if (this.analyzer != null) {
            ((Job)this.analyzer).cancel();
        }
        this.analyzer = mode.equals((Object)CommandFlowDiagramEditorInput.Mode.TCBSwitches) ? new CommandFlowTCBSwitchAnalyzer(transaction, task) : (mode.equals((Object)CommandFlowDiagramEditorInput.Mode.RegionSwitches) ? new CommandFlowRegionSwitchAnalyzer(transaction, task) : new CommandFlowApplicationSwitchAnalyzer(transaction, task));
        this.analyzer.addListener((IConnectionsAnalyzerListener)this);
        ((Job)this.analyzer).schedule();
        Debug.exit((Logger)logger, (String)CommandFlowDiagram.class.getName(), (String)"runSearch");
        return (Job)this.analyzer;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)CommandFlowDiagram.class.getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        Debug.exit((Logger)logger, (String)CommandFlowDiagram.class.getName(), (String)"init");
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)CommandFlowDiagram.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.connectionServiceListener.makeStale();
        super.dispose();
        this.clear();
        Debug.exit((Logger)logger, (String)CommandFlowDiagram.class.getName(), (String)"dispose");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId()) && event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    this.disconnected();
                }
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CommandFlowDiagram.this.clear();
                        CommandFlowDiagram.this.changeOrientation.setEnabled(false);
                    }
                });
            }
        };
    }

    public void onRootNodeUpdated(final RootNode rootNode) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Debug.enter((Logger)logger, (String)"CommandFlowDiagram.onRootNodeUpdated().Runnable()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if (CommandFlowDiagram.this.viewer != null && CommandFlowDiagram.this.viewer.getControl() != null && !CommandFlowDiagram.this.viewer.getControl().isDisposed()) {
                    CommandFlowDiagram.this.viewer.setContents((Object)rootNode);
                    ((SortedGraphRootEditPart)CommandFlowDiagram.this.viewer.getContents()).setDirection(CommandFlowDiagram.this.getLayoutOrientation());
                    if (CommandFlowDiagram.this.outlinePage != null) {
                        CommandFlowDiagram.this.outlinePage.refreshRootFromViewer();
                    }
                }
                Debug.exit((Logger)logger, (String)"CommandFlowDiagram.onRootNodeUpdated().Runnable()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        });
    }

    protected void initializeGraphicalViewer() {
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    class OutlinePage
    extends ContentOutlinePage
    implements IAdaptable {
        private Canvas overview;
        private Thumbnail thumbnail;
        private DisposeListener disposeListener;
        final Logger logger;

        public OutlinePage(EditPartViewer viewer) {
            super(viewer);
            this.logger = Logger.getLogger(OutlinePage.class.getPackage().getName());
        }

        public void createControl(Composite parent) {
            Debug.enter((Logger)this.logger, (String)OutlinePage.class.getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
            this.overview = new Canvas(parent, 0);
            this.initializeOverview(this.overview);
            Debug.exit((Logger)this.logger, (String)OutlinePage.class.getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        }

        public void dispose() {
            Debug.enter((Logger)this.logger, (String)OutlinePage.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            super.dispose();
            Debug.exit((Logger)this.logger, (String)OutlinePage.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        }

        public Object getAdapter(Class type) {
            if (type == ZoomManager.class) {
                return CommandFlowDiagram.this.viewer.getProperty(ZoomManager.class.toString());
            }
            if (type == IContentOutlinePage.class) {
                return CommandFlowDiagram.this.outlinePage;
            }
            return null;
        }

        public Control getControl() {
            return this.overview;
        }

        protected void initializeOverview(Canvas canvas) {
            Debug.enter((Logger)this.logger, (String)OutlinePage.class.getName(), (String)"initializeOverview", (Object)("Thread ID: " + Thread.currentThread().getId()));
            LightweightSystem lws = new LightweightSystem(canvas);
            RootEditPart rep = CommandFlowDiagram.this.viewer.getRootEditPart();
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
            this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
            this.thumbnail.setBorder((Border)new MarginBorder(3));
            this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (OutlinePage.this.thumbnail != null) {
                        OutlinePage.this.thumbnail.deactivate();
                        OutlinePage.this.thumbnail = null;
                    }
                }
            };
            CommandFlowDiagram.this.viewer.getControl().addDisposeListener(this.disposeListener);
            Debug.exit((Logger)this.logger, (String)OutlinePage.class.getName(), (String)"initializeOverview", (Object)("Thread ID: " + Thread.currentThread().getId()));
        }

        protected void unhookOutlineViewer() {
            Debug.enter((Logger)this.logger, (String)OutlinePage.class.getName(), (String)"unhookOutlineViewer", (Object)("Thread ID: " + Thread.currentThread().getId()));
            if (this.disposeListener != null && CommandFlowDiagram.this.viewer.getControl() != null && !CommandFlowDiagram.this.viewer.getControl().isDisposed()) {
                CommandFlowDiagram.this.viewer.getControl().removeDisposeListener(this.disposeListener);
            }
            Debug.exit((Logger)this.logger, (String)OutlinePage.class.getName(), (String)"unhookOutlineViewer", (Object)("Thread ID: " + Thread.currentThread().getId()));
        }

        public void refreshRootFromViewer() {
            Debug.enter((Logger)this.logger, (String)OutlinePage.class.getName(), (String)"refreshRootFromViewer", (Object)("Thread ID: " + Thread.currentThread().getId()));
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            this.initializeOverview(this.overview);
            Debug.exit((Logger)this.logger, (String)OutlinePage.class.getName(), (String)"refreshRootFromViewer", (Object)("Thread ID: " + Thread.currentThread().getId()));
        }
    }
}

