/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.actions.Messages;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CollectorConnectionDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CollectorConnectionDialog.class.getPackage().getName());
    private Table connectionsTable;
    private ConnectionProfile connectionProfile;

    public CollectorConnectionDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(Messages.getString("CollectorConnectionDialog.title.text"));
        this.setTitleImage(ImageFactory.getConnectionWizardImage());
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)CollectorConnectionDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("CollectorConnectionDialog.label.text"));
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.connectionsTable = toolkit.createTable(composite, 2820);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.connectionsTable.setLayoutData((Object)gridData);
        this.fillConnectionsTable();
        this.connectionsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = CollectorConnectionDialog.this.connectionsTable.getSelection();
                CollectorConnectionDialog.this.setSelectedConnection();
                CollectorConnectionDialog.this.updateOkStatus();
            }
        });
        Debug.exit((Logger)logger, (String)CollectorConnectionDialog.class.getName(), (String)"createDialogArea");
        return composite;
    }

    private void fillConnectionsTable() {
        Debug.enter((Logger)logger, (String)CollectorConnectionDialog.class.getName(), (String)"fillConnectionsTable", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List list = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getConnectionProfiles("com.ibm.cics.ia.collectorConnection");
        for (ConnectionProfile conf : list) {
            TableItem item;
            TableItem[] items = this.connectionsTable.getItems();
            int index = 0;
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                item = tableItemArray[n2];
                if (conf.getName().compareTo(item.getText()) < 0) break;
                ++index;
                ++n2;
            }
            item = new TableItem(this.connectionsTable, 0, index);
            item.setImage(ImageFactory.getConnectionImage());
            item.setText(conf.getName());
            item.setData((Object)conf);
        }
        Debug.exit((Logger)logger, (String)CollectorConnectionDialog.class.getName(), (String)"fillConnectionsTable");
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setMessage(Messages.getString("CollectorConnectionDialog.message"));
        return result;
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return createButtonBar;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("CollectorConnectionDialog.title.text"));
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void updateOkStatus() {
        if (this.connectionsTable.isEnabled() && this.connectionsTable.getSelectionCount() == 1) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public ConnectionProfile getConnectionConfiguration() {
        return this.connectionProfile;
    }

    private void setSelectedConnection() {
        this.connectionProfile = this.connectionsTable.isEnabled() && this.connectionsTable.getSelectionCount() == 1 ? (ConnectionProfile)this.connectionsTable.getSelection()[0].getData() : null;
    }
}

