/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.EntryPoint;
import com.ibm.cics.ia.model.EntryPointsModel;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.CellEditorValidator;
import com.ibm.cics.ia.ui.CiuspepsEntryPointsPresenter;
import com.ibm.cics.ia.ui.EntryPointsTreeByRegionLabelProvider;
import com.ibm.cics.ia.ui.EntryPointsTreeUtilities;
import com.ibm.cics.ia.ui.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;

public class Ciuspep3EntryPointsPresenter
extends CiuspepsEntryPointsPresenter {
    private static final Logger logger = Logger.getLogger(Ciuspep3EntryPointsPresenter.class.getPackage().getName());

    @Override
    protected boolean canFinish() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"canFinish", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.view.getUpdatePage().getSelectedProjectComboIndex() <= 0) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return false;
        }
        if (this.view.getUpdatePage().getErrorMessage() != null) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return false;
        }
        if (this.model.getCachedEntryPoints().isEmpty()) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return false;
        }
        for (EntryPoint entryPoint : this.model.getCachedEntryPoints()) {
            if (!entryPoint.isEnabled() || !entryPoint.isSelected()) continue;
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return true;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
        return false;
    }

    @Override
    public void onUpdatePageCreation() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onUpdatePageCreation", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.view.getUpdatePage().setPageComplete(false);
        this.view.getUpdatePage().setCicsTsLevelComboContents(new String[]{EntryPointsModel.CicsTsLevel.LEVEL_51.toString(), EntryPointsModel.CicsTsLevel.LEVEL_52.toString(), EntryPointsModel.CicsTsLevel.LEVEL_53.toString(), EntryPointsModel.CicsTsLevel.LEVEL_55.toString(), EntryPointsModel.CicsTsLevel.LEVEL_56.toString(), EntryPointsModel.CicsTsLevel.LEVEL_61.toString(), EntryPointsModel.CicsTsLevel.LEVEL_62.toString(), EntryPointsModel.CicsTsLevel.LEVEL_63.toString()});
        String[] projectNames = this.model.getCicsBundleProjectNames();
        this.view.getUpdatePage().setProjectComboContents((String[])IAUtilities.concat((Object[])new String[]{Messages.getString("ApplicationCreationWizard.type.newProject")}, (Object[][])new String[][]{projectNames}));
        EntryPointsTreeByRegionLabelProvider labelProvider = new EntryPointsTreeByRegionLabelProvider();
        this.view.getUpdatePage().setLabelProvider((IBaseLabelProvider)labelProvider);
        this.view.getUpdatePage().setCellModifier(new ICellModifier(){

            public Object getEmergencyValue(int columnIndex, EntryPoint entryPoint) {
                return columnIndex == 6 ? entryPoint.getObject() : null;
            }

            public Object getValue(Object element, String property) {
                if (Ciuspep3EntryPointsPresenter.this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByApp.toString())) {
                    return new CiuspepsEntryPointsPresenter.EntryPointByAppCellModifier(Ciuspep3EntryPointsPresenter.this).getValue(element, property);
                }
                if (Ciuspep3EntryPointsPresenter.this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByAppWithDep.toString())) {
                    return new CiuspepsEntryPointsPresenter.EntryPointByAppWithDepCellModifier(Ciuspep3EntryPointsPresenter.this).getValue(element, property);
                }
                return new CiuspepsEntryPointsPresenter.EntryPointCellModifier(Ciuspep3EntryPointsPresenter.this).getValue(element, property);
            }

            public boolean canModify(Object element, String property) {
                if (Ciuspep3EntryPointsPresenter.this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByApp.toString())) {
                    return new CiuspepsEntryPointsPresenter.EntryPointByAppCellModifier(Ciuspep3EntryPointsPresenter.this).canModify(element, property);
                }
                if (Ciuspep3EntryPointsPresenter.this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByAppWithDep.toString())) {
                    return new CiuspepsEntryPointsPresenter.EntryPointByAppWithDepCellModifier(Ciuspep3EntryPointsPresenter.this).canModify(element, property);
                }
                return new CiuspepsEntryPointsPresenter.EntryPointCellModifier(Ciuspep3EntryPointsPresenter.this).canModify(element, property);
            }

            public void modify(Object element, String property, Object value) {
                new CiuspepsEntryPointsPresenter.EntryPointCellModifier(Ciuspep3EntryPointsPresenter.this).modify(element, property, value);
            }
        });
        this.setViewContents();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onUpdatePageCreation");
    }

    private void setViewContents() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setViewContents", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String[] columnNames = this.getColumnNames();
        List entryPoints = this.model.getFreshEntryPoints();
        this.model.validateResources();
        this.updateGeneralErrorMessage();
        final CellEditorValidator operationValidator = new CellEditorValidator();
        ICellEditorListener cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                Ciuspep3EntryPointsPresenter.this.model.validateResources();
                Ciuspep3EntryPointsPresenter.this.view.getUpdatePage().setErrorMessage(operationValidator.getErrorMessage());
            }

            public void cancelEditor() {
                Ciuspep3EntryPointsPresenter.this.model.validateResources();
                Ciuspep3EntryPointsPresenter.this.updateGeneralErrorMessage();
            }

            public void applyEditorValue() {
                Ciuspep3EntryPointsPresenter.this.model.validateResources();
                Ciuspep3EntryPointsPresenter.this.updateGeneralErrorMessage();
            }
        };
        HashMap<Integer, ICellEditorValidator> validators = new HashMap<Integer, ICellEditorValidator>();
        validators.put(5, operationValidator);
        HashMap<Integer, ICellEditorListener> cellEditorListeners = new HashMap<Integer, ICellEditorListener>();
        cellEditorListeners.put(5, cellEditorListener);
        this.view.getUpdatePage().initTable(columnNames, validators, cellEditorListeners, entryPoints);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setViewContents");
    }
}

