/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.bundle.ui.BundleTypeHelper;
import com.ibm.cics.bundle.ui.BundleUIMessages;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.CicsBundleResource;
import com.ibm.cics.ia.model.EntryPoint;
import com.ibm.cics.ia.model.EntryPointTreeItem;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.CellEditorValidator;
import com.ibm.cics.ia.ui.CiuspepsEntryPointsPresenter;
import com.ibm.cics.ia.ui.EntryPointsTreeByAppLabelProvider;
import com.ibm.cics.ia.ui.EntryPointsTreeByRegionLabelProvider;
import com.ibm.cics.ia.ui.EntryPointsTreeUtilities;
import com.ibm.cics.ia.ui.Messages;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.TreeItem;

public class CiuspdepPresenter
extends CiuspepsEntryPointsPresenter {
    private static final Logger logger = Logger.getLogger(CiuspdepPresenter.class.getPackage().getName());
    private CicsBundleResource selectedDependency;

    @Override
    protected boolean canFinish() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"canFinish", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.view.getUpdatePage().getSelectedProjectComboIndex() <= 0) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return false;
        }
        if (this.view.getUpdatePage().getErrorMessage() != null) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return false;
        }
        for (CicsBundleResource dependency : this.model.getCachedDependencies()) {
            if (!dependency.isSelected()) continue;
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return true;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
        return false;
    }

    @Override
    public void onUpdatePageCreation() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onUpdatePageCreation", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.view.getUpdatePage().setPageComplete(false);
        String[] projectNames = this.model.getCicsBundleProjectNames();
        this.view.getUpdatePage().setProjectComboContents((String[])IAUtilities.concat((Object[])new String[]{Messages.getString("ApplicationCreationWizard.type.newProject")}, (Object[][])new String[][]{projectNames}));
        EntryPointsTreeByRegionLabelProvider dependencyLabelProvider = new EntryPointsTreeByRegionLabelProvider();
        this.view.getUpdatePage().setLabelProvider((IBaseLabelProvider)dependencyLabelProvider);
        this.view.getUpdatePage().setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                int columnIndex = Arrays.asList(CiuspdepPresenter.this.getColumnNames()).indexOf(property);
                TreeItem item = (TreeItem)element;
                EntryPointTreeItem dependency = (EntryPointTreeItem)item.getData();
                if (CiuspdepPresenter.this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByApp.toString())) {
                    switch (columnIndex) {
                        case 0: {
                            dependency.setSelected(((Boolean)value).booleanValue());
                            break;
                        }
                        case 5: {
                            dependency.setName(value.toString());
                        }
                    }
                } else if (CiuspdepPresenter.this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByRegion.toString())) {
                    switch (columnIndex) {
                        case 0: {
                            dependency.setSelected(((Boolean)value).booleanValue());
                            break;
                        }
                        case 4: {
                            dependency.setName(value.toString());
                        }
                    }
                }
                CiuspdepPresenter.this.model.validateResources();
                if (dependency.getError() != null) {
                    CiuspdepPresenter.this.view.getUpdatePage().setErrorMessage(dependency.getError());
                } else {
                    CiuspdepPresenter.this.updateGeneralErrorMessage();
                }
                CiuspdepPresenter.this.view.getUpdatePage().setPageComplete(CiuspdepPresenter.this.canFinish());
                CiuspdepPresenter.this.view.getUpdatePage().updateElem(dependency, null);
                CiuspdepPresenter.this.view.getUpdatePage().refreshTable();
            }

            public Object getValue(Object element, String property) {
                if (element instanceof EntryPointTreeItem) {
                    if (CiuspdepPresenter.this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByApp.toString())) {
                        return new CiuspepsEntryPointsPresenter.EntryPointByAppCellModifier(CiuspdepPresenter.this).getValue(element, property);
                    }
                    if (CiuspdepPresenter.this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByRegion.toString())) {
                        return new CiuspepsEntryPointsPresenter.EntryPointCellModifier(CiuspdepPresenter.this).getValue(element, property);
                    }
                }
                int columnIndex = Arrays.asList(CiuspdepPresenter.this.getColumnNames()).indexOf(property);
                CicsBundleResource dependency = (CicsBundleResource)element;
                switch (columnIndex) {
                    case 0: {
                        return dependency.isSelected();
                    }
                    case 1: {
                        return dependency.getCollectionId();
                    }
                    case 2: {
                        return dependency.getApplid();
                    }
                    case 3: {
                        return dependency.getUserFriendlyType();
                    }
                    case 4: {
                        return dependency.getName();
                    }
                    case 5: {
                        return dependency.getApplOperation();
                    }
                    case 6: {
                        return dependency.getPlatform();
                    }
                    case 7: {
                        return dependency.getFullApplName();
                    }
                    case 8: {
                        return dependency.getApplOperation();
                    }
                    case 9: {
                        return dependency.getObject();
                    }
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                int columnIndex = Arrays.asList(CiuspdepPresenter.this.getColumnNames()).indexOf(property);
                EntryPointTreeItem item = (EntryPointTreeItem)element;
                if (CiuspdepPresenter.this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByApp.toString())) {
                    EntryPoint dependency = item.getEntryPoint();
                    return columnIndex == 0 || columnIndex == 5 && (dependency.getBundlePartType().equals((Object)BundleTypeHelper.BundlePartType.DB2CONN) || dependency.getBundlePartType().equals((Object)BundleTypeHelper.BundlePartType.MQCONN));
                }
                EntryPoint dependency = ((EntryPointTreeItem)element).getEntryPoint();
                return columnIndex == 0 || columnIndex == 4 && (dependency.getBundlePartType().equals((Object)BundleTypeHelper.BundlePartType.DB2CONN) || dependency.getBundlePartType().equals((Object)BundleTypeHelper.BundlePartType.MQCONN));
            }
        });
        this.setViewContents();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onUpdatePageCreation");
    }

    private void setViewContents() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setViewContents", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List dependencies = this.model.getFreshDependencies();
        this.model.validateResources();
        this.updateGeneralErrorMessage();
        final CellEditorValidator nameValidator = new CellEditorValidator(){

            @Override
            public String isValid(Object value) {
                ISelection selection = CiuspdepPresenter.this.view.getUpdatePage().getSelectedRow();
                if (selection != null && selection instanceof StructuredSelection) {
                    CiuspdepPresenter.this.selectedDependency = (CicsBundleResource)((EntryPointTreeItem)((StructuredSelection)selection).getFirstElement()).getEntryPoint();
                }
                CicsBundleResource editedDependency = new CicsBundleResource(value.toString(), CiuspdepPresenter.this.selectedDependency.getBundlePartType(), new HashMap());
                this.setErrorMessage(CiuspdepPresenter.this.model.hasValidName(editedDependency));
                if (this.getErrorMessage() != null) {
                    return this.getErrorMessage();
                }
                for (CicsBundleResource cachedDependency : CiuspdepPresenter.this.model.getCachedDependencies()) {
                    if (cachedDependency == CiuspdepPresenter.this.selectedDependency || !cachedDependency.equals((Object)editedDependency)) continue;
                    this.setErrorMessage(Messages.getString("ApplicationCreationWizard.err.dependency.alreadyExists"));
                    return this.getErrorMessage();
                }
                this.setErrorMessage(CiuspdepPresenter.this.model.availableInCurrentProject(editedDependency));
                return this.getErrorMessage();
            }
        };
        ICellEditorListener cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                CiuspdepPresenter.this.view.getUpdatePage().setErrorMessage(nameValidator.getErrorMessage());
            }

            public void cancelEditor() {
                CiuspdepPresenter.this.model.validateResources();
                CiuspdepPresenter.this.updateGeneralErrorMessage();
            }

            public void applyEditorValue() {
                CiuspdepPresenter.this.model.validateResources();
                CiuspdepPresenter.this.updateGeneralErrorMessage();
            }
        };
        int editableColumnIndex = this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByApp.toString()) ? 5 : 4;
        HashMap<Integer, ICellEditorValidator> validators = new HashMap<Integer, ICellEditorValidator>();
        validators.put(editableColumnIndex, nameValidator);
        HashMap<Integer, ICellEditorListener> cellEditorListeners = new HashMap<Integer, ICellEditorListener>();
        cellEditorListeners.put(editableColumnIndex, cellEditorListener);
        this.view.getUpdatePage().initTable(this.getColumnNames(), validators, cellEditorListeners, dependencies);
        this.view.getUpdatePage().addVerifyListener(this.view.getUpdatePage().getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByApp.toString()) ? 5 : 4, new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                VerifyListener verifyListener = CiuspdepPresenter.this.selectedDependency.getBundlePartType().getVerifyListener();
                if (verifyListener != null) {
                    verifyListener.verifyText(e);
                }
            }
        });
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setViewContents");
    }

    @Override
    public void onFinish() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onFinish", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.model.addDependenciesToProject();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onFinish");
    }

    @Override
    public void onSelectAll() {
        this.selectAllDependencies(true);
    }

    @Override
    public void onDeselectAll() {
        this.selectAllDependencies(false);
    }

    private void selectAllDependencies(boolean selected) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"selectAllDependencies", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (CicsBundleResource dependency : this.model.getCachedDependencies()) {
            dependency.setSelected(selected);
            this.view.getUpdatePage().updateElem(dependency, null);
        }
        this.model.validateResources();
        this.updateGeneralErrorMessage();
        this.view.getUpdatePage().setPageComplete(this.canFinish());
        this.view.getUpdatePage().refreshTable();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"selectAllDependencies");
    }

    @Override
    public String[] getColumnNames() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getColumnNames", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String[] columnsWithoutOperation = new String[]{"!", Messages.getString("ApplicationCreationWizard.table.column.collectionId"), Messages.getString("ApplicationCreationWizard.table.column.applId"), Messages.getString("ApplicationCreationWizard.table.column.type"), BundleUIMessages.ImportPropertiesDialog_nameLabel, Messages.getString("ApplicationCreationWizard.table.column.operation"), Messages.getString("ApplicationCreationWizard.table.column.platform"), Messages.getString("ApplicationCreationWizard.table.column.application")};
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getColumnNames");
        return columnsWithoutOperation;
    }

    @Override
    public void combo1Selected() {
    }

    @Override
    public void cicsTsLevelSelected() {
    }

    @Override
    public void treeTypeSelected() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"projectSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String type = this.view.getUpdatePage().getTreeType();
        final CellEditorValidator operationValidator = new CellEditorValidator();
        ICellEditorListener cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                CiuspdepPresenter.this.view.getUpdatePage().setErrorMessage(operationValidator.getErrorMessage());
            }

            public void cancelEditor() {
                CiuspdepPresenter.this.updateGeneralErrorMessage();
            }

            public void applyEditorValue() {
                CiuspdepPresenter.this.updateGeneralErrorMessage();
            }
        };
        this.validators = new HashMap();
        this.cellEditorListeners = new HashMap();
        List input = this.model.getCachedDependencies();
        if (type.equals(EntryPointsTreeUtilities.TreeTypes.ByRegion.toString())) {
            this.view.getUpdatePage().getTreeViewer().setLabelProvider((IBaseLabelProvider)new EntryPointsTreeByRegionLabelProvider());
            this.columnNames = new String[]{"!", Messages.getString("ApplicationCreationWizard.table.column.collectionId"), Messages.getString("ApplicationCreationWizard.table.column.applId"), Messages.getString("ApplicationCreationWizard.table.column.type"), BundleUIMessages.ImportPropertiesDialog_nameLabel, Messages.getString("ApplicationCreationWizard.table.column.operation"), Messages.getString("ApplicationCreationWizard.table.column.platform"), Messages.getString("ApplicationCreationWizard.table.column.application")};
            this.view.getUpdatePage().setCellModifier(new CiuspepsEntryPointsPresenter.EntryPointCellModifier(this));
            this.validators.put(5, operationValidator);
            this.cellEditorListeners.put(5, cellEditorListener);
            this.view.getUpdatePage().getTreeViewer().setColumnProperties(this.columnNames);
            this.view.getUpdatePage().initTable(this.columnNames, this.validators, this.cellEditorListeners, input);
        }
        if (type.equals(EntryPointsTreeUtilities.TreeTypes.ByApp.toString())) {
            this.view.getUpdatePage().getTreeViewer().setLabelProvider((IBaseLabelProvider)new EntryPointsTreeByAppLabelProvider());
            this.columnNames = new String[]{"!", Messages.getString("ApplicationCreationWizard.table.column.collectionId"), Messages.getString("ApplicationCreationWizard.table.column.platform"), Messages.getString("ApplicationCreationWizard.table.column.application"), Messages.getString("ApplicationCreationWizard.table.column.operation"), BundleUIMessages.ImportPropertiesDialog_nameLabel, Messages.getString("ApplicationCreationWizard.table.column.type"), Messages.getString("ApplicationCreationWizard.table.column.applId")};
            this.view.getUpdatePage().setCellModifier(new CiuspepsEntryPointsPresenter.EntryPointByAppCellModifier(this));
            this.validators.put(4, operationValidator);
            this.cellEditorListeners.put(4, cellEditorListener);
            this.view.getUpdatePage().getTreeViewer().setColumnProperties(this.columnNames);
            this.view.getUpdatePage().initTable(this.columnNames, this.validators, this.cellEditorListeners, input);
        }
        this.setViewContents();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"projectSelected");
    }

    @Override
    protected void updateGeneralErrorMessage() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"updateGeneralErrorMessage", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.model.hasInvalidResources()) {
            this.view.getUpdatePage().setErrorMessage(Messages.getString("ApplicationCreationWizard.DependenciesPage.invalidDependencies"));
        } else {
            this.view.getUpdatePage().setErrorMessage(null);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"updateGeneralErrorMessage");
    }
}

