/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.CommandExecution;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.query.Messages;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class CSVUtils {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String PROPERTY_KEY;
    public static final String SEPARATOR = ",";

    private CSVUtils() {
    }

    public static List<String> createCSV(Tree tree, String propertyKey) {
        PROPERTY_KEY = propertyKey;
        ArrayList<String> result = new ArrayList<String>();
        if (tree.getItemCount() > 0) {
            CSVUtils.parseTree(tree.getItem(0), result);
        }
        return result;
    }

    public static StringBuffer createCSVForCmdView(List<CommandExecution> commandExecutions, List<String> columnNames) {
        StringBuffer row = new StringBuffer();
        for (String columnName : columnNames) {
            row.append(String.valueOf(Messages.getString((String)("Column." + columnName))) + SEPARATOR);
        }
        row.append(IAUtilities.LINE_SEPARATOR);
        for (CommandExecution commandExec : commandExecutions) {
            for (String columnName : columnNames) {
                row.append(String.valueOf(commandExec.get(columnName)) + SEPARATOR);
            }
            row.append(IAUtilities.LINE_SEPARATOR);
        }
        return row;
    }

    private static String createCSVLine(TreeItem treeItem) {
        StringBuffer result = new StringBuffer();
        while (treeItem != null) {
            Resource resource = (Resource)treeItem.getData(PROPERTY_KEY);
            String cellText = resource != null ? resource.getName() : "";
            result.insert(0, SEPARATOR + cellText);
            treeItem = treeItem.getParentItem();
        }
        return result.delete(0, 1).toString();
    }

    private static void parseTree(TreeItem treeItem, List<String> result) {
        int childItems = treeItem.getItemCount();
        if (childItems == 0) {
            result.add(CSVUtils.createCSVLine(treeItem));
            return;
        }
        int i = 0;
        while (i < childItems) {
            CSVUtils.parseTree(treeItem.getItem(i), result);
            ++i;
        }
    }
}

